/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.opencrx.application.uses.ezvcard.VCard;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.Warning;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameters;

public abstract class VCardProperty
implements Comparable<VCardProperty> {
    protected String group;
    protected VCardParameters parameters = new VCardParameters();

    public final Set<VCardVersion> getSupportedVersions() {
        return this._supportedVersions();
    }

    protected Set<VCardVersion> _supportedVersions() {
        return EnumSet.copyOf(Arrays.asList(VCardVersion.values()));
    }

    public final List<Warning> validate(VCardVersion version, VCard vcard) {
        ArrayList<Warning> warnings = new ArrayList<Warning>(0);
        Set<VCardVersion> supportedVersions = this.getSupportedVersions();
        if (!supportedVersions.contains((Object)version)) {
            warnings.add(new Warning(2, supportedVersions));
        }
        warnings.addAll(this.parameters.validate(version));
        this._validate(warnings, version, vcard);
        return warnings;
    }

    protected void _validate(List<Warning> warnings, VCardVersion version, VCard vcard) {
    }

    public VCardParameters getParameters() {
        return this.parameters;
    }

    public void setParameters(VCardParameters parameters) {
        this.parameters = parameters;
    }

    public String getParameter(String name) {
        return (String)this.parameters.first(name);
    }

    public List<String> getParameters(String name) {
        return this.parameters.get(name);
    }

    public void setParameter(String name, String value) {
        this.parameters.replace(name, value);
    }

    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void removeParameter(String name) {
        this.parameters.removeAll(name);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public int compareTo(VCardProperty that) {
        Integer pref0 = this.getParameters().getPref();
        Integer pref1 = that.getParameters().getPref();
        if (pref0 == null && pref1 == null) {
            return 0;
        }
        if (pref0 == null) {
            return 1;
        }
        if (pref1 == null) {
            return -1;
        }
        return pref1.compareTo(pref0);
    }

    List<Integer[]> getPids() {
        return this.parameters.getPids();
    }

    void addPid(int localId, int clientPidMapRef) {
        this.parameters.addPid(localId, clientPidMapRef);
    }

    void removePids() {
        this.parameters.removePids();
    }

    Integer getPref() {
        return this.parameters.getPref();
    }

    void setPref(Integer pref) {
        this.parameters.setPref(pref);
    }

    String getLanguage() {
        return this.parameters.getLanguage();
    }

    void setLanguage(String language) {
        this.parameters.setLanguage(language);
    }

    Integer getIndex() {
        return this.parameters.getIndex();
    }

    void setIndex(Integer index) {
        this.parameters.setIndex(index);
    }
}

