/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.net.freeutils.tnef;

import java.io.IOException;
import org.opencrx.application.uses.net.freeutils.tnef.GUID;
import org.opencrx.application.uses.net.freeutils.tnef.RawInputStream;

public class MAPIPropName {
    public static final int MNID_ID = 0;
    public static final int MNID_STRING = 1;
    GUID guid;
    int type;
    long ID;
    String name;
    int rawLength;

    public MAPIPropName(RawInputStream data) throws IOException {
        long startOffest = data.getPosition();
        this.guid = new GUID(data.readBytes(16));
        this.type = (int)data.readU32();
        if (this.type == 1) {
            int length = (int)data.readU32();
            this.name = data.readStringUnicode(length);
            if (length % 4 != 0) {
                data.skip(4 - length % 4);
            }
            this.rawLength += length;
        } else if (this.type == 0) {
            this.ID = data.readU32();
        } else {
            throw new IOException("invalid type: " + this.type);
        }
        this.rawLength = (int)(data.getPosition() - startOffest);
    }

    public MAPIPropName(GUID guid, long ID) {
        this.guid = guid;
        this.type = 0;
        this.ID = ID;
    }

    public MAPIPropName(GUID guid, String name) {
        this.guid = guid;
        this.type = 1;
        this.name = name;
    }

    public GUID getGUID() {
        return this.guid;
    }

    public int getType() {
        return this.type;
    }

    public long getID() {
        return this.ID;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer s = new StringBuffer().append("GUID=").append(this.guid).append(" Name=").append(this.type == 1 ? this.name : "0x" + Long.toHexString(this.ID));
        return s.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MAPIPropName)) {
            return false;
        }
        MAPIPropName p = (MAPIPropName)o;
        return this.type == p.type && (this.type == 0 ? this.ID == p.ID : this.name.equals(p.name)) && this.guid.equals(p.guid);
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + this.type;
        result = result * 37 + this.guid.hashCode();
        if (this.type == 0) {
            result = result * 37 + (int)(this.ID ^ this.ID >>> 32);
        }
        if (this.type == 1 && this.name != null) {
            result = result * 37 + this.name.hashCode();
        }
        return result;
    }

    protected int getRawLength() {
        return this.rawLength;
    }
}

