/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.net.freeutils.tnef;

import java.io.IOException;
import org.opencrx.application.uses.net.freeutils.tnef.MAPIProp;
import org.opencrx.application.uses.net.freeutils.tnef.MAPIPropName;
import org.opencrx.application.uses.net.freeutils.tnef.MAPIValue;
import org.opencrx.application.uses.net.freeutils.tnef.RawInputStream;

public class MAPIProps {
    MAPIProp[] props;
    int rawLength;

    public MAPIProps(RawInputStream data) throws IOException {
        long startOffest = data.getPosition();
        int count = (int)data.readU32();
        this.props = new MAPIProp[count];
        for (int i = 0; i < count; ++i) {
            MAPIProp prop = this.props[i] = new MAPIProp();
            prop.type = data.readU16();
            boolean isMultiValue = (prop.type & 0x1000) != 0;
            prop.type &= 0xFFFFEFFF;
            switch (prop.type) {
                case 13: 
                case 30: 
                case 31: 
                case 258: {
                    isMultiValue = true;
                }
            }
            prop.ID = data.readU16();
            if (prop.ID >= 32768 && prop.ID <= 65534) {
                MAPIPropName name = new MAPIPropName(data);
                prop.setName(name);
            }
            int valueCount = 1;
            if (isMultiValue) {
                valueCount = (int)data.readU32();
            }
            prop.values = new MAPIValue[valueCount];
            block11: for (int j = 0; j < prop.values.length; ++j) {
                switch (prop.type) {
                    case 1: {
                        prop.values[j] = null;
                        continue block11;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 10: 
                    case 11: {
                        prop.values[j] = new MAPIValue(prop.type, data, 4);
                        continue block11;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 20: 
                    case 64: {
                        prop.values[j] = new MAPIValue(prop.type, data, 8);
                        continue block11;
                    }
                    case 72: {
                        prop.values[j] = new MAPIValue(prop.type, data, 16);
                        continue block11;
                    }
                    case 13: 
                    case 30: 
                    case 31: 
                    case 258: {
                        int vlen = (int)data.readU32();
                        prop.values[j] = new MAPIValue(prop.type, data, vlen);
                        if (vlen % 4 == 0) continue block11;
                        data.skip(4 - vlen % 4);
                        continue block11;
                    }
                    default: {
                        throw new IOException("Unknown MAPI type: " + prop.type);
                    }
                }
            }
        }
        this.rawLength = (int)(data.getPosition() - startOffest);
    }

    public MAPIProps(MAPIProp[] props) {
        this.props = props;
    }

    public MAPIProp[] getProps() {
        return this.props;
    }

    public MAPIProp getProp(int ID) {
        return MAPIProp.findProp(this.props, ID);
    }

    public MAPIProp getProp(MAPIPropName name) {
        return MAPIProp.findProp(this.props, name);
    }

    public Object getPropValue(int ID) throws IOException {
        MAPIProp prop = this.getProp(ID);
        return prop != null ? prop.getValue() : null;
    }

    public Object getPropValue(MAPIPropName name) throws IOException {
        MAPIProp prop = this.getProp(name);
        return prop != null ? prop.getValue() : null;
    }

    protected int getRawLength() {
        return this.rawLength;
    }
}

