/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.net.sf.webdav.methods;

import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.uses.net.sf.webdav.exceptions.AccessDeniedException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.LockFailedException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.ObjectAlreadyExistsException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.ObjectNotFoundException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.WebdavException;
import org.opencrx.application.uses.net.sf.webdav.methods.WebDavMethod;
import org.openmdx.base.exception.ServiceException;

public class DoDelete
extends WebDavMethod {
    private static Logger LOG = Logger.getLogger(DoDelete.class.getPackage().getName());
    private final WebDavStore _store;

    public DoDelete(WebDavStore store) {
        this._store = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(RequestContext requestContext) throws IOException, LockFailedException {
        LOG.finest("-- " + this.getClass().getName());
        HttpServletRequest req = requestContext.getHttpServletRequest();
        HttpServletResponse resp = requestContext.getHttpServletResponse();
        String path = this.getRelativePath(requestContext);
        String parentPath = this.getParentPath(this.getCleanPath(path));
        Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
        if (!this.checkLocks(requestContext, this._store, parentPath)) {
            errorList.put(parentPath, 423);
            this.sendReport(requestContext, errorList);
            return;
        }
        if (!this.checkLocks(requestContext, this._store, path)) {
            errorList.put(path, 423);
            this.sendReport(requestContext, errorList);
            return;
        }
        try {
            errorList = new Hashtable();
            Resource so = this._store.getResourceByPath(requestContext, path);
            this.deleteResource(requestContext, so, path, errorList);
            if (!errorList.isEmpty()) {
                this.sendReport(requestContext, errorList);
            }
        }
        catch (AccessDeniedException e) {
            resp.sendError(403);
        }
        catch (ObjectAlreadyExistsException e) {
            resp.sendError(404, req.getRequestURI());
        }
        catch (WebdavException e) {
            new ServiceException((Exception)e).log();
            resp.sendError(500);
        }
    }

    public void deleteResource(RequestContext requestContext, Resource so, String path, Hashtable<String, Integer> errorList) throws IOException, WebdavException {
        HttpServletResponse resp = requestContext.getHttpServletResponse();
        if (so != null) {
            if (so.isCollection()) {
                this.deleteCollectionContent(requestContext, path, so, errorList);
            }
            WebDavStore.Status status = this._store.removeResource(requestContext, path, so);
            switch (status) {
                case OK: {
                    resp.setStatus(204);
                    break;
                }
                default: {
                    resp.setStatus(403);
                }
            }
        }
    }

    private void deleteCollectionContent(RequestContext requestContext, String path, Resource parent, Hashtable<String, Integer> errorList) throws WebdavException {
        Collection<Resource> children = this._store.getChildren(requestContext, parent, null, null);
        for (Resource child : children) {
            try {
                if (child.isCollection()) {
                    this.deleteCollectionContent(requestContext, path + "/" + child.getName(), child, errorList);
                }
                this._store.removeResource(requestContext, path, child);
            }
            catch (AccessDeniedException e) {
                errorList.put(path + "/" + child.getName(), new Integer(403));
            }
            catch (ObjectNotFoundException e) {
                errorList.put(path + "/" + child.getName(), new Integer(404));
            }
            catch (WebdavException e) {
                errorList.put(path + "/" + child.getName(), new Integer(500));
            }
        }
    }
}

