/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.net.sf.webdav.methods;

import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.uses.net.sf.webdav.exceptions.AccessDeniedException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.LockFailedException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.WebdavException;
import org.opencrx.application.uses.net.sf.webdav.methods.WebDavMethod;
import org.openmdx.base.exception.ServiceException;

public class DoOptions
extends WebDavMethod {
    private static Logger LOG = Logger.getLogger(DoOptions.class.getPackage().getName());
    private final WebDavStore _store;

    public DoOptions(WebDavStore store) {
        this._store = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(RequestContext requestContext) throws IOException, LockFailedException {
        HttpServletResponse resp = requestContext.getHttpServletResponse();
        LOG.finest("-- " + this.getClass().getName());
        String path = this.getRelativePath(requestContext);
        Resource so = null;
        try {
            resp.addHeader("DAV", this.getVersion());
            resp.setCharacterEncoding("UTF-8");
            so = this._store.getResourceByPath(requestContext, path);
            String methodsAllowed = this.determineMethodsAllowed(so);
            resp.addHeader("Allow", methodsAllowed);
            resp.addHeader("Accept-Ranges", "bytes");
            resp.addHeader("MS-Author-Via", "DAV");
        }
        catch (AccessDeniedException e) {
            resp.sendError(403);
        }
        catch (WebdavException e) {
            new ServiceException((Exception)e).log();
            resp.sendError(500);
        }
    }
}

