/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.net.sf.webdav.methods;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.uses.net.sf.webdav.exceptions.AccessDeniedException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.LockFailedException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.WebdavException;
import org.opencrx.application.uses.net.sf.webdav.methods.WebDavMethod;
import org.openmdx.base.exception.ServiceException;

public class DoPut
extends WebDavMethod {
    private static Logger LOG = Logger.getLogger(DoPut.class.getPackage().getName());
    private final WebDavStore _store;
    private final boolean _lazyFolderCreationOnPut;

    public DoPut(WebDavStore store, boolean lazyFolderCreationOnPut) {
        this._store = store;
        this._lazyFolderCreationOnPut = lazyFolderCreationOnPut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(RequestContext requestContext) throws IOException, LockFailedException {
        block13: {
            LOG.finest("-- " + this.getClass().getName());
            HttpServletRequest req = requestContext.getHttpServletRequest();
            HttpServletResponse resp = requestContext.getHttpServletResponse();
            String path = this.getRelativePath(requestContext);
            String parentPath = this.getParentPath(path);
            Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
            if (!this.checkLocks(requestContext, this._store, parentPath)) {
                errorList.put(parentPath, 423);
                this.sendReport(requestContext, errorList);
                return;
            }
            if (!this.checkLocks(requestContext, this._store, path)) {
                errorList.put(path, 423);
                this.sendReport(requestContext, errorList);
                return;
            }
            Resource parentSo = null;
            try {
                parentSo = this._store.getResourceByPath(requestContext, parentPath);
                if (parentPath != null && parentSo != null && !parentSo.isCollection()) {
                    resp.sendError(403);
                    return;
                }
                if (parentPath != null && parentSo == null && this._lazyFolderCreationOnPut) {
                    this._store.createCollection(requestContext, parentPath);
                } else if (parentPath != null && parentSo == null && !this._lazyFolderCreationOnPut) {
                    errorList.put(parentPath, 404);
                    this.sendReport(requestContext, errorList);
                    return;
                }
                WebDavStore.Status putResult = this._store.putResource(requestContext, path, (InputStream)req.getInputStream(), req.getContentType());
                if (putResult == WebDavStore.Status.FORBIDDEN) {
                    resp.sendError(200);
                    resp.setHeader("ETag", Long.toString(System.currentTimeMillis()));
                    break block13;
                }
                resp.setCharacterEncoding("UTF-8");
                if (putResult != WebDavStore.Status.OK_CREATED) {
                    resp.setHeader("ETag", Long.toString(System.currentTimeMillis()));
                }
                resp.setStatus(putResult == WebDavStore.Status.OK_CREATED ? 201 : 200);
            }
            catch (AccessDeniedException e) {
                resp.sendError(403);
            }
            catch (WebdavException e) {
                new ServiceException((Exception)e).log();
                resp.sendError(500);
            }
        }
    }
}

