/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.webdav;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.webdav.WebDavRequestContext;
import org.openmdx.base.jmi1.BasicObject;
import org.w3c.cci2.BinaryLargeObject;
import org.w3c.cci2.BinaryLargeObjects;

abstract class WebDavResource
implements Resource {
    private final RequestContext requestContext;
    private final BasicObject object;

    public WebDavResource(RequestContext requestContext, BasicObject object) {
        this.requestContext = requestContext;
        this.object = object;
    }

    @Override
    public Date getCreationDate() {
        return this.object.getCreatedAt();
    }

    @Override
    public Date getLastModified() {
        return this.object.getModifiedAt();
    }

    public BasicObject getObject() {
        return this.object;
    }

    public <T extends Resource> Collection<T> getChildren(Date timeRangeStart, Date timeRangeEnd) {
        return Collections.emptyList();
    }

    public WebDavRequestContext getRequestContext() {
        return (WebDavRequestContext)this.requestContext;
    }

    @Override
    public String getName() {
        return this.object.refGetPath().getLastSegment().toString();
    }

    public String getMimeType() {
        return "application/xml";
    }

    public WebDavStore.ResourceContent getContent() {
        return new WebDavStore.ResourceContent(){

            @Override
            public BinaryLargeObject getContent() {
                return BinaryLargeObjects.valueOf((byte[])new byte[0]);
            }

            @Override
            public Long getLength() {
                return 0L;
            }
        };
    }
}

