/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.webdav;

import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.activation.MimetypesFileTypeMap;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.uses.net.sf.webdav.Lock;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.uses.net.sf.webdav.exceptions.LockFailedException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.WebdavException;
import org.opencrx.application.webdav.DocumentCollectionResource;
import org.opencrx.application.webdav.DocumentFilterFeedResource;
import org.opencrx.application.webdav.DocumentFolderFeedResource;
import org.opencrx.application.webdav.DocumentFolderResource;
import org.opencrx.application.webdav.DocumentProfileResource;
import org.opencrx.application.webdav.DocumentResource;
import org.opencrx.application.webdav.WebDavRequestContext;
import org.opencrx.application.webdav.WebDavResource;
import org.opencrx.kernel.document1.cci2.DocumentBasedFolderEntryQuery;
import org.opencrx.kernel.document1.cci2.DocumentFolderQuery;
import org.opencrx.kernel.document1.cci2.DocumentLockQuery;
import org.opencrx.kernel.document1.cci2.DocumentQuery;
import org.opencrx.kernel.document1.jmi1.Document;
import org.opencrx.kernel.document1.jmi1.DocumentFilterGlobal;
import org.opencrx.kernel.document1.jmi1.DocumentFolder;
import org.opencrx.kernel.document1.jmi1.DocumentFolderEntry;
import org.opencrx.kernel.document1.jmi1.DocumentLock;
import org.opencrx.kernel.document1.jmi1.DocumentRevision;
import org.opencrx.kernel.document1.jmi1.MediaContent;
import org.opencrx.kernel.document1.jmi1.Segment;
import org.opencrx.kernel.home1.cci2.DocumentProfileQuery;
import org.opencrx.kernel.home1.jmi1.DocumentProfile;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.opencrx.kernel.utils.Utils;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.BasicObject;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.UserObjects;
import org.openmdx.base.text.conversion.UUIDConversion;
import org.openmdx.kernel.id.UUIDs;
import org.w3c.cci2.BinaryLargeObject;
import org.w3c.cci2.BinaryLargeObjects;

public class WebDavStore
implements org.opencrx.application.uses.net.sf.webdav.WebDavStore {
    protected PersistenceManagerFactory pmf = null;

    public WebDavStore(PersistenceManagerFactory pmf) {
        this.pmf = pmf;
    }

    public static PersistenceManager getPersistenceManager(HttpServletRequest req, PersistenceManagerFactory pmf) {
        return req.getUserPrincipal() == null ? null : pmf.getPersistenceManager(req.getUserPrincipal().getName(), null);
    }

    @Override
    public RequestContext begin(HttpServletRequest req, HttpServletResponse resp) {
        WebDavRequestContext requestContext = new WebDavRequestContext(req, resp, this.pmf);
        return requestContext;
    }

    @Override
    public void commit(RequestContext requestContext) {
        PersistenceManager pm = ((WebDavRequestContext)requestContext).getPersistenceManager();
        try {
            if (!pm.isClosed()) {
                pm.currentTransaction().commit();
                pm.close();
            }
        }
        catch (Exception e) {
            try {
                pm.currentTransaction().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void createCollection(RequestContext requestContext, String path) {
        int pos;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((pos = path.lastIndexOf("/")) <= 0) throw new WebdavException("Unable to create folder. Invalid path >" + path + "<");
        String parentPath = path.substring(0, pos);
        DocumentCollectionResource parent = (DocumentCollectionResource)this.getResourceByPath(requestContext, parentPath);
        if (parent == null) throw new WebdavException("Unable to create folder. Parent folder >" + path + "< not found");
        String name = path.substring(pos + 1);
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)parent.getObject());
        if (!(parent.getObject() instanceof DocumentFolder)) throw new WebdavException("Unable to create folder. Parent folder >" + path + "< not a document folder");
        DocumentFolder parentFolder = (DocumentFolder)parent.getObject();
        DocumentFolderQuery query = (DocumentFolderQuery)pm.newQuery(DocumentFolder.class);
        query.name().equalTo((Object)name);
        List folders = parentFolder.getSubFolder(query);
        if (!folders.isEmpty()) return;
        Segment documentSegment = (Segment)pm.getObjectById((Object)parentFolder.refGetPath().getPrefix(5));
        pm.currentTransaction().begin();
        DocumentFolder newFolder = (DocumentFolder)pm.newInstance(DocumentFolder.class);
        newFolder.setName(name);
        newFolder.setParent(parentFolder);
        newFolder.getOwningGroup().addAll(parentFolder.getOwningGroup());
        documentSegment.addFolder(UUIDConversion.toUID((UUID)UUIDs.newUUID()), newFolder);
        pm.currentTransaction().commit();
    }

    @Override
    public Collection<Resource> getChildren(RequestContext requestContext, Resource res, Date timeRangeStart, Date timeRangeEnd) {
        if (res instanceof WebDavResource) {
            return ((WebDavResource)res).getChildren(timeRangeStart, timeRangeEnd);
        }
        return Collections.emptyList();
    }

    @Override
    public WebDavStore.ResourceContent getResourceContent(RequestContext requestContext, Resource res) {
        if (res instanceof WebDavResource) {
            return ((WebDavResource)res).getContent();
        }
        return new WebDavStore.ResourceContent(){

            @Override
            public BinaryLargeObject getContent() {
                return BinaryLargeObjects.valueOf((byte[])new byte[0]);
            }

            @Override
            public Long getLength() {
                return 0L;
            }
        };
    }

    @Override
    public Resource getResourceByPath(RequestContext requestContext, String path) {
        PersistenceManager pm = ((WebDavRequestContext)requestContext).getPersistenceManager();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        path = path.replace("/user/", "/");
        String[] components = (path = path.replace("/profile/", "/")).split("/");
        if (components.length >= 4) {
            UserHome userHome = (UserHome)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.home1").getDescendant(new String[]{"provider", components[0], "segment", components[1], "userHome", components[2]}));
            String profileName = components[3];
            DocumentProfileQuery documentProfileQuery = (DocumentProfileQuery)pm.newQuery(DocumentProfile.class);
            documentProfileQuery.name().equalTo((Object)profileName);
            List documentProfiles = userHome.getSyncProfile(documentProfileQuery);
            if (documentProfiles.isEmpty()) {
                return null;
            }
            DocumentProfileResource documentProfileResource = new DocumentProfileResource(requestContext, (DocumentProfile)documentProfiles.iterator().next());
            if (components.length == 4) {
                return documentProfileResource;
            }
            String feedName = components[4];
            DocumentCollectionResource documentCollectionResource = null;
            for (Resource resource : documentProfileResource.getChildren(null, null)) {
                DocumentFilterFeedResource documentFilterFeedResource;
                if (resource instanceof DocumentFolderFeedResource) {
                    DocumentFolderFeedResource documentFeedResource = (DocumentFolderFeedResource)resource;
                    if (!documentFeedResource.getName().equals(feedName)) continue;
                    documentCollectionResource = documentFeedResource;
                    break;
                }
                if (!(resource instanceof DocumentFilterFeedResource) || !(documentFilterFeedResource = (DocumentFilterFeedResource)resource).getName().equals(feedName)) continue;
                documentCollectionResource = documentFilterFeedResource;
                break;
            }
            if (documentCollectionResource == null) {
                return null;
            }
            for (int i = 5; i < components.length; ++i) {
                String name = components[i];
                if (documentCollectionResource.getObject() instanceof DocumentFolder) {
                    DocumentFolder documentFolder = (DocumentFolder)documentCollectionResource.getObject();
                    DocumentFolderQuery folderQuery = documentCollectionResource.getFolderQuery();
                    folderQuery.name().equalTo((Object)name);
                    List documentFolders = documentFolder.getSubFolder(folderQuery);
                    if (!documentFolders.isEmpty()) {
                        documentCollectionResource = new DocumentFolderResource(requestContext, (DocumentFolder)documentFolders.iterator().next());
                        continue;
                    }
                    DocumentBasedFolderEntryQuery folderEntryQuery = documentCollectionResource.getFolderEntryQuery();
                    folderEntryQuery.name().equalTo((Object)name);
                    List entries = documentFolder.getFolderEntry(folderEntryQuery);
                    return entries.isEmpty() ? null : new DocumentResource(requestContext, (Document)((DocumentFolderEntry)entries.iterator().next()).getDocument(), documentCollectionResource);
                }
                if (!(documentCollectionResource instanceof DocumentFilterFeedResource)) continue;
                DocumentFilterFeedResource filterFeedResource = (DocumentFilterFeedResource)documentCollectionResource;
                DocumentQuery documentQuery = documentCollectionResource.getDocumentQuery();
                documentQuery.name().equalTo((Object)name);
                List entries = filterFeedResource.getObject().getFilteredDocument(documentQuery);
                return entries.isEmpty() ? null : new DocumentResource(requestContext, (Document)entries.iterator().next(), documentCollectionResource);
            }
            return documentCollectionResource;
        }
        return null;
    }

    @Override
    public WebDavStore.Status removeResource(RequestContext requestContext, String path, Resource res) {
        BasicObject documentCollection;
        PersistenceManager pm = ((WebDavRequestContext)requestContext).getPersistenceManager();
        if (res instanceof DocumentResource) {
            Document document = ((DocumentResource)res).getObject();
            DocumentCollectionResource documentCollectionResource = ((DocumentResource)res).getDocumentCollectionResource();
            try {
                pm.currentTransaction().begin();
                if (documentCollectionResource.getObject() instanceof DocumentFolder) {
                    DocumentFolder documentFolder = (DocumentFolder)documentCollectionResource.getObject();
                    document.getFolder().remove(documentFolder);
                }
                if (document.getFolder().isEmpty()) {
                    document.setDisabled(true);
                }
                pm.currentTransaction().commit();
                return WebDavStore.Status.OK;
            }
            catch (Exception e) {
                new ServiceException(e).log();
                try {
                    pm.currentTransaction().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return WebDavStore.Status.FORBIDDEN;
            }
        }
        if (res instanceof DocumentCollectionResource && (documentCollection = ((DocumentCollectionResource)res).getObject()) instanceof DocumentFolder) {
            try {
                pm.currentTransaction().begin();
                ((DocumentFolder)documentCollection).setDisabled(true);
                pm.currentTransaction().commit();
                return WebDavStore.Status.OK;
            }
            catch (Exception e) {
                new ServiceException(e).log();
                try {
                    pm.currentTransaction().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return WebDavStore.Status.FORBIDDEN;
            }
        }
        return WebDavStore.Status.FORBIDDEN;
    }

    @Override
    public WebDavStore.Status moveResource(RequestContext requestContext, Resource sourceRes, String sourcePath, String destinationPath) {
        if (sourcePath.endsWith("/")) {
            sourcePath = sourcePath.substring(0, sourcePath.length() - 1);
        }
        if (destinationPath.endsWith("/")) {
            destinationPath = destinationPath.substring(0, destinationPath.length() - 1);
        }
        String sourceFolderName = this.getParentPath(sourcePath);
        String destFolderName = this.getParentPath(destinationPath);
        String newName = destinationPath.substring(destFolderName.length() + 1);
        if (sourceRes instanceof DocumentResource) {
            Resource destRes = this.getResourceByPath(requestContext, this.getParentPath(destinationPath));
            if (sourceFolderName.equals(destFolderName)) {
                PersistenceManager pm = ((WebDavRequestContext)requestContext).getPersistenceManager();
                Document document = ((DocumentResource)sourceRes).getObject();
                pm.currentTransaction().begin();
                document.setName(newName);
                document.setTitle(newName);
                if (document.getHeadRevision() != null) {
                    DocumentRevision headRevision = document.getHeadRevision();
                    headRevision.setName(newName);
                    if (headRevision instanceof MediaContent) {
                        ((MediaContent)headRevision).setContentName(newName);
                    }
                }
                pm.currentTransaction().commit();
                return WebDavStore.Status.OK_CREATED;
            }
            if (destRes instanceof DocumentCollectionResource) {
                WebDavStore.Status status = null;
                try {
                    status = this.putResource(requestContext, destinationPath, this.getResourceContent(requestContext, sourceRes).getContent().getContent(), this.getMimeType(destRes));
                }
                catch (Exception e) {
                    throw new WebdavException("Unable to put source content to destination. source=>" + sourcePath + "< destination=>" + destinationPath + "<");
                }
                if (status == WebDavStore.Status.FORBIDDEN) {
                    return WebDavStore.Status.FORBIDDEN;
                }
                PersistenceManager pm = ((WebDavRequestContext)requestContext).getPersistenceManager();
                Document document = ((DocumentResource)sourceRes).getObject();
                pm.currentTransaction().begin();
                document.setDisabled(true);
                pm.currentTransaction().commit();
                return WebDavStore.Status.OK_CREATED;
            }
        } else if (sourceRes instanceof DocumentCollectionResource) {
            if (sourceFolderName.equals(destFolderName)) {
                PersistenceManager pm = ((WebDavRequestContext)requestContext).getPersistenceManager();
                BasicObject documentCollection = ((DocumentCollectionResource)sourceRes).getObject();
                if (documentCollection instanceof DocumentFolder) {
                    pm.currentTransaction().begin();
                    ((DocumentFolder)documentCollection).setName(newName);
                    pm.currentTransaction().commit();
                    return WebDavStore.Status.OK_CREATED;
                }
                if (documentCollection instanceof DocumentFilterGlobal) {
                    pm.currentTransaction().begin();
                    ((DocumentFilterGlobal)documentCollection).setName(newName);
                    pm.currentTransaction().commit();
                    return WebDavStore.Status.OK_CREATED;
                }
                return WebDavStore.Status.FORBIDDEN;
            }
            throw new WebdavException("Move only supports rename of resources. source=>" + sourceFolderName + "< destination=>" + destFolderName + "<");
        }
        throw new WebdavException("Unsupported move operation. source=>" + sourceFolderName + "< destination=>" + destFolderName + "<");
    }

    @Override
    public void rollback(RequestContext requestContext) {
        PersistenceManager pm = ((WebDavRequestContext)requestContext).getPersistenceManager();
        try {
            if (!pm.isClosed()) {
                pm.currentTransaction().rollback();
                pm.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getMimeType(Resource res) {
        if (res instanceof WebDavResource) {
            return ((WebDavResource)res).getMimeType();
        }
        return "application/xml";
    }

    protected String getParentPath(String path) {
        int slash = path.lastIndexOf(47);
        if (slash != -1) {
            return path.substring(0, slash);
        }
        return null;
    }

    @Override
    public WebDavStore.Status putResource(RequestContext requestContext, String path, InputStream content, String contentType) {
        String parentPath = this.getParentPath(path);
        Resource parent = this.getResourceByPath(requestContext, parentPath);
        if (parent instanceof DocumentCollectionResource) {
            try {
                DocumentCollectionResource documentCollectionResource = (DocumentCollectionResource)parent;
                if (documentCollectionResource.getObject() instanceof DocumentFolder) {
                    WebDavStore.Status status = WebDavStore.Status.OK;
                    DocumentFolder documentFolder = (DocumentFolder)documentCollectionResource.getObject();
                    PersistenceManager pm = JDOHelper.getPersistenceManager((Object)documentFolder);
                    Segment documentSegment = (Segment)pm.getObjectById((Object)documentFolder.refGetPath().getParent().getParent());
                    DocumentBasedFolderEntryQuery query = documentCollectionResource.getFolderEntryQuery();
                    String name = path.substring(path.lastIndexOf("/") + 1);
                    if (contentType == null) {
                        contentType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(name);
                    }
                    query.name().equalTo((Object)name);
                    List entries = documentFolder.getFolderEntry(query);
                    Document document = null;
                    pm.currentTransaction().begin();
                    if (entries.isEmpty()) {
                        document = (Document)pm.newInstance(Document.class);
                        document.setName(name);
                        document.setTitle(name);
                        document.setContentType(contentType);
                        document.getOwningGroup().addAll(documentFolder.getOwningGroup());
                        documentSegment.addDocument(Utils.getUidAsString(), document);
                        document.getFolder().add(documentFolder);
                        status = WebDavStore.Status.OK_CREATED;
                    } else {
                        document = (Document)((DocumentFolderEntry)entries.iterator().next()).getDocument();
                    }
                    MediaContent revision = (MediaContent)pm.newInstance(MediaContent.class);
                    revision.setName(name);
                    revision.setContentName(name);
                    revision.setContentMimeType(contentType);
                    ByteArrayOutputStream contentAsBytes = new ByteArrayOutputStream();
                    BinaryLargeObjects.streamCopy((InputStream)content, (long)0L, (OutputStream)contentAsBytes);
                    contentAsBytes.close();
                    revision.setContent(BinaryLargeObjects.valueOf((byte[])contentAsBytes.toByteArray()));
                    revision.getOwningGroup().addAll(documentFolder.getOwningGroup());
                    Integer version = 0;
                    if (document.getHeadRevision() != null) {
                        try {
                            version = Integer.valueOf(document.getHeadRevision().getVersion());
                            version = version + 1;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    revision.setVersion(Integer.toString(version));
                    document.addRevision(Utils.getUidAsString(), revision);
                    document.setHeadRevision(revision);
                    document.setContentLength(contentAsBytes.size());
                    pm.currentTransaction().commit();
                    return status;
                }
                return WebDavStore.Status.FORBIDDEN;
            }
            catch (Exception e) {
                new ServiceException(e).log();
            }
        }
        return null;
    }

    @Override
    public List<Lock> getLocksByPath(RequestContext requestContext, String path) {
        Resource res = this.getResourceByPath(requestContext, path);
        if (res instanceof DocumentResource) {
            DocumentResource documentRes = (DocumentResource)res;
            Document document = documentRes.getObject();
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)document);
            DocumentLockQuery documentLockQuery = (DocumentLockQuery)pm.newQuery(DocumentLock.class);
            ArrayList<Lock> locks = new ArrayList<Lock>();
            for (DocumentLock documentLock : document.getLock(documentLockQuery)) {
                if (documentLock.getDescription() == null || documentLock.getDescription().isEmpty()) continue;
                try {
                    Gson json = new Gson();
                    LockImpl lock = (LockImpl)json.fromJson(documentLock.getDescription(), LockImpl.class);
                    if (lock.getExpiresAt() <= System.currentTimeMillis()) continue;
                    locks.add(lock);
                }
                catch (Exception exception) {}
            }
            return locks;
        }
        return Collections.emptyList();
    }

    @Override
    public Lock lock(RequestContext requestContext, String path, String id, String owner, String scope, String type, int depth, int timeout) throws LockFailedException {
        DocumentResource documentRes;
        Resource res = this.getResourceByPath(requestContext, path);
        if (res instanceof DocumentResource && (documentRes = (DocumentResource)res).getObject() instanceof Document) {
            Document document = documentRes.getObject();
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)document);
            owner = UserObjects.getPrincipalChain((PersistenceManager)pm).toString();
            LockImpl lock = new LockImpl(id, owner, scope, type, depth, timeout);
            try {
                DocumentLockQuery documentLockQuery = (DocumentLockQuery)pm.newQuery(DocumentLock.class);
                documentLockQuery.name().equalTo((Object)lock.getID());
                List documentLocks = document.getLock(documentLockQuery);
                DocumentLock documentLock = null;
                pm.currentTransaction().begin();
                if (documentLocks.isEmpty()) {
                    documentLock = (DocumentLock)pm.newInstance(DocumentLock.class);
                    documentLock.setName(lock.getID());
                    documentLock.getLockedBy().addAll(UserObjects.getPrincipalChain((PersistenceManager)pm));
                    document.addLock(Utils.getUidAsString(), documentLock);
                } else {
                    documentLock = (DocumentLock)documentLocks.iterator().next();
                }
                Gson json = new Gson();
                documentLock.setDescription(json.toJson((Object)lock));
                documentLock.setLockedAt(new Date());
                pm.currentTransaction().commit();
            }
            catch (Exception e) {
                new ServiceException(e).log();
                try {
                    pm.currentTransaction().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return lock;
        }
        return new LockImpl(id, owner, scope, type, depth, timeout);
    }

    @Override
    public boolean unlock(RequestContext requestContext, String path, String id) {
        DocumentResource documentRes;
        Resource res = this.getResourceByPath(requestContext, path);
        if (res instanceof DocumentResource && (documentRes = (DocumentResource)res).getObject() instanceof Document) {
            Document document = documentRes.getObject();
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)document);
            DocumentLockQuery documentLockQuery = (DocumentLockQuery)pm.newQuery(DocumentLock.class);
            documentLockQuery.name().equalTo((Object)id);
            List documentLocks = document.getLock(documentLockQuery);
            if (!documentLocks.isEmpty()) {
                try {
                    pm.currentTransaction().begin();
                    for (DocumentLock documentLock : documentLocks) {
                        pm.deletePersistent((Object)documentLock);
                    }
                    pm.currentTransaction().commit();
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                    try {
                        pm.currentTransaction().rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return true;
    }

    private static class LockImpl
    implements Lock {
        private final String id;
        private final String owner;
        private final String scope;
        private final String type;
        private final int depth;
        private final long expiresAt;

        public LockImpl(String id, String owner, String scope, String type, int depth, int timeout) {
            int end;
            int start;
            this.id = id != null && id.indexOf("opaquelocktoken:") > 0 ? id.substring(start + 16, (end = id.indexOf(">", start = id.indexOf("opaquelocktoken:"))) > 0 ? end : id.length()) : Utils.getUidAsString();
            this.owner = owner;
            this.scope = scope;
            this.type = type;
            this.depth = depth;
            this.expiresAt = System.currentTimeMillis() + (long)timeout * 1000L;
        }

        @Override
        public long getExpiresAt() {
            return this.expiresAt;
        }

        @Override
        public String getID() {
            return this.id;
        }

        @Override
        public int getLockDepth() {
            return this.depth;
        }

        @Override
        public String getOwner() {
            return this.owner;
        }

        @Override
        public String getScope() {
            return this.scope;
        }

        @Override
        public String getType() {
            return this.type;
        }
    }
}

