/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.backend;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import org.opencrx.kernel.account1.jmi1.AccountFilterGlobal;
import org.opencrx.kernel.account1.jmi1.AccountFilterProperty;
import org.opencrx.kernel.account1.jmi1.AccountQueryFilterProperty;
import org.opencrx.kernel.account1.jmi1.AddressFilterProperty;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.activity1.jmi1.ActivityFilterProperty;
import org.opencrx.kernel.activity1.jmi1.ActivityProcess;
import org.opencrx.kernel.activity1.jmi1.ActivityProcessState;
import org.opencrx.kernel.activity1.jmi1.ActivityProcessStateFilterProperty;
import org.opencrx.kernel.activity1.jmi1.ActivityTracker;
import org.opencrx.kernel.activity1.jmi1.ActivityType;
import org.opencrx.kernel.activity1.jmi1.ActivityTypeFilterProperty;
import org.opencrx.kernel.backend.AbstractImpl;
import org.opencrx.kernel.backend.Accounts;
import org.opencrx.kernel.backend.Activities;
import org.opencrx.kernel.backend.Contracts;
import org.opencrx.kernel.backend.Products;
import org.opencrx.kernel.backend.SecureObject;
import org.opencrx.kernel.backend.UserHomes;
import org.opencrx.kernel.backend.Workflows;
import org.opencrx.kernel.contract1.jmi1.ContractFilterProperty;
import org.opencrx.kernel.contract1.jmi1.ContractQueryFilterProperty;
import org.opencrx.kernel.contract1.jmi1.ContractStateFilterProperty;
import org.opencrx.kernel.contract1.jmi1.ContractTypeFilterProperty;
import org.opencrx.kernel.generic.SecurityKeys;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.opencrx.kernel.product1.jmi1.Segment;
import org.opencrx.security.realm1.jmi1.Principal;
import org.opencrx.security.realm1.jmi1.PrincipalGroup;
import org.opencrx.security.realm1.jmi1.User;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.Provider;
import org.openmdx.base.naming.Path;
import org.openmdx.base.query.ConditionType;
import org.openmdx.base.query.Quantifier;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.log.SysLog;
import org.openmdx.portal.servlet.CssClass;
import org.openmdx.security.authorization1.jmi1.Policy;
import org.openmdx.security.realm1.cci2.Subject;
import org.openmdx.security.realm1.jmi1.Group;
import org.openmdx.security.realm1.jmi1.Realm;

public class Admin
extends AbstractImpl {
    public static final String OK = CssClass.alert_success.toString();
    public static final String MISSING = CssClass.alert_danger.toString();
    public static final String SALES_TAX_TYPE_NAME_8_5 = "Sales Tax 8.5%";
    public static final String ACCOUNT_FILTER_NAME_ALL = "All Accounts";
    public static final String ACCOUNT_FILTER_NAME_NO_OR_BROKEN_VCARD = "Accounts with missing or broken vCard";
    public static final String ADDRESS_FILTER_NAME_ALL = "All Addresses";
    public static final String CONTRACT_FILTER_NAME_LEAD_FORECAST = "Lead Forecast";
    public static final String CONTRACT_FILTER_NAME_OPPORTUNITY_FORECAST = "Opportunity Forecast";
    public static final String CONTRACT_FILTER_NAME_QUOTE_FORECAST = "Quote Forecast";
    public static final String CONTRACT_FILTER_NAME_WON_LEADS = "Won Leads";
    public static final String CONTRACT_FILTER_NAME_WON_OPPORTUNITIES = "Won Opportunities";
    public static final String CONTRACT_FILTER_NAME_WON_QUOTES = "Won Quotes";
    public static final String ACTIVITY_FILTER_NAME_PHONE_CALLS = "Phone Calls";
    public static final String ACTIVITY_FILTER_NAME_NEW_ACTIVITIES = "New Activities";
    public static final String ACTIVITY_FILTER_NAME_OPEN_ACTIVITIES = "Open Activities";
    public static final String ACTIVITY_FILTER_NAME_MEETINGS = "Meetings";

    public static void register() {
        Admin.registerImpl(new Admin());
    }

    public static Admin getInstance() throws ServiceException {
        return Admin.getInstance(Admin.class);
    }

    protected Admin() {
    }

    public void createSegment(Provider provider, org.openmdx.base.jmi1.Segment segment, String segmentName, User owningUser, PrincipalGroup owningGroup, List<String> errors) {
        org.openmdx.base.jmi1.Segment test = null;
        try {
            test = provider.getSegment(segmentName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (test == null) {
            if (segment instanceof org.opencrx.kernel.base.jmi1.SecureObject) {
                ((org.opencrx.kernel.base.jmi1.SecureObject)segment).setOwningUser(owningUser);
                ((org.opencrx.kernel.base.jmi1.SecureObject)segment).getOwningGroup().add(owningGroup);
                ((org.opencrx.kernel.base.jmi1.SecureObject)segment).setAccessLevelBrowse(new Short(4));
                ((org.opencrx.kernel.base.jmi1.SecureObject)segment).setAccessLevelUpdate(new Short(3));
                ((org.opencrx.kernel.base.jmi1.SecureObject)segment).setAccessLevelDelete(new Short(1));
            }
            try {
                provider.addSegment(segmentName, segment);
            }
            catch (Exception e0) {
                ServiceException e1 = new ServiceException(e0);
                SysLog.warning((String)e1.getMessage(), (Throwable)e1.getCause());
                errors.add("Unable to create segment " + segment);
                errors.add("reason is " + e0.getMessage());
            }
        }
    }

    public Contact createContact(org.opencrx.kernel.admin1.jmi1.Segment adminSegment, String segmentName, String principalName, User owningUser, List<PrincipalGroup> owningGroups, List<String> errors) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)adminSegment);
        org.opencrx.kernel.account1.jmi1.Segment accountSegment = (org.opencrx.kernel.account1.jmi1.Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.account1").getDescendant(new String[]{"provider", adminSegment.refGetPath().get(2), "segment", segmentName}));
        Contact contact = null;
        try {
            contact = (Contact)accountSegment.getAccount(principalName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (contact == null) {
            contact = (Contact)pm.newInstance(Contact.class);
            contact.setLastName(principalName);
            contact.setOwningUser(owningUser);
            contact.getOwningGroup().addAll(owningGroups);
            accountSegment.addAccount(principalName, contact);
        }
        return contact;
    }

    public org.opencrx.security.identity1.jmi1.Subject createSubject(org.opencrx.security.identity1.jmi1.Segment identitySegment, String subjectName, String subjectDescription, List<String> errors) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)identitySegment);
        org.opencrx.security.identity1.jmi1.Subject subject = identitySegment.getSubject(subjectName);
        if (subject == null) {
            subject = (org.opencrx.security.identity1.jmi1.Subject)pm.newInstance(org.opencrx.security.identity1.jmi1.Subject.class);
            subject.setDescription(subjectDescription == null ? subjectName : subjectDescription);
            identitySegment.addSubject(false, subjectName, subject);
        }
        return subject;
    }

    public org.openmdx.security.realm1.jmi1.Principal createPrincipal(String id, String description, Realm realm, PrincipalType principalType, List<Group> memberOfGroups, org.openmdx.security.realm1.jmi1.Subject subject) throws ServiceException {
        return this.createPrincipal(id, null, description, realm, principalType, memberOfGroups, subject);
    }

    public boolean isValidPrincipalId(String principalId) throws ServiceException {
        return Charset.forName("US-ASCII").newEncoder().canEncode(principalId) && principalId.indexOf("@") < 0 && principalId.indexOf("[") < 0 && principalId.indexOf("]") < 0 && principalId.indexOf("{") < 0 && principalId.indexOf("}") < 0 && principalId.indexOf("\\") < 0 && principalId.indexOf(" ") < 0;
    }

    public org.openmdx.security.realm1.jmi1.Principal createPrincipal(String id, String name, String description, Realm realm, PrincipalType principalType, List<Group> memberOfGroups, org.openmdx.security.realm1.jmi1.Subject subject) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)realm);
        if (!this.isValidPrincipalId(id)) {
            throw new ServiceException("OpenCrxDomain", 10000, "principal id must be US-ASCII and not contain @,[,],{,},\\", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)id)});
        }
        org.openmdx.security.realm1.jmi1.Principal principal = realm.getPrincipal(id);
        if (principal != null) {
            LinkedHashSet<Group> mergedGroups = new LinkedHashSet<Group>(principal.getIsMemberOf());
            mergedGroups.addAll(memberOfGroups);
            principal.getIsMemberOf().clear();
            principal.getIsMemberOf().addAll(mergedGroups);
        } else {
            switch (principalType) {
                case USER: {
                    principal = (org.openmdx.security.realm1.jmi1.Principal)pm.newInstance(User.class);
                    break;
                }
                case PRINCIPAL: {
                    principal = (org.openmdx.security.realm1.jmi1.Principal)pm.newInstance(Principal.class);
                    break;
                }
                case GROUP: {
                    principal = (org.openmdx.security.realm1.jmi1.Principal)pm.newInstance(PrincipalGroup.class);
                }
            }
            principal.setName(name == null ? id : name);
            principal.setDescription(description == null ? realm.refGetPath().getLastSegment().toString() + "\\\\" + id : description);
            principal.setDisabled(Boolean.FALSE);
            principal.getIsMemberOf().addAll(new LinkedHashSet<Group>(memberOfGroups));
            principal.setSubject((Subject)subject);
            realm.addPrincipal(id, principal);
        }
        return principal;
    }

    public Policy createPolicy(PersistenceManager pm, String providerName, String segmentName) {
        Path policyIdentity = SecureObject.getPolicyIdentity(providerName, segmentName);
        Policy policy = null;
        try {
            policy = (Policy)pm.getObjectById((Object)policyIdentity);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (policy == null) {
            org.openmdx.security.authorization1.jmi1.Segment policySegment = (org.openmdx.security.authorization1.jmi1.Segment)pm.getObjectById((Object)policyIdentity.getParent().getParent());
            policy = (Policy)pm.newInstance(Policy.class);
            policy.setDescription(segmentName + " Policy");
            policySegment.addPolicy(false, segmentName, policy);
        }
        return policy;
    }

    public void createAdministrator(org.opencrx.kernel.admin1.jmi1.Segment adminSegment, String segmentName, String principalId, String initialPassword, String initialPasswordVerification, List<String> errors) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)adminSegment);
        String providerName = adminSegment.refGetPath().get(2);
        Path realmIdentity = SecureObject.getRealmIdentity(providerName, segmentName);
        Path contactIdentity = null;
        Path groupAdministratorsIdentity = null;
        PersistenceManager pmRoot = pm.getPersistenceManagerFactory().getPersistenceManager("admin-Root", null);
        pmRoot.currentTransaction().begin();
        String adminPrincipalName = "admin" + SecurityKeys.ID_SEPARATOR + segmentName;
        Path loginRealmIdentity = SecureObject.getInstance().getLoginRealmIdentity(providerName);
        Realm loginRealm = (Realm)pmRoot.getObjectById((Object)loginRealmIdentity);
        org.openmdx.security.realm1.jmi1.Subject segmentAdminSubject = null;
        if (loginRealm.getPrincipal(principalId) != null) {
            try {
                segmentAdminSubject = loginRealm.getPrincipal(principalId).getSubject();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (segmentAdminSubject == null) {
            org.opencrx.security.identity1.jmi1.Segment identitySegment = (org.opencrx.security.identity1.jmi1.Segment)pmRoot.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.security.identity1").getDescendant(new String[]{"provider", loginRealmIdentity.get(2), "segment", "Root"}));
            segmentAdminSubject = this.createSubject(identitySegment, adminPrincipalName, null, errors);
            if (!errors.isEmpty()) {
                return;
            }
            ArrayList<Group> groups = new ArrayList<Group>();
            groups.add((Group)loginRealm.getPrincipal("Administrators"));
            this.createPrincipal(principalId, null, null, loginRealm, PrincipalType.PRINCIPAL, groups, segmentAdminSubject);
        }
        if (loginRealm.getPrincipal(adminPrincipalName) == null && !principalId.equals(adminPrincipalName)) {
            errors.add("primary principal name must match " + adminPrincipalName);
            return;
        }
        if (principalId.startsWith("admin" + SecurityKeys.ID_SEPARATOR) && !principalId.equals(adminPrincipalName)) {
            errors.add("admin principal for segment " + segmentName + " must match " + adminPrincipalName);
            return;
        }
        this.createPolicy(pmRoot, providerName, segmentName);
        Realm realm = null;
        try {
            realm = (Realm)pmRoot.getObjectById((Object)realmIdentity);
        }
        catch (Exception groups) {
            // empty catch block
        }
        if (realm == null) {
            org.openmdx.security.realm1.jmi1.Segment realmSegment = (org.openmdx.security.realm1.jmi1.Segment)pmRoot.getObjectById((Object)realmIdentity.getParent().getParent());
            realm = (Realm)pmRoot.newInstance(Realm.class);
            realm.setDescription(segmentName + " Realm");
            realmSegment.addRealm(segmentName, realm);
        }
        User adminUser = (User)this.createPrincipal(principalId + "." + "User", null, null, realm, PrincipalType.USER, new ArrayList<Group>(), segmentAdminSubject);
        ArrayList<Object> groups = new ArrayList<Group>();
        groups.add(adminUser);
        this.createPrincipal(principalId, null, null, realm, PrincipalType.PRINCIPAL, groups, segmentAdminSubject);
        PrincipalGroup groupUnspecified = (PrincipalGroup)this.createPrincipal("Unspecified", null, null, realm, PrincipalType.GROUP, new ArrayList<Group>(), segmentAdminSubject);
        groups = new ArrayList();
        groups.add(groupUnspecified);
        PrincipalGroup groupAdministrators = (PrincipalGroup)this.createPrincipal("Administrators", null, null, realm, PrincipalType.GROUP, groups, segmentAdminSubject);
        groupAdministratorsIdentity = groupAdministrators.refGetPath();
        PrincipalGroup groupUsers = (PrincipalGroup)this.createPrincipal("Users", null, null, realm, PrincipalType.GROUP, groups, segmentAdminSubject);
        groups = new ArrayList();
        groups.add(groupUsers);
        this.createPrincipal("Unassigned", null, null, realm, PrincipalType.GROUP, groups, segmentAdminSubject);
        this.createPrincipal("Public", null, null, realm, PrincipalType.GROUP, groups, segmentAdminSubject);
        this.createSegment((Provider)pmRoot.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.account1").getDescendant(new String[]{"provider", providerName})), (org.openmdx.base.jmi1.Segment)pmRoot.newInstance(org.opencrx.kernel.account1.jmi1.Segment.class), segmentName, adminUser, groupAdministrators, errors);
        this.createSegment((Provider)pmRoot.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.home1").getDescendant(new String[]{"provider", providerName})), (org.openmdx.base.jmi1.Segment)pmRoot.newInstance(org.opencrx.kernel.home1.jmi1.Segment.class), segmentName, adminUser, groupAdministrators, errors);
        this.createSegment((Provider)pmRoot.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.activity1").getDescendant(new String[]{"provider", providerName})), (org.openmdx.base.jmi1.Segment)pmRoot.newInstance(org.opencrx.kernel.activity1.jmi1.Segment.class), segmentName, adminUser, groupAdministrators, errors);
        this.createSegment((Provider)pmRoot.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.contract1").getDescendant(new String[]{"provider", providerName})), (org.openmdx.base.jmi1.Segment)pmRoot.newInstance(org.opencrx.kernel.contract1.jmi1.Segment.class), segmentName, adminUser, groupAdministrators, errors);
        this.createSegment((Provider)pmRoot.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.product1").getDescendant(new String[]{"provider", providerName})), (org.openmdx.base.jmi1.Segment)pmRoot.newInstance(Segment.class), segmentName, adminUser, groupAdministrators, errors);
        this.createSegment((Provider)pmRoot.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.document1").getDescendant(new String[]{"provider", providerName})), (org.openmdx.base.jmi1.Segment)pmRoot.newInstance(org.opencrx.kernel.document1.jmi1.Segment.class), segmentName, adminUser, groupAdministrators, errors);
        this.createSegment((Provider)pmRoot.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.building1").getDescendant(new String[]{"provider", providerName})), (org.openmdx.base.jmi1.Segment)pmRoot.newInstance(org.opencrx.kernel.building1.jmi1.Segment.class), segmentName, adminUser, groupAdministrators, errors);
        this.createSegment((Provider)pmRoot.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.uom1").getDescendant(new String[]{"provider", providerName})), (org.openmdx.base.jmi1.Segment)pmRoot.newInstance(org.opencrx.kernel.uom1.jmi1.Segment.class), segmentName, adminUser, groupAdministrators, errors);
        this.createSegment((Provider)pmRoot.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.forecast1").getDescendant(new String[]{"provider", providerName})), (org.openmdx.base.jmi1.Segment)pmRoot.newInstance(org.opencrx.kernel.forecast1.jmi1.Segment.class), segmentName, adminUser, groupAdministrators, errors);
        this.createSegment((Provider)pmRoot.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.workflow1").getDescendant(new String[]{"provider", providerName})), (org.openmdx.base.jmi1.Segment)pmRoot.newInstance(org.opencrx.kernel.workflow1.jmi1.Segment.class), segmentName, adminUser, groupAdministrators, errors);
        this.createSegment((Provider)pmRoot.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.depot1").getDescendant(new String[]{"provider", providerName})), (org.openmdx.base.jmi1.Segment)pmRoot.newInstance(org.opencrx.kernel.depot1.jmi1.Segment.class), segmentName, adminUser, groupAdministrators, errors);
        this.createSegment((Provider)pmRoot.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.model1").getDescendant(new String[]{"provider", providerName})), (org.openmdx.base.jmi1.Segment)pmRoot.newInstance(org.opencrx.kernel.model1.jmi1.Segment.class), segmentName, adminUser, groupAdministrators, errors);
        this.createSegment((Provider)pmRoot.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.code1").getDescendant(new String[]{"provider", providerName})), (org.openmdx.base.jmi1.Segment)pmRoot.newInstance(org.opencrx.kernel.code1.jmi1.Segment.class), segmentName, adminUser, groupAdministrators, errors);
        if (!errors.isEmpty()) {
            return;
        }
        Contact contact = this.createContact((org.opencrx.kernel.admin1.jmi1.Segment)pmRoot.getObjectById((Object)adminSegment.refGetPath()), segmentName, principalId, adminUser, Arrays.asList(groupUsers, groupAdministrators), errors);
        if (contact == null) {
            return;
        }
        contactIdentity = contact.refGetPath();
        pmRoot.currentTransaction().commit();
        UserHomes.getInstance().createUserHome((Realm)pm.getObjectById((Object)realmIdentity), (Contact)pm.getObjectById((Object)contactIdentity), (PrincipalGroup)pm.getObjectById((Object)groupAdministratorsIdentity), principalId, new ArrayList<Group>(), true, initialPassword, initialPasswordVerification, null, null, errors);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public String importLoginPrincipals(org.opencrx.kernel.admin1.jmi1.Segment adminSegment, byte[] item) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)adminSegment);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(item), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        Realm loginRealm = (Realm)pm.getObjectById((Object)SecureObject.getInstance().getLoginRealmIdentity(adminSegment.refGetPath().get(2)));
        org.opencrx.security.identity1.jmi1.Segment identitySegment = (org.opencrx.security.identity1.jmi1.Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.security.identity1").getDescendant(new String[]{"provider", adminSegment.refGetPath().get(2), "segment", "Root"}));
        int nCreatedPrincipals = 0;
        int nExistingPrincipals = 0;
        int nFailedPrincipals = 0;
        int nCreatedSubjects = 0;
        int nExistingSubjects = 0;
        int nFailedSubjects = 0;
        try {
            block12: while (reader.ready()) {
                StringTokenizer t;
                String l = reader.readLine();
                if (l.indexOf("Principal;") >= 0) {
                    t = new StringTokenizer(l, ";");
                    t.nextToken();
                    String principalId = t.nextToken();
                    String principalDescription = t.nextToken();
                    String subjectName = t.nextToken();
                    String groups = t.nextToken();
                    org.openmdx.security.realm1.jmi1.Principal principal = null;
                    try {
                        principal = loginRealm.getPrincipal(principalId);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (principal == null) {
                        try {
                            principal = this.createPrincipal(principalId, principalId, principalDescription, loginRealm, PrincipalType.PRINCIPAL, new ArrayList<Group>(), identitySegment.getSubject(subjectName));
                            ++nCreatedPrincipals;
                        }
                        catch (Exception e) {
                            new ServiceException(e).log();
                            ++nFailedPrincipals;
                        }
                    } else {
                        ++nExistingPrincipals;
                    }
                    if (principal == null) continue;
                    StringTokenizer g = new StringTokenizer(groups, ",");
                    while (true) {
                        if (!g.hasMoreTokens()) continue block12;
                        String groupPrincipalName = g.nextToken();
                        Group groupPrincipal = (Group)loginRealm.getPrincipal(groupPrincipalName);
                        if (principal.getIsMemberOf().contains(groupPrincipal)) continue;
                        principal.getIsMemberOf().add(groupPrincipal);
                    }
                }
                if (l.indexOf("Subject") < 0) continue;
                t = new StringTokenizer(l, ";");
                t.nextToken();
                String subjectName = t.nextToken();
                String subjectDescription = t.nextToken();
                org.opencrx.security.identity1.jmi1.Subject subject = null;
                try {
                    subject = identitySegment.getSubject(subjectName);
                }
                catch (Exception groups) {
                    // empty catch block
                }
                if (subject == null) {
                    try {
                        subject = this.createSubject(identitySegment, subjectName, subjectDescription, new ArrayList<String>());
                        ++nCreatedSubjects;
                        continue;
                    }
                    catch (Exception e) {
                        new ServiceException(e).log();
                        ++nFailedSubjects;
                        continue;
                    }
                }
                ++nExistingSubjects;
            }
            return "Principals=(created:" + nCreatedPrincipals + ",existing:" + nExistingPrincipals + ",failed:" + nFailedPrincipals + "); Subjects:(created:" + nCreatedSubjects + ",existing:" + nExistingSubjects + ",failed:" + nFailedSubjects + ")";
        }
        catch (IOException e) {
            new ServiceException((Exception)e).log();
        }
        return "Principals=(created:" + nCreatedPrincipals + ",existing:" + nExistingPrincipals + ",failed:" + nFailedPrincipals + "); Subjects:(created:" + nCreatedSubjects + ",existing:" + nExistingSubjects + ",failed:" + nFailedSubjects + ")";
    }

    public void initSalesTaxTypes(Segment productSegment) throws ServiceException {
        Products.getInstance().initSalesTaxType(SALES_TAX_TYPE_NAME_8_5, new BigDecimal(8.5), productSegment);
    }

    public void initContractFilters(org.opencrx.kernel.contract1.jmi1.Segment contractSegment, List<PrincipalGroup> allUsers) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)contractSegment);
        ContractTypeFilterProperty contractTypeFilterProperty = (ContractTypeFilterProperty)pm.newInstance(ContractTypeFilterProperty.class);
        contractTypeFilterProperty.setName("Lead");
        contractTypeFilterProperty.setActive(new Boolean(true));
        contractTypeFilterProperty.setFilterQuantor(Quantifier.THERE_EXISTS.code());
        contractTypeFilterProperty.setFilterOperator(ConditionType.IS_IN.code());
        contractTypeFilterProperty.getContractType().add("org:opencrx:kernel:contract1:Lead");
        ContractQueryFilterProperty contractQueryFilterProperty = (ContractQueryFilterProperty)pm.newInstance(ContractQueryFilterProperty.class);
        contractQueryFilterProperty.setName("Estimated close date >= Today");
        contractQueryFilterProperty.setActive(new Boolean(true));
        contractQueryFilterProperty.setClause("(v.estimated_close_date >= now())");
        Contracts.getInstance().initContractFilter(CONTRACT_FILTER_NAME_LEAD_FORECAST, new ContractFilterProperty[]{contractTypeFilterProperty, contractQueryFilterProperty}, contractSegment, allUsers);
        contractTypeFilterProperty = (ContractTypeFilterProperty)pm.newInstance(ContractTypeFilterProperty.class);
        contractTypeFilterProperty.setName("Lead");
        contractTypeFilterProperty.setActive(new Boolean(true));
        contractTypeFilterProperty.setFilterQuantor(Quantifier.THERE_EXISTS.code());
        contractTypeFilterProperty.setFilterOperator(ConditionType.IS_IN.code());
        contractTypeFilterProperty.getContractType().add("org:opencrx:kernel:contract1:Lead");
        ContractStateFilterProperty contractStateFilterProperty = (ContractStateFilterProperty)pm.newInstance(ContractStateFilterProperty.class);
        contractStateFilterProperty.setName("Won");
        contractStateFilterProperty.setActive(new Boolean(true));
        contractStateFilterProperty.setFilterQuantor(Quantifier.THERE_EXISTS.code());
        contractStateFilterProperty.setFilterOperator(ConditionType.IS_IN.code());
        contractStateFilterProperty.getContractState().add(new Short(1110));
        Contracts.getInstance().initContractFilter(CONTRACT_FILTER_NAME_WON_LEADS, new ContractFilterProperty[]{contractTypeFilterProperty, contractStateFilterProperty}, contractSegment, allUsers);
        contractTypeFilterProperty = (ContractTypeFilterProperty)pm.newInstance(ContractTypeFilterProperty.class);
        contractTypeFilterProperty.setName("Opportunity");
        contractTypeFilterProperty.setActive(new Boolean(true));
        contractTypeFilterProperty.setFilterQuantor(Quantifier.THERE_EXISTS.code());
        contractTypeFilterProperty.setFilterOperator(ConditionType.IS_IN.code());
        contractTypeFilterProperty.getContractType().add("org:opencrx:kernel:contract1:Opportunity");
        contractQueryFilterProperty = (ContractQueryFilterProperty)pm.newInstance(ContractQueryFilterProperty.class);
        contractQueryFilterProperty.setName("Estimated close date >= Today");
        contractQueryFilterProperty.setActive(new Boolean(true));
        contractQueryFilterProperty.setClause("(v.estimated_close_date >= now())");
        Contracts.getInstance().initContractFilter(CONTRACT_FILTER_NAME_OPPORTUNITY_FORECAST, new ContractFilterProperty[]{contractTypeFilterProperty, contractQueryFilterProperty}, contractSegment, allUsers);
        contractTypeFilterProperty = (ContractTypeFilterProperty)pm.newInstance(ContractTypeFilterProperty.class);
        contractTypeFilterProperty.setName("Opportunity");
        contractTypeFilterProperty.setActive(new Boolean(true));
        contractTypeFilterProperty.setFilterQuantor(Quantifier.THERE_EXISTS.code());
        contractTypeFilterProperty.setFilterOperator(ConditionType.IS_IN.code());
        contractTypeFilterProperty.getContractType().add("org:opencrx:kernel:contract1:Opportunity");
        contractStateFilterProperty = (ContractStateFilterProperty)pm.newInstance(ContractStateFilterProperty.class);
        contractStateFilterProperty.setName("Won");
        contractStateFilterProperty.setActive(new Boolean(true));
        contractStateFilterProperty.setFilterQuantor(Quantifier.THERE_EXISTS.code());
        contractStateFilterProperty.setFilterOperator(ConditionType.IS_IN.code());
        contractStateFilterProperty.getContractState().add(new Short(1210));
        Contracts.getInstance().initContractFilter(CONTRACT_FILTER_NAME_WON_OPPORTUNITIES, new ContractFilterProperty[]{contractTypeFilterProperty, contractStateFilterProperty}, contractSegment, allUsers);
        contractTypeFilterProperty = (ContractTypeFilterProperty)pm.newInstance(ContractTypeFilterProperty.class);
        contractTypeFilterProperty.setName("Quote");
        contractTypeFilterProperty.setActive(new Boolean(true));
        contractTypeFilterProperty.setFilterQuantor(Quantifier.THERE_EXISTS.code());
        contractTypeFilterProperty.setFilterOperator(ConditionType.IS_IN.code());
        contractTypeFilterProperty.getContractType().add("org:opencrx:kernel:contract1:Quote");
        contractQueryFilterProperty = (ContractQueryFilterProperty)pm.newInstance(ContractQueryFilterProperty.class);
        contractQueryFilterProperty.setName("Estimated close date >= Today");
        contractQueryFilterProperty.setActive(new Boolean(true));
        contractQueryFilterProperty.setClause("(v.estimated_close_date >= now())");
        Contracts.getInstance().initContractFilter(CONTRACT_FILTER_NAME_QUOTE_FORECAST, new ContractFilterProperty[]{contractTypeFilterProperty, contractQueryFilterProperty}, contractSegment, allUsers);
        contractTypeFilterProperty = (ContractTypeFilterProperty)pm.newInstance(ContractTypeFilterProperty.class);
        contractTypeFilterProperty.setName("Quote");
        contractTypeFilterProperty.setActive(new Boolean(true));
        contractTypeFilterProperty.setFilterQuantor(Quantifier.THERE_EXISTS.code());
        contractTypeFilterProperty.setFilterOperator(ConditionType.IS_IN.code());
        contractTypeFilterProperty.getContractType().add("org:opencrx:kernel:contract1:Quote");
        contractStateFilterProperty = (ContractStateFilterProperty)pm.newInstance(ContractStateFilterProperty.class);
        contractStateFilterProperty.setName("Won");
        contractStateFilterProperty.setActive(new Boolean(true));
        contractStateFilterProperty.setFilterQuantor(Quantifier.THERE_EXISTS.code());
        contractStateFilterProperty.setFilterOperator(ConditionType.IS_IN.code());
        contractStateFilterProperty.getContractState().add(new Short(1310));
        Contracts.getInstance().initContractFilter(CONTRACT_FILTER_NAME_WON_QUOTES, new ContractFilterProperty[]{contractTypeFilterProperty, contractStateFilterProperty}, contractSegment, allUsers);
    }

    public void initAccountFilters(org.opencrx.kernel.account1.jmi1.Segment accountSegment, List<PrincipalGroup> allUsers) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)accountSegment);
        Accounts.getInstance().initAccountFilter(ACCOUNT_FILTER_NAME_ALL, new AccountFilterProperty[0], accountSegment, allUsers);
        AccountQueryFilterProperty accountQueryFilterProperty = (AccountQueryFilterProperty)pm.newInstance(AccountQueryFilterProperty.class);
        accountQueryFilterProperty.setName("external_link is null or vcard is null");
        accountQueryFilterProperty.setActive(new Boolean(true));
        accountQueryFilterProperty.setClause("object_id IN (\n  select oocke1_account.object_id from oocke1_account, oocke1_account_\n  where oocke1_account.object_id = oocke1_account_.object_id\n  and oocke1_account_.idx=0\n  and ((oocke1_account_.external_link is null) or (oocke1_account.vcard is null))\n  )");
        AccountFilterGlobal accountFilterBrokenVcard = Accounts.getInstance().initAccountFilter(ACCOUNT_FILTER_NAME_NO_OR_BROKEN_VCARD, new AccountFilterProperty[]{accountQueryFilterProperty}, accountSegment, allUsers);
        Accounts.getInstance().initAddressFilter(ADDRESS_FILTER_NAME_ALL, new AddressFilterProperty[0], accountSegment, allUsers);
    }

    public String initSegments(UserHome segmentAdminHome) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)segmentAdminHome);
        String providerName = segmentAdminHome.refGetPath().getSegment(2).toString();
        String segmentName = segmentAdminHome.refGetPath().getSegment(4).toString();
        org.opencrx.kernel.account1.jmi1.Segment accountSegment = Accounts.getInstance().getAccountSegment(pm, providerName, segmentName);
        org.opencrx.kernel.activity1.jmi1.Segment activitySegment = Activities.getInstance().getActivitySegment(pm, providerName, segmentName);
        org.opencrx.kernel.contract1.jmi1.Segment contractSegment = Contracts.getInstance().getContractSegment(pm, providerName, segmentName);
        Segment productSegment = Products.getInstance().getProductSegment(pm, providerName, segmentName);
        org.opencrx.kernel.workflow1.jmi1.Segment workflowSegment = Workflows.getInstance().getWorkflowSegment(pm, providerName, segmentName);
        PrincipalGroup publicPrincipalGroup = SecureObject.getInstance().initPrincipalGroup("Public", pm, providerName, segmentName);
        PrincipalGroup usersPrincipalGroup = SecureObject.getInstance().initPrincipalGroup("Users", pm, providerName, segmentName);
        PrincipalGroup administratorsPrincipalGroup = SecureObject.getInstance().initPrincipalGroup("Administrators", pm, providerName, segmentName);
        ArrayList<PrincipalGroup> allUsers = new ArrayList<PrincipalGroup>();
        allUsers.add(usersPrincipalGroup);
        allUsers.add(administratorsPrincipalGroup);
        Workflows.getInstance().initWorkflows(pm, providerName, segmentName);
        ActivityProcess bulkEmailProcess = Activities.getInstance().initBulkEmailProcess(pm, providerName, segmentName, allUsers, (short)1);
        ActivityProcess emailProcess = Activities.getInstance().initEmailProcess(pm, providerName, segmentName, allUsers, (short)1);
        ActivityProcessState emailProcessStateNew = null;
        ActivityProcessState emailProcessStateOpen = null;
        Iterator i = emailProcess.getState().iterator();
        while (i.hasNext()) {
            ActivityProcessState state = (ActivityProcessState)i.next();
            if ("New".equals(state.getName())) {
                emailProcessStateNew = state;
            }
            if (!"Open".equals(state.getName())) continue;
            emailProcessStateOpen = state;
        }
        ActivityProcess bugAndFeatureTrackingProcess = Activities.getInstance().initBugAndFeatureTrackingProcess(pm, providerName, segmentName, allUsers, (short)1);
        ActivityProcessState bugAndFeatureTrackingProcessStateNew = null;
        ActivityProcessState bugAndFeatureTrackingProcessStateInProgress = null;
        Iterator i2 = bugAndFeatureTrackingProcess.getState().iterator();
        while (i2.hasNext()) {
            ActivityProcessState state = (ActivityProcessState)i2.next();
            if ("New".equals(state.getName())) {
                bugAndFeatureTrackingProcessStateNew = state;
            }
            if (!"In Progress".equals(state.getName())) continue;
            bugAndFeatureTrackingProcessStateInProgress = state;
        }
        Activities.getInstance().initCalendar("Default Business Calendar", pm, providerName, segmentName, allUsers, (short)1);
        ActivityType bugsAndFeaturesType = Activities.getInstance().initActivityType(bugAndFeatureTrackingProcess, "Bugs + Features", Activities.ActivityClass.INCIDENT.getValue(), allUsers, (short)1);
        ActivityType bulkEmailsType = Activities.getInstance().initActivityType(bulkEmailProcess, "Bulk E-Mails", Activities.ActivityClass.EMAIL.getValue(), allUsers, (short)1);
        ActivityType emailsType = Activities.getInstance().initActivityType(emailProcess, "E-Mails", Activities.ActivityClass.EMAIL.getValue(), allUsers, (short)1);
        ActivityType tasksType = Activities.getInstance().initActivityType(bugAndFeatureTrackingProcess, "Tasks", Activities.ActivityClass.TASK.getValue(), allUsers, (short)1);
        ActivityType meetingsType = Activities.getInstance().initActivityType(bugAndFeatureTrackingProcess, ACTIVITY_FILTER_NAME_MEETINGS, Activities.ActivityClass.MEETING.getValue(), allUsers, (short)1);
        ActivityType phoneCallsType = Activities.getInstance().initActivityType(bugAndFeatureTrackingProcess, ACTIVITY_FILTER_NAME_PHONE_CALLS, Activities.ActivityClass.PHONE_CALL.getValue(), allUsers, (short)1);
        ActivityTracker bugsAndFeaturesTracker = Activities.getInstance().initActivityTracker("Bugs + Features", allUsers, activitySegment);
        ActivityTracker emailsTracker = Activities.getInstance().initActivityTracker("E-Mails", allUsers, activitySegment);
        ActivityTracker tasksTracker = Activities.getInstance().initActivityTracker("Tasks", allUsers, activitySegment);
        ActivityTracker pollsTracker = Activities.getInstance().initActivityTracker("Polls", allUsers, activitySegment);
        ActivityTracker meetingRoomsTracker = Activities.getInstance().initActivityTracker("Meeting Rooms", allUsers, activitySegment);
        ActivityTracker meetingsTracker = Activities.getInstance().initActivityTracker(ACTIVITY_FILTER_NAME_MEETINGS, allUsers, activitySegment);
        ActivityTracker phoneCallsTracker = Activities.getInstance().initActivityTracker(ACTIVITY_FILTER_NAME_PHONE_CALLS, allUsers, activitySegment);
        ActivityTracker publicTracker = Activities.getInstance().initActivityTracker("Public", Arrays.asList(publicPrincipalGroup), activitySegment);
        try {
            Activities.getInstance().initActivityCreator("Bugs + Features", bugsAndFeaturesType, Arrays.asList(bugsAndFeaturesTracker), allUsers);
            Activities.getInstance().initActivityCreator("E-Mails", emailsType, Arrays.asList(emailsTracker), allUsers);
            Activities.getInstance().initActivityCreator("Tasks", tasksType, Arrays.asList(tasksTracker), allUsers);
            Activities.getInstance().initActivityCreator("Polls", emailsType, Arrays.asList(pollsTracker), allUsers);
            Activities.getInstance().initActivityCreator("Meeting Rooms", emailsType, Arrays.asList(meetingRoomsTracker), allUsers);
            Activities.getInstance().initActivityCreator(ACTIVITY_FILTER_NAME_MEETINGS, meetingsType, Arrays.asList(meetingsTracker), allUsers);
            Activities.getInstance().initActivityCreator(ACTIVITY_FILTER_NAME_PHONE_CALLS, phoneCallsType, Arrays.asList(phoneCallsTracker), allUsers);
            Activities.getInstance().initActivityCreator("Public E-Mails", emailsType, Arrays.asList(publicTracker), Arrays.asList(publicPrincipalGroup));
            Activities.getInstance().initActivityCreator("Public Tasks", tasksType, Arrays.asList(publicTracker), Arrays.asList(publicPrincipalGroup));
            Activities.getInstance().initActivityCreator("Public Meetings", meetingsType, Arrays.asList(publicTracker), Arrays.asList(publicPrincipalGroup));
            Activities.getInstance().initActivityCreator("Public Phone Calls", phoneCallsType, Arrays.asList(publicTracker), Arrays.asList(publicPrincipalGroup));
        }
        catch (Exception e) {
            new ServiceException(e).log();
            try {
                pm.currentTransaction().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Products.getInstance().initPricingRule("Lowest Price", "Get price level which returns the lowest price of the given product, contract currency, pricing date and quantity. If the product is not defined return the price level which matches the contract currency, price uom and pricing date.", "//<pre>\n    public static org.opencrx.kernel.product1.jmi1.GetPriceLevelResult getPriceLevel(\n    org.openmdx.base.accessor.jmi.cci.RefPackage_1_0 rootPkg,\n    org.opencrx.kernel.product1.jmi1.PricingRule pricingRule,\n    org.opencrx.kernel.contract1.jmi1.SalesContract contract,\n    org.opencrx.kernel.contract1.jmi1.SalesContractPosition position,\n    org.opencrx.kernel.product1.jmi1.AbstractProduct product,\n    org.opencrx.kernel.uom1.jmi1.Uom priceUom,\n    java.math.BigDecimal quantity,\n    java.lang.Short contractPositionState,\n    java.util.Date pricingDate,\n    org.opencrx.kernel.product1.jmi1.AbstractPriceLevel overridePriceLevel\n) {\n    return org.opencrx.kernel.backend.Products.getLowestPricePriceLevel(\n        rootPkg,\n        pricingRule,\n        contract,\n        position,\n        product,\n        priceUom,\n        quantity,\n        contractPositionState,\n        pricingDate,\n        overridePriceLevel\n    );\n}//</pre>", pm, providerName, segmentName);
        this.initSalesTaxTypes(productSegment);
        Contracts.getInstance().initCalculationRule("Default", null, "//<pre>\npublic static org.opencrx.kernel.contract1.jmi1.GetPositionAmountsResult getPositionAmounts(\n    org.openmdx.base.accessor.jmi.cci.RefPackage_1_0 rootPkg,\n    org.opencrx.kernel.contract1.jmi1.CalculationRule calculationRule,\n    org.opencrx.kernel.contract1.jmi1.SalesContractPosition position,\n    java.math.BigDecimal pricePerUnit,\n    java.math.BigDecimal quantity,\n    java.math.BigDecimal uomScaleFactor,\n    java.math.BigDecimal discount,\n    java.lang.Boolean discountIsPercentage,\n    java.lang.Short discountCalculationType,\n    java.math.BigDecimal salesTaxRate\n) {\n    return org.opencrx.kernel.backend.Contracts.getPositionAmounts(\n        rootPkg,\n        calculationRule,\n        position,\n        pricePerUnit,\n        quantity,\n        uomScaleFactor,\n        discount,\n        discountIsPercentage,\n        discountCalculationType,\n        salesTaxRate\n   );\n}//</pre>", "//<pre>\npublic static org.opencrx.kernel.contract1.jmi1.GetContractAmountsResult getContractAmounts(\n    org.openmdx.base.accessor.jmi.cci.RefPackage_1_0 rootPkg,\n    org.opencrx.kernel.contract1.jmi1.CalculationRule calculationRule,\n    org.opencrx.kernel.contract1.jmi1.SalesContract contract,\n    Integer[] lineItemNumbers,\n    java.math.BigDecimal[] positionBaseAmounts,\n    java.math.BigDecimal[] positionDiscountAmounts,\n    java.math.BigDecimal[] positionTaxAmounts,\n    java.math.BigDecimal[] positionAmounts,\n    java.math.BigDecimal[] salesCommissions,\n    Boolean[] salesCommissionIsPercentages\n) {\n    return org.opencrx.kernel.backend.Contracts.getContractAmounts(\n        rootPkg,\n        calculationRule,\n        contract,\n        lineItemNumbers,\n        positionBaseAmounts,\n        positionDiscountAmounts,\n        positionTaxAmounts,\n        positionAmounts,\n        salesCommissions,\n        salesCommissionIsPercentages\n    );\n}//</pre>", pm, providerName, segmentName);
        this.initAccountFilters(accountSegment, allUsers);
        this.initContractFilters(contractSegment, allUsers);
        ActivityTypeFilterProperty activityTypeFilterProperty = (ActivityTypeFilterProperty)pm.newInstance(ActivityTypeFilterProperty.class);
        activityTypeFilterProperty.setName(ACTIVITY_FILTER_NAME_PHONE_CALLS);
        activityTypeFilterProperty.setActive(new Boolean(true));
        activityTypeFilterProperty.setFilterQuantor(Quantifier.THERE_EXISTS.code());
        activityTypeFilterProperty.setFilterOperator(ConditionType.IS_IN.code());
        activityTypeFilterProperty.getActivityType().add(phoneCallsType);
        Activities.getInstance().initActivityFilter(ACTIVITY_FILTER_NAME_PHONE_CALLS, new ActivityFilterProperty[]{activityTypeFilterProperty}, activitySegment, allUsers);
        activityTypeFilterProperty = (ActivityTypeFilterProperty)pm.newInstance(ActivityTypeFilterProperty.class);
        activityTypeFilterProperty.setName(ACTIVITY_FILTER_NAME_MEETINGS);
        activityTypeFilterProperty.setActive(new Boolean(true));
        activityTypeFilterProperty.setFilterQuantor(Quantifier.THERE_EXISTS.code());
        activityTypeFilterProperty.setFilterOperator(ConditionType.IS_IN.code());
        activityTypeFilterProperty.getActivityType().add(meetingsType);
        Activities.getInstance().initActivityFilter(ACTIVITY_FILTER_NAME_MEETINGS, new ActivityFilterProperty[]{activityTypeFilterProperty}, activitySegment, allUsers);
        activityTypeFilterProperty = (ActivityTypeFilterProperty)pm.newInstance(ActivityTypeFilterProperty.class);
        activityTypeFilterProperty.setName("All Types");
        activityTypeFilterProperty.setActive(new Boolean(true));
        activityTypeFilterProperty.setFilterQuantor(Quantifier.THERE_EXISTS.code());
        activityTypeFilterProperty.setFilterOperator(ConditionType.IS_IN.code());
        activityTypeFilterProperty.getActivityType().add(bugsAndFeaturesType);
        activityTypeFilterProperty.getActivityType().add(meetingsType);
        activityTypeFilterProperty.getActivityType().add(emailsType);
        activityTypeFilterProperty.getActivityType().add(phoneCallsType);
        ActivityProcessStateFilterProperty activityProcessStateFilterProperty = (ActivityProcessStateFilterProperty)pm.newInstance(ActivityProcessStateFilterProperty.class);
        activityProcessStateFilterProperty.setFilterQuantor(Quantifier.THERE_EXISTS.code());
        activityProcessStateFilterProperty.setFilterOperator(ConditionType.IS_IN.code());
        activityProcessStateFilterProperty.getProcessState().add(bugAndFeatureTrackingProcessStateNew);
        activityProcessStateFilterProperty.getProcessState().add(emailProcessStateNew);
        Activities.getInstance().initActivityFilter(ACTIVITY_FILTER_NAME_NEW_ACTIVITIES, new ActivityFilterProperty[]{activityTypeFilterProperty, activityProcessStateFilterProperty}, activitySegment, allUsers);
        activityTypeFilterProperty = (ActivityTypeFilterProperty)pm.newInstance(ActivityTypeFilterProperty.class);
        activityTypeFilterProperty.setName("All Types");
        activityTypeFilterProperty.setActive(new Boolean(true));
        activityTypeFilterProperty.setFilterQuantor(Quantifier.THERE_EXISTS.code());
        activityTypeFilterProperty.setFilterOperator(ConditionType.IS_IN.code());
        activityTypeFilterProperty.getActivityType().add(bugsAndFeaturesType);
        activityTypeFilterProperty.getActivityType().add(meetingsType);
        activityTypeFilterProperty.getActivityType().add(emailsType);
        activityTypeFilterProperty.getActivityType().add(phoneCallsType);
        activityProcessStateFilterProperty = (ActivityProcessStateFilterProperty)pm.newInstance(ActivityProcessStateFilterProperty.class);
        activityProcessStateFilterProperty.setName("Open");
        activityProcessStateFilterProperty.setActive(new Boolean(true));
        activityProcessStateFilterProperty.setFilterQuantor(Quantifier.THERE_EXISTS.code());
        activityProcessStateFilterProperty.setFilterOperator(ConditionType.IS_IN.code());
        activityProcessStateFilterProperty.getProcessState().add(bugAndFeatureTrackingProcessStateInProgress);
        activityProcessStateFilterProperty.getProcessState().add(emailProcessStateOpen);
        Activities.getInstance().initActivityFilter(ACTIVITY_FILTER_NAME_OPEN_ACTIVITIES, new ActivityFilterProperty[]{activityTypeFilterProperty, activityProcessStateFilterProperty}, activitySegment, allUsers);
        StringBuilder report = new StringBuilder();
        report.append("<div class=\"row\">");
        report.append("<fieldset class=\"col-sm\">");
        report.append("<div class=\"" + CssClass.fieldGroupName + "\">Activity and Incident Management</div>");
        report.append("<table class=\"table table-condensed\" style=\"width:100%\">");
        report.append("\t<tr>");
        report.append("\t\t<th>Activity Processes</th>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityProcess("Bug + feature tracking process", activitySegment) == null ? MISSING : OK) + "\">" + "Bug + feature tracking process" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityProcess("E-Mail Process", activitySegment) == null ? MISSING : OK) + "\">" + "E-Mail Process" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityProcess("Bulk E-Mail Process", activitySegment) == null ? MISSING : OK) + "\">" + "Bulk E-Mail Process" + "</td>");
        report.append("\t</tr>");
        report.append("</table>");
        report.append("<table class=\"table table-condensed\" style=\"width:100%\">");
        report.append("\t<tr>");
        report.append("\t\t<th>Calendars</th>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findCalendar("Default Business Calendar", activitySegment) == null ? MISSING : OK) + "\">" + "Default Business Calendar" + "</td>");
        report.append("\t</tr>");
        report.append("</table>");
        report.append("<table class=\"table table-condensed\" style=\"width:100%\">");
        report.append("\t<tr>");
        report.append("\t\t<th>Activity Types</th>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityType("Bugs + Features", activitySegment) == null ? MISSING : OK) + "\">" + "Bugs + Features" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityType("E-Mails", activitySegment) == null ? MISSING : OK) + "\">" + "E-Mails" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityType("Bulk E-Mails", activitySegment) == null ? MISSING : OK) + "\">" + "Bulk E-Mails" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityType("Tasks", activitySegment) == null ? MISSING : OK) + "\">" + "Tasks" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityType(ACTIVITY_FILTER_NAME_MEETINGS, activitySegment) == null ? MISSING : OK) + "\">" + ACTIVITY_FILTER_NAME_MEETINGS + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityType(ACTIVITY_FILTER_NAME_PHONE_CALLS, activitySegment) == null ? MISSING : OK) + "\">" + ACTIVITY_FILTER_NAME_PHONE_CALLS + "</td>");
        report.append("\t</tr>");
        report.append("</table>");
        report.append("<table class=\"table table-condensed\" style=\"width:100%\">");
        report.append("\t<tr>");
        report.append("\t\t<th>Activity Trackers</th>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityTracker("Bugs + Features", activitySegment) == null ? MISSING : OK) + "\">" + "Bugs + Features" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityTracker("E-Mails", activitySegment) == null ? MISSING : OK) + "\">" + "E-Mails" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityTracker("Tasks", activitySegment) == null ? MISSING : OK) + "\">" + "Tasks" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityTracker("Polls", activitySegment) == null ? MISSING : OK) + "\">" + "Polls" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityTracker("Meeting Rooms", activitySegment) == null ? MISSING : OK) + "\">" + "Meeting Rooms" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityTracker(ACTIVITY_FILTER_NAME_MEETINGS, activitySegment) == null ? MISSING : OK) + "\">" + ACTIVITY_FILTER_NAME_MEETINGS + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityTracker(ACTIVITY_FILTER_NAME_PHONE_CALLS, activitySegment) == null ? MISSING : OK) + "\">" + ACTIVITY_FILTER_NAME_PHONE_CALLS + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityTracker("Public", activitySegment) == null ? MISSING : OK) + "\">" + "Public" + "</td>");
        report.append("\t</tr>");
        report.append("</table>");
        report.append("<table class=\"table table-condensed\" style=\"width:100%\">");
        report.append("\t<tr>");
        report.append("\t\t<th>Activity Creators</th>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td  class=\"" + (Activities.getInstance().findActivityCreator("Bugs + Features", activitySegment) == null ? MISSING : OK) + "\">" + "Bugs + Features" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityCreator("E-Mails", activitySegment) == null ? MISSING : OK) + "\">" + "E-Mails" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityCreator("Tasks", activitySegment) == null ? MISSING : OK) + "\">" + "Tasks" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityCreator("Polls", activitySegment) == null ? MISSING : OK) + "\">" + "Polls" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityCreator("Meeting Rooms", activitySegment) == null ? MISSING : OK) + "\">" + "Meeting Rooms" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityCreator(ACTIVITY_FILTER_NAME_MEETINGS, activitySegment) == null ? MISSING : OK) + "\">" + ACTIVITY_FILTER_NAME_MEETINGS + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityCreator(ACTIVITY_FILTER_NAME_PHONE_CALLS, activitySegment) == null ? MISSING : OK) + "\">" + ACTIVITY_FILTER_NAME_PHONE_CALLS + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityCreator("Public E-Mails", activitySegment) == null ? MISSING : OK) + "\">" + "Public E-Mails" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityCreator("Public Tasks", activitySegment) == null ? MISSING : OK) + "\">" + "Public Tasks" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityCreator("Public Meetings", activitySegment) == null ? MISSING : OK) + "\">" + "Public Meetings" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityCreator("Public Phone Calls", activitySegment) == null ? MISSING : OK) + "\">" + "Public Phone Calls" + "</td>");
        report.append("\t</tr>");
        report.append("</table>");
        report.append("</fieldset>");
        report.append("</div>");
        report.append("<div class=\"row\">");
        report.append("<fieldset class=\"col-sm\">");
        report.append("<div class=\"" + CssClass.fieldGroupName + "\">Workflows and Topics</div>");
        report.append("<table class=\"table table-condensed\" style=\"width:100%\">");
        report.append("\t<tr>");
        report.append("\t\t<th>Topics</th>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findTopic("Account Modifications", workflowSegment) == null ? MISSING : OK) + "\">" + "Account Modifications" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findTopic("Activity Follow Up Modifications", workflowSegment) == null ? MISSING : OK) + "\">" + "Activity Follow Up Modifications" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findTopic("Activity Modifications", workflowSegment) == null ? MISSING : OK) + "\">" + "Activity Modifications" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findTopic("Alert Modifications", workflowSegment) == null ? MISSING : OK) + "\">" + "Alert Modifications" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findTopic("Booking Modifications", workflowSegment) == null ? MISSING : OK) + "\">" + "Booking Modifications" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findTopic("Competitor Modifications", workflowSegment) == null ? MISSING : OK) + "\">" + "Competitor Modifications" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findTopic("Compound Booking Modifications", workflowSegment) == null ? MISSING : OK) + "\">" + "Compound Booking Modifications" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findTopic("Invoice Modifications", workflowSegment) == null ? MISSING : OK) + "\">" + "Invoice Modifications" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findTopic("Lead Modifications", workflowSegment) == null ? MISSING : OK) + "\">" + "Lead Modifications" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findTopic("Opportunity Modifications", workflowSegment) == null ? MISSING : OK) + "\">" + "Opportunity Modifications" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findTopic("Organization Modifications", workflowSegment) == null ? MISSING : OK) + "\">" + "Organization Modifications" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findTopic("Product Modifications", workflowSegment) == null ? MISSING : OK) + "\">" + "Product Modifications" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findTopic("Quote Modifications", workflowSegment) == null ? MISSING : OK) + "\">" + "Quote Modifications" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findTopic("Timer Modifications (Alert)", workflowSegment) == null ? MISSING : OK) + "\">" + "Timer Modifications (Alert)" + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findTopic("SalesOrder Modifications", workflowSegment) == null ? MISSING : OK) + "\">" + "SalesOrder Modifications" + "</td>");
        report.append("\t</tr>");
        report.append("</table>");
        report.append("<table class=\"table table-condensed\" style=\"width:100%\">");
        report.append("\t<tr>");
        report.append("\t\t<th>Workflows</th>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findWfProcess(Workflows.WORKFLOW_NAME_EXPORT_MAIL, workflowSegment) == null && Workflows.getInstance().findWfProcess("org.opencrx.mail.workflow.ExportMailWorkflow", workflowSegment) == null ? MISSING : OK) + "\">" + Workflows.WORKFLOW_NAME_EXPORT_MAIL + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findWfProcess(Workflows.WORKFLOW_NAME_PRINT_CONSOLE, workflowSegment) == null ? MISSING : OK) + "\">" + Workflows.WORKFLOW_NAME_PRINT_CONSOLE + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findWfProcess(Workflows.WORKFLOW_NAME_SEND_ALERT, workflowSegment) == null ? MISSING : OK) + "\">" + Workflows.WORKFLOW_NAME_SEND_ALERT + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findWfProcess(Workflows.WORKFLOW_NAME_SEND_MAIL, workflowSegment) == null && Workflows.getInstance().findWfProcess("org.opencrx.mail.workflow.SendMailWorkflow", workflowSegment) == null ? MISSING : OK) + "\">" + Workflows.WORKFLOW_NAME_SEND_MAIL + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findWfProcess(Workflows.WORKFLOW_NAME_SEND_MAIL_NOTIFICATION, workflowSegment) == null && Workflows.getInstance().findWfProcess("org.opencrx.mail.workflow.SendMailNotificationWorkflow", workflowSegment) == null ? MISSING : OK) + "\">" + Workflows.WORKFLOW_NAME_SEND_MAIL_NOTIFICATION + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findWfProcess(Workflows.WORKFLOW_NAME_BULK_ACTIVITY_FOLLOWUP, workflowSegment) == null ? MISSING : OK) + "\">" + Workflows.WORKFLOW_NAME_BULK_ACTIVITY_FOLLOWUP + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findWfProcess(Workflows.WORKFLOW_NAME_BULK_CREATE_ACTIVITY, workflowSegment) == null ? MISSING : OK) + "\">" + Workflows.WORKFLOW_NAME_BULK_CREATE_ACTIVITY + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findWfProcess(Workflows.WORKFLOW_RUN_EXPORT, workflowSegment) == null ? MISSING : OK) + "\">" + Workflows.WORKFLOW_RUN_EXPORT + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Workflows.getInstance().findWfProcess(Workflows.WORKFLOW_NAME_RUN_IMPORT, workflowSegment) == null ? MISSING : OK) + "\">" + Workflows.WORKFLOW_NAME_RUN_IMPORT + "</td>");
        report.append("\t</tr>");
        report.append("</table>");
        report.append("</fieldset>");
        report.append("</div>");
        report.append("<div class=\"row\">");
        report.append("<fieldset class=\"col-sm\">");
        report.append("<div class=\"" + CssClass.fieldGroupName + "\">Products</div>");
        report.append("<table class=\"table table-condensed\" style=\"width:100%\">");
        report.append("\t<tr>");
        report.append("\t\t<th>Pricing Rules</th>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Products.getInstance().findPricingRule("Lowest Price", productSegment) == null ? MISSING : OK) + "\">" + "Lowest Price" + "</td>");
        report.append("\t</tr>");
        report.append("</table>");
        report.append("</fieldset>");
        report.append("</div>");
        report.append("<div class=\"row\">");
        report.append("<fieldset class=\"col-sm\">");
        report.append("<div class=\"" + CssClass.fieldGroupName + "\">Contracts</div>");
        report.append("<table class=\"table table-condensed\" style=\"width:100%\">");
        report.append("\t<tr>");
        report.append("\t\t<th>Calculation Rules</th>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Contracts.getInstance().findCalculationRule("Default", contractSegment) == null ? MISSING : OK) + "\">" + "Default" + "</td>");
        report.append("\t</tr>");
        report.append("</table>");
        report.append("</fieldset>");
        report.append("</div>");
        report.append("<div class=\"row\">");
        report.append("<fieldset class=\"col-sm\">");
        report.append("<div class=\"" + CssClass.fieldGroupName + "\">Filters</div>");
        report.append("<table class=\"table table-condensed\" style=\"width:100%\">");
        report.append("\t<tr>");
        report.append("\t\t<th>Activity Filters</th>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityFilter(ACTIVITY_FILTER_NAME_PHONE_CALLS, activitySegment) == null ? MISSING : OK) + "\">" + ACTIVITY_FILTER_NAME_PHONE_CALLS + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityFilter(ACTIVITY_FILTER_NAME_MEETINGS, activitySegment) == null ? MISSING : OK) + "\">" + ACTIVITY_FILTER_NAME_MEETINGS + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityFilter(ACTIVITY_FILTER_NAME_NEW_ACTIVITIES, activitySegment) == null ? MISSING : OK) + "\">" + ACTIVITY_FILTER_NAME_NEW_ACTIVITIES + "</td>");
        report.append("\t</tr>");
        report.append("\t<tr>");
        report.append("\t\t<td class=\"" + (Activities.getInstance().findActivityFilter(ACTIVITY_FILTER_NAME_OPEN_ACTIVITIES, activitySegment) == null ? MISSING : OK) + "\">" + ACTIVITY_FILTER_NAME_OPEN_ACTIVITIES + "</td>");
        report.append("\t</tr>");
        report.append("</table>");
        report.append("</fieldset>");
        report.append("</div>");
        return report.toString();
    }

    public static enum PrincipalType {
        PRINCIPAL,
        USER,
        GROUP;

    }
}

