/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.backend;

import java.net.URL;
import java.util.List;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import org.opencrx.kernel.backend.AbstractImpl;
import org.opencrx.kernel.backend.Activities;
import org.opencrx.kernel.backend.UserHomes;
import org.opencrx.kernel.document1.cci2.DocumentFolderQuery;
import org.opencrx.kernel.document1.cci2.DocumentFolderShareQuery;
import org.opencrx.kernel.document1.cci2.DocumentQuery;
import org.opencrx.kernel.document1.cci2.ValidateSchemaResult;
import org.opencrx.kernel.document1.jmi1.AbstractFilterDocument;
import org.opencrx.kernel.document1.jmi1.Document;
import org.opencrx.kernel.document1.jmi1.DocumentFolder;
import org.opencrx.kernel.document1.jmi1.DocumentFolderShare;
import org.opencrx.kernel.document1.jmi1.MediaContent;
import org.opencrx.kernel.document1.jmi1.Segment;
import org.opencrx.kernel.document1.jmi1.ValidateSchemaResult;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.opencrx.kernel.utils.Utils;
import org.opencrx.security.realm1.jmi1.PrincipalGroup;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.PersistenceHelper;
import org.openmdx.base.rest.cci.QueryExtensionRecord;
import org.w3c.cci2.AnyTypePredicate;
import org.w3c.cci2.BinaryLargeObject;
import org.w3c.cci2.BinaryLargeObjects;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class Documents
extends AbstractImpl {
    public static final String PRIVATE_DOCUMENTS_FOLDER_SUFFIX = "~Private";

    public static void register() {
        Documents.registerImpl(new Documents());
    }

    public static Documents getInstance() throws ServiceException {
        return Documents.getInstance(Documents.class);
    }

    protected Documents() {
    }

    public Segment getDocumentSegment(PersistenceManager pm, String providerName, String segmentName) throws ServiceException {
        return (Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.document1").getDescendant(new String[]{"provider", providerName, "segment", segmentName}));
    }

    public DocumentFolder findDocumentFolder(String documentFolderName, Segment segment) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)segment);
        DocumentFolderQuery query = (DocumentFolderQuery)pm.newQuery(DocumentFolder.class);
        query.name().equalTo((Object)documentFolderName);
        List documentFolders = segment.getFolder(query);
        if (!documentFolders.isEmpty()) {
            return (DocumentFolder)documentFolders.iterator().next();
        }
        return null;
    }

    public DocumentFolder initDocumentFolder(String documentFolderName, Segment segment, List<PrincipalGroup> allUsers) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)segment);
        DocumentFolder documentFolder = this.findDocumentFolder(documentFolderName, segment);
        if (documentFolder != null) {
            return documentFolder;
        }
        try {
            pm.currentTransaction().begin();
            documentFolder = (DocumentFolder)pm.newInstance(DocumentFolder.class);
            documentFolder.setName(documentFolderName);
            documentFolder.getOwningGroup().addAll(allUsers);
            segment.addFolder(this.getUidAsString(), documentFolder);
            pm.currentTransaction().commit();
        }
        catch (Exception e) {
            new ServiceException(e).log();
            try {
                pm.currentTransaction().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return documentFolder;
    }

    public Document initDocument(String documentName, String documentTitle, URL revisionURL, String revisionMimeType, String revisionName, DocumentFolder documentFolder, Segment segment, List<PrincipalGroup> allUsers) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)segment);
        Document document = this.findDocument(documentName, segment);
        if (document != null) {
            return document;
        }
        try {
            pm.currentTransaction().begin();
            document = (Document)pm.newInstance(Document.class);
            document.setName(documentName);
            document.setTitle(documentTitle);
            document.getOwningGroup().addAll(allUsers);
            segment.addDocument(false, Activities.getInstance().getUidAsString(), document);
            MediaContent documentRevision = (MediaContent)pm.newInstance(MediaContent.class);
            documentRevision.setName(revisionName);
            documentRevision.setContentName(revisionName);
            documentRevision.setContentMimeType(revisionMimeType);
            documentRevision.setContent(BinaryLargeObjects.valueOf((URL)revisionURL));
            documentRevision.getOwningGroup().addAll(allUsers);
            document.addRevision(this.getUidAsString(), documentRevision);
            document.setHeadRevision(documentRevision);
            if (documentFolder != null) {
                document.getFolder().add(documentFolder);
            }
            pm.currentTransaction().commit();
        }
        catch (Exception e) {
            new ServiceException(e).log();
            try {
                pm.currentTransaction().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return document;
    }

    public Document findDocument(String documentName, Segment segment) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)segment);
        DocumentQuery query = (DocumentQuery)pm.newQuery(Document.class);
        query.name().equalTo((Object)documentName);
        List documents = segment.getDocument(query);
        if (!documents.isEmpty()) {
            return (Document)documents.iterator().next();
        }
        return null;
    }

    public Document initDocument(String documentName, URL revisionURL, String revisionMimeType, String revisionName, DocumentFolder documentFolder, Segment segment, List<PrincipalGroup> allUsers) throws ServiceException {
        return Documents.getInstance().initDocument(documentName, documentName, revisionURL, revisionMimeType, revisionName, documentFolder, segment, allUsers);
    }

    public int countFilteredDocument(AbstractFilterDocument documentFilter) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)documentFilter);
        DocumentQuery query = (DocumentQuery)pm.newQuery(Document.class);
        QueryExtensionRecord queryExtension = PersistenceHelper.newQueryExtension((AnyTypePredicate)query);
        queryExtension.setClause("/*!COUNT*/(1=1)");
        List documents = documentFilter.getFilteredDocument(query);
        return documents.size();
    }

    public MediaContent addRevision(Document document, String contentName, String contentMimeType, String author, BinaryLargeObject content) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)document);
        Integer version = null;
        if (document.getHeadRevision() == null) {
            version = 0;
        }
        try {
            version = Integer.valueOf(document.getHeadRevision().getVersion());
        }
        catch (Exception exception) {
            // empty catch block
        }
        MediaContent revision = (MediaContent)pm.newInstance(MediaContent.class);
        revision.setName(contentName);
        revision.setContentName(contentName);
        revision.setContentMimeType(contentMimeType);
        revision.setContent(content);
        revision.setAuthor(author);
        revision.setVersion(version == null ? null : Integer.toString(version + 1));
        document.addRevision(Utils.getUidAsString(), revision);
        if (document.getContentType() == null) {
            document.setContentType(contentMimeType);
        }
        if (document.getName() == null || document.getName().isEmpty()) {
            document.setName(contentName);
        }
        document.setHeadRevision(revision);
        return revision;
    }

    public DocumentFolderShare createDefaultShare(DocumentFolder documentFolder) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)documentFolder);
        UserHome userHome = UserHomes.getInstance().getUserHome(documentFolder.refGetPath(), pm);
        DocumentFolderShare defaultShare = null;
        if (userHome != null) {
            DocumentFolderShareQuery folderShareQuery = (DocumentFolderShareQuery)pm.newQuery(DocumentFolderShare.class);
            folderShareQuery.thereExistsShareForUser().equalTo(userHome);
            folderShareQuery.name().equalTo((Object)documentFolder.getName());
            List folderShares = documentFolder.getFolderShare(folderShareQuery);
            if (folderShares.isEmpty()) {
                defaultShare = (DocumentFolderShare)pm.newInstance(DocumentFolderShare.class);
                defaultShare.setName(documentFolder.getName());
                defaultShare.setShareForUser(userHome);
                documentFolder.addFolderShare(this.getUidAsString(), defaultShare);
            } else {
                defaultShare = (DocumentFolderShare)folderShares.iterator().next();
            }
            defaultShare.setActive(true);
        }
        return defaultShare;
    }

    public void removeDefaultShare(DocumentFolder documentFolder) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)documentFolder);
        UserHome userHome = UserHomes.getInstance().getUserHome(documentFolder.refGetPath(), pm);
        if (userHome != null) {
            DocumentFolderShareQuery folderShareQuery = (DocumentFolderShareQuery)pm.newQuery(DocumentFolderShare.class);
            folderShareQuery.thereExistsShareForUser().equalTo(userHome);
            folderShareQuery.name().equalTo((Object)documentFolder.getName());
            for (DocumentFolderShare folderShare : documentFolder.getFolderShare(folderShareQuery)) {
                folderShare.setActive(false);
            }
        }
    }

    public ValidateSchemaResult validateSchema(Document document) throws ServiceException {
        short statusCode = -1;
        String statusMessage = null;
        if (document.getDocumentSchema() == null) {
            statusCode = 0;
            statusMessage = "Valid. No schema";
        } else {
            statusCode = -1;
            statusMessage = "not implemented";
        }
        return (ValidateSchemaResult)Structures.create(ValidateSchemaResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ValidateSchemaResult.Member.statusCode, (Object)statusCode), Datatypes.member((Enum)ValidateSchemaResult.Member.statusMessage, (Object)statusMessage)});
    }
}

