/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.backend;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jdo.PersistenceManager;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.activity1.cci2.ActivityFollowUpQuery;
import org.opencrx.kernel.activity1.cci2.ActivityHasTrackerAndGroupAssignment;
import org.opencrx.kernel.activity1.cci2.MeetingPartyQuery;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.activity1.jmi1.ActivityFollowUp;
import org.opencrx.kernel.activity1.jmi1.ActivityGroup;
import org.opencrx.kernel.activity1.jmi1.ActivityGroupAssignment;
import org.opencrx.kernel.activity1.jmi1.ActivityProcessState;
import org.opencrx.kernel.activity1.jmi1.ActivityProcessTransition;
import org.opencrx.kernel.activity1.jmi1.EMail;
import org.opencrx.kernel.activity1.jmi1.Incident;
import org.opencrx.kernel.activity1.jmi1.Meeting;
import org.opencrx.kernel.activity1.jmi1.MeetingParty;
import org.opencrx.kernel.backend.AbstractImpl;
import org.opencrx.kernel.backend.Activities;
import org.opencrx.kernel.backend.UserHomes;
import org.opencrx.kernel.home1.jmi1.Alert;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.opencrx.kernel.utils.DataproviderOperation;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.ContextCapable;
import org.openmdx.base.naming.Path;
import org.openmdx.base.text.conversion.HtmlEncoder;
import org.openmdx.portal.servlet.Action;
import org.openmdx.portal.servlet.CssClass;

public class Notifications
extends AbstractImpl {
    public static final short CHANGE_PASSWORD_OK = 0;
    public static final short MISSING_NEW_PASSWORD = 1;
    public static final short MISSING_NEW_PASSWORD_VERIFICATION = 2;
    public static final short PASSWORD_VERIFICATION_MISMATCH = 3;
    public static final short CAN_NOT_RETRIEVE_REQUESTED_PRINCIPAL = 4;
    public static final short CAN_NOT_CHANGE_PASSWORD = 5;
    public static final short MISSING_OLD_PASSWORD = 6;
    protected static final String PRE_STYLE = "white-space:pre-wrap; word-break:normal;";
    protected static final String BOOTSTRAP_MIN_CSS_URL = "https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css";

    public static void register() {
        Notifications.registerImpl(new Notifications());
    }

    public static Notifications getInstance() throws ServiceException {
        return Notifications.getInstance(Notifications.class);
    }

    protected Notifications() {
    }

    public String getAccessUrl(Path targetIdentity, UserHome userHome) throws ServiceException {
        String webAccessUrl = UserHomes.getInstance().getWebAccessUrl(userHome);
        Action selectTargetAction = targetIdentity == null ? null : new Action(6, new Action.Parameter[]{new Action.Parameter("xri", targetIdentity.toXRI())}, "", true);
        return webAccessUrl + "?event=" + 6 + "&parameter=" + selectTargetAction.getParameter();
    }

    public String getNotificationText(PersistenceManager pm, ContextCapable target, Path wfProcessInstanceIdentity, UserHome userHome, Map<String, Object> params) throws ServiceException {
        Action selectTriggeredByAction;
        Action selectTargetAction;
        String text = "#ERR";
        String webAccessUrl = UserHomes.getInstance().getWebAccessUrl(userHome);
        Path targetIdentity = target == null ? null : target.refGetPath();
        Action action = selectTargetAction = targetIdentity == null ? null : new Action(6, new Action.Parameter[]{new Action.Parameter("xri", targetIdentity.toXRI())}, "", true);
        Path triggeredBy = params.get("triggeredBy") instanceof String ? new Path((String)params.get("triggeredBy")) : (params.get("triggeredBy") instanceof Path ? (Path)params.get("triggeredBy") : null);
        String triggeredById = triggeredBy == null ? "N/A" : triggeredBy.getLastSegment().toString();
        Action selectWfProcessInstanceAction = wfProcessInstanceIdentity == null ? null : new Action(6, new Action.Parameter[]{new Action.Parameter("xri", wfProcessInstanceIdentity.toXRI())}, "", true);
        Action action2 = selectTriggeredByAction = triggeredBy == null ? null : new Action(6, new Action.Parameter[]{new Action.Parameter("xri", triggeredBy.toXRI())}, "", true);
        if (target instanceof Alert) {
            Alert alert = (Alert)target;
            ContextCapable referencedObj = null;
            try {
                referencedObj = alert.getReference();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (referencedObj != null && !(referencedObj instanceof UserHome)) {
                text = this.getNotificationText(pm, referencedObj, wfProcessInstanceIdentity, userHome, params);
            } else {
                text = "<!DOCTYPE html>";
                text = text + "<html lang=\"en\">";
                text = text + "<head>";
                text = text + "\t<meta content=\"width=device-width, initial-scale=1\" name=\"viewport\">";
                text = text + "\t<link rel=\"stylesheet\" href=\"https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css\">";
                text = text + "</head>";
                text = text + "<body>";
                text = text + "<div class=\"container\">";
                if (selectTargetAction != null) {
                    text = text + "<div class=\"alert alert-warning\" style=\"margin-bottom:0px\">";
                    text = text + "<h4><a href=\"" + this.getAccessUrl(targetIdentity, userHome) + "\">" + (alert.getName() == null ? "Alert" : alert.getName()) + "</a></h4>";
                    text = text + "</div>";
                    text = text + "<pre style=\"white-space:pre-wrap; word-break:normal;\">";
                } else {
                    text = text + "<pre style=\"white-space:pre-wrap; word-break:normal;\">";
                    text = text + "Name:\n";
                    text = text + (alert.getName() == null ? "---" : alert.getName()) + "\n\n";
                }
                text = text + "Description:\n";
                text = text + (alert.getDescription() == null ? "---" : alert.getDescription()) + "\n\n";
                text = text + "</pre>";
                text = text + "</div>";
                text = text + "</body>";
                text = text + "</html>";
            }
        } else if (target instanceof Activity || target instanceof ActivityFollowUp) {
            Activity activity = target instanceof Activity ? (Activity)target : (Activity)pm.getObjectById((Object)new Path(target.refMofId()).getParent().getParent());
            Contact reportingContact = null;
            try {
                reportingContact = activity.getReportingContact();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Account reportingAccount = null;
            try {
                reportingAccount = activity.getReportingAccount();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Contact assignedTo = null;
            try {
                assignedTo = activity.getAssignedTo();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ActivityProcessState activityState = activity.getProcessState();
            ActivityProcessTransition lastTransition = activity.getLastTransition();
            String activityName = activity.getName();
            text = "<!DOCTYPE html>";
            text = text + "<html lang=\"en\">";
            text = text + "<head>";
            text = text + "\t<meta content=\"width=device-width, initial-scale=1\" name=\"viewport\">";
            text = text + "\t<link rel=\"stylesheet\" href=\"https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css\">";
            text = text + "</head>";
            text = text + "<body>";
            text = text + "<div class=\"container\">";
            text = text + "<div class=\"" + CssClass.alert + " " + CssClass.alert_warning + "\" style=\"margin-bottom:0px\">";
            text = text + "<h4><a href=\"" + webAccessUrl + "?event=" + 6 + "&parameter=" + selectTargetAction.getParameter() + "\">#" + activity.getActivityNumber() + ": " + HtmlEncoder.encode((String)(activityName == null ? "---" : activityName), (boolean)false) + "</a></h4>";
            text = text + "</div>";
            text = text + "<pre style=\"white-space:pre-wrap; word-break:normal;\">";
            text = text + "=========================================================\n";
            text = text + "Reporting Contact:          " + (reportingContact == null ? "---" : reportingContact.getFullName()) + "\n";
            text = text + "Reporting Account:          " + (reportingAccount == null ? "---" : reportingAccount.getFullName()) + "\n";
            text = text + "Handler:                    " + (assignedTo == null ? "---" : assignedTo.getFullName()) + "\n";
            text = text + "=========================================================\n";
            boolean ii = false;
            ActivityHasTrackerAndGroupAssignment.AssignedGroup assignedGroups = activity.getAssignedGroup();
            Iterator iterator = assignedGroups.iterator();
            while (iterator.hasNext()) {
                ActivityGroupAssignment assignedGroup = (ActivityGroupAssignment)iterator.next();
                ActivityGroup group = assignedGroup.getActivityGroup();
                if (group == null) continue;
                if (!ii) {
                    text = text + "Activity Group:             " + group.getName() + "\n";
                    continue;
                }
                text = text + "                            " + group.getName() + "\n";
            }
            text = text + "Activity#:                  " + activity.getActivityNumber() + "\n";
            if (activity instanceof Incident) {
                Incident incident = (Incident)activity;
                try {
                    text = text + "Category:                   " + incident.getCategory() + "\n";
                }
                catch (Exception assignedGroup) {
                    // empty catch block
                }
                try {
                    text = text + "Reproducibility:            " + incident.getReproducibility() + "\n";
                }
                catch (Exception assignedGroup) {
                    // empty catch block
                }
                try {
                    text = text + "Severity:                   " + incident.getSeverity() + "\n";
                }
                catch (Exception assignedGroup) {
                    // empty catch block
                }
            }
            text = text + "Priority:                   " + activity.getPriority() + "\n";
            text = text + "Status:                     " + (activityState == null ? "---" : activityState.getName()) + "\n";
            text = text + "Last transition:            " + (lastTransition == null ? "---" : lastTransition.getName()) + "\n";
            text = text + "=========================================================\n";
            text = text + "Scheduled start:            " + (activity.getScheduledStart() == null ? "---" : activity.getScheduledStart()) + "\n";
            text = text + "Scheduled end:              " + (activity.getScheduledEnd() == null ? "---" : activity.getScheduledEnd()) + "\n";
            text = text + "Due by:                     " + (activity.getDueBy() == null ? "---" : activity.getDueBy()) + "\n";
            text = text + "Actual start:               " + (activity.getActualStart() == null ? "---" : activity.getActualStart()) + "\n";
            text = text + "Actual end:                 " + (activity.getActualEnd() == null ? "---" : activity.getActualEnd()) + "\n";
            text = text + "=========================================================\n";
            text = text + "Date Submitted:             " + activity.getCreatedAt() + "\n";
            text = text + "Last Modified:              " + activity.getModifiedAt() + "\n";
            text = text + "=========================================================\n";
            if (activity instanceof Meeting) {
                text = text + "Organizer:\n";
                text = text + "*  " + activity.getAssignedTo().getFullName() + "\n";
                text = text + "Attendees:\n";
                Meeting meeting = (Meeting)activity;
                MeetingPartyQuery partyQuery = (MeetingPartyQuery)pm.newQuery(MeetingParty.class);
                partyQuery.orderByPartyStatus().ascending();
                List meetingParties = meeting.getMeetingParty(partyQuery);
                for (MeetingParty meetingParty : meetingParties) {
                    String partyStatus = meetingParty.getPartyStatus() == Activities.PartyStatus.ACCEPTED.getValue() ? "+" : (meetingParty.getPartyStatus() == Activities.PartyStatus.DECLINED.getValue() ? "-" : "?");
                    text = text + partyStatus + "  " + (meetingParty.getEmailHint() == null ? meetingParty.getParty().getFullName() : meetingParty.getEmailHint()) + "\n";
                }
                text = text + "=========================================================\n";
            }
            String activityDescription = activity.getDescription();
            String activityDetailedDescription = activity.getDetailedDescription();
            String messageBody = activity instanceof EMail ? ((EMail)activity).getMessageBody() : null;
            text = text + "Summary:\n";
            text = text + (activityName == null ? "---" : activityName) + "\n\n";
            text = text + "Description:\n";
            text = text + (activityDescription == null ? "---" : activityDescription) + "\n\n";
            text = text + "Details:\n";
            text = text + (activityDetailedDescription == null ? "---" : activityDetailedDescription) + "\n\n";
            if (messageBody != null) {
                text = text + "Message Body:\n";
                text = text + messageBody + "\n\n";
            }
            text = text + "</pre>";
            ActivityFollowUpQuery followUpQuery = (ActivityFollowUpQuery)pm.newQuery(ActivityFollowUp.class);
            followUpQuery.orderByCreatedAt().descending();
            List followUps = activity.getFollowUp(followUpQuery);
            for (ActivityFollowUp followUp : followUps) {
                Contact followUpAssignedTo = null;
                try {
                    followUpAssignedTo = followUp.getAssignedTo();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ActivityProcessTransition followUpTransition = null;
                try {
                    followUpTransition = followUp.getTransition();
                }
                catch (Exception meetingParty) {
                    // empty catch block
                }
                text = text + "<div class=\"" + CssClass.alert + " " + CssClass.alert_info + "\" style=\"padding:10px;margin-bottom:0px\">";
                if (followUp.getTitle() != null && !followUp.getTitle().isEmpty()) {
                    text = text + "<div class=\"" + CssClass.row + "\">";
                    text = text + "\t<div class=\"\"><h4>" + HtmlEncoder.encode((String)followUp.getTitle(), (boolean)false) + "</h4></div>";
                    text = text + "</div>";
                }
                text = text + "<div class=\"row\">";
                text = text + "\t<div class=\" text-left\">" + (followUpTransition == null ? "---" : followUpTransition.getName()) + "</div>";
                text = text + "\t<div class=\" text-right\">" + (followUpAssignedTo == null ? "---" : followUpAssignedTo.getFullName()) + "</div>";
                text = text + "\t<div class=\" text-right\">" + followUp.getCreatedAt() + "</div>";
                text = text + "</div>";
                text = text + "</div>";
                String followUpText = followUp.getText();
                if (followUpText != null && !HtmlEncoder.containsWiki((String)followUpText) && HtmlEncoder.containsHtml((String)followUpText)) {
                    text = text + "<div class=\"" + CssClass.panel + " panel-default\">";
                    text = text + "<div class=\"panel-body\">";
                    text = text + followUpText;
                    text = text + "</div>";
                    text = text + "</div>";
                    continue;
                }
                text = text + "<pre style=\"white-space:pre-wrap; word-break:normal;\">";
                text = text + (followUpText == null || followUpText.isEmpty() ? "---" : HtmlEncoder.encode((String)followUpText, (boolean)false));
                text = text + "</pre>";
            }
            text = text + "</div>";
            text = text + "</body>";
            text = text + "</html>";
        } else {
            text = "<!DOCTYPE html>";
            text = text + "<html lang=\"en\">";
            text = text + "<head>";
            text = text + "\t<meta content=\"width=device-width, initial-scale=1\" name=\"viewport\">";
            text = text + "\t<link rel=\"stylesheet\" href=\"https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css\">";
            text = text + "</head>";
            text = text + "<body>";
            text = text + "<div class=\"container\">";
            text = text + "<pre style=\"white-space:pre-wrap; word-break:normal;\">";
            text = text + "=========================================================\n";
            text = text + "Event:           " + (params.get("triggeredByEventType") == null ? "N/A" : DataproviderOperation.valueOf(((Number)params.get("triggeredByEventType")).shortValue()).name()) + "\n";
            text = text + "Trigger Id:      " + triggeredById + "\n";
            if (selectTargetAction != null) {
                text = text + "Object Invoked:  " + "\"" + webAccessUrl + "?event=" + 6 + "&parameter=" + selectTargetAction.getParameter() + "\"\n";
            }
            text = text + "Workflow:        " + (selectWfProcessInstanceAction == null ? "N/A" : "\"" + webAccessUrl + "?event=" + 6 + "&parameter=" + selectWfProcessInstanceAction.getParameter()) + "\"\n";
            text = text + "Trigger URL:     " + (selectTriggeredByAction == null ? "N/A" : "\"" + webAccessUrl + "?event=" + 6 + "&parameter=" + selectTriggeredByAction.getParameter()) + "\"\n";
            text = text + "=========================================================\n";
            text = text + "</pre>";
            text = text + "</div>";
            text = text + "</body>";
            text = text + "</html>";
        }
        return text;
    }

    public String getNotificationSubject(PersistenceManager pm, ContextCapable target, Path wfProcessInstanceIdentity, UserHome userHome, Map<String, Object> params, boolean useSendMailSubjectPrefix) throws ServiceException {
        String webAccessUrl;
        String sendMailSubjectPrefix;
        String triggeredById;
        String title;
        String segmentName;
        String providerName;
        Path userHomeIdentity;
        block17: {
            userHomeIdentity = userHome.refGetPath();
            providerName = userHomeIdentity.getSegment(2).toString();
            segmentName = userHomeIdentity.getSegment(4).toString();
            title = null;
            Path triggeredBy = params.get("triggeredBy") instanceof String ? new Path((String)params.get("triggeredBy")) : (params.get("triggeredBy") instanceof Path ? (Path)params.get("triggeredBy") : null);
            triggeredById = triggeredBy == null ? "N/A" : triggeredBy.getLastSegment().toString();
            sendMailSubjectPrefix = userHome.getSendMailSubjectPrefix() == null ? "[" + providerName + ":" + segmentName + "]" : userHome.getSendMailSubjectPrefix();
            webAccessUrl = UserHomes.getInstance().getWebAccessUrl(userHome);
            if (target != null && !Boolean.TRUE.equals(params.get("confidential"))) {
                try {
                    if (target instanceof EMail) {
                        EMail emailActivity = (EMail)target;
                        title = (useSendMailSubjectPrefix ? sendMailSubjectPrefix + ": " : "") + emailActivity.getMessageSubject();
                        break block17;
                    }
                    if (target instanceof Alert) {
                        Alert alert = (Alert)target;
                        title = alert.getName() != null && !alert.getName().isEmpty() ? (useSendMailSubjectPrefix ? sendMailSubjectPrefix + ": " : "") + alert.getName() : (alert.getReference() != null && !(alert.getReference() instanceof UserHome) ? this.getNotificationSubject(pm, alert.getReference(), wfProcessInstanceIdentity, userHome, params, useSendMailSubjectPrefix) : alert.refGetPath().toXRI());
                        break block17;
                    }
                    if (title == null) {
                        try {
                            if (target.refGetValue("name") != null) {
                                title = sendMailSubjectPrefix + ": " + target.refGetValue("name");
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (title == null) {
                        try {
                            if (target.refGetValue("title") != null) {
                                title = sendMailSubjectPrefix + ": " + target.refGetValue("title");
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (title != null) break block17;
                    try {
                        if (target.refGetValue("fullName") != null) {
                            title = sendMailSubjectPrefix + ": " + target.refGetValue("fullName");
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (title == null) {
            title = sendMailSubjectPrefix + ": from=" + providerName + "/" + segmentName + "/" + userHomeIdentity.getSegment(6).toString() + "; trigger=" + triggeredById + "; access=" + webAccessUrl;
        }
        return title;
    }
}

