/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.generic;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ChainingCollection<T>
extends AbstractCollection<T> {
    protected final Collection<T>[] collections;

    public ChainingCollection(Collection<T> ... collections) {
        this.collections = collections;
    }

    public ChainingCollection(List<Collection<T>> collections) {
        this.collections = collections.toArray(new Collection[collections.size()]);
    }

    @Override
    public Iterator<T> iterator() {
        return new ChainingIterator();
    }

    @Override
    public int size() {
        int size = 0;
        for (int i = 0; i < this.collections.length; ++i) {
            size += this.collections[i].size();
        }
        return size;
    }

    class ChainingIterator
    implements Iterator<T> {
        private Iterator<T> iterator;
        private int index = 0;

        public ChainingIterator() {
            this.iterator = ChainingCollection.this.collections[0].iterator();
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.iterator.hasNext();
            while (!hasNext && this.index < ChainingCollection.this.collections.length - 1) {
                ++this.index;
                this.iterator = ChainingCollection.this.collections[this.index].iterator();
                hasNext = this.iterator.hasNext();
            }
            return hasNext;
        }

        @Override
        public T next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

