/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.layer.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import org.opencrx.kernel.generic.SecurityKeys;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.opencrx.security.realm1.cci2.PrincipalGroupQuery;
import org.opencrx.security.realm1.jmi1.Principal;
import org.opencrx.security.realm1.jmi1.PrincipalGroup;
import org.openmdx.application.dataprovider.cci.AttributeSpecifier;
import org.openmdx.application.dataprovider.cci.FilterProperty;
import org.openmdx.base.accessor.jmi.spi.EntityManagerFactory_1;
import org.openmdx.base.accessor.rest.DataManagerFactory_1;
import org.openmdx.base.dataprovider.cci.DataproviderRequestProcessor;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.mof.cci.ModelElement_1_0;
import org.openmdx.base.mof.cci.Model_1_0;
import org.openmdx.base.mof.spi.Model_1Factory;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.ConfigurableProperty;
import org.openmdx.base.persistence.cci.PersistenceHelper;
import org.openmdx.base.persistence.spi.PersistenceManagers;
import org.openmdx.base.query.ConditionType;
import org.openmdx.base.query.Quantifier;
import org.openmdx.base.resource.Records;
import org.openmdx.base.resource.cci.ConnectionFactory;
import org.openmdx.base.resource.spi.ResourceExceptions;
import org.openmdx.base.resource.spi.RestInteractionSpec;
import org.openmdx.base.rest.cci.ConsumerRecord;
import org.openmdx.base.rest.cci.MessageRecord;
import org.openmdx.base.rest.cci.ObjectRecord;
import org.openmdx.base.rest.cci.QueryExtensionRecord;
import org.openmdx.base.rest.cci.QueryFilterRecord;
import org.openmdx.base.rest.cci.RequestRecord;
import org.openmdx.base.rest.cci.RestConnection;
import org.openmdx.base.rest.cci.ResultRecord;
import org.openmdx.base.rest.spi.AbstractRestInteraction;
import org.openmdx.base.rest.spi.AbstractRestPort;
import org.openmdx.base.rest.spi.DelegatingConsumerRecord;
import org.openmdx.base.rest.spi.Facades;
import org.openmdx.base.rest.spi.Object_2Facade;
import org.openmdx.base.rest.spi.QueryRecord;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.log.SysLog;
import org.openmdx.security.realm1.cci2.PrincipalQuery;
import org.openmdx.security.realm1.jmi1.Group;
import org.openmdx.security.realm1.jmi1.Permission;
import org.openmdx.security.realm1.jmi1.Realm;
import org.openmdx.security.realm1.jmi1.Role;
import org.w3c.cci2.AnyTypePredicate;

public class AccessControl_2
extends AbstractRestPort {
    protected static final Path EXTENT_PATTERN = new Path("xri:@openmdx:**/provider/**/segment/**/extent");
    protected static final Path USER_HOME_PATH_PATTERN = new Path("xri://@openmdx*org.opencrx.kernel.home1/provider/:*/segment/:*/userHome/:*");
    protected static final String ALL_PERMISSION = "*";
    protected Path realmIdentity = null;
    protected Model_1_0 model = Model_1Factory.getModel();
    protected boolean useExtendedAccessLevelBasic = false;
    protected ConnectionFactory connectionFactory = null;
    private Map<String, DefaultRealm> cachedRealms = new ConcurrentHashMap<String, DefaultRealm>();
    private static final long TTL_CACHED_OBJECTS = 60000L;
    protected static final ConcurrentMap<Path, Object[]> objectCache = new ConcurrentHashMap<Path, Object[]>();
    protected static final ConcurrentMap<Path, Path> sharedAssociationToCompositeParentPathMap = new ConcurrentHashMap<Path, Path>();

    public Interaction getInteraction(RestConnection connection) throws ResourceException {
        return new RestInteraction(connection);
    }

    protected Path getUserIdentity(CachedPrincipal principal) {
        return this.getUserIdentity(principal.getIdentity().getSegment(6).toString(), principal.getIdentity().getLastSegment().toString());
    }

    protected Path getUserIdentity(String qualifiedPrincipalName) {
        int pos = qualifiedPrincipalName.indexOf(":");
        String realmName = null;
        String principalName = null;
        if (pos < 0) {
            SysLog.error((String)("FATAL: object has illegal formatted owner (<realm segment>:<subject name>): " + qualifiedPrincipalName));
            realmName = "Root";
            principalName = qualifiedPrincipalName;
        } else {
            realmName = qualifiedPrincipalName.substring(0, pos);
            principalName = qualifiedPrincipalName.substring(pos + 1);
        }
        return this.getUserIdentity(realmName, principalName);
    }

    protected Path getUserIdentity(String realmName, String principalName) {
        if ("admin".equals(principalName) || "loader".equals(principalName)) {
            principalName = principalName + SecurityKeys.ID_SEPARATOR + realmName;
        }
        if (!principalName.endsWith("User")) {
            principalName = principalName + ".User";
        }
        Path userIdentity = this.realmIdentity.getParent().getDescendant(new String[]{realmName, "principal", principalName});
        return userIdentity;
    }

    protected Path getUser(CachedPrincipal principal) throws ServiceException {
        return this.getUserIdentity(principal);
    }

    protected Path getGroupIdentity(Path accessPath, String qualifiedPrincipalName) {
        int pos = qualifiedPrincipalName.indexOf(":");
        String segmentName = null;
        String principalName = null;
        if (pos < 0) {
            System.err.println("FATAL: object has illegal formatted owner (<realm segment>:<subject name>): " + qualifiedPrincipalName + "; path=" + accessPath.toXRI());
            segmentName = "Root";
            principalName = qualifiedPrincipalName;
        } else {
            segmentName = qualifiedPrincipalName.substring(0, pos);
            principalName = qualifiedPrincipalName.substring(pos + 1);
        }
        Path principalIdentity = this.realmIdentity.getParent().getDescendant(new String[]{segmentName, "principal", principalName});
        return principalIdentity;
    }

    protected String getQualifiedPrincipalName(Path accessPath, String principalName) {
        return accessPath.getSegment(4).toString() + ":" + principalName;
    }

    protected String getQualifiedPrincipalName(Path principalIdentity) {
        return principalIdentity.getSegment(6).toString() + ":" + principalIdentity.getLastSegment().toString();
    }

    protected DataproviderRequestProcessor newDelegateRequestProcessor(RestConnection connection) throws ResourceException {
        return new DataproviderRequestProcessor(PersistenceManagers.toPrincipalChain((String)connection.getMetaData().getUserName()), this.getDelegate());
    }

    protected PersistenceManager newDelegatePersistenceManager(RestConnection connection) {
        ConnectionFactory connectionFactory = this.connectionFactory == null ? connection.getConnectionFactory() : this.connectionFactory;
        HashMap<String, Object> entityManagerConfiguration = new HashMap<String, Object>();
        entityManagerConfiguration.put(ConfigurableProperty.ConnectionFactory.qualifiedName(), DataManagerFactory_1.getPersistenceManagerFactory(Collections.singletonMap(ConfigurableProperty.ConnectionFactory.qualifiedName(), connectionFactory)));
        entityManagerConfiguration.put(ConfigurableProperty.PersistenceManagerFactoryClass.qualifiedName(), EntityManagerFactory_1.class.getName());
        return JDOHelper.getPersistenceManagerFactory(entityManagerConfiguration).getPersistenceManager("admin-Root", null);
    }

    protected ObjectRecord retrieveObject(DataproviderRequestProcessor p, Path resourceIdentifier, boolean preferringNotFoundException) throws ResourceException {
        QueryRecord getRequest = new QueryRecord();
        getRequest.setResourceIdentifier(resourceIdentifier);
        getRequest.setFetchGroupName("all");
        QueryFilterRecord query = (QueryFilterRecord)Records.getRecordFactory().createMappedRecord(QueryFilterRecord.class);
        query.getOrderSpecifier().addAll(AttributeSpecifier.toOrderSpecifier((AttributeSpecifier[])new AttributeSpecifier[]{new AttributeSpecifier("owner")}));
        getRequest.setQueryFilter(query);
        return p.addGetRequest((org.openmdx.base.rest.cci.QueryRecord)getRequest);
    }

    protected MappedRecord newOperationResult(String recordType) throws ResourceException {
        return Records.getRecordFactory().createMappedRecord(recordType);
    }

    protected ResultRecord findObjects(DataproviderRequestProcessor p, Path reference) throws ResourceException {
        return p.addFindRequest(reference);
    }

    protected void completeOwningUserAndGroup(ObjectRecord object) throws ResourceException {
        try {
            Object_2Facade facade = Facades.asObject((MappedRecord)object);
            facade.getValue().keySet().remove("owningUser");
            facade.getValue().keySet().remove("owningGroup");
            if (!facade.attributeValuesAsList("owner").isEmpty()) {
                if ((String)facade.attributeValue("owner") == null) {
                    SysLog.error((String)"Values of attribute owner are corrupt. Element at index 0 (owning user) is missing. Fix the database", (Object)object);
                } else {
                    facade.attributeValuesAsList("owningUser").add(this.getUserIdentity((String)facade.attributeValue("owner")));
                }
            }
            for (int i = 1; i < facade.attributeValuesAsList("owner").size(); ++i) {
                facade.attributeValuesAsList("owningGroup").add(this.getGroupIdentity(facade.getPath(), (String)facade.attributeValuesAsList("owner").get(i)));
            }
        }
        catch (ServiceException e) {
            throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
        }
    }

    protected void completeObject(ObjectRecord object) throws ResourceException {
        this.completeOwningUserAndGroup(object);
    }

    protected void completeReply(ResultRecord objects) throws ResourceException {
        if (objects != null) {
            for (Object object : objects) {
                this.completeObject((ObjectRecord)object);
            }
        }
    }

    protected boolean isPrincipalGroup(MappedRecord object) throws ServiceException {
        String objectClass = Object_2Facade.getObjectClass((MappedRecord)object);
        return this.model.isSubtypeOf((Object)objectClass, (Object)"org:opencrx:security:realm1:PrincipalGroup");
    }

    protected boolean isSecureObject(MappedRecord object) throws ResourceException {
        try {
            String objectClass = Object_2Facade.getObjectClass((MappedRecord)object);
            if (objectClass == null) {
                SysLog.error((String)"Undefined object class", (Object)Object_2Facade.getPath((MappedRecord)object));
                return true;
            }
            return this.model.isSubtypeOf((Object)objectClass, (Object)"org:opencrx:kernel:base:SecureObject");
        }
        catch (ServiceException e) {
            throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
        }
    }

    protected boolean isSecureObject(ModelElement_1_0 type) throws ServiceException {
        return this.model.isSubtypeOf((Object)type, (Object)"org:opencrx:kernel:base:SecureObject");
    }

    protected List<String> getPrincipalChain(Connection connection) throws ResourceException {
        return PersistenceManagers.toPrincipalChain((String)connection.getMetaData().getUserName());
    }

    protected DefaultRealm newRealm(Path realmIdentity) throws ResourceException {
        return new DefaultRealm(realmIdentity);
    }

    protected DefaultRealm getRealm(RequestRecord request, List<String> principalChain, PersistenceManager pm) throws ResourceException {
        DefaultRealm realm;
        CachedPrincipal requestingPrincipal;
        String realmName;
        Path path = request.getResourceIdentifier();
        String principalName = principalChain.get(0);
        String string = realmName = "admin-Root".equals(principalName) ? "Root" : path.getSegment(4).toString();
        if (this.cachedRealms.get(realmName) == null) {
            this.cachedRealms.put(realmName, this.newRealm(this.realmIdentity.getParent().getChild(realmName)));
        }
        if ((requestingPrincipal = (realm = this.cachedRealms.get(realmName)).getPrincipal(principalName, pm)) == null) {
            throw ResourceExceptions.initHolder((ResourceException)new ResourceException("Requested principal not found.", (Throwable)BasicException.newEmbeddedExceptionStack((String)"OpenCrxDomain", (int)1003, (BasicException.Parameter[])new BasicException.Parameter[]{new BasicException.Parameter("principal", principalChain), new BasicException.Parameter("param0", principalChain), new BasicException.Parameter("param1", (Object)this.realmIdentity)})));
        }
        SysLog.detail((String)"Requesting principal", (Object)requestingPrincipal);
        return realm;
    }

    protected ModelElement_1_0 getReferencedType(Path accessPath, List<FilterProperty> filter) throws ServiceException {
        boolean isExtent = false;
        if (filter != null && accessPath.isLike(EXTENT_PATTERN)) {
            for (FilterProperty p : filter) {
                if (!"identity".equals(p.name())) continue;
                if (p.values().size() > 1) {
                    throw new ServiceException("DefaultDomain", -36, "at most one value allowed for filter property 'identity'", new BasicException.Parameter[]{new BasicException.Parameter("filter", filter)});
                }
                isExtent = true;
                accessPath = new Path(p.values().iterator().next().toString());
            }
            if (!isExtent) {
                throw new ServiceException("DefaultDomain", -36, "extent lookups require at least a filter value for property 'identity'", new BasicException.Parameter[]{new BasicException.Parameter("filter", filter)});
            }
        }
        return this.model.getTypes(accessPath)[2];
    }

    protected static ConcurrentMap<Path, Object[]> getObjectCache() {
        return objectCache;
    }

    public Path getRealmIdentity() {
        return this.realmIdentity;
    }

    public void setRealmIdentity(Path realmIdentity) {
        this.realmIdentity = realmIdentity;
    }

    public boolean isUseExtendedAccessLevelBasic() {
        return this.useExtendedAccessLevelBasic;
    }

    public void setUseExtendedAccessLevelBasic(boolean useExtendedAccessLevelBasic) {
        this.useExtendedAccessLevelBasic = useExtendedAccessLevelBasic;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public class RestInteraction
    extends AbstractRestInteraction {
        public RestInteraction(RestConnection connection) throws ResourceException {
            super(connection, AccessControl_2.this.newDelegateInteraction(connection));
        }

        protected String getOwningUserForNewObject(Path requestingUser, Object_2Facade newObjectFacade, Object_2Facade parentFacade, DefaultRealm realm) throws ResourceException {
            try {
                String owningUser = null;
                owningUser = newObjectFacade.getPath().size() > USER_HOME_PATH_PATTERN.size() && newObjectFacade.getPath().getPrefix(USER_HOME_PATH_PATTERN.size()).isLike(USER_HOME_PATH_PATTERN) && !parentFacade.attributeValuesAsList("owner").isEmpty() ? (String)parentFacade.attributeValue("owner") : (!newObjectFacade.attributeValuesAsList("owningUser").isEmpty() ? AccessControl_2.this.getQualifiedPrincipalName((Path)newObjectFacade.attributeValue("owningUser")) : (newObjectFacade.attributeValuesAsList("owner").isEmpty() ? (requestingUser == null ? AccessControl_2.this.getQualifiedPrincipalName(newObjectFacade.getPath(), "admin") : AccessControl_2.this.getQualifiedPrincipalName(requestingUser)) : (String)newObjectFacade.attributeValue("owner")));
                return owningUser;
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
        }

        protected Set<String> getOwningGroupsForNewObject(CachedPrincipal requestingPrincipal, Object_2Facade newObjectFacade, Object_2Facade parentFacade, PersistenceManager pm) throws ResourceException {
            try {
                DefaultRealm realm = requestingPrincipal.getRealm();
                HashSet<String> owningGroup = new HashSet<String>();
                if (newObjectFacade.getAttributeValues("owningGroup") != null && !newObjectFacade.attributeValuesAsList("owningGroup").isEmpty()) {
                    Iterator i = newObjectFacade.attributeValuesAsList("owningGroup").iterator();
                    while (i.hasNext()) {
                        owningGroup.add(AccessControl_2.this.getQualifiedPrincipalName((Path)i.next()));
                    }
                } else {
                    Path userGroup = requestingPrincipal == null ? null : realm.getPrimaryGroup(requestingPrincipal, pm);
                    owningGroup = new HashSet();
                    if (parentFacade != null) {
                        ArrayList ownersParent = new ArrayList(parentFacade.attributeValuesAsList("owner"));
                        if (parentFacade.getPath().size() == 5) {
                            ownersParent.remove(AccessControl_2.this.getQualifiedPrincipalName(newObjectFacade.getPath(), "Users"));
                        }
                        if (!ownersParent.isEmpty()) {
                            owningGroup.addAll(ownersParent.subList(1, ownersParent.size()));
                        }
                    }
                    if (userGroup == null) {
                        if (owningGroup.isEmpty()) {
                            owningGroup.add(AccessControl_2.this.getQualifiedPrincipalName(newObjectFacade.getPath(), "Unassigned"));
                        }
                    } else {
                        owningGroup.add(AccessControl_2.this.getQualifiedPrincipalName(userGroup));
                    }
                }
                return owningGroup;
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
        }

        private ObjectRecord getCachedObject(DataproviderRequestProcessor p, Path path) throws ResourceException {
            ConcurrentMap<Path, Object[]> objectCache = AccessControl_2.getObjectCache();
            Iterator i = objectCache.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                try {
                    if (entry == null) continue;
                    if (entry.getValue() == null) {
                        i.remove();
                        continue;
                    }
                    Long expiresAt = (Long)((Object[])entry.getValue())[1];
                    if (expiresAt != null && expiresAt >= System.currentTimeMillis()) continue;
                    i.remove();
                }
                catch (Exception exception) {}
            }
            Object[] entry = (Object[])objectCache.get(path);
            ObjectRecord object = null;
            if (entry == null) {
                SysLog.log((Level)Level.FINE, (String)"retrieveObject {0}", (Object[])new Object[]{path});
                object = AccessControl_2.this.retrieveObject(p, path, true);
                this.addToObjectCache(object);
            } else {
                object = (ObjectRecord)entry[0];
            }
            return object;
        }

        private void addToObjectCache(ObjectRecord object) throws ResourceException {
            try {
                Object_2Facade facade = Facades.asObject((MappedRecord)object);
                if (facade.getObjectClass() != null) {
                    AccessControl_2.getObjectCache().put(facade.getPath(), new Object[]{Object_2Facade.cloneObject((MappedRecord)object), new Long(System.currentTimeMillis() + 60000L)});
                } else {
                    SysLog.error((String)"Missing object class. Object not added to cache", (Object)facade.getPath());
                }
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
        }

        public boolean create(RestInteractionSpec ispec, ObjectRecord request, ResultRecord response) throws ResourceException {
            PersistenceManager pm = AccessControl_2.this.newDelegatePersistenceManager((RestConnection)this.getConnection());
            DataproviderRequestProcessor p = AccessControl_2.this.newDelegateRequestProcessor((RestConnection)this.getConnection());
            try {
                ObjectRecord newObject;
                Path path = request.getResourceIdentifier();
                DefaultRealm realm = AccessControl_2.this.getRealm((RequestRecord)request, this.getPrincipalChain(), pm);
                GetRunAsPrincipalResult getRunAsPrincipalResult = realm.getRunAsPrincipal((RequestRecord)request, this.getPrincipalChain(), p, pm);
                CachedPrincipal principal = getRunAsPrincipalResult.getPrincipal();
                Path userIdentity = getRunAsPrincipalResult.getUserIdentity();
                ObjectRecord parent = null;
                Object_2Facade parentFacade = null;
                if (path.size() >= 7) {
                    boolean hasPermission;
                    parent = this.getCachedObject(p, path.getPrefix(path.size() - 2));
                    parentFacade = Facades.asObject((MappedRecord)parent);
                    if (AccessControl_2.this.isSecureObject((MappedRecord)parent) && !(hasPermission = realm.hasPermission((RequestRecord)request, parentFacade, null, principal, userIdentity, realm.getAccessControlAction(ispec, parentFacade), null, p, pm))) {
                        throw ResourceExceptions.initHolder((ResourceException)new ResourceException("No permission to create object.", (Throwable)BasicException.newEmbeddedExceptionStack((String)"OpenCrxDomain", (int)1002, (BasicException.Parameter[])new BasicException.Parameter[]{new BasicException.Parameter("object", (Object)path), new BasicException.Parameter("param0", (Object)path), new BasicException.Parameter("param1", (Object)(principal.getIdentity().getSegment(6).toString() + ":" + principal.getIdentity().getLastSegment().toString()))})));
                    }
                }
                if (AccessControl_2.this.isSecureObject((MappedRecord)(newObject = request))) {
                    Object_2Facade newObjectFacade = Facades.asObject((MappedRecord)newObject);
                    String owningUser = this.getOwningUserForNewObject(userIdentity, newObjectFacade, parentFacade, realm);
                    newObjectFacade.attributeValuesAsList("owner").clear();
                    newObjectFacade.attributeValuesAsList("owner").add(owningUser);
                    Set<String> owningGroup = this.getOwningGroupsForNewObject(principal, newObjectFacade, parentFacade, pm);
                    newObjectFacade.attributeValuesAsList("owner").addAll(owningGroup);
                    newObjectFacade.getValue().keySet().remove("owningUser");
                    newObjectFacade.getValue().keySet().remove("owningGroup");
                    for (String mode : Arrays.asList("accessLevelBrowse", "accessLevelUpdate", "accessLevelDelete")) {
                        if (newObjectFacade.attributeValuesAsList(mode).size() == 1 && ((Number)newObjectFacade.attributeValue(mode)).shortValue() != 0) continue;
                        newObjectFacade.attributeValuesAsList(mode).clear();
                        newObjectFacade.attributeValuesAsList(mode).add(new Short("accessLevelBrowse".equals(mode) ? (short)3 : 2));
                    }
                }
                if (super.create(ispec, request, response)) {
                    this.addToObjectCache(request);
                }
                AccessControl_2.this.completeReply(response);
                boolean bl = true;
                return bl;
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
            finally {
                if (pm != null) {
                    pm.close();
                }
            }
        }

        protected void restrictQuery(PersistenceManager pm, DataproviderRequestProcessor p, DefaultRealm realm, RestInteractionSpec ispec, org.openmdx.base.rest.cci.QueryRecord request) throws ResourceException, ServiceException {
            Path path = request.getResourceIdentifier();
            GetRunAsPrincipalResult getRunAsPrincipalResult = realm.getRunAsPrincipal((RequestRecord)request, this.getPrincipalChain(), p, pm);
            CachedPrincipal principal = getRunAsPrincipalResult.getPrincipal();
            Path userIdentity = getRunAsPrincipalResult.getUserIdentity();
            ObjectRecord parent = this.getCachedObject(p, path.getParent());
            Object_2Facade parentFacade = Facades.asObject((MappedRecord)parent);
            boolean containsSharedAssociation = AccessControl_2.this.model.containsSharedAssociation(path);
            if (containsSharedAssociation) {
                Object_2Facade objectParentFacade = null;
                Path compositeParentPath = null;
                for (Map.Entry e : sharedAssociationToCompositeParentPathMap.entrySet()) {
                    if (!path.isLike((Path)e.getKey())) continue;
                    compositeParentPath = (Path)e.getValue();
                    break;
                }
                if (compositeParentPath != null) {
                    objectParentFacade = Facades.asObject((MappedRecord)this.getCachedObject(p, compositeParentPath));
                } else {
                    Long originalSize = request.getSize();
                    Long originalPosition = request.getPosition();
                    ResultRecord response = (ResultRecord)Records.getRecordFactory().createIndexedRecord("org:openmdx:kernel:ResultSet");
                    request.setSize(Long.valueOf(1L));
                    request.setPosition(Long.valueOf(0L));
                    super.find(ispec, request, response);
                    if (!response.isEmpty()) {
                        compositeParentPath = Object_2Facade.getPath((MappedRecord)((ObjectRecord)response.get(0))).getParent().getParent();
                        objectParentFacade = Facades.asObject((MappedRecord)this.getCachedObject(p, compositeParentPath));
                        request.setPosition(originalPosition);
                        request.setSize(originalSize);
                        response.clear();
                        if (compositeParentPath.size() == 5) {
                            Path sharedAssociationPathPattern = path.getPrefix(5);
                            for (int i = 5; i < path.size(); ++i) {
                                sharedAssociationPathPattern = i % 2 == 0 ? sharedAssociationPathPattern.getChild(":*") : sharedAssociationPathPattern.getChild(path.getSegment(i).toString());
                            }
                            sharedAssociationToCompositeParentPathMap.put(sharedAssociationPathPattern, compositeParentPath);
                        }
                    }
                }
                if (objectParentFacade != null) {
                    realm.restrictQuery(request, objectParentFacade, principal, userIdentity, pm);
                }
            }
            realm.restrictQuery(request, parentFacade, principal, userIdentity, pm);
        }

        public boolean find(RestInteractionSpec ispec, org.openmdx.base.rest.cci.QueryRecord request, ResultRecord response) throws ResourceException {
            PersistenceManager pm = AccessControl_2.this.newDelegatePersistenceManager((RestConnection)this.getConnection());
            DataproviderRequestProcessor p = AccessControl_2.this.newDelegateRequestProcessor((RestConnection)this.getConnection());
            try {
                Path path = request.getResourceIdentifier();
                DefaultRealm realm = AccessControl_2.this.getRealm((RequestRecord)request, this.getPrincipalChain(), pm);
                ObjectRecord parent = this.getCachedObject(p, path.getParent());
                ModelElement_1_0 referencedType = AccessControl_2.this.getReferencedType(path, FilterProperty.getFilterProperties((QueryFilterRecord)request.getQueryFilter()));
                if (AccessControl_2.this.isSecureObject(referencedType) && AccessControl_2.this.isSecureObject((MappedRecord)parent)) {
                    this.restrictQuery(pm, p, realm, ispec, request);
                    super.find(ispec, request, response);
                } else {
                    super.find(ispec, request, response);
                }
                if (response != null && "all".equals(request.getFetchGroupName())) {
                    for (Object object : response) {
                        ObjectRecord record = (ObjectRecord)object;
                        if (record.getResourceIdentifier().size() > 7) continue;
                        SysLog.log((Level)Level.FINE, (String)"addToObjectCache {0}", (Object[])new Object[]{record.getResourceIdentifier()});
                        this.addToObjectCache(record);
                    }
                }
                AccessControl_2.this.completeReply(response);
                boolean bl = true;
                return bl;
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
            finally {
                if (pm != null) {
                    pm.close();
                }
            }
        }

        protected boolean consume(RestInteractionSpec ispec, org.openmdx.base.rest.cci.QueryRecord request, ConsumerRecord response) throws ResourceException {
            PersistenceManager pm = AccessControl_2.this.newDelegatePersistenceManager((RestConnection)this.getConnection());
            DataproviderRequestProcessor p = AccessControl_2.this.newDelegateRequestProcessor((RestConnection)this.getConnection());
            try {
                DefaultRealm realm = AccessControl_2.this.getRealm((RequestRecord)request, this.getPrincipalChain(), pm);
                this.restrictQuery(pm, p, realm, ispec, request);
                boolean bl = super.consume(ispec, request, (ConsumerRecord)new CompletingConsumerRecord(response));
                return bl;
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
            finally {
                if (pm != null) {
                    pm.close();
                }
            }
        }

        public boolean get(RestInteractionSpec ispec, org.openmdx.base.rest.cci.QueryRecord request, ResultRecord response) throws ResourceException {
            PersistenceManager pm = AccessControl_2.this.newDelegatePersistenceManager((RestConnection)this.getConnection());
            DataproviderRequestProcessor p = AccessControl_2.this.newDelegateRequestProcessor((RestConnection)this.getConnection());
            try {
                Path path = request.getResourceIdentifier();
                Model_1_0 model = Model_1Factory.getModel();
                DefaultRealm realm = AccessControl_2.this.getRealm((RequestRecord)request, this.getPrincipalChain(), pm);
                GetRunAsPrincipalResult getRunAsPrincipalResult = realm.getRunAsPrincipal((RequestRecord)request, this.getPrincipalChain(), p, pm);
                CachedPrincipal principal = getRunAsPrincipalResult.getPrincipal();
                Path userIdentity = getRunAsPrincipalResult.getUserIdentity();
                try {
                    request.setFetchGroupName("all");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                super.get(ispec, request, response);
                if (response.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
                ObjectRecord parent = null;
                if (path.size() >= 7) {
                    parent = this.getCachedObject(p, path.getPrefix(path.size() - 2));
                    Object_2Facade parentFacade = Facades.asObject((MappedRecord)parent);
                    ModelElement_1_0 referencedType = model.getTypes(path)[2];
                    if (AccessControl_2.this.isSecureObject(referencedType) && AccessControl_2.this.isSecureObject((MappedRecord)parent)) {
                        Object_2Facade objectFacade = Facades.asObject((MappedRecord)((ObjectRecord)response.get(0)));
                        boolean hasPermission = realm.hasPermission((RequestRecord)request, objectFacade, parentFacade, principal, userIdentity, realm.getAccessControlAction(ispec, parentFacade), null, p, pm);
                        if (hasPermission) {
                            AccessControl_2.this.completeReply(response);
                            boolean bl = true;
                            return bl;
                        }
                        throw ResourceExceptions.initHolder((ResourceException)new ResourceException("No permission to access requested object.", (Throwable)BasicException.newEmbeddedExceptionStack((String)"OpenCrxDomain", (int)1004, (BasicException.Parameter[])new BasicException.Parameter[]{new BasicException.Parameter("object", (Object)path), new BasicException.Parameter("param0", (Object)path.toXRI()), new BasicException.Parameter("param1", (Object)(principal.getIdentity().getSegment(6).toString() + ":" + principal.getIdentity().getLastSegment().toString())), new BasicException.Parameter("param2", (Object)userIdentity.toXRI())})));
                    }
                }
                AccessControl_2.this.completeReply(response);
                boolean bl = true;
                return bl;
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
            finally {
                if (pm != null) {
                    pm.close();
                }
            }
        }

        public boolean delete(RestInteractionSpec ispec, ObjectRecord request) throws ResourceException {
            PersistenceManager pm = AccessControl_2.this.newDelegatePersistenceManager((RestConnection)this.getConnection());
            DataproviderRequestProcessor p = AccessControl_2.this.newDelegateRequestProcessor((RestConnection)this.getConnection());
            try {
                Object_2Facade objectFacade;
                boolean hasPermission;
                Path path = request.getResourceIdentifier();
                DefaultRealm realm = AccessControl_2.this.getRealm((RequestRecord)request, this.getPrincipalChain(), pm);
                GetRunAsPrincipalResult getRunAsPrincipalResult = realm.getRunAsPrincipal((RequestRecord)request, this.getPrincipalChain(), p, pm);
                CachedPrincipal principal = getRunAsPrincipalResult.getPrincipal();
                Path userIdentity = getRunAsPrincipalResult.getUserIdentity();
                ObjectRecord object = AccessControl_2.this.retrieveObject(p, path, true);
                if (AccessControl_2.this.isSecureObject((MappedRecord)object) && !(hasPermission = realm.hasPermission((RequestRecord)request, objectFacade = Facades.asObject((MappedRecord)object), null, principal, userIdentity, realm.getAccessControlAction(ispec, objectFacade), null, p, pm))) {
                    throw ResourceExceptions.initHolder((ResourceException)new ResourceException("No permission to delete requested object.", (Throwable)BasicException.newEmbeddedExceptionStack((String)"OpenCrxDomain", (int)1001, (BasicException.Parameter[])new BasicException.Parameter[]{new BasicException.Parameter("object", (Object)path), new BasicException.Parameter("param0", (Object)path.toXRI()), new BasicException.Parameter("param1", (Object)(principal.getIdentity().getSegment(6).toString() + ":" + principal.getIdentity().getLastSegment().toString())), new BasicException.Parameter("param2", (Object)userIdentity.toXRI())})));
                }
                objectCache.remove(path);
                boolean bl = super.delete(ispec, request);
                return bl;
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
            finally {
                if (pm != null) {
                    pm.close();
                }
            }
        }

        protected boolean update(RestInteractionSpec ispec, ObjectRecord request, ResultRecord response) throws ResourceException {
            PersistenceManager pm = AccessControl_2.this.newDelegatePersistenceManager((RestConnection)this.getConnection());
            DataproviderRequestProcessor p = AccessControl_2.this.newDelegateRequestProcessor((RestConnection)this.getConnection());
            try {
                Path path = request.getResourceIdentifier();
                DefaultRealm realm = AccessControl_2.this.getRealm((RequestRecord)request, this.getPrincipalChain(), pm);
                ObjectRecord replacement = request;
                Object_2Facade replacementFacade = Facades.asObject((MappedRecord)replacement);
                GetRunAsPrincipalResult getRunAsPrincipalResult = realm.getRunAsPrincipal((RequestRecord)request, this.getPrincipalChain(), p, pm);
                CachedPrincipal principal = getRunAsPrincipalResult.getPrincipal();
                Path userIdentity = getRunAsPrincipalResult.getUserIdentity();
                ObjectRecord object = AccessControl_2.this.retrieveObject(p, path, true);
                if (AccessControl_2.this.isSecureObject((MappedRecord)object)) {
                    Object_2Facade objectFacade = Facades.asObject((MappedRecord)object);
                    boolean hasPermission = realm.hasPermission((RequestRecord)request, objectFacade, null, principal, userIdentity, realm.getAccessControlAction(ispec, replacementFacade), null, p, pm);
                    if (!hasPermission) {
                        throw ResourceExceptions.initHolder((ResourceException)new ResourceException("No permission to update requested object.", (Throwable)BasicException.newEmbeddedExceptionStack((String)"OpenCrxDomain", (int)1000, (BasicException.Parameter[])new BasicException.Parameter[]{new BasicException.Parameter("object", (Object)path), new BasicException.Parameter("param0", (Object)path.toXRI()), new BasicException.Parameter("param1", (Object)(principal.getIdentity().getSegment(6).toString() + ":" + principal.getIdentity().getLastSegment().toString())), new BasicException.Parameter("param2", (Object)userIdentity.toXRI())})));
                    }
                    ArrayList<String> newOwner = new ArrayList<String>();
                    String owningUser = null;
                    owningUser = !replacementFacade.attributeValuesAsList("owningUser").isEmpty() ? AccessControl_2.this.getQualifiedPrincipalName((Path)replacementFacade.attributeValue("owningUser")) : (objectFacade.attributeValuesAsList("owner").isEmpty() ? (userIdentity == null ? AccessControl_2.this.getQualifiedPrincipalName(replacementFacade.getPath(), "admin") : AccessControl_2.this.getQualifiedPrincipalName(userIdentity)) : (String)objectFacade.attributeValue("owner"));
                    newOwner.add(owningUser);
                    HashSet<String> owningGroup = new HashSet<String>();
                    if (replacementFacade.getAttributeValues("owningGroup") != null) {
                        for (Path group : replacementFacade.attributeValuesAsList("owningGroup")) {
                            if (group == null) continue;
                            owningGroup.add(AccessControl_2.this.getQualifiedPrincipalName(group));
                        }
                    } else if (objectFacade.attributeValuesAsList("owner").size() > 1) {
                        owningGroup.addAll(objectFacade.attributeValuesAsList("owner").subList(1, objectFacade.attributeValuesAsList("owner").size()));
                    }
                    newOwner.addAll(owningGroup);
                    if (!objectFacade.attributeValuesAsList("owner").containsAll(newOwner) || !newOwner.containsAll(objectFacade.attributeValuesAsList("owner"))) {
                        replacementFacade.attributeValuesAsList("owner").clear();
                        replacementFacade.attributeValuesAsList("owner").addAll(newOwner);
                    }
                    replacementFacade.getValue().keySet().remove("owningUser");
                    replacementFacade.getValue().keySet().remove("owningGroup");
                }
                objectCache.remove(path);
                super.update(ispec, request, response);
                AccessControl_2.this.completeReply(response);
                boolean bl = true;
                return bl;
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
            finally {
                if (pm != null) {
                    pm.close();
                }
            }
        }

        protected boolean invoke(RestInteractionSpec ispec, MessageRecord request, MessageRecord response) throws ResourceException {
            PersistenceManager pm = AccessControl_2.this.newDelegatePersistenceManager((RestConnection)this.getConnection());
            DataproviderRequestProcessor p = AccessControl_2.this.newDelegateRequestProcessor((RestConnection)this.getConnection());
            String operationName = request.getTarget().getLastSegment().toString();
            try {
                Path path = request.getResourceIdentifier();
                DefaultRealm realm = AccessControl_2.this.getRealm((RequestRecord)request, this.getPrincipalChain(), pm);
                if ("checkPermissions".equals(operationName)) {
                    String principalName = (String)request.getBody().get((Object)"principalName");
                    CachedPrincipal principal = null;
                    if (principalName != null) {
                        principal = realm.getPrincipal(principalName, pm);
                    }
                    if (principal == null) {
                        throw ResourceExceptions.initHolder((ResourceException)new ResourceException("Requested principal not found.", (Throwable)BasicException.newEmbeddedExceptionStack((String)"OpenCrxDomain", (int)1003, (BasicException.Parameter[])new BasicException.Parameter[]{new BasicException.Parameter("principal", (Object)principalName), new BasicException.Parameter("param0", (Object)principalName), new BasicException.Parameter("param1", (Object)AccessControl_2.this.realmIdentity)})));
                    }
                    Path objectIdentity = path.getPrefix(path.size() - 2);
                    if (objectIdentity.size() >= 5) {
                        Path userIdentity = AccessControl_2.this.getUser(principal);
                        Object_2Facade parentFacade = null;
                        if (objectIdentity.size() >= 7) {
                            ObjectRecord parent = this.getCachedObject(p, path.getPrefix(path.size() - 2));
                            parentFacade = Facades.asObject((MappedRecord)parent);
                        }
                        ObjectRecord object = AccessControl_2.this.retrieveObject(p, objectIdentity, true);
                        Object_2Facade objectFacade = Facades.asObject((MappedRecord)object);
                        response.setBody(AccessControl_2.this.newOperationResult("org:opencrx:kernel:base:CheckPermissionsResult"));
                        MappedRecord responseBody = response.getBody();
                        TreeSet<String> grantedPermissionsAll = new TreeSet<String>();
                        Set<String> grantedPermissions = new TreeSet<String>();
                        boolean hasPermission = realm.hasPermission((RequestRecord)request, objectFacade, parentFacade, principal, userIdentity, SecurityKeys.Action.READ, grantedPermissions, p, pm);
                        for (String permission : grantedPermissions) {
                            grantedPermissionsAll.add(permission + "|" + SecurityKeys.Action.READ.getName());
                        }
                        responseBody.put("grantedPermissionsRead", grantedPermissions);
                        responseBody.put("hasReadPermission", hasPermission);
                        grantedPermissions = new TreeSet();
                        hasPermission = realm.hasPermission((RequestRecord)request, objectFacade, parentFacade, principal, userIdentity, SecurityKeys.Action.DELETE, grantedPermissions, p, pm);
                        for (String permission : grantedPermissions) {
                            grantedPermissionsAll.add(permission + "|" + SecurityKeys.Action.DELETE.getName());
                        }
                        responseBody.put("grantedPermissionsDelete", grantedPermissions);
                        responseBody.put("hasDeletePermission", hasPermission);
                        grantedPermissions = new TreeSet();
                        hasPermission = realm.hasPermission((RequestRecord)request, objectFacade, parentFacade, principal, userIdentity, SecurityKeys.Action.UPDATE, grantedPermissions, p, pm);
                        for (String permission : grantedPermissions) {
                            grantedPermissionsAll.add(permission + "|" + SecurityKeys.Action.UPDATE.getName());
                        }
                        responseBody.put("grantedPermissionsUpdate", grantedPermissions);
                        responseBody.put("hasUpdatePermission", hasPermission);
                        grantedPermissions = realm.getPermissions(principal, userIdentity, objectFacade.attributeValuesAsList("accessLevelBrowse").isEmpty() ? (short)2 : ((Number)objectFacade.attributeValue("accessLevelBrowse")).shortValue(), null, pm);
                        if (grantedPermissions != null) {
                            for (String permission : grantedPermissions) {
                                if (permission.indexOf("|") <= 0) continue;
                                grantedPermissionsAll.add(permission);
                            }
                        }
                        responseBody.put("grantedPermissionsAll", grantedPermissionsAll);
                        boolean bl = true;
                        return bl;
                    }
                    throw ResourceExceptions.initHolder((ResourceException)new ResourceException("Can not invoke checkPermissions on this object", (Throwable)BasicException.newEmbeddedExceptionStack((String)"DefaultDomain", (int)-2, (BasicException.Parameter[])new BasicException.Parameter[]{new BasicException.Parameter("path", (Object)path), new BasicException.Parameter("principal", (Object)principalName), new BasicException.Parameter("param0", (Object)principalName), new BasicException.Parameter("param1", (Object)AccessControl_2.this.realmIdentity)})));
                }
                boolean bl = super.invoke(ispec, request, response);
                return bl;
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
            finally {
                if (pm != null) {
                    pm.close();
                }
            }
        }
    }

    public class CompletingConsumerRecord
    extends DelegatingConsumerRecord {
        private static final long serialVersionUID = 2835765933381645174L;
        private final ConsumerRecord delegate;

        public CompletingConsumerRecord(ConsumerRecord delegate) {
            this.delegate = delegate;
        }

        protected ConsumerRecord getDelegate() {
            return this.delegate;
        }

        public void accept(ObjectRecord object) {
            try {
                AccessControl_2.this.completeObject(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.accept(object);
        }
    }

    public class DefaultRealm {
        protected final Path ACTIVITY_CREATOR_IDENTITY_PATTERN = new Path("xri://@openmdx*org.opencrx.kernel.activity1/provider/:*/segment/:*/activityCreator/:*");
        private final Path realmIdentity;
        private Map<String, CachedPrincipal> cachedPrincipals = new ConcurrentHashMap<String, CachedPrincipal>();
        private boolean isActive = true;
        private long cachedPrincipalsTTL = 120000L;

        public DefaultRealm(Path realmIdentity) throws ResourceException {
            this.realmIdentity = realmIdentity;
            this.isActive = true;
            if (System.getProperty("org.opencrx.security.enable") != null) {
                this.isActive = "true".equals(System.getProperty("org.opencrx.security.enable"));
            }
            if (!this.isActive) {
                System.out.println("WARNING: AccessControl_1 is not active. Activate with system property org.opencrx.security.enable=true. Default is true.");
            }
            if (System.getProperty("org.opencrx.security.realmRefreshRateMillis") != null) {
                this.cachedPrincipalsTTL = Long.valueOf(System.getProperty("org.opencrx.security.realmRefreshRateMillis"));
            }
        }

        protected CachedPrincipal getPrincipal(String principalName, PersistenceManager pm) throws ResourceException {
            return this.getPrincipal(principalName, pm, true);
        }

        protected CachedPrincipal getPrincipal(String principalName, PersistenceManager pm, boolean throwExceptionWhenNotFound) throws ResourceException {
            CachedPrincipal cachedPrincipal;
            if (principalName.indexOf(":") > 0) {
                principalName = principalName.substring(principalName.indexOf(":") + 1);
            }
            if ((cachedPrincipal = this.cachedPrincipals.get(principalName)) == null || System.currentTimeMillis() > cachedPrincipal.getExpiresAt()) {
                if (cachedPrincipal != null) {
                    cachedPrincipal.setExpiresAt(System.currentTimeMillis() + this.cachedPrincipalsTTL);
                }
                org.openmdx.security.realm1.jmi1.Principal principal = null;
                try {
                    principal = (org.openmdx.security.realm1.jmi1.Principal)pm.getObjectById((Object)this.realmIdentity.getDescendant(new String[]{"principal", principalName}));
                    cachedPrincipal = new CachedPrincipal(this, principal, System.currentTimeMillis() + this.cachedPrincipalsTTL);
                    this.cachedPrincipals.put(principalName, cachedPrincipal);
                }
                catch (Exception e) {
                    if (throwExceptionWhenNotFound) {
                        new ServiceException(e).log();
                    }
                    this.cachedPrincipals.remove(principalName);
                }
            }
            if (cachedPrincipal == null && throwExceptionWhenNotFound) {
                SysLog.warning((String)"principal not found", (Object)principalName);
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException("principal not found", (Throwable)BasicException.newEmbeddedExceptionStack((String)"DefaultDomain", (int)-34, (BasicException.Parameter[])new BasicException.Parameter[]{new BasicException.Parameter("realm", (Object)this.realmIdentity), new BasicException.Parameter("principal", (Object)principalName)})));
            }
            return cachedPrincipal;
        }

        public GetRunAsPrincipalResult getRunAsPrincipal(RequestRecord request, List<String> principalChain, DataproviderRequestProcessor p, PersistenceManager pm) throws ResourceException {
            try {
                CachedPrincipal principal = this.getPrincipal(principalChain.get(0), pm);
                Path userIdentity = AccessControl_2.this.getUser(principal);
                HashSet<String> runAsPermissions = new HashSet<String>();
                if (principalChain.size() >= 2 && this.hasPermission(request, null, null, principal, userIdentity, SecurityKeys.Action.RUN_AS, runAsPermissions, p, pm)) {
                    boolean hasRunAsPermission = false;
                    for (String runAsPermission : runAsPermissions) {
                        if (runAsPermission.indexOf("@") > 0) {
                            String runAsPrincipalName = runAsPermission.substring(runAsPermission.indexOf("@") + 1);
                            if (!runAsPrincipalName.equals(principalChain.get(1))) continue;
                            if (hasRunAsPermission) {
                                SysLog.warning((String)"Multiple runAs permissions found. Accepting first only.", Arrays.asList(principalChain, principal, runAsPermissions));
                                continue;
                            }
                            CachedPrincipal runAsPrincipal = this.getPrincipal(runAsPrincipalName, pm);
                            Path runAsUserIdentity = AccessControl_2.this.getUser(runAsPrincipal);
                            SysLog.detail((String)"Applying runAs permission", Arrays.asList(principal, userIdentity, runAsPrincipal, runAsUserIdentity));
                            principal = runAsPrincipal;
                            userIdentity = runAsUserIdentity;
                            hasRunAsPermission = true;
                            continue;
                        }
                        if (runAsPermission.equals(AccessControl_2.ALL_PERMISSION)) continue;
                        SysLog.warning((String)"Invalid format for runAs permission. Accepted format is 'authority@principal'. Ignoring.", Arrays.asList(principal, runAsPermissions));
                    }
                }
                final CachedPrincipal fPrincipal = principal;
                final Path fUserIdentity = userIdentity;
                return new GetRunAsPrincipalResult(){

                    @Override
                    public CachedPrincipal getPrincipal() {
                        return fPrincipal;
                    }

                    @Override
                    public Path getUserIdentity() {
                        return fUserIdentity;
                    }
                };
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
        }

        protected Path getPrimaryGroup(CachedPrincipal principal, PersistenceManager pm) throws ResourceException {
            try {
                if (principal.getPrimaryGroup() == null) {
                    String providerName = principal.getIdentity().getSegment(2).toString();
                    String segmentName = principal.getIdentity().getSegment(principal.getIdentity().size() - 3).toString();
                    String principalId = principal.getIdentity().getLastSegment().toString();
                    UserHome userHome = (UserHome)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.home1").getDescendant(new String[]{"provider", providerName, "segment", segmentName, "userHome", principalId}));
                    PrincipalGroup userGroup = userHome.getPrimaryGroup();
                    String userGroupId = userGroup == null ? null : userGroup.refGetPath().getLastSegment().toString();
                    Path primaryGroup = userGroup == null ? this.getPrincipal(principalId + "." + "Group", pm).getIdentity() : this.getPrincipal(userGroupId, pm).getIdentity();
                    principal.setPrimaryGroup(primaryGroup);
                }
                return principal.getPrimaryGroup();
            }
            catch (Exception e) {
                String principalId = principal.getIdentity().getLastSegment().toString();
                if (!"admin-Root".equals(principalId)) {
                    try {
                        Path primaryGroup = this.getPrincipal(principalId + "." + "Group", pm).getIdentity();
                        principal.setPrimaryGroup(primaryGroup);
                        return primaryGroup;
                    }
                    catch (Exception ignore) {
                        SysLog.warning((String)"No primary group found for principal", (Object)principalId);
                        return null;
                    }
                }
                return null;
            }
        }

        protected SecurityKeys.Action getAccessControlAction(RestInteractionSpec ispec, Object_2Facade object) {
            switch (ispec.getFunction()) {
                case GET: {
                    return SecurityKeys.Action.READ;
                }
                case DELETE: {
                    return SecurityKeys.Action.DELETE;
                }
                case PUT: {
                    if (object.getValue().size() == 2) {
                        if (object.getPath().isLike(this.ACTIVITY_CREATOR_IDENTITY_PATTERN)) {
                            return SecurityKeys.Action.READ;
                        }
                        return SecurityKeys.Action.UPDATE;
                    }
                    return SecurityKeys.Action.UPDATE;
                }
                case POST: {
                    return SecurityKeys.Action.UPDATE;
                }
            }
            return SecurityKeys.Action.UPDATE;
        }

        protected Map<String, CachedPrincipal> getImpliedPrincipals(CachedPrincipal principal, Path userIdentity, short accessLevel, PersistenceManager pm) {
            HashMap<String, CachedPrincipal> impliedPrincipals = new HashMap<String, CachedPrincipal>();
            if (!this.isActive || accessLevel == 4 || principal.getIdentity().getLastSegment().toString().equals("admin-Root")) {
                return null;
            }
            if (accessLevel >= 1) {
                String principalName;
                try {
                    principalName = AccessControl_2.this.getQualifiedPrincipalName(principal.getIdentity());
                    impliedPrincipals.put(principalName, this.getPrincipal(principalName, pm));
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                }
                try {
                    principalName = AccessControl_2.this.getQualifiedPrincipalName(userIdentity);
                    impliedPrincipals.put(principalName, this.getPrincipal(principalName, pm));
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                }
            }
            if (accessLevel == 3 || accessLevel == 2) {
                CachedPrincipal group;
                if (AccessControl_2.this.useExtendedAccessLevelBasic) {
                    try {
                        for (String groupName : principal.getIsMemberOf()) {
                            group = this.getPrincipal(groupName, pm);
                            if (Boolean.TRUE.equals(group.isDisabled())) continue;
                            for (String subGroupName : group.getAllSubgroups(pm)) {
                                impliedPrincipals.put(subGroupName, this.getPrincipal(subGroupName, pm));
                            }
                        }
                    }
                    catch (Exception e) {
                        new ServiceException(e).log();
                    }
                }
                try {
                    for (String groupName : principal.getIsMemberOf()) {
                        group = this.getPrincipal(groupName, pm);
                        if (Boolean.TRUE.equals(group.isDisabled())) continue;
                        for (String superGroupName : group.getAllSupergroups()) {
                            impliedPrincipals.put(superGroupName, this.getPrincipal(superGroupName, pm));
                        }
                    }
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                }
            }
            if (accessLevel == 3) {
                HashMap<String, CachedPrincipal> subGroups = new HashMap<String, CachedPrincipal>();
                for (CachedPrincipal group : impliedPrincipals.values()) {
                    try {
                        for (String subGroupName : group.getAllSubgroups(pm)) {
                            subGroups.put(subGroupName, this.getPrincipal(subGroupName, pm));
                        }
                    }
                    catch (Exception e) {
                        new ServiceException(e).log();
                    }
                }
                impliedPrincipals.putAll(subGroups);
                HashMap<String, CachedPrincipal> superGroups = new HashMap<String, CachedPrincipal>();
                for (CachedPrincipal group : impliedPrincipals.values()) {
                    try {
                        for (String superGroupName : group.getAllSupergroups()) {
                            superGroups.put(superGroupName, this.getPrincipal(superGroupName, pm));
                        }
                    }
                    catch (Exception e) {
                        new ServiceException(e).log();
                    }
                }
                impliedPrincipals.putAll(superGroups);
            }
            return impliedPrincipals;
        }

        protected Set<String> getPermissions(CachedPrincipal principal, Path userIdentity, short accessLevel, SecurityKeys.Action action, PersistenceManager pm) {
            HashSet<String> permissions = null;
            Map<String, CachedPrincipal> impliedPrincipals = this.getImpliedPrincipals(principal, userIdentity, accessLevel, pm);
            if (impliedPrincipals != null) {
                permissions = new HashSet<String>();
                permissions.addAll(impliedPrincipals.keySet());
                for (CachedPrincipal impliedPrincipal : impliedPrincipals.values()) {
                    if (action == null) {
                        permissions.addAll(impliedPrincipal.getPermissions());
                        continue;
                    }
                    permissions.addAll(impliedPrincipal.getPermissions(action.getName()));
                }
            }
            return permissions == null || permissions.contains("Root:Administrators") ? null : permissions;
        }

        public Path getRealmIdentity() {
            return this.realmIdentity;
        }

        public boolean hasPermission(RequestRecord request, Object_2Facade secureObject, Object_2Facade parent, CachedPrincipal principal, Path userIdentity, SecurityKeys.Action action, Set<String> grantedPermissions, DataproviderRequestProcessor p, PersistenceManager pm) throws ResourceException {
            try {
                block36: {
                    block37: {
                        Path path = request.getResourceIdentifier();
                        if (secureObject == null && org.openmdx.base.rest.spi.ObjectRecord.isCompatible((Record)request)) {
                            secureObject = Facades.asObject((MappedRecord)request);
                        }
                        if (action == SecurityKeys.Action.DELETE) {
                            Set<Object> permissions = new HashSet();
                            if (secureObject.attributeValuesAsList("accessLevelDelete").isEmpty()) {
                                SysLog.error((String)"Missing value for attribute 'accessLevelDelete'", (Object)secureObject);
                            } else {
                                permissions = this.getPermissions(principal, userIdentity, ((Number)secureObject.attributeValue("accessLevelDelete")).shortValue(), action, pm);
                            }
                            if (permissions != null) {
                                if (grantedPermissions != null) {
                                    grantedPermissions.addAll(permissions);
                                }
                                permissions.retainAll(secureObject.attributeValuesAsList("owner"));
                                return !permissions.isEmpty();
                            }
                            if (grantedPermissions != null) {
                                grantedPermissions.add(AccessControl_2.ALL_PERMISSION);
                            }
                            return true;
                        }
                        if (action == SecurityKeys.Action.UPDATE) {
                            Set<Object> permissions = new HashSet();
                            if (secureObject.attributeValuesAsList("accessLevelUpdate").isEmpty()) {
                                SysLog.error((String)"Missing value for attribute 'accessLevelUpdate'", (Object)secureObject);
                            } else {
                                permissions = this.getPermissions(principal, userIdentity, ((Number)secureObject.attributeValue("accessLevelUpdate")).shortValue(), action, pm);
                            }
                            if (permissions != null) {
                                if (grantedPermissions != null) {
                                    grantedPermissions.addAll(permissions);
                                }
                                permissions.retainAll(secureObject.attributeValuesAsList("owner"));
                                return !permissions.isEmpty();
                            }
                            if (grantedPermissions != null) {
                                grantedPermissions.add(AccessControl_2.ALL_PERMISSION);
                            }
                            return true;
                        }
                        if (action == SecurityKeys.Action.READ) {
                            Set<Object> permissions = new HashSet();
                            short accessLevelBrowse = parent == null || parent.attributeValuesAsList("accessLevelBrowse").isEmpty() ? ((Number)secureObject.attributeValue("accessLevelBrowse")).shortValue() : ((Number)parent.attributeValue("accessLevelBrowse")).shortValue();
                            permissions = this.getPermissions(principal, userIdentity, accessLevelBrowse, action, pm);
                            if (permissions != null) {
                                if (grantedPermissions != null) {
                                    grantedPermissions.addAll(permissions);
                                }
                                permissions.retainAll(secureObject.attributeValuesAsList("owner"));
                                return !permissions.isEmpty();
                            }
                            if (grantedPermissions != null) {
                                grantedPermissions.add(AccessControl_2.ALL_PERMISSION);
                            }
                            return true;
                        }
                        if (action != SecurityKeys.Action.RUN_AS) break block36;
                        Set<String> permissions = this.getPermissions(principal, userIdentity, (short)0, action, pm);
                        if (permissions == null) break block37;
                        Iterator<String> i = permissions.iterator();
                        while (i.hasNext()) {
                            boolean matches;
                            block39: {
                                String[] groupIdentityComponents;
                                int j;
                                String permission;
                                block38: {
                                    Path pattern;
                                    block40: {
                                        permission = i.next();
                                        matches = false;
                                        if (!permission.startsWith("object:")) break block38;
                                        String[] components = permission.substring(7, permission.indexOf("@")).split("/");
                                        if (components.length <= 0) break block39;
                                        pattern = new Path("xri://@openmdx*" + components[0]).getDescendant(new String[]{"provider", path.getSegment(2).toString(), "segment", path.getSegment(4).toString()});
                                        for (j = 1; j < components.length; ++j) {
                                            pattern = pattern.getDescendant(new String[]{components[j]});
                                        }
                                        if (!path.isLike(pattern)) break block40;
                                        matches = true;
                                        break block39;
                                    }
                                    if (secureObject == null || !secureObject.getPath().startsWith(new Path("xri://@openmdx*org.opencrx.kernel.activity1").getDescendant(new String[]{"provider", path.getSegment(2).toString(), "segment", path.getSegment(4).toString(), "activity"}))) break block39;
                                    Object_2Facade activity = null;
                                    if (path.isLike(new Path("xri://@openmdx*org.opencrx.kernel.activity1").getDescendant(new String[]{"provider", path.getSegment(2).toString(), "segment", path.getSegment(4).toString(), "activity", ":*"}))) {
                                        activity = secureObject;
                                    } else {
                                        try {
                                            activity = Facades.asObject((MappedRecord)AccessControl_2.this.retrieveObject(p, secureObject.getPath().getPrefix(7), false));
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    if (activity != null && activity.attributeValue("lastAppliedCreator") != null && ((Path)activity.attributeValue("lastAppliedCreator")).isLike(pattern)) {
                                        matches = true;
                                    }
                                    break block39;
                                }
                                if (permission.startsWith("groupMembership:") && path.startsWith(new Path("xri://@openmdx*org.opencrx.kernel.activity1").getDescendant(new String[]{"provider", path.getSegment(2).toString(), "segment", path.getSegment(4).toString(), "activity"})) && path.size() >= 7 && (groupIdentityComponents = permission.substring(16, permission.indexOf("@")).split("/")).length > 0) {
                                    Path groupIdentity = new Path("xri://@openmdx*" + groupIdentityComponents[0]).getDescendant(new String[]{"provider", path.getSegment(2).toString(), "segment", path.getSegment(4).toString()});
                                    for (j = 1; j < groupIdentityComponents.length; ++j) {
                                        groupIdentity = groupIdentity.getDescendant(new String[]{groupIdentityComponents[j]});
                                    }
                                    Object_2Facade group = null;
                                    try {
                                        group = Facades.asObject((MappedRecord)AccessControl_2.this.retrieveObject(p, groupIdentity, false));
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    if (group != null) {
                                        Path activityIdentity = path.getPrefix(7);
                                        ResultRecord groupAssignments = AccessControl_2.this.findObjects(p, activityIdentity.getDescendant(new String[]{"assignedGroup"}));
                                        for (Object object : groupAssignments) {
                                            Object_2Facade groupAssignment = null;
                                            try {
                                                groupAssignment = Facades.asObject((MappedRecord)((ObjectRecord)object));
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                            if (groupAssignment == null || !group.getPath().equals(groupAssignment.attributeValue("activityGroup"))) continue;
                                            matches = true;
                                            break;
                                        }
                                    }
                                }
                            }
                            if (matches) continue;
                            i.remove();
                        }
                        if (grantedPermissions != null) {
                            grantedPermissions.addAll(permissions);
                        }
                        return !permissions.isEmpty();
                    }
                    if (grantedPermissions != null) {
                        grantedPermissions.add(AccessControl_2.ALL_PERMISSION);
                    }
                    return true;
                }
                SysLog.error((String)"Unknown action", (Object)action.toString());
                return false;
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void restrictQuery(org.openmdx.base.rest.cci.QueryRecord request, Object_2Facade object, CachedPrincipal principal, Path userIdentity, PersistenceManager pm) throws ServiceException, ResourceException {
            Set<Object> memberships = new HashSet();
            if (object.attributeValuesAsList("accessLevelBrowse").isEmpty()) {
                SysLog.error((String)"Missing attribute value for accessLevelBrowse", (Object)object);
            } else {
                memberships = this.getPermissions(principal, userIdentity, ((Number)object.attributeValue("accessLevelBrowse")).shortValue(), SecurityKeys.Action.READ, pm);
            }
            if (memberships != null) {
                List conditions;
                List list = conditions = request.getQueryFilter() != null && request.getQueryFilter().getCondition() != null ? request.getQueryFilter().getCondition() : Collections.emptyList();
                synchronized (list) {
                    boolean exists = false;
                    for (FilterProperty p : FilterProperty.getFilterProperties((QueryFilterRecord)request.getQueryFilter())) {
                        if (!"owner".equals(p.name()) || !p.values().containsAll(memberships)) continue;
                        exists = true;
                        break;
                    }
                    if (!exists) {
                        if (request.getQueryFilter() == null) {
                            request.setQueryFilter((QueryFilterRecord)Records.getRecordFactory().createMappedRecord(QueryFilterRecord.class));
                        }
                        request.getQueryFilter().getCondition().addAll(FilterProperty.toCondition((FilterProperty[])new FilterProperty[]{new FilterProperty(Quantifier.THERE_EXISTS.code(), "owner", ConditionType.IS_IN.code(), memberships.toArray())}));
                    }
                }
            }
        }
    }

    public class CachedPrincipal {
        private final DefaultRealm realm;
        private long expiresAt;
        private final Path principalIdentity;
        private final Set<String> isMemberOf;
        private final Set<String[]> permissions;
        private Set<String> allSubgroups = null;
        private final Set<String> allSupergroups;
        private Path primaryGroup;
        private Boolean disabled;

        protected void prefetchMemberOfPrincipals(org.openmdx.security.realm1.jmi1.Principal principal) {
            int FETCH_SIZE_LARGE = 1000;
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)principal);
            Collection memberOfIdentities = (Collection)PersistenceHelper.getFeatureReplacingObjectById((Object)principal, (String)"isMemberOf");
            PrincipalQuery principalQuery = (PrincipalQuery)pm.newQuery(org.openmdx.security.realm1.jmi1.Principal.class);
            QueryExtensionRecord queryExtension = PersistenceHelper.newQueryExtension((AnyTypePredicate)principalQuery);
            String clause = "v.object_id IN ('0'";
            String sep = ",";
            for (Path memberOfIdentity : memberOfIdentities) {
                clause = clause + sep + "'principal/" + memberOfIdentity.getSegment(2).toClassicRepresentation() + "/" + memberOfIdentity.getSegment(4).toClassicRepresentation() + "/" + memberOfIdentity.getSegment(6).toClassicRepresentation() + "/" + memberOfIdentity.getLastSegment().toClassicRepresentation() + "'";
                sep = ",";
            }
            clause = clause + ")";
            queryExtension.setClause(clause);
            ((Query)principalQuery).getFetchPlan().setGroup("all");
            ((Query)principalQuery).getFetchPlan().setFetchSize(1000);
            Realm realm = (Realm)pm.getObjectById((Object)principal.refGetPath().getParent().getParent());
            realm.getPrincipal(principalQuery).size();
        }

        protected Set<String[]> getPermissions(org.openmdx.security.realm1.jmi1.Principal principal) {
            HashSet<String[]> permissions = new HashSet<String[]>();
            List roles = principal instanceof Principal ? ((Principal)principal).getGrantedRole() : (principal instanceof PrincipalGroup ? ((PrincipalGroup)principal).getGrantedRole() : Collections.emptyList());
            for (Role role : roles) {
                for (Permission permission : role.getPermission()) {
                    for (String action : permission.getAction()) {
                        permissions.add(new String[]{permission.getName(), action});
                    }
                }
            }
            return permissions;
        }

        public CachedPrincipal(DefaultRealm realm, org.openmdx.security.realm1.jmi1.Principal principal, long expiresAt) {
            this.realm = realm;
            this.principalIdentity = principal.refGetPath();
            this.isMemberOf = new TreeSet<String>();
            this.disabled = principal.isDisabled();
            this.prefetchMemberOfPrincipals(principal);
            List groups = principal.getIsMemberOf();
            Iterator i = groups.iterator();
            while (i.hasNext()) {
                try {
                    Group group = (Group)i.next();
                    if (Boolean.TRUE.equals(group.isDisabled())) continue;
                    this.isMemberOf.add(group.refGetPath().getLastSegment().toString());
                }
                catch (Exception e) {
                    ServiceException e0 = new ServiceException(e, "OpenCrxDomain", -23, "Unable to principal's group membership", new BasicException.Parameter[]{new BasicException.Parameter("principal", (Object)principal.refGetPath())});
                    e0.log();
                }
            }
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)principal);
            HashSet<String> allSupergroups = new HashSet<String>();
            allSupergroups.add(AccessControl_2.this.getQualifiedPrincipalName(principal.refGetPath()));
            HashSet<String[]> permissions = new HashSet<String[]>();
            permissions.addAll(this.getPermissions(principal));
            List supergroups = principal.getIsMemberOf();
            Iterator i2 = supergroups.iterator();
            while (i2.hasNext()) {
                try {
                    Group supergroup = (Group)i2.next();
                    if (Boolean.TRUE.equals(supergroup.isDisabled())) continue;
                    String qualifiedGroupName = AccessControl_2.this.getQualifiedPrincipalName(supergroup.refGetPath());
                    if (!allSupergroups.contains(qualifiedGroupName)) {
                        allSupergroups.addAll(realm.getPrincipal(qualifiedGroupName, pm).getAllSupergroups());
                    }
                    permissions.addAll(this.getPermissions((org.openmdx.security.realm1.jmi1.Principal)supergroup));
                }
                catch (Exception e) {
                    ServiceException e0 = new ServiceException(e, "OpenCrxDomain", -23, "Unable to get principal's group membership", new BasicException.Parameter[]{new BasicException.Parameter("principal", (Object)principal.refGetPath())});
                    e0.log();
                }
            }
            this.permissions = permissions;
            this.allSupergroups = allSupergroups;
            this.expiresAt = expiresAt;
        }

        public Path getIdentity() {
            return this.principalIdentity;
        }

        public DefaultRealm getRealm() {
            return this.realm;
        }

        public void setPrimaryGroup(Path primaryGroup) {
            this.primaryGroup = primaryGroup;
        }

        public Path getPrimaryGroup() {
            return this.primaryGroup;
        }

        public Set<String> getIsMemberOf() {
            return this.isMemberOf;
        }

        public Set<String> getPermissions(String action) {
            HashSet<String> permissions = new HashSet<String>();
            for (String[] permission : this.permissions) {
                if (!action.equals(permission[1])) continue;
                permissions.add(permission[0]);
            }
            return permissions;
        }

        public Set<String> getPermissions() {
            HashSet<String> permissions = new HashSet<String>();
            for (String[] permission : this.permissions) {
                permissions.add(permission[0] + "|" + permission[1]);
            }
            return permissions;
        }

        public long getExpiresAt() {
            return this.expiresAt;
        }

        public void setExpiresAt(long expiresAt) {
            this.expiresAt = expiresAt;
        }

        private List<PrincipalGroup> getSubgroups(PersistenceManager pm) throws ResourceException {
            Realm realm = (Realm)pm.getObjectById((Object)this.realm.getRealmIdentity());
            org.openmdx.security.realm1.jmi1.Principal group = (org.openmdx.security.realm1.jmi1.Principal)pm.getObjectById((Object)this.principalIdentity);
            if (group instanceof PrincipalGroup && Boolean.TRUE.equals(((PrincipalGroup)group).isFinal())) {
                return Collections.emptyList();
            }
            PrincipalGroupQuery query = (PrincipalGroupQuery)pm.newQuery(PrincipalGroup.class);
            query.forAllDisabled().isFalse();
            query.thereExistsIsMemberOf().equalTo((Object)group);
            return realm.getPrincipal((PrincipalQuery)query);
        }

        private Set<String> getAllSubgroups(PersistenceManager pm) throws ResourceException {
            if (this.allSubgroups == null) {
                HashSet<String> allSubgroups = new HashSet<String>();
                allSubgroups.add(AccessControl_2.this.getQualifiedPrincipalName(this.principalIdentity));
                for (PrincipalGroup subgroup : this.getSubgroups(pm)) {
                    CachedPrincipal subGroup;
                    String qualifiedGroupName = AccessControl_2.this.getQualifiedPrincipalName(subgroup.refGetPath());
                    if (allSubgroups.contains(qualifiedGroupName) || Boolean.TRUE.equals((subGroup = this.realm.getPrincipal(qualifiedGroupName, pm)).isDisabled())) continue;
                    allSubgroups.addAll(subGroup.getAllSubgroups(pm));
                }
                this.allSubgroups = allSubgroups;
            }
            return this.allSubgroups;
        }

        public Set<String> getAllSupergroups() {
            return this.allSupergroups;
        }

        public String toString() {
            return this.getIdentity().toString();
        }

        public Boolean isDisabled() {
            return this.disabled;
        }
    }

    static interface GetRunAsPrincipalResult {
        public CachedPrincipal getPrincipal();

        public Path getUserIdentity();
    }
}

