/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.layer.persistence;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.resource.ResourceException;
import javax.resource.cci.Interaction;
import javax.resource.cci.MappedRecord;
import org.opencrx.kernel.backend.Base;
import org.opencrx.kernel.layer.persistence.Media_2;
import org.openmdx.application.dataprovider.cci.AttributeSpecifier;
import org.openmdx.application.dataprovider.cci.FilterProperty;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.openmdx.base.query.ConditionType;
import org.openmdx.base.query.IsInCondition;
import org.openmdx.base.query.Quantifier;
import org.openmdx.base.query.SortOrder;
import org.openmdx.base.resource.Records;
import org.openmdx.base.resource.spi.ResourceExceptions;
import org.openmdx.base.resource.spi.RestInteractionSpec;
import org.openmdx.base.rest.cci.MessageRecord;
import org.openmdx.base.rest.cci.ObjectRecord;
import org.openmdx.base.rest.cci.QueryFilterRecord;
import org.openmdx.base.rest.cci.RestConnection;
import org.openmdx.base.rest.cci.ResultRecord;
import org.openmdx.base.rest.spi.Facades;
import org.openmdx.base.rest.spi.FeatureOrderRecord;
import org.openmdx.base.rest.spi.Object_2Facade;
import org.openmdx.base.rest.spi.QueryRecord;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.id.UUIDs;
import org.openmdx.kernel.log.SysLog;

public class Indexed_2
extends Media_2 {
    public static final int STANDARD_KEYWORD_LENGTH_MIN = 3;
    public static final int STANDARD_KEYWORD_LENGTH_MAX = 40;
    protected static final int BATCH_SIZE = 50;
    protected static List<Path> indexableTypes;
    protected Map<Path, Date> syncKeys = new ConcurrentHashMap<Path, Date>();
    protected static final Set<String> STANDARD_INDEXED_ATTRIBUTES;

    public Indexed_2() {
        try {
            if (indexableTypes == null) {
                indexableTypes = Base.getInstance().getIndexableTypes();
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
        }
    }

    @Override
    public Interaction getInteraction(RestConnection connection) throws ResourceException {
        return new RestInteraction(this, connection);
    }

    protected org.openmdx.base.rest.cci.QueryRecord newQuery(Path resourceIdentifier, FilterProperty[] filterProperties, AttributeSpecifier[] attributeSpecifiers) throws ResourceException {
        QueryRecord query = new QueryRecord();
        query.setResourceIdentifier(resourceIdentifier);
        query.setQueryFilter((QueryFilterRecord)Records.getRecordFactory().createMappedRecord(QueryFilterRecord.class));
        if (filterProperties != null) {
            query.getQueryFilter().getCondition().addAll(FilterProperty.toCondition((FilterProperty[])filterProperties));
        }
        if (attributeSpecifiers != null) {
            query.getQueryFilter().getOrderSpecifier().addAll(AttributeSpecifier.toOrderSpecifier((AttributeSpecifier[])attributeSpecifiers));
        }
        return query;
    }

    static {
        STANDARD_INDEXED_ATTRIBUTES = new HashSet<String>(Arrays.asList("name", "description", "detailedDescription", "aliasName", "fullName", "postalAddressLine", "postalStreet", "postalCity", "postalCode", "emailAddress", "webUrl", "phoneNumberFull", "text", "content", "contractNumber", "activityNumber", "externalLink"));
    }

    public class RestInteraction
    extends Media_2.RestInteraction {
        public RestInteraction(Indexed_2 indexed, RestConnection connection) throws ResourceException {
            super(indexed, connection);
        }

        @Override
        public ObjectRecord retrieveObject(Path resourceIdentifier, String fetchGroupName) throws ResourceException {
            ResultRecord result = this.newResult();
            org.openmdx.base.rest.cci.QueryRecord query = this.newQuery(resourceIdentifier);
            query.setFetchGroupName(fetchGroupName);
            super.get(Indexed_2.this.SUPER.GET, query, result);
            return result.isEmpty() ? null : (ObjectRecord)result.get(0);
        }

        private void updateIndexEntry(RestInteractionSpec ispec, ObjectRecord indexed, Integer keywordLengthMin, Integer keywordLengthMax, Set<String> indexedAttributes) throws ServiceException {
            try {
                Base.RestInteractionCallback restInteractionCallback = new Base.RestInteractionCallback(){

                    @Override
                    public void get(org.openmdx.base.rest.cci.QueryRecord query, ResultRecord result) throws ResourceException {
                        RestInteraction.super.get(Indexed_2.this.SUPER.GET, query, result);
                    }

                    @Override
                    public void find(org.openmdx.base.rest.cci.QueryRecord query, ResultRecord result) throws ResourceException {
                        RestInteraction.super.find(Indexed_2.this.SUPER.GET, query, result);
                    }

                    @Override
                    public void create(ObjectRecord query, ResultRecord result) throws ResourceException {
                        RestInteraction.super.create(Indexed_2.this.SUPER.CREATE, query, result);
                    }

                    @Override
                    public void update(ObjectRecord object, ResultRecord result) throws ResourceException {
                        RestInteraction.super.update(Indexed_2.this.SUPER.UPDATE, object, result);
                    }
                };
                Path indexedPath = Object_2Facade.getPath((MappedRecord)indexed);
                Object_2Facade indexedFacade = Object_2Facade.newInstance((MappedRecord)indexed);
                ObjectRecord indexEntry = Object_2Facade.newInstance((Path)Object_2Facade.getPath((MappedRecord)indexed).getPrefix(5).getDescendant(new String[]{"indexEntry", UUIDs.newUUID().toString()}), (String)"org:opencrx:kernel:base:IndexEntry").getDelegate();
                Object_2Facade indexEntryFacade = Object_2Facade.newInstance((MappedRecord)indexEntry);
                indexEntryFacade.attributeValuesAsList("indexedObject").add(indexedPath);
                List<String> keywords = Base.getInstance().getKeywords((MappedRecord)indexed, keywordLengthMin, keywordLengthMax, indexedAttributes, restInteractionCallback);
                indexEntryFacade.attributeValuesAsList("keywords").add(keywords.toString());
                indexEntryFacade.attributeValuesAsList("modifiedAt").addAll(indexedFacade.attributeValuesAsList("modifiedAt"));
                indexEntryFacade.attributeValuesAsList("modifiedBy").addAll(indexedFacade.attributeValuesAsList("modifiedBy"));
                indexEntryFacade.attributeValuesAsList("createdAt").addAll(indexedFacade.attributeValuesAsList("modifiedAt"));
                indexEntryFacade.attributeValuesAsList("createdBy").addAll(indexedFacade.attributeValuesAsList("modifiedBy"));
                indexEntryFacade.attributeValuesAsList("owner").addAll(indexedFacade.attributeValuesAsList("owner"));
                indexEntryFacade.attributeValuesAsList("accessLevelBrowse").addAll(indexedFacade.attributeValuesAsList("accessLevelBrowse"));
                indexEntryFacade.attributeValuesAsList("accessLevelUpdate").add(new Short(0));
                indexEntryFacade.attributeValuesAsList("accessLevelDelete").add(new Short(0));
                Base.getInstance().updateIndexEntry(restInteractionCallback, indexEntry);
            }
            catch (ResourceException e) {
                throw new ServiceException((Exception)((Object)e));
            }
        }

        @Override
        public boolean get(RestInteractionSpec ispec, org.openmdx.base.rest.cci.QueryRecord request, ResultRecord response) throws ResourceException {
            Path path = request.getResourceIdentifier();
            Path reference = path.getParent();
            if ("indexEntry".equals(reference.getLastSegment().toString())) {
                ObjectRecord indexEntry = this.retrieveObject(path.getPrefix(5).getDescendant(new String[]{"indexEntry", path.getLastSegment().toString()}), "all");
                if (indexEntry != null) {
                    Object_2Facade indexEntryFacade = Object_2Facade.newInstance((MappedRecord)indexEntry);
                    Object_2Facade mappedIndexEntryFacade = Object_2Facade.newInstance((Path)path, (String)indexEntryFacade.getObjectClass());
                    mappedIndexEntryFacade.getValue().putAll((Map)indexEntryFacade.getValue());
                    response.add((Object)mappedIndexEntryFacade.getDelegate());
                    return true;
                }
                return false;
            }
            super.get(ispec, request, response);
            return true;
        }

        protected ResultRecord findIndexEntries(Path objectIdentity, org.openmdx.base.rest.cci.QueryRecord query) throws ServiceException {
            try {
                org.openmdx.base.rest.cci.QueryRecord findRequest = query == null ? (org.openmdx.base.rest.cci.QueryRecord)Records.getRecordFactory().createMappedRecord(org.openmdx.base.rest.cci.QueryRecord.class) : query.clone();
                findRequest.setResourceIdentifier(objectIdentity.getPrefix(5).getChild("indexEntry"));
                if (findRequest.getQueryFilter() == null) {
                    findRequest.setQueryFilter((QueryFilterRecord)Records.getRecordFactory().createMappedRecord(QueryFilterRecord.class));
                }
                findRequest.getQueryFilter().getCondition().add(new IsInCondition(Quantifier.THERE_EXISTS, "indexedObject", true, new Object[]{objectIdentity}));
                findRequest.getQueryFilter().getOrderSpecifier().add(new FeatureOrderRecord("createdAt", SortOrder.DESCENDING));
                ResultRecord findResult = this.newResult();
                super.find(Indexed_2.this.SUPER.GET, findRequest, findResult);
                return findResult;
            }
            catch (ResourceException e) {
                throw new ServiceException((Exception)((Object)e));
            }
        }

        @Override
        public boolean delete(RestInteractionSpec ispec, ObjectRecord request) throws ResourceException {
            Path path = request.getResourceIdentifier();
            try {
                if (path.size() > 5) {
                    ResultRecord indexEntries = this.findIndexEntries(path, null);
                    for (Object entry : indexEntries) {
                        super.delete(Indexed_2.this.SUPER.DELETE, (ObjectRecord)entry);
                    }
                }
                return super.delete(ispec, request);
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
        }

        public boolean invoke(RestInteractionSpec ispec, MessageRecord request, MessageRecord response) throws ResourceException {
            String operationName = request.getTarget().getLastSegment().toString();
            Path path = request.getResourceIdentifier();
            try {
                if ("updateIndex".equals(operationName)) {
                    List indexedAttributesExclude;
                    Integer keywordLengthMin = (Integer)request.getBody().get((Object)"keywordLengthMin");
                    keywordLengthMin = keywordLengthMin == null ? 3 : keywordLengthMin;
                    Integer keywordLengthMax = (Integer)request.getBody().get((Object)"keywordLengthMax");
                    keywordLengthMax = keywordLengthMax == null ? 40 : keywordLengthMax;
                    HashSet<String> indexedAttributes = new HashSet<String>(STANDARD_INDEXED_ATTRIBUTES);
                    List indexedAttributesInclude = (List)request.getBody().get((Object)"indexedAttributesInclude");
                    if (indexedAttributesInclude != null) {
                        indexedAttributes.addAll(indexedAttributesInclude);
                    }
                    if ((indexedAttributesExclude = (List)request.getBody().get((Object)"indexedAttributesExclude")) != null) {
                        indexedAttributes.removeAll(indexedAttributesExclude);
                    }
                    Path indexedIdentity = path.getPrefix(path.size() - 2);
                    int numberOfIndexedObjects = 0;
                    if (indexedIdentity.size() == 5) {
                        for (Path type : indexableTypes) {
                            if (!":*".equals(type.getSegment(0).toString()) && !type.getSegment(0).toString().equals(indexedIdentity.getSegment(0).toString())) continue;
                            Path concreteType = new Path("");
                            for (int i = 0; i < type.size(); ++i) {
                                concreteType = i == 0 || i == 2 || i == 4 ? concreteType.getChild(indexedIdentity.getSegment(i).toString()) : concreteType.getChild(type.getSegment(i).toString());
                            }
                            String queryFilterContext = "context:" + UUIDs.newUUID().toString() + ":";
                            Date syncKey = Indexed_2.this.syncKeys.get(concreteType);
                            if (syncKey == null) {
                                syncKey = new Date(0L);
                            }
                            org.openmdx.base.rest.cci.QueryRecord findRequest = Indexed_2.this.newQuery(indexedIdentity.getChild("extent"), new FilterProperty[]{new FilterProperty(Quantifier.THERE_EXISTS.code(), "identity", ConditionType.IS_LIKE.code(), new Object[]{concreteType.toXRI()}), new FilterProperty(Quantifier.THERE_EXISTS.code(), "modifiedAt", ConditionType.IS_GREATER_OR_EQUAL.code(), new Object[]{syncKey}), new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "clause", ConditionType.codeOf(null), new Object[]{"/*!COLUMNS  v.object_id, v.dtype */ NOT EXISTS (SELECT 0 FROM OOCKE1_INDEXENTRY e WHERE v.object_id = e.indexed_object AND v.modified_at <= e.created_at)"}), new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "object_class", ConditionType.codeOf(null), new Object[]{"org:openmdx:compatibility:datastore1:QueryFilter"})}, new AttributeSpecifier[]{new AttributeSpecifier("modifiedAt", SortOrder.ASCENDING.code())});
                            ResultRecord findResult = null;
                            findResult = this.newResult();
                            super.find(Indexed_2.this.SUPER.GET, findRequest, findResult);
                            Date newSyncKey = syncKey;
                            for (Object object : findResult) {
                                try {
                                    Path objectToBeIndexedPath = Object_2Facade.getPath((MappedRecord)((ObjectRecord)object));
                                    ObjectRecord indexed = this.retrieveObject(objectToBeIndexedPath, "all");
                                    if (indexed == null) continue;
                                    this.updateIndexEntry(ispec, indexed, keywordLengthMin, keywordLengthMax, indexedAttributes);
                                    newSyncKey = (Date)Facades.asObject((MappedRecord)indexed).attributeValue("modifiedAt");
                                    ++numberOfIndexedObjects;
                                }
                                catch (Exception e) {
                                    SysLog.log((Level)Level.WARNING, (String)"Unable to index {0}. The reason is {1}. See log at level detail for more info.", (Object[])new Object[]{object, e.getMessage()});
                                    SysLog.detail((String)e.getMessage(), (Throwable)e.getCause());
                                }
                            }
                            Indexed_2.this.syncKeys.put(concreteType, newSyncKey);
                        }
                    } else {
                        ObjectRecord indexed = this.retrieveObject(indexedIdentity, "all");
                        if (indexed != null) {
                            this.updateIndexEntry(ispec, indexed, keywordLengthMin, keywordLengthMax, indexedAttributes);
                            ++numberOfIndexedObjects;
                        }
                    }
                    response.setBody(this.newOperationResult("org:opencrx:kernel:base:UpdateIndexResult"));
                    response.getBody().put((Object)"numberOfIndexedObjects", (Object)new Integer(numberOfIndexedObjects));
                    return true;
                }
                return super.invoke(ispec, request, response);
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
        }
    }
}

