/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.portal;

import javax.jmi.reflect.RefObject;
import org.opencrx.kernel.base.jmi1.Note;
import org.openmdx.base.text.conversion.HtmlEncoder;
import org.openmdx.portal.servlet.ApplicationContext;
import org.openmdx.portal.servlet.DefaultDataBinding;

public class FormattedNoteDataBinding
extends DefaultDataBinding {
    public Object getValue(RefObject object, String qualifiedFeatureName, ApplicationContext app) {
        if (object instanceof Note) {
            Note note = (Note)object;
            String title = note.getTitle();
            String text = note.getText();
            if (title == null || title.length() == 0) {
                return text;
            }
            int titleLength = title.length();
            int indexBol = 0;
            int indexEol = 0;
            boolean containsWiki = false;
            boolean containsHtml = false;
            if (text != null) {
                while ((indexEol = text.indexOf(10, indexBol)) > 0) {
                    titleLength = Math.max(titleLength, indexEol - indexBol);
                    indexBol = indexEol + 1;
                }
                containsWiki = HtmlEncoder.containsWiki((String)text);
                containsHtml = HtmlEncoder.containsHtml((String)text);
            }
            titleLength = Math.min(140, titleLength);
            StringBuilder formattedText = new StringBuilder(containsWiki ? "*" : "<b>");
            formattedText.append(title.replace(" ", "&nbsp;"));
            boolean isFirst = true;
            for (int i = title.length(); i < titleLength; ++i) {
                if (isFirst) {
                    formattedText.append(" ");
                }
                formattedText.append("&nbsp;");
                isFirst = false;
            }
            formattedText.append(containsWiki ? "*\\\\ " : "</b><br />").append(text == null ? "" : (containsWiki || containsHtml ? text : text.replaceAll("\n", "<br />")));
            return formattedText.toString();
        }
        return null;
    }
}

