/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.opencrx.kernel.tools.FastResultSet;
import org.opencrx.kernel.utils.DbSchemaUtils;
import org.openmdx.application.configuration.LegacyConfiguration;
import org.openmdx.base.dataprovider.layer.persistence.jdbc.Database_2;
import org.openmdx.base.dataprovider.layer.persistence.jdbc.Database_2Configuration;
import org.openmdx.base.exception.ServiceException;

public class DbSearchReplace {
    static final List<String> DBOBJECTS_KERNEL = new ArrayList<String>();
    static final List<String> DBOBJECTS_SECURITY = new ArrayList<String>();

    private static String getStringFromClob(Clob clob) throws IOException, SQLException {
        int c;
        Reader reader = clob.getCharacterStream();
        StringBuilder s = new StringBuilder();
        while ((c = reader.read()) != -1) {
            s.append((char)c);
        }
        return s.toString();
    }

    private static String mapColumnName(Connection conn, String dbObject, String columnName) throws SQLException {
        String databaseProductName = conn.getMetaData().getDatabaseProductName();
        if ("HSQL Database Engine".equals(databaseProductName)) {
            String mappedColumnName = columnName.toUpperCase();
            if ("POSITION".equals(mappedColumnName) || mappedColumnName.indexOf("$") > 0) {
                return "\"" + mappedColumnName + "\"";
            }
            return mappedColumnName;
        }
        return columnName.toUpperCase();
    }

    private static void searchReplaceDbObject(String dbObject, boolean useSuffix, Connection conn, String columnNameIncludes, String columnNameExcludes, String searchPattern, String replacement, boolean validateOnly, PrintStream out) throws SQLException {
        String currentStatement = null;
        Database_2 db = new Database_2();
        try {
            LegacyConfiguration configuration = new LegacyConfiguration();
            configuration.values("booleanType").put((Object)0, (Object)"STANDARD");
            configuration.values("datasource");
            Database_2Configuration.activate((Database_2)db, (LegacyConfiguration)configuration);
        }
        catch (Exception e) {
            out.println("Can not activate database plugin: " + e.getMessage());
        }
        try {
            currentStatement = "SELECT * FROM " + dbObject + (useSuffix ? "_" : "");
            PreparedStatement s = conn.prepareStatement(currentStatement);
            ResultSet rs = s.executeQuery();
            if (rs != null) {
                ResultSetMetaData rsm = rs.getMetaData();
                FastResultSet frs = new FastResultSet(rs);
                int nRows = 0;
                while (frs.next()) {
                    String statement = "UPDATE " + dbObject + (useSuffix ? "_" : "") + " SET ";
                    ArrayList<Object> statementParameters = new ArrayList<Object>();
                    for (int j = 0; j < rsm.getColumnCount(); ++j) {
                        String replacedValue;
                        String columnName = rsm.getColumnName(j + 1);
                        boolean includeColumn = true;
                        if (columnNameIncludes != null) {
                            includeColumn = Pattern.matches(columnNameIncludes, columnName.toUpperCase());
                        }
                        if (columnNameExcludes != null) {
                            includeColumn &= !Pattern.matches(columnNameExcludes, columnName.toUpperCase());
                        }
                        if (!includeColumn || frs.getObject(columnName) == null) continue;
                        String value = null;
                        if (frs.getObject(columnName) instanceof Clob) {
                            try {
                                value = DbSearchReplace.getStringFromClob((Clob)frs.getObject(columnName));
                            }
                            catch (Exception e) {
                                out.println("Reading Clob failed. Reason: " + e.getMessage());
                                out.println("Statement=" + statement);
                                out.println("Parameters=" + statementParameters);
                            }
                        } else if (frs.getObject(columnName) instanceof String) {
                            value = (String)frs.getObject(columnName);
                        }
                        if (value == null || value.equals(replacedValue = value.replaceAll(searchPattern, replacement))) continue;
                        String mappedColumnName = DbSearchReplace.mapColumnName(conn, dbObject, columnName);
                        statement = statement + (statementParameters.isEmpty() ? "" : ",") + mappedColumnName + " = ?";
                        statementParameters.add(replacedValue);
                    }
                    if (!statementParameters.isEmpty()) {
                        statement = statement + " WHERE OBJECT_ID = ?";
                        statementParameters.add(frs.getObject("OBJECT_ID"));
                        if (useSuffix) {
                            statement = statement + " AND IDX = ?";
                            statementParameters.add(frs.getObject("IDX"));
                        }
                        try {
                            out.println("Statement=" + statement);
                            out.println("Parameters=" + statementParameters);
                            out.println();
                            if (!validateOnly) {
                                currentStatement = statement;
                                PreparedStatement t = conn.prepareStatement(currentStatement);
                                for (int j = 0; j < statementParameters.size(); ++j) {
                                    Object parameter = statementParameters.get(j);
                                    db.setPreparedStatementValue(conn, t, j + 1, parameter);
                                }
                                t.executeUpdate();
                                t.close();
                            }
                        }
                        catch (Exception e) {
                            new ServiceException(e).log();
                            out.println("Update failed. Reason: " + e.getMessage());
                        }
                    }
                    if (++nRows % 1000 != 0) continue;
                    out.println(nRows + " rows processed");
                }
                rs.close();
            } else {
                out.println("Unable to process table (result set is null). Statement: " + currentStatement);
            }
            s.close();
        }
        catch (Exception e) {
            new ServiceException(e).log();
            out.println("Unable to process table (see log for more info). Statement: " + currentStatement);
        }
    }

    private static void searchReplaceNamespace(Connection conn, List<String> dbObjects, String columnNameIncludes, String columnNameExcludes, String searchPattern, String replacement, boolean validateOnly, PrintStream out) {
        String currentStatement = null;
        try {
            out.println("Processing tables:");
            int ii = 0;
            for (String dbObject : dbObjects) {
                out.println(ii + ": " + dbObject);
                ++ii;
            }
            HashSet<String> processedDbObjects = new HashSet<String>();
            for (int i = 0; i < dbObjects.size(); ++i) {
                String dbObject = dbObjects.get(i);
                if (dbObject == null || dbObject.isEmpty() || processedDbObjects.contains(dbObject)) continue;
                out.println("Processing table " + i + ": " + dbObject);
                DbSearchReplace.searchReplaceDbObject(dbObject, false, conn, columnNameIncludes, columnNameExcludes, searchPattern, replacement, validateOnly, out);
                out.println("Processing table " + i + ": " + dbObject + "_");
                DbSearchReplace.searchReplaceDbObject(dbObject, true, conn, columnNameIncludes, columnNameExcludes, searchPattern, replacement, validateOnly, out);
                processedDbObjects.add(dbObject);
            }
        }
        catch (SQLException e) {
            ServiceException e0 = new ServiceException((Exception)e);
            e0.log();
            out.println("Statement: " + currentStatement + " (message=" + e0.getMessage());
        }
    }

    public static void dbSearchReplace(Connection conn, String tableNameIncludes, String tableNameExcludes, String columnNameIncludes, String columnNameExcludes, String searchPattern, String replacement, boolean validateOnly, PrintStream out) throws ServiceException {
        String tableName;
        DBOBJECTS_KERNEL.clear();
        DBOBJECTS_SECURITY.clear();
        List<Object> tableNames = new ArrayList();
        try {
            tableNames = DbSchemaUtils.getTableNames();
        }
        catch (Exception e) {
            new ServiceException(e).log();
        }
        for (String string : tableNames) {
            if (string.indexOf("_TOBJ_") >= 0 || string.indexOf("_JOIN_") >= 0 || string.endsWith("_")) continue;
            if (string.startsWith("OOCKE1_")) {
                DBOBJECTS_KERNEL.add(string);
                continue;
            }
            if (!string.startsWith("OOMSE2_")) continue;
            DBOBJECTS_SECURITY.add(string);
        }
        Iterator<String> i = DBOBJECTS_KERNEL.iterator();
        while (i.hasNext()) {
            tableName = i.next();
            boolean bl = true;
            if (tableNameIncludes != null) {
                bl = Pattern.matches(tableNameIncludes, tableName.toUpperCase());
            }
            if (tableNameExcludes != null) {
                bl &= !Pattern.matches(tableNameExcludes, tableName.toUpperCase());
            }
            if (bl) continue;
            i.remove();
        }
        i = DBOBJECTS_SECURITY.iterator();
        while (i.hasNext()) {
            tableName = i.next();
            boolean bl = true;
            if (tableNameIncludes != null) {
                bl = Pattern.matches(tableNameIncludes, tableName.toUpperCase());
            }
            if (tableNameExcludes != null) {
                bl &= !Pattern.matches(tableNameExcludes, tableName.toUpperCase());
            }
            if (bl) continue;
            i.remove();
        }
        try {
            DbSearchReplace.searchReplaceNamespace(conn, DBOBJECTS_KERNEL, columnNameIncludes, columnNameExcludes, searchPattern, replacement, validateOnly, out);
            DbSearchReplace.searchReplaceNamespace(conn, DBOBJECTS_SECURITY, columnNameIncludes, columnNameExcludes, searchPattern, replacement, validateOnly, out);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        out.println();
        out.println("!!! DONE !!!");
    }
}

