/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opencrx.kernel.utils.DbSchemaUtils;
import org.openmdx.base.dataprovider.layer.persistence.jdbc.Database_2;
import org.openmdx.base.dataprovider.layer.persistence.jdbc.dbobject.DbObject;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.mof.cci.ModelElement_1_0;
import org.openmdx.base.mof.cci.ModelHelper;
import org.openmdx.base.mof.cci.Model_1_0;
import org.openmdx.base.mof.spi.Model_1Factory;
import org.openmdx.base.naming.Path;
import org.openmdx.base.text.conversion.JavaBeans;
import org.openmdx.kernel.exception.BasicException;

public abstract class QueryBuilderUtil {

    public static class OwnerPredicate
    extends FeaturePredicate {
        protected Condition condition;
        protected Predicate predicate;

        public OwnerPredicate() {
        }

        public OwnerPredicate(String id, String description) {
            super(id, description, "org:opencrx:kernel:base:SecureObject:owner");
        }

        public OwnerPredicate(String id, String description, Condition condition, Predicate predicate) {
            super(id, description, "org:opencrx:kernel:base:SecureObject:owner");
            this.condition = condition;
            this.predicate = predicate;
        }

        @Override
        public Predicate findPredicate(String id) {
            Predicate f = super.findPredicate(id);
            return f == null ? (this.predicate == null ? null : this.predicate.findPredicate(id)) : f;
        }

        public Predicate getPredicate() {
            return this.predicate;
        }

        public void setPredicate(Predicate predicate) {
            this.predicate = predicate;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public void setCondition(Condition condition) {
            this.condition = condition;
        }

        @Override
        public String toSql(String indent, Path accessPath, String tableAlias) throws ServiceException {
            DbObject dbObject = this.getDbObject(accessPath);
            String tableName_ = dbObject.getConfiguration().getDbObjectForUpdate2() == null ? dbObject.getConfiguration().getDbObjectForQuery2() : dbObject.getConfiguration().getDbObjectForUpdate2();
            Path principalsAccessPath = new Path("xri://@openmdx*org.openmdx.security.realm1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "realm", ":*", "principal", ":*"});
            DbObject dbObjectPrincipals = this.getDbObject(principalsAccessPath);
            String tableNamePrincipals = dbObjectPrincipals.getConfiguration().getDbObjectForUpdate1() == null ? dbObjectPrincipals.getConfiguration().getDbObjectForQuery1() : dbObjectPrincipals.getConfiguration().getDbObjectForUpdate1();
            String clause = "";
            if (this.getDescription() != null) {
                clause = clause + indent + "/* " + this.getDescription() + " */\n";
            }
            switch (this.condition) {
                case EXISTS: {
                    clause = clause + indent + "EXISTS (\n";
                    break;
                }
                case NOT_EXISTS: {
                    clause = clause + indent + "NOT EXISTS (\n";
                }
            }
            clause = clause + indent + "    " + "SELECT 0 FROM " + tableNamePrincipals + " " + tableAlias + "v\n" + indent + "    " + "INNER JOIN\n" + indent + "    " + "    " + tableName_ + " " + tableAlias + "_\n" + indent + "    " + "ON\n" + indent + "    " + "    " + tableAlias + "v.object_id LIKE ('principal/%/Root/' || REPLACE(" + tableAlias + "_.owner, ':', '/'))\n" + indent + "    " + "WHERE\n" + indent + "    " + "    " + tableAlias + "_.object_id = " + tableAlias + ".object_id AND\n";
            clause = clause + this.predicate.toSql(indent + "    " + "    ", principalsAccessPath.getParent(), tableAlias + "v");
            clause = clause + "\n";
            clause = clause + indent + ")";
            return clause;
        }

        public static enum Condition {
            EXISTS,
            NOT_EXISTS;

        }
    }

    public static class SelfJoinPredicate
    extends SingleValuedAttributePredicate {
        protected SingleValuedAttributePredicate.Condition condition;
        protected Predicate predicate;
        protected String havingClause;

        public SelfJoinPredicate() {
        }

        public SelfJoinPredicate(String id, String description, String qualifiedFeatureName) {
            super(id, description, qualifiedFeatureName);
        }

        public SelfJoinPredicate(String id, String description, String qualifiedFeatureName, SingleValuedAttributePredicate.Condition condition, Predicate predicate) {
            super(id, description, qualifiedFeatureName);
            this.condition = condition;
            this.predicate = predicate;
        }

        @Override
        public Predicate findPredicate(String id) {
            Predicate f = super.findPredicate(id);
            return f == null ? (this.predicate == null ? null : this.predicate.findPredicate(id)) : f;
        }

        public Predicate getPredicate() {
            return this.predicate;
        }

        public void setPredicate(Predicate predicate) {
            this.predicate = predicate;
        }

        public String getHavingClause() {
            return this.havingClause;
        }

        public SelfJoinPredicate setHavingClause(String havingClause) {
            this.havingClause = havingClause;
            return this;
        }

        @Override
        public String toSql(String indent, Path accessPath, String tableAlias) throws ServiceException {
            String clause = "";
            if (this.getDescription() != null) {
                clause = clause + indent + "/* " + this.getDescription() + " */\n";
            }
            String columnName = this.getColumnName();
            clause = clause + indent + tableAlias + "." + columnName + " " + this.conditionToSqlOperator(this.condition) + " (\n";
            clause = clause + indent + "    " + "SELECT DISTINCT(" + tableAlias + "v." + columnName + ") FROM ";
            DbObject dbObject = this.getDbObject(accessPath);
            String tableName = dbObject.getConfiguration().getDbObjectForUpdate1() == null ? dbObject.getConfiguration().getDbObjectForQuery1() : dbObject.getConfiguration().getDbObjectForUpdate1();
            clause = clause + tableName + " " + tableAlias + "v WHERE\n";
            clause = clause + this.predicate.toSql(indent + "    " + "    ", accessPath.getParent(), tableAlias + "v");
            clause = clause + "\n";
            if (this.havingClause != null) {
                clause = clause + indent + "    " + "GROUP BY (" + tableAlias + "v." + columnName + ") HAVING " + this.havingClause + "\n";
            }
            clause = clause + indent + ")";
            return clause;
        }
    }

    public static class CompositeParentPredicate
    extends FeaturePredicate {
        protected Condition condition;
        protected Predicate predicate;
        protected String havingClause;

        public CompositeParentPredicate() {
        }

        public CompositeParentPredicate(String id, String description) {
            super(id, description, null);
        }

        public CompositeParentPredicate(String id, String description, Condition condition, Predicate predicate) {
            super(id, description, null);
            this.condition = condition;
            this.predicate = predicate;
        }

        @Override
        public Predicate findPredicate(String id) {
            Predicate f = super.findPredicate(id);
            return f == null ? (this.predicate == null ? null : this.predicate.findPredicate(id)) : f;
        }

        public Predicate getPredicate() {
            return this.predicate;
        }

        public void setPredicate(Predicate predicate) {
            this.predicate = predicate;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public void setCondition(Condition condition) {
            this.condition = condition;
        }

        public String getHavingClause() {
            return this.havingClause;
        }

        public CompositeParentPredicate setHavingClause(String havingClause) {
            this.havingClause = havingClause;
            return this;
        }

        @Override
        public String toSql(String indent, Path accessPath, String tableAlias) throws ServiceException {
            Model_1_0 model = Model_1Factory.getModel();
            String clause = "";
            if (this.getDescription() != null) {
                clause = clause + indent + "/* " + this.getDescription() + " */\n";
            }
            switch (this.condition) {
                case EXISTS: {
                    clause = clause + indent + "EXISTS (\n";
                    break;
                }
                case NOT_EXISTS: {
                    clause = clause + indent + "NOT EXISTS (\n";
                }
            }
            clause = clause + indent + "    " + "SELECT 0 FROM ";
            Path referencedTypeAccessPath = model.getIdentityPattern(model.getElement((Object)model.getReferenceType(accessPath).getType())).getParent().getParent();
            DbObject referencedDbObject = this.getDbObject(referencedTypeAccessPath);
            String joinClause = "WHERE\n" + indent + "    " + "    " + tableAlias + ".p$$parent = " + tableAlias + "v.object_id";
            String referencedTableName = referencedDbObject.getConfiguration().getDbObjectForUpdate1() == null ? referencedDbObject.getConfiguration().getDbObjectForQuery1() : referencedDbObject.getConfiguration().getDbObjectForUpdate1();
            clause = clause + referencedTableName + " " + tableAlias + "v " + joinClause + " AND\n";
            clause = clause + this.predicate.toSql(indent + "    " + "    ", referencedTypeAccessPath.size() % 2 == 1 ? referencedTypeAccessPath.getParent() : referencedTypeAccessPath, tableAlias + "v");
            clause = clause + "\n";
            if (this.havingClause != null) {
                clause = clause + indent + "    " + "HAVING " + this.havingClause + "\n";
            }
            clause = clause + indent + ")";
            return clause;
        }

        public static enum Condition {
            EXISTS,
            NOT_EXISTS;

        }
    }

    public static class TypedReferencePredicate
    extends ReferencePredicate {
        private String referencedTypeName;

        public TypedReferencePredicate() {
        }

        public TypedReferencePredicate(String id, String description, String qualifiedFeatureName) {
            super(id, description, qualifiedFeatureName);
        }

        public TypedReferencePredicate(String id, String description, String qualifiedFeatureName, String referencedTypeName, ReferencePredicate.Condition condition, Predicate predicate) {
            super(id, description, qualifiedFeatureName);
            this.referencedTypeName = referencedTypeName;
            this.condition = condition;
            this.predicate = predicate;
        }

        @Override
        protected Path getReferencedTypeAccessPath(ModelElement_1_0 reference, Path accessPath) throws ServiceException {
            if (this.referencedTypeName != null && reference.objGetValue("qualifiedFeatureName").equals(this.getQualifiedFeatureName())) {
                Model_1_0 model = reference.getModel();
                return model.getIdentityPattern(model.getElement((Object)this.referencedTypeName));
            }
            return super.getReferencedTypeAccessPath(reference, accessPath);
        }

        public String getReferencedTypeName() {
            return this.referencedTypeName;
        }

        public void setReferencedTypeName(String referencedTypeName) {
            this.referencedTypeName = referencedTypeName;
        }
    }

    public static class ReferencePredicate
    extends FeaturePredicate {
        protected Condition condition;
        protected Predicate predicate;
        protected String havingClause;

        public ReferencePredicate() {
        }

        public ReferencePredicate(String id, String description, String qualifiedFeatureName) {
            super(id, description, qualifiedFeatureName);
        }

        public ReferencePredicate(String id, String description, String qualifiedFeatureName, Condition condition, Predicate predicate) {
            super(id, description, qualifiedFeatureName);
            this.condition = condition;
            this.predicate = predicate;
        }

        @Override
        public Predicate findPredicate(String id) {
            Predicate f = super.findPredicate(id);
            return f == null ? (this.predicate == null ? null : this.predicate.findPredicate(id)) : f;
        }

        public Predicate getPredicate() {
            return this.predicate;
        }

        public void setPredicate(Predicate predicate) {
            this.predicate = predicate;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public void setCondition(Condition condition) {
            this.condition = condition;
        }

        public String getHavingClause() {
            return this.havingClause;
        }

        public ReferencePredicate setHavingClause(String havingClause) {
            this.havingClause = havingClause;
            return this;
        }

        @Override
        public String toSql(String indent, Path accessPath, String tableAlias) throws ServiceException {
            ModelElement_1_0 feature = this.getFeature();
            String clause = "";
            if (this.getDescription() != null) {
                clause = clause + indent + "/* " + this.getDescription() + " */\n";
            }
            switch (this.condition) {
                case EXISTS: {
                    clause = clause + indent + "EXISTS (\n";
                    break;
                }
                case NOT_EXISTS: {
                    clause = clause + indent + "NOT EXISTS (\n";
                }
            }
            clause = clause + indent + "    " + "SELECT 0 FROM ";
            String joinClause = null;
            Path referencedTypeAccessPath = null;
            DbObject referencedDbObject = null;
            if (ModelHelper.isCompositeEnd((ModelElement_1_0)feature, (boolean)false)) {
                referencedTypeAccessPath = this.getReferencedTypeAccessPath(feature, accessPath);
                referencedDbObject = this.getDbObject(referencedTypeAccessPath);
                joinClause = "WHERE\n" + indent + "    " + "    " + tableAlias + "v.p$$parent = " + tableAlias + ".object_id";
            } else if (ModelHelper.isSharedEnd((ModelElement_1_0)feature, (boolean)false)) {
                referencedTypeAccessPath = this.getReferencedTypeAccessPath(feature, accessPath);
                referencedDbObject = this.getDbObject(referencedTypeAccessPath);
                String[] joinCriteria = referencedDbObject.getJoinCriteria();
                joinClause = joinClause + "\n" + indent + "    " + "INNER JOIN\n" + indent + "    " + "    " + joinCriteria[0] + " " + tableAlias + "vj\n" + indent + "    " + "ON\n" + indent + "    " + "    " + tableAlias + "vj." + joinCriteria[2] + " = " + tableAlias + "v.object_id\n" + indent + "    " + "WHERE\n" + indent + "    " + "    " + tableAlias + "vj." + joinCriteria[1] + " = " + tableAlias + ".object_id";
            } else if (feature.isReference() && ModelHelper.isStoredAsAttribute((ModelElement_1_0)feature)) {
                referencedTypeAccessPath = this.getReferencedTypeAccessPath(feature, accessPath);
                referencedDbObject = this.getDbObject(referencedTypeAccessPath);
                String columnName = this.getColumnName();
                if (ModelHelper.getMultiplicity((ModelElement_1_0)feature).isMultiValued()) {
                    DbObject dbObject = this.getDbObject(accessPath);
                    String tableName_ = dbObject.getConfiguration().getDbObjectForUpdate2() == null ? dbObject.getConfiguration().getDbObjectForQuery2() : dbObject.getConfiguration().getDbObjectForUpdate2();
                    joinClause = "WHERE\n" + indent + "    " + "    " + "EXISTS (SELECT 0 FROM " + tableName_ + " " + tableAlias + "_ WHERE " + tableAlias + "_.object_id = " + tableAlias + ".object_id AND " + tableAlias + "v.object_id = " + tableAlias + "_." + columnName + ")";
                } else {
                    joinClause = "WHERE\n" + indent + "    " + "    " + tableAlias + "v.object_id = " + tableAlias + "." + columnName;
                }
            }
            if (referencedDbObject == null) {
                throw new ServiceException("DefaultDomain", -34, "No db object found for referencedTypeAccessPath", new BasicException.Parameter[]{new BasicException.Parameter("referencedTypeAccessPath", (Object)referencedTypeAccessPath), new BasicException.Parameter("feature", (Object)feature), new BasicException.Parameter("accessPath", (Object)accessPath)});
            }
            String referencedTableName = referencedDbObject.getConfiguration().getDbObjectForUpdate1() == null ? referencedDbObject.getConfiguration().getDbObjectForQuery1() : referencedDbObject.getConfiguration().getDbObjectForUpdate1();
            clause = clause + referencedTableName + " " + tableAlias + "v " + joinClause + " AND\n";
            clause = clause + this.predicate.toSql(indent + "    " + "    ", referencedTypeAccessPath.size() % 2 == 1 ? referencedTypeAccessPath.getParent() : referencedTypeAccessPath, tableAlias + "v");
            clause = clause + "\n";
            if (this.havingClause != null) {
                clause = clause + indent + "    " + "HAVING " + this.havingClause + "\n";
            }
            clause = clause + indent + ")";
            return clause;
        }

        public static enum Condition {
            EXISTS,
            NOT_EXISTS;

        }
    }

    public static class MultiValuedAttributePredicate
    extends FeaturePredicate {
        protected Condition condition;
        protected String values;

        public MultiValuedAttributePredicate() {
        }

        public MultiValuedAttributePredicate(String id, String description, String qualifiedFeatureName) {
            super(id, description, qualifiedFeatureName);
        }

        public MultiValuedAttributePredicate(String id, String description, String qualifiedFeatureName, Condition condition, String values) {
            super(id, description, qualifiedFeatureName);
            this.condition = condition;
            this.values = values;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public void setCondition(Condition condition) {
            this.condition = condition;
        }

        public String getValues() {
            return this.values;
        }

        public void setValues(String values) {
            this.values = values;
        }

        @Override
        public String toSql(String indent, Path accessPath, String tableAlias) throws ServiceException {
            Integer upperBound;
            String clause = "";
            if (this.getDescription() != null) {
                clause = clause + indent + "/* " + this.getDescription() + " */\n";
            }
            if ((upperBound = this.getEmbeddedFeature()) == null) {
                String columnName = this.getColumnName();
                Model_1_0 model = Model_1Factory.getModel();
                DbObject dbObject = this.getDbObject(this.getReferencedTypeAccessPath(model.getReferenceType(accessPath), accessPath));
                String tableName_ = dbObject.getConfiguration().getDbObjectForUpdate2() == null ? dbObject.getConfiguration().getDbObjectForQuery2() : dbObject.getConfiguration().getDbObjectForUpdate2();
                switch (this.condition) {
                    case IS_IN: {
                        clause = clause + indent + "EXISTS (SELECT 0 FROM " + tableName_ + " " + tableAlias + "_ WHERE " + tableAlias + ".object_id = " + tableAlias + "_.object_id AND " + columnName + " IN " + this.values + ")";
                        break;
                    }
                    case IS_NOT_IN: {
                        clause = clause + indent + "NOT EXISTS (SELECT 0 FROM " + tableName_ + " " + tableAlias + "_ WHERE " + tableAlias + ".object_id = " + tableAlias + "_.object_id AND " + columnName + " IN " + this.values + ")";
                        break;
                    }
                    case IS_EMPTY: {
                        clause = clause + indent + "NOT EXISTS (SELECT 0 FROM " + tableName_ + " " + tableAlias + "_ WHERE " + tableAlias + ".object_id = " + tableAlias + "_.object_id AND " + columnName + " IS NOT NULL)";
                        break;
                    }
                    case IS_NOT_EMPTY: {
                        clause = clause + indent + "EXISTS (SELECT 0 FROM " + tableName_ + " " + tableAlias + "_ WHERE " + tableAlias + ".object_id = " + tableAlias + "_.object_id AND " + columnName + " IS NOT NULL)";
                    }
                }
            } else {
                clause = clause + indent + "(";
                switch (this.condition) {
                    case IS_IN: {
                        for (int index = 0; index < upperBound; ++index) {
                            String columnName = this.getColumnName(index);
                            if (index > 0) {
                                clause = clause + " OR ";
                            }
                            clause = clause + tableAlias + "." + columnName + " IN " + this.values;
                        }
                        break;
                    }
                    case IS_NOT_IN: {
                        for (int index = 0; index < upperBound; ++index) {
                            String columnName = this.getColumnName(index);
                            if (index > 0) {
                                clause = clause + " AND ";
                            }
                            clause = clause + tableAlias + "." + columnName + " NOT IN " + this.values;
                        }
                        break;
                    }
                    case IS_EMPTY: {
                        for (int index = 0; index < upperBound; ++index) {
                            String columnName = this.getColumnName(index);
                            if (index > 0) {
                                clause = clause + " AND ";
                            }
                            clause = clause + tableAlias + "." + columnName + " IS NULL";
                        }
                        break;
                    }
                    case IS_NOT_EMPTY: {
                        for (int index = 0; index < upperBound; ++index) {
                            String columnName = this.getColumnName(index);
                            if (index > 0) {
                                clause = clause + " OR ";
                            }
                            clause = clause + tableAlias + "." + columnName + " IS NOT NULL";
                        }
                        break;
                    }
                }
                clause = clause + ")";
            }
            return clause;
        }

        public static enum Condition {
            IS_IN,
            IS_NOT_IN,
            IS_EMPTY,
            IS_NOT_EMPTY;

        }
    }

    public static class SingleValuedAttributePredicate
    extends FeaturePredicate {
        protected String function;
        protected Condition condition;
        protected String value;

        public SingleValuedAttributePredicate() {
        }

        public SingleValuedAttributePredicate(String id, String description, String qualifiedFeatureName) {
            super(id, description, qualifiedFeatureName);
        }

        public SingleValuedAttributePredicate(String id, String description, String qualifiedFeatureName, Condition condition, String value) {
            super(id, description, qualifiedFeatureName);
            this.condition = condition;
            this.value = value;
        }

        public SingleValuedAttributePredicate(String id, String description, String function, String qualifiedFeatureName, Condition condition, String value) {
            super(id, description, qualifiedFeatureName);
            this.function = function;
            this.condition = condition;
            this.value = value;
        }

        public String conditionToSqlOperator(Condition condition) {
            switch (condition) {
                case IS_LIKE: {
                    return "LIKE";
                }
                case IS_UNLIKE: {
                    return "NOT LIKE";
                }
                case IS_LESS_OR_EQUAL: {
                    return "<=";
                }
                case IS_LESS: {
                    return "<";
                }
                case IS_NOT_IN: {
                    return "NOT IN";
                }
                case IS_IN: {
                    return "IN";
                }
                case IS_GREATER_OR_EQUAL: {
                    return ">=";
                }
                case IS_GREATER: {
                    return ">";
                }
                case IS: {
                    return "IS";
                }
                case IS_NOT: {
                    return "IS NOT";
                }
            }
            return "?";
        }

        public Condition getCondition() {
            return this.condition;
        }

        public void setCondition(Condition condition) {
            this.condition = condition;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getFunction() {
            return this.function;
        }

        public void setFunction(String function) {
            this.function = function;
        }

        @Override
        public String toSql(String indent, Path accessPath, String tableAlias) throws ServiceException {
            String columnName = this.getColumnName();
            String clause = "";
            if (this.getDescription() != null) {
                clause = clause + indent + "/* " + this.getDescription() + " */\n";
            }
            clause = clause + indent + "(" + (this.function == null ? tableAlias + "." + columnName : this.function.replace(this.getFeature().getName(), tableAlias + "." + columnName)) + " " + this.conditionToSqlOperator(this.condition) + " " + this.value + ")";
            return clause;
        }

        public static enum Condition {
            IS_LIKE,
            IS_UNLIKE,
            IS_LESS_OR_EQUAL,
            IS_LESS,
            IS_NOT_IN,
            IS_IN,
            IS_GREATER_OR_EQUAL,
            IS_GREATER,
            IS,
            IS_NOT;

        }
    }

    public static class IsFalsePredicate
    extends Predicate {
        public IsFalsePredicate() {
        }

        public IsFalsePredicate(String id, String description) {
            super(id, description);
        }

        @Override
        public String toSql(String indent, Path accessPath, String tableAlias) throws ServiceException {
            String clause = "";
            clause = "(1=0)";
            if (this.getDescription() != null) {
                clause = clause + " /* " + this.getDescription() + " */";
            }
            return clause;
        }
    }

    public static class IsTruePredicate
    extends Predicate {
        public IsTruePredicate() {
        }

        public IsTruePredicate(String id, String description) {
            super(id, description);
        }

        @Override
        public String toSql(String indent, Path accessPath, String tableAlias) throws ServiceException {
            String clause = indent + "(1=1)";
            if (this.getDescription() != null) {
                clause = clause + " /* " + this.getDescription() + " */";
            }
            return clause;
        }
    }

    public static abstract class FeaturePredicate
    extends Predicate {
        protected String qualifiedFeatureName;

        public FeaturePredicate() {
        }

        public FeaturePredicate(String id, String description, String qualifiedFeatureName) {
            super(id, description);
            this.qualifiedFeatureName = qualifiedFeatureName;
        }

        protected ModelElement_1_0 getFeature() throws ServiceException {
            Model_1_0 model = Model_1Factory.getModel();
            return model.getElement((Object)this.getQualifiedFeatureName());
        }

        protected String getColumnName() throws ServiceException {
            String columnName = DbSchemaUtils.getDatabasePlugIns()[0].getColumnName(null, this.getFeature().getName(), 0, false, true, false);
            return columnName;
        }

        protected Integer getEmbeddedFeature() throws ServiceException {
            return DbSchemaUtils.getDatabasePlugIns()[0].getEmbeddedFeature(this.getFeature().getName());
        }

        protected String getColumnName(int index) throws ServiceException {
            String columnName = DbSchemaUtils.getDatabasePlugIns()[0].getColumnName(null, this.getFeature().getName(), index, true, true, false);
            return columnName;
        }

        protected Path getReferencedTypeAccessPath(ModelElement_1_0 reference, Path accessPath) throws ServiceException {
            Model_1_0 model = reference.getModel();
            Path referencedTypeAccessPath = model.getIdentityPattern(model.getElement((Object)reference.getType()));
            if (referencedTypeAccessPath == null) {
                try {
                    referencedTypeAccessPath = model.getIdentityPattern(model.getElement((Object)model.getReferenceType(accessPath).getType()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (referencedTypeAccessPath == null) {
                    referencedTypeAccessPath = accessPath.size() % 2 == 0 ? accessPath.getChild(":*") : accessPath;
                }
                referencedTypeAccessPath = referencedTypeAccessPath.getDescendant(new String[]{reference.getName()});
            }
            return referencedTypeAccessPath;
        }

        protected DbObject getDbObject(Path accessPath) throws ServiceException {
            for (Database_2 db : DbSchemaUtils.getDatabasePlugIns()) {
                try {
                    DbObject dbObject = db.getDbObject(null, accessPath, null, true);
                    if (dbObject.getConfiguration().getDbObjectForUpdate1() == null && dbObject.getConfiguration().getDbObjectForQuery1() == null) continue;
                    return dbObject;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public String getQualifiedFeatureName() {
            return this.qualifiedFeatureName;
        }

        public void setQualifiedFeatureName(String qualifiedFeatureName) {
            this.qualifiedFeatureName = qualifiedFeatureName;
        }
    }

    public static class IdentityPredicate
    extends Predicate {
        protected String values;
        protected Condition condition;

        public IdentityPredicate() {
        }

        public IdentityPredicate(String id, String description, Condition condition, String value) {
            super(id, description);
            this.condition = condition;
            this.values = value;
        }

        protected String getColumnNameParent() throws ServiceException {
            return DbSchemaUtils.getDatabasePlugIns()[0].getColumnName(null, "parent", 0, false, false, true);
        }

        public String getValues() {
            return this.values;
        }

        public void setValues(String values) {
            this.values = values;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public void setCondition(Condition condition) {
            this.condition = condition;
        }

        @Override
        public String toSql(String indent, Path accessPath, String tableAlias) throws ServiceException {
            String clause = "";
            if (this.getDescription() != null) {
                clause = clause + indent + "/* " + this.getDescription() + " */\n";
            }
            switch (this.condition) {
                case IS_IN: {
                    clause = clause + indent + "(" + tableAlias + ".object_id IN " + this.values + ")";
                    break;
                }
                case PARENT_IS_IN: {
                    clause = clause + indent + "(" + tableAlias + "." + this.getColumnNameParent() + " IN " + this.values + ")";
                }
            }
            return clause;
        }

        public static enum Condition {
            IS_IN,
            PARENT_IS_IN;

        }
    }

    public static class InstanceOfPredicate
    extends Predicate {
        protected String values;

        public InstanceOfPredicate() {
        }

        public InstanceOfPredicate(String id, String description, String values) {
            super(id, description);
            this.values = values;
        }

        public String getValues() {
            return this.values;
        }

        public void setValues(String values) {
            this.values = values;
        }

        @Override
        public String toSql(String indent, Path accessPath, String tableAlias) throws ServiceException {
            String clause = "";
            if (this.getDescription() != null) {
                clause = clause + indent + "/* " + this.getDescription() + " */\n";
            }
            clause = clause + indent + "(" + tableAlias + ".dtype IN " + this.values + ")";
            return clause;
        }
    }

    public static class OrPredicate
    extends ComplexPredicate {
        public OrPredicate() {
        }

        public OrPredicate or(Predicate predicate) {
            return (OrPredicate)super.addPredicate(predicate);
        }

        public OrPredicate(String id, String description, boolean negate) {
            super(id, description, negate);
        }

        @Override
        public String toSql(String indent, Path accessPath, String tableAlias) throws ServiceException {
            String clause = "";
            if (this.getDescription() != null) {
                clause = clause + indent + "/* " + this.getDescription() + " */\n";
            }
            if (this.getPredicates() != null && !this.getPredicates().isEmpty()) {
                clause = clause + indent + (this.negate ? "NOT " : "") + "(\n";
                int count = 0;
                for (Predicate predicate : this.getPredicates()) {
                    clause = clause + (count == 0 ? "" : " OR\n") + predicate.toSql(indent + "    ", accessPath, tableAlias);
                    ++count;
                }
                clause = clause + "\n";
                clause = clause + indent + ")";
            }
            return clause;
        }
    }

    public static class AndPredicate
    extends ComplexPredicate {
        public AndPredicate() {
        }

        public AndPredicate(String id, String description, boolean negate) {
            super(id, description, negate);
        }

        public AndPredicate and(Predicate predicate) {
            return (AndPredicate)super.addPredicate(predicate);
        }

        @Override
        public String toSql(String indent, Path accessPath, String tableAlias) throws ServiceException {
            String clause = "";
            if (this.getDescription() != null) {
                clause = clause + indent + "/* " + this.getDescription() + " */\n";
            }
            if (this.getPredicates() != null && !this.getPredicates().isEmpty()) {
                clause = clause + indent + (this.negate ? "NOT " : "") + "(\n";
                int count = 0;
                for (Predicate predicate : this.getPredicates()) {
                    clause = clause + (count == 0 ? "" : " AND\n") + predicate.toSql(indent + "    ", accessPath, tableAlias);
                    ++count;
                }
                clause = clause + "\n";
                clause = clause + indent + ")";
            }
            return clause;
        }
    }

    public static abstract class ComplexPredicate
    extends Predicate {
        protected boolean negate;
        protected List<Predicate> predicates;

        public ComplexPredicate() {
        }

        public ComplexPredicate(String id, String description, boolean negate) {
            super(id, description);
            this.negate = negate;
        }

        protected ComplexPredicate addPredicate(Predicate predicate) {
            if (this.predicates == null) {
                this.predicates = new ArrayList<Predicate>();
            }
            this.predicates.add(predicate);
            return this;
        }

        public Predicate removePredicate(String id) {
            if (this.predicates != null) {
                Iterator<Predicate> i = this.predicates.iterator();
                while (i.hasNext()) {
                    Predicate predicate = i.next();
                    if (!id.equals(predicate.getId())) continue;
                    i.remove();
                    return predicate;
                }
            }
            return null;
        }

        @Override
        public Predicate findPredicate(String id) {
            Predicate f = super.findPredicate(id);
            if (f == null) {
                for (Predicate predicate : this.predicates) {
                    f = predicate.findPredicate(id);
                    if (f == null) continue;
                    return f;
                }
                return null;
            }
            return f;
        }

        public List<Predicate> getPredicates() {
            return this.predicates;
        }

        public void setPredicates(List<Predicate> predicates) {
            this.predicates = predicates;
        }

        public boolean isNegate() {
            return this.negate;
        }

        public void setNegate(boolean negate) {
            this.negate = negate;
        }
    }

    public static abstract class Predicate {
        public static final String TAB = "    ";
        protected String id;
        protected String description;

        public Predicate() {
        }

        public Predicate(String id, String description) {
            this.id = id;
            this.description = description;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Predicate findPredicate(String id) {
            return id.equals(this.id) ? this : null;
        }

        public abstract String toSql(String var1, Path var2, String var3) throws ServiceException;

        public String toXML() throws ServiceException {
            return JavaBeans.toXML((Object)this);
        }

        public static Predicate fromXML(String predicate) throws ServiceException {
            return (Predicate)JavaBeans.fromXML((CharSequence)predicate);
        }
    }
}

