/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.utils;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.naming.NamingException;
import javax.resource.cci.MappedRecord;
import org.oasisopen.jmi1.RefContainer;
import org.opencrx.kernel.account1.jmi1.Account1Package;
import org.opencrx.kernel.activity1.jmi1.Activity1Package;
import org.opencrx.kernel.admin1.jmi1.Admin1Package;
import org.opencrx.kernel.base.jmi1.BasePackage;
import org.opencrx.kernel.building1.jmi1.Building1Package;
import org.opencrx.kernel.code1.jmi1.Code1Package;
import org.opencrx.kernel.contract1.jmi1.Contract1Package;
import org.opencrx.kernel.depot1.jmi1.Depot1Package;
import org.opencrx.kernel.document1.jmi1.Document1Package;
import org.opencrx.kernel.forecast1.jmi1.Forecast1Package;
import org.opencrx.kernel.generic.jmi1.GenericPackage;
import org.opencrx.kernel.home1.jmi1.Home1Package;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.opencrx.kernel.product1.jmi1.Product1Package;
import org.opencrx.kernel.uom1.jmi1.Uom;
import org.opencrx.kernel.uom1.jmi1.Uom1Package;
import org.opencrx.kernel.workflow1.jmi1.Workflow1Package;
import org.opencrx.security.realm1.jmi1.Principal;
import org.opencrx.security.realm1.jmi1.Realm1Package;
import org.openmdx.application.rest.ejb.DataManager_2ProxyFactory;
import org.openmdx.application.rest.http.SimplePort;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.accessor.jmi.spi.EntityManagerFactory_1;
import org.openmdx.base.accessor.rest.DirtyObjects;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.Authority;
import org.openmdx.base.mof.cci.ModelElement_1_0;
import org.openmdx.base.mof.cci.Model_1_0;
import org.openmdx.base.mof.spi.Model_1Factory;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.ConfigurableProperty;
import org.openmdx.base.persistence.cci.UserObjects;
import org.openmdx.base.resource.spi.Port;
import org.openmdx.base.rest.connector.EntityManagerProxyFactory_2;
import org.openmdx.base.rest.spi.ConnectionFactoryAdapter;
import org.openmdx.base.rest.spi.Object_2Facade;
import org.openmdx.base.rest.spi.Query_2Facade;
import org.openmdx.base.text.conversion.Base64;
import org.openmdx.base.text.conversion.UUIDConversion;
import org.openmdx.base.transaction.TransactionAttributeType;
import org.openmdx.kernel.id.UUIDs;
import org.openmdx.portal.servlet.UserSettings;
import org.openmdx.portal.servlet.attribute.DateValue;
import org.openmdx.security.realm1.jmi1.Group;
import org.openmdx.security.realm1.jmi1.Permission;
import org.openmdx.security.realm1.jmi1.Role;

public abstract class Utils {
    private static Pattern CRLF = Pattern.compile("(\r\n|\r|\n)");
    private static ThreadLocal<Map<String, DateFormat>> cachedDateFormat = new ThreadLocal<Map<String, DateFormat>>(){

        @Override
        protected synchronized Map<String, DateFormat> initialValue() {
            return new HashMap<String, DateFormat>();
        }
    };
    private static ThreadLocal<Map<String, DateFormat>> cachedTimeFormat = new ThreadLocal<Map<String, DateFormat>>(){

        @Override
        protected synchronized Map<String, DateFormat> initialValue() {
            return new HashMap<String, DateFormat>();
        }
    };
    private static ThreadLocal<Map<String, DecimalFormat>> cachedDecimalFormat = new ThreadLocal<Map<String, DecimalFormat>>(){

        @Override
        protected synchronized Map<String, DecimalFormat> initialValue() {
            return new HashMap<String, DecimalFormat>();
        }
    };

    public static Model_1_0 getModel() {
        Model_1_0 model = null;
        try {
            model = Model_1Factory.getModel();
        }
        catch (Exception e) {
            System.out.println("Can not initialize model repository " + e.getMessage());
            System.out.println(new ServiceException(e).getCause());
        }
        return model;
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory() throws ServiceException {
        try {
            return JDOHelper.getPersistenceManagerFactory((String)"EntityManagerFactory");
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(Map<String, Object> overrides) throws ServiceException {
        try {
            return JDOHelper.getPersistenceManagerFactory(overrides, (String)"EntityManagerFactory");
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public static PersistenceManagerFactory getPersistenceManagerFactoryProxy(String url, String userName, String password, String mimeType) throws NamingException, ServiceException {
        SimplePort port = new SimplePort();
        port.setMimeType(mimeType == null ? "application/vnd.openmdx.wbxml" : mimeType);
        port.setUserName(userName);
        port.setPassword(password);
        port.setConnectionURL(url);
        ConnectionFactoryAdapter connectionFactory = new ConnectionFactoryAdapter((Port)port, true, TransactionAttributeType.NEVER);
        HashMap<String, Object> dataManagerProxyConfiguration = new HashMap<String, Object>();
        dataManagerProxyConfiguration.put(ConfigurableProperty.ConnectionFactory.qualifiedName(), connectionFactory);
        dataManagerProxyConfiguration.put(ConfigurableProperty.PersistenceManagerFactoryClass.qualifiedName(), EntityManagerProxyFactory_2.class.getName());
        PersistenceManagerFactory outboundConnectionFactory = JDOHelper.getPersistenceManagerFactory(dataManagerProxyConfiguration);
        HashMap<String, Object> entityManagerConfiguration = new HashMap<String, Object>();
        entityManagerConfiguration.put(ConfigurableProperty.ConnectionFactory.qualifiedName(), outboundConnectionFactory);
        entityManagerConfiguration.put(ConfigurableProperty.PersistenceManagerFactoryClass.qualifiedName(), EntityManagerFactory_1.class.getName());
        return JDOHelper.getPersistenceManagerFactory(entityManagerConfiguration);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactoryProxy(String contextName) throws NamingException, ServiceException {
        HashMap<String, String> dataManagerConfiguration = new HashMap<String, String>();
        dataManagerConfiguration.put("javax.jdo.option.ConnectionFactoryName", contextName == null ? "java:comp/env/ejb/EntityManagerFactory" : contextName);
        dataManagerConfiguration.put("javax.jdo.PersistenceManagerFactoryClass", DataManager_2ProxyFactory.class.getName());
        PersistenceManagerFactory dataManagerFactory = JDOHelper.getPersistenceManagerFactory(dataManagerConfiguration);
        HashMap<String, Object> entityManagerConfiguration = new HashMap<String, Object>();
        entityManagerConfiguration.put(ConfigurableProperty.ConnectionFactory.qualifiedName(), dataManagerFactory);
        entityManagerConfiguration.put(ConfigurableProperty.PersistenceManagerFactoryClass.qualifiedName(), EntityManagerFactory_1.class.getName());
        return JDOHelper.getPersistenceManagerFactory(entityManagerConfiguration);
    }

    public static RefPackage getJmiPackage(PersistenceManager pm, String authorityXri) {
        Authority obj = (Authority)pm.getObjectById(Authority.class, (Object)authorityXri);
        return obj.refOutermostPackage().refPackage(obj.refGetPath().getLastSegment().toString());
    }

    public static Workflow1Package getWorkflowPackage(PersistenceManager pm) {
        return (Workflow1Package)Utils.getJmiPackage(pm, "xri://@openmdx*org.opencrx.kernel.workflow1");
    }

    public static Code1Package getCodePackage(PersistenceManager pm) {
        return (Code1Package)Utils.getJmiPackage(pm, "xri://@openmdx*org.opencrx.kernel.code1");
    }

    public static Document1Package getDocumentPackage(PersistenceManager pm) {
        return (Document1Package)Utils.getJmiPackage(pm, "xri://@openmdx*org.opencrx.kernel.document1");
    }

    public static Admin1Package getAdminPackage(PersistenceManager pm) {
        return (Admin1Package)Utils.getJmiPackage(pm, "xri://@openmdx*org.opencrx.kernel.admin1");
    }

    public static org.openmdx.base.jmi1.BasePackage getOpenMdxBasePackage(PersistenceManager pm) {
        return (org.openmdx.base.jmi1.BasePackage)Utils.getJmiPackage(pm, "xri://@openmdx*org.openmdx.base");
    }

    public static Home1Package getHomePackage(PersistenceManager pm) {
        return (Home1Package)Utils.getJmiPackage(pm, "xri://@openmdx*org.opencrx.kernel.home1");
    }

    public static Contract1Package getContractPackage(PersistenceManager pm) {
        return (Contract1Package)Utils.getJmiPackage(pm, "xri://@openmdx*org.opencrx.kernel.contract1");
    }

    public static Depot1Package getDepotPackage(PersistenceManager pm) {
        return (Depot1Package)Utils.getJmiPackage(pm, "xri://@openmdx*org.opencrx.kernel.depot1");
    }

    public static Building1Package getBuildingPackage(PersistenceManager pm) {
        return (Building1Package)Utils.getJmiPackage(pm, "xri://@openmdx*org.opencrx.kernel.building1");
    }

    public static Product1Package getProductPackage(PersistenceManager pm) {
        return (Product1Package)Utils.getJmiPackage(pm, "xri://@openmdx*org.opencrx.kernel.product1");
    }

    public static Uom1Package getUomPackage(PersistenceManager pm) {
        return (Uom1Package)Utils.getJmiPackage(pm, "xri://@openmdx*org.opencrx.kernel.uom1");
    }

    public static Realm1Package getRealmPackage(PersistenceManager pm) {
        return (Realm1Package)Utils.getJmiPackage(pm, "xri://@openmdx*org.opencrx.security.realm1");
    }

    public static BasePackage getBasePackage(PersistenceManager pm) {
        return (BasePackage)Utils.getJmiPackage(pm, "xri://@openmdx*org.opencrx.kernel.base");
    }

    public static Activity1Package getActivityPackage(PersistenceManager pm) {
        return (Activity1Package)Utils.getJmiPackage(pm, "xri://@openmdx*org.opencrx.kernel.activity1");
    }

    public static Account1Package getAccountPackage(PersistenceManager pm) {
        return (Account1Package)Utils.getJmiPackage(pm, "xri://@openmdx*org.opencrx.kernel.account1");
    }

    public static Forecast1Package getForecastPackage(PersistenceManager pm) {
        return (Forecast1Package)Utils.getJmiPackage(pm, "xri://@openmdx*org.opencrx.kernel.forecast1");
    }

    public static GenericPackage getGenericPackage(PersistenceManager pm) {
        return (GenericPackage)Utils.getJmiPackage(pm, "xri://@openmdx*org.opencrx.kernel.generic");
    }

    public static String toFilename(String s) {
        s = s.replace(' ', '-');
        s = s.replace(',', '-');
        s = s.replace('/', '-');
        s = s.replace('\\', '-');
        s = s.replace('=', '-');
        s = s.replace('%', '-');
        s = s.replace(':', '-');
        s = s.replace('*', '-');
        s = s.replace('?', '-');
        s = s.replace('+', '-');
        s = s.replace('(', '-');
        s = s.replace(')', '-');
        s = s.replace('<', '-');
        s = s.replace('>', '-');
        s = s.replace('|', '-');
        s = s.replace('\"', '-');
        s = s.replace('\'', '-');
        s = s.replace('&', '-');
        s = s.replace('.', '-');
        s = s.replace('#', '-');
        if ((s = s.replace("-", "")).length() > 50) {
            s = s.substring(0, 44) + s.substring(s.length() - 5);
        }
        return s;
    }

    public static String getPasswordDigest(String password, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(password.getBytes("UTF-8"));
            return "{" + algorithm + "}" + Base64.encode((byte[])md.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    public static boolean areEqual(Object v1, Object v2) {
        if (v1 instanceof Comparable && v2 instanceof Comparable && v1.getClass().equals(v2.getClass())) {
            return ((Comparable)v1).compareTo(v2) == 0;
        }
        return Objects.equals(v1, v2);
    }

    public static BigDecimal getUomScaleFactor(Uom from, Uom to) {
        if (from == null || to == null) {
            return BigDecimal.ZERO;
        }
        if (from.refMofId().equals(to.refMofId())) {
            return BigDecimal.ONE;
        }
        if (from.getBaseUom() != null && from.getBaseUom().refMofId().equals(to.refMofId())) {
            return from.getQuantity() != null ? from.getQuantity() : BigDecimal.ZERO;
        }
        if (to.getBaseUom() != null && to.getBaseUom().refMofId().equals(from.refMofId())) {
            return to.getQuantity() != null && to.getQuantity().signum() != 0 ? new BigDecimal(1.0 / to.getQuantity().doubleValue()) : BigDecimal.ZERO;
        }
        if (from.getBaseUom() != null && to.getBaseUom() != null && from.getBaseUom().refMofId().equals(to.getBaseUom().refMofId())) {
            return from.getQuantity() != null && to.getQuantity() != null && to.getQuantity().signum() != 0 ? new BigDecimal(from.getQuantity().doubleValue() / to.getQuantity().doubleValue()) : BigDecimal.ZERO;
        }
        return BigDecimal.ZERO;
    }

    public static SimpleDateFormat getLocalizedDateFormat(UserHome userHome) {
        Properties userSettings = new Properties();
        try {
            if (userHome != null && userHome.getSettings() != null) {
                userSettings.load(new ByteArrayInputStream(userHome.getSettings().getBytes("UTF-8")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Locale userLocale = Locale.getDefault();
        if (userSettings.getProperty(UserSettings.LOCALE_NAME.getName()) != null) {
            String localeAsString = userSettings.getProperty(UserSettings.LOCALE_NAME.getName());
            userLocale = new Locale(localeAsString.substring(0, 2), localeAsString.substring(localeAsString.indexOf("_") + 1));
        }
        SimpleDateFormat dateTimeFormat = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 2, userLocale);
        DateValue.assert4DigitYear((SimpleDateFormat)dateTimeFormat);
        if (userSettings.getProperty(UserSettings.TIMEZONE_NAME.getName()) != null) {
            try {
                dateTimeFormat.setTimeZone(TimeZone.getTimeZone(userSettings.getProperty(UserSettings.TIMEZONE_NAME.getName())));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dateTimeFormat;
    }

    public static String getUidAsString() {
        return UUIDConversion.toUID((UUID)UUIDs.newUUID());
    }

    public static Object traverseObjectTree(RefObject_1_0 object, Set<String> referenceFilter, TraverseObjectTreeCallback callback, Object context) throws ServiceException {
        Object newContext = callback.visit(object, context);
        Model_1_0 model = Model_1Factory.getModel();
        Map references = model.getElement((Object)object.refClass().refMofId()).objGetMap("reference");
        for (ModelElement_1_0 featureDef : references.values()) {
            boolean matches;
            boolean referenceIsSharedAndChangeable;
            ModelElement_1_0 referencedEnd = model.getElement((Object)featureDef.getReferencedEnd());
            boolean referenceIsCompositeAndChangeable = model.isReferenceType((Object)featureDef) && "composite".equals(referencedEnd.getAggregation()) && referencedEnd.isChangeable() != false;
            boolean bl = referenceIsSharedAndChangeable = model.isReferenceType((Object)featureDef) && "shared".equals(referencedEnd.getAggregation()) && referencedEnd.isChangeable() != false;
            if (!referenceIsCompositeAndChangeable && !referenceIsSharedAndChangeable) continue;
            String referenceName = featureDef.getName();
            boolean bl2 = matches = referenceFilter == null;
            if (!matches) {
                String qualifiedReferenceName = featureDef.getQualifiedName();
                boolean bl3 = matches = referenceFilter.contains(referenceName) || referenceFilter.contains(qualifiedReferenceName);
            }
            if (!matches) continue;
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)object);
            Query query = null;
            try {
                Query_2Facade queryFacade = Query_2Facade.newInstance((Path)object.refGetPath().getDescendant(new String[]{referenceName}));
                ModelElement_1_0 referencedType = model.getElement((Object)referencedEnd.getType());
                queryFacade.setQueryType(referencedType.getQualifiedName());
                query = pm.newQuery("org.openmdx.query.OPENMDXQL", (Object)queryFacade.getDelegate());
                query.getFetchPlan().setGroup("all");
            }
            catch (Exception e) {
                throw new ServiceException(e);
            }
            List content = ((RefContainer)object.refGetValue(referenceName)).refGetAll((Object)query);
            for (Object contained : content) {
                Utils.traverseObjectTree((RefObject_1_0)contained, referenceFilter, callback, newContext);
            }
        }
        return newContext;
    }

    public static org.openmdx.security.realm1.jmi1.Principal getRequestingPrincipal(PersistenceManager pm, String providerName, String segmentName) {
        List principalChain = UserObjects.getPrincipalChain((PersistenceManager)pm);
        if (principalChain.isEmpty()) {
            return null;
        }
        return (org.openmdx.security.realm1.jmi1.Principal)pm.getObjectById((Object)new Path("xri://@openmdx*org.openmdx.security.realm1").getDescendant(new String[]{"provider", providerName, "segment", "Root", "realm", segmentName, "principal", (String)principalChain.get(0)}));
    }

    public static boolean principalIsMemberOf(org.openmdx.security.realm1.jmi1.Principal principal, String ... principalGroups) {
        if (principal != null && principalGroups != null) {
            List<String> groups = Arrays.asList(principalGroups);
            List memberships = principal.getIsMemberOf();
            for (Group membership : memberships) {
                if (!groups.contains(membership.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> getPermissions(org.openmdx.security.realm1.jmi1.Principal principal, String action) throws ServiceException {
        ArrayList<String> permissions = new ArrayList<String>();
        if (principal instanceof Principal) {
            List roles = ((Principal)principal).getGrantedRole();
            for (Role role : roles) {
                for (Permission permission : role.getPermission()) {
                    if (!permission.getAction().contains(action)) continue;
                    permissions.add(permission.getName());
                }
            }
        }
        return permissions;
    }

    public static boolean hasObjectRunAsPermission(Path objectIdentity, List<String> runAsPermissions) {
        for (String runAsPermission : runAsPermissions) {
            String[] components;
            if (!runAsPermission.startsWith("object:") || (components = runAsPermission.substring(7, runAsPermission.indexOf("@")).split("/")).length <= 0) continue;
            Path pattern = new Path("xri://@openmdx*" + components[0]).getDescendant(new String[]{"provider", objectIdentity.get(2), "segment", objectIdentity.get(4)});
            for (int j = 1; j < components.length; ++j) {
                pattern = pattern.getDescendant(new String[]{components[j]});
            }
            if (!objectIdentity.isLike(pattern)) continue;
            return true;
        }
        return false;
    }

    public static DateFormat getTimeFormat(String language) {
        Map<String, DateFormat> timeFormatters = cachedTimeFormat.get();
        DateFormat timeFormat = timeFormatters.get(language);
        if (timeFormat == null) {
            timeFormat = DateFormat.getTimeInstance(3, new Locale(language));
            timeFormatters.put(language, timeFormat);
        }
        return timeFormat;
    }

    public static DecimalFormat getDecimalFormat(String language) {
        Map<String, DecimalFormat> decimalFormatters = cachedDecimalFormat.get();
        DecimalFormat decimalFormat = decimalFormatters.get(language);
        if (decimalFormat == null) {
            decimalFormat = (DecimalFormat)DecimalFormat.getInstance(new Locale(language));
            decimalFormatters.put(language, decimalFormat);
        }
        return decimalFormat;
    }

    public static DateFormat getDateFormat(String language) {
        Map<String, DateFormat> dateFormatters = cachedDateFormat.get();
        DateFormat dateFormat = dateFormatters.get(language);
        if (dateFormat == null) {
            dateFormat = DateFormat.getDateInstance(3, new Locale(language));
            dateFormatters.put(language, dateFormat);
        }
        return dateFormat;
    }

    public static String normalizeNewLines(String s) {
        Matcher m = CRLF.matcher(s);
        if (m.find()) {
            return m.replaceAll("\\\n");
        }
        return s;
    }

    public static List<String> splitString(String text, int size) {
        if (text == null) {
            text = "";
        }
        ArrayList<String> ret = new ArrayList<String>((text.length() + size - 1) / size);
        for (int start = 0; start < text.length(); start += size) {
            ret.add(text.substring(start, Math.min(text.length(), start + size)));
        }
        return ret;
    }

    public static void touchObject(RefObject object) throws ServiceException {
        DirtyObjects.touch((RefObject)object);
    }

    public static String getRandomBase62(int length) {
        String alphabet = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        Random random = new Random(System.currentTimeMillis());
        String s = "";
        for (int i = 0; i < length; ++i) {
            s = s + "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".charAt(random.nextInt(62));
        }
        return s;
    }

    public static boolean isInstanceOf(MappedRecord object, String qualifiedTypeName) throws ServiceException {
        Model_1_0 model = Utils.getModel();
        String objectClass = Object_2Facade.getObjectClass((MappedRecord)object);
        return model.isSubtypeOf((Object)objectClass, (Object)qualifiedTypeName);
    }

    public static BigDecimal round(BigDecimal value, BigDecimal roundingFactor) {
        if (roundingFactor == null || BigDecimal.ZERO.equals(roundingFactor)) {
            return value;
        }
        return new BigDecimal(value.divide(roundingFactor, MathContext.DECIMAL64).add(new BigDecimal((float)value.signum() * 0.5f), MathContext.DECIMAL64).toBigInteger()).multiply(roundingFactor, MathContext.DECIMAL64);
    }

    public static interface TraverseObjectTreeCallback {
        public Object visit(RefObject_1_0 var1, Object var2) throws ServiceException;
    }
}

