/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.utils.rtf;

import java.text.SimpleDateFormat;
import java.util.Date;

public class RtfUtil {
    public static String convertDateToRTFString(Date datum) {
        SimpleDateFormat formater = new SimpleDateFormat("'\\yr'yyyy'\\mo'MM'\\dy'dd'\\hr'HH'\\min'mm'\\sec'ss");
        return formater.format(datum);
    }

    public static String getRTFString(String text) {
        StringBuffer workstr = new StringBuffer();
        block7: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\\': {
                    workstr.append("\\\\");
                    continue block7;
                }
                case '{': {
                    workstr.append("\\{");
                    continue block7;
                }
                case '}': {
                    workstr.append("\\}");
                    continue block7;
                }
                case '\t': {
                    workstr.append("{\\tab}");
                    continue block7;
                }
                case '\u0010': {
                    workstr.append("{\\line}");
                    continue block7;
                }
                default: {
                    if (ch < '\u0080') {
                        workstr.append(ch);
                        continue block7;
                    }
                    workstr.append("\\u" + String.format("%04d", ch) + "?");
                }
            }
        }
        return workstr.toString();
    }

    public static int getTwipFromMillimeter(double mm) {
        return (int)(mm / 25.4 * 1440.0 + 0.5);
    }

    public static double getMillimeterFromTwip(int twips) {
        return (double)twips * 25.4 / 1440.0;
    }

    public static int getIntegerFromText(String buf, int startpos) {
        int result = -1;
        int len = 0;
        while (Character.isDigit(buf.charAt(startpos + len))) {
            ++len;
        }
        try {
            result = Integer.parseInt(buf.substring(startpos, startpos + len));
        }
        catch (NumberFormatException e) {
            result = -1;
        }
        return result;
    }

    public static int getPositionOfTagEnd(StringBuffer text, int begin) {
        int end = begin + 1;
        int count = 1;
        while (count > 0) {
            if (text.charAt(end) == '{') {
                ++count;
            } else if (text.charAt(end) == '}') {
                --count;
            }
            ++end;
        }
        return end;
    }

    public static int getPositionOfTagEnd(String text, int begin) {
        int end = begin + 1;
        int count = 1;
        while (count > 0) {
            if (text.charAt(end) == '{') {
                ++count;
            } else if (text.charAt(end) == '}') {
                --count;
            }
            ++end;
        }
        return end;
    }
}

