/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.workflow.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.kernel.admin1.jmi1.ComponentConfiguration;
import org.opencrx.kernel.backend.Accounts;
import org.opencrx.kernel.backend.Activities;
import org.opencrx.kernel.backend.Buildings;
import org.opencrx.kernel.backend.Contracts;
import org.opencrx.kernel.backend.Depots;
import org.opencrx.kernel.backend.Documents;
import org.opencrx.kernel.backend.Forecasts;
import org.opencrx.kernel.backend.Models;
import org.opencrx.kernel.backend.Products;
import org.opencrx.kernel.backend.UserHomes;
import org.opencrx.kernel.backend.Workflows;
import org.opencrx.kernel.base.cci2.UpdateIndexParams;
import org.opencrx.kernel.base.jmi1.Indexed;
import org.opencrx.kernel.base.jmi1.StringProperty;
import org.opencrx.kernel.base.jmi1.UpdateIndexParams;
import org.opencrx.kernel.base.jmi1.UpdateIndexResult;
import org.opencrx.kernel.generic.SecurityKeys;
import org.opencrx.kernel.utils.ComponentConfigHelper;
import org.opencrx.kernel.utils.Utils;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.kernel.exception.BasicException;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class IndexerServlet
extends HttpServlet {
    private static final long serialVersionUID = 4441731357561757549L;
    private static final String COMMAND_EXECUTE = "/execute";
    private static final String WORKFLOW_NAME = "Indexer";
    private static final String CONFIGURATION_ID = "Indexer";
    private static final String OPTION_KEYWORD_LENGTH_MIN = "keywordLengthMin";
    private static final String OPTION_KEYWORD_LENGTH_MAX = "keywordLengthMax";
    private static final String OPTION_INDEXED_ATTRIBUTES_INCLUDE = "indexedAttributesInclude";
    private static final String OPTION_INDEXED_ATTRIBUTES_EXCLUDE = "indexedAttributesExclude";
    private static final long STARTUP_DELAY = 180000L;
    private static final Map<String, Thread> runningSegments = new ConcurrentHashMap<String, Thread>();
    private PersistenceManagerFactory pmf = null;
    private long startedAt = System.currentTimeMillis();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.pmf = Utils.getPersistenceManagerFactory();
        }
        catch (Exception e) {
            throw new ServletException("Can not get connection to data provider", (Throwable)e);
        }
    }

    public void updateIndex(String id, String providerName, String segmentName, HttpServletRequest req, HttpServletResponse res) throws IOException {
        System.out.println(new Date().toString() + "  " + "Indexer" + " " + providerName + "/" + segmentName);
        try {
            PersistenceManager pm = this.pmf.getPersistenceManager("admin" + SecurityKeys.ID_SEPARATOR + segmentName, null);
            PersistenceManager rootPm = Utils.getPersistenceManagerFactory().getPersistenceManager("admin-Root", null);
            Workflows.getInstance().initWorkflows(pm, providerName, segmentName);
            ComponentConfiguration componentConfig = ComponentConfigHelper.getComponentConfiguration("Indexer", providerName, rootPm, true, new String[][]{{providerName + "." + segmentName + "." + OPTION_KEYWORD_LENGTH_MIN, Integer.toString(3)}, {providerName + "." + segmentName + "." + OPTION_KEYWORD_LENGTH_MAX, Integer.toString(40)}, {providerName + "." + segmentName + "." + OPTION_INDEXED_ATTRIBUTES_INCLUDE, ""}, {providerName + "." + segmentName + "." + OPTION_INDEXED_ATTRIBUTES_EXCLUDE, ""}});
            StringProperty keywordLengthMinProperty = ComponentConfigHelper.getComponentConfigProperty(providerName + "." + segmentName + "." + OPTION_KEYWORD_LENGTH_MIN, componentConfig);
            StringProperty keywordLengthMaxProperty = ComponentConfigHelper.getComponentConfigProperty(providerName + "." + segmentName + "." + OPTION_KEYWORD_LENGTH_MAX, componentConfig);
            StringProperty indexedAttributesIncludeProperty = ComponentConfigHelper.getComponentConfigProperty(providerName + "." + segmentName + "." + OPTION_INDEXED_ATTRIBUTES_INCLUDE, componentConfig);
            StringProperty indexedAttributesExcludeProperty = ComponentConfigHelper.getComponentConfigProperty(providerName + "." + segmentName + "." + OPTION_INDEXED_ATTRIBUTES_EXCLUDE, componentConfig);
            Integer keywordLengthMin = null;
            if (keywordLengthMinProperty != null) {
                try {
                    keywordLengthMin = Integer.parseInt(keywordLengthMinProperty.getStringValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Integer keywordLengthMax = null;
            if (keywordLengthMaxProperty != null) {
                try {
                    keywordLengthMax = Integer.parseInt(keywordLengthMaxProperty.getStringValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ArrayList<String> indexedAttributesInclude = null;
            if (indexedAttributesIncludeProperty != null) {
                try {
                    indexedAttributesInclude = new ArrayList<String>(Arrays.asList(indexedAttributesIncludeProperty.getStringValue().split(",")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ArrayList<String> indexedAttributesExclude = null;
            if (indexedAttributesExcludeProperty != null) {
                try {
                    indexedAttributesExclude = new ArrayList<String>(Arrays.asList(indexedAttributesExcludeProperty.getStringValue().split(",")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ArrayList<Indexed> indexedSegments = new ArrayList<Indexed>();
            indexedSegments.add(Accounts.getInstance().getAccountSegment(pm, providerName, segmentName));
            indexedSegments.add(Activities.getInstance().getActivitySegment(pm, providerName, segmentName));
            indexedSegments.add(Buildings.getInstance().getBuildingSegment(pm, providerName, segmentName));
            indexedSegments.add(Contracts.getInstance().getContractSegment(pm, providerName, segmentName));
            indexedSegments.add(Depots.getInstance().getDepotSegment(pm, providerName, segmentName));
            indexedSegments.add(Documents.getInstance().getDocumentSegment(pm, providerName, segmentName));
            indexedSegments.add(Forecasts.getInstance().getForecastSegment(pm, providerName, segmentName));
            indexedSegments.add(Models.getInstance().getModelSegment(pm, providerName, segmentName));
            indexedSegments.add(Products.getInstance().getProductSegment(pm, providerName, segmentName));
            indexedSegments.add(UserHomes.getInstance().getUserHomeSegment(pm, providerName, segmentName));
            for (Indexed indexedSegment : indexedSegments) {
                long startedAt = System.currentTimeMillis();
                try {
                    UpdateIndexParams params = (UpdateIndexParams)Structures.create(UpdateIndexParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)UpdateIndexParams.Member.keywordLengthMin, (Object)keywordLengthMin), Datatypes.member((Enum)UpdateIndexParams.Member.keywordLengthMax, (Object)keywordLengthMax), Datatypes.member((Enum)UpdateIndexParams.Member.indexedAttributesInclude, indexedAttributesInclude), Datatypes.member((Enum)UpdateIndexParams.Member.indexedAttributesExclude, indexedAttributesExclude)});
                    UpdateIndexResult result = indexedSegment.updateIndex(params);
                    if (result.getNumberOfIndexedObjects() <= 0) continue;
                    long duration = System.currentTimeMillis() - startedAt;
                    System.out.println(new Date().toString() + "  " + "Indexer" + " " + providerName + "/" + segmentName + ": Indexed " + indexedSegment.refMofId() + " (" + result.getNumberOfIndexedObjects() + " objects in " + duration + " ms)");
                }
                catch (Exception e) {
                    ServiceException e0 = new ServiceException(e, "DefaultDomain", -19, "Unable to update index", new BasicException.Parameter[]{new BasicException.Parameter("segment.xri", (Object)indexedSegment.refMofId())});
                    e0.log();
                    System.out.println(new Date() + "  " + "Indexer" + " " + providerName + "/" + segmentName + ": exception occured " + e.getMessage() + ". Continuing");
                }
            }
            try {
                pm.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            new ServiceException(e).log();
            System.out.println(new Date() + "  " + "Indexer" + " " + providerName + "/" + segmentName + ": exception occured " + e.getMessage() + ". Continuing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (System.currentTimeMillis() > this.startedAt + 180000L) {
            String segmentName = req.getParameter("segment");
            String providerName = req.getParameter("provider");
            String id = providerName + "/" + segmentName;
            if (COMMAND_EXECUTE.equals(req.getPathInfo())) {
                if (!runningSegments.containsKey(id)) {
                    try {
                        runningSegments.put(id, Thread.currentThread());
                        this.updateIndex(id, providerName, segmentName, req, res);
                    }
                    catch (Exception e) {
                        new ServiceException(e).log();
                    }
                    finally {
                        runningSegments.remove(id);
                    }
                } else if (!runningSegments.get(id).isAlive() || runningSegments.get(id).isInterrupted()) {
                    Thread t = runningSegments.get(id);
                    System.out.println(new Date() + "  " + "Indexer" + " " + providerName + "/" + segmentName + ": workflow " + t.getId() + " is alive=" + t.isAlive() + "; interrupted=" + t.isInterrupted() + ". Skipping execution.");
                }
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(200);
        res.flushBuffer();
        this.handleRequest(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(200);
        res.flushBuffer();
        this.handleRequest(req, res);
    }
}

