/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.workflow.servlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.jdo.Extent;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.kernel.backend.Accounts;
import org.opencrx.kernel.backend.Activities;
import org.opencrx.kernel.backend.Buildings;
import org.opencrx.kernel.backend.Contracts;
import org.opencrx.kernel.backend.Depots;
import org.opencrx.kernel.backend.Documents;
import org.opencrx.kernel.backend.Forecasts;
import org.opencrx.kernel.backend.Models;
import org.opencrx.kernel.backend.Products;
import org.opencrx.kernel.backend.UserHomes;
import org.opencrx.kernel.backend.Workflows;
import org.opencrx.kernel.base.cci2.AuditEntryQuery;
import org.opencrx.kernel.base.cci2.ExecuteWorkflowParams;
import org.opencrx.kernel.base.cci2.TestAndSetVisitedByParams;
import org.opencrx.kernel.base.jmi1.AuditEntry;
import org.opencrx.kernel.base.jmi1.Auditee;
import org.opencrx.kernel.base.jmi1.ExecuteWorkflowParams;
import org.opencrx.kernel.base.jmi1.Indexed;
import org.opencrx.kernel.base.jmi1.TestAndSetVisitedByParams;
import org.opencrx.kernel.base.jmi1.TestAndSetVisitedByResult;
import org.opencrx.kernel.generic.SecurityKeys;
import org.opencrx.kernel.home1.cci2.SubscriptionMatchesParams;
import org.opencrx.kernel.home1.cci2.SubscriptionQuery;
import org.opencrx.kernel.home1.cci2.TimerQuery;
import org.opencrx.kernel.home1.jmi1.Subscription;
import org.opencrx.kernel.home1.jmi1.SubscriptionMatchesParams;
import org.opencrx.kernel.home1.jmi1.SubscriptionMatchesResult;
import org.opencrx.kernel.home1.jmi1.Timer;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.opencrx.kernel.utils.Utils;
import org.opencrx.kernel.workflow1.cci2.SegmentContainsTopic;
import org.opencrx.kernel.workflow1.jmi1.Segment;
import org.opencrx.kernel.workflow1.jmi1.Topic;
import org.opencrx.kernel.workflow1.jmi1.WfProcess;
import org.opencrx.security.realm1.cci2.User;
import org.openmdx.base.cci2.ExtentCapableQuery;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.BasicObject;
import org.openmdx.base.jmi1.ContextCapable;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.PersistenceHelper;
import org.openmdx.base.rest.cci.QueryExtensionRecord;
import org.openmdx.base.text.conversion.Base64;
import org.openmdx.kernel.log.SysLog;
import org.w3c.cci2.AnyTypePredicate;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class SubscriptionHandlerServlet
extends HttpServlet {
    private static final long serialVersionUID = 7074135054692868453L;
    private static final int BATCH_SIZE = 50;
    private static final String WORKFLOW_NAME = "SubscriptionHandler";
    private static final String COMMAND_EXECUTE = "/execute";
    private static final String VISITOR_ID = "SubscriptionHandler";
    private static final Map<String, Thread> runningSegments = new ConcurrentHashMap<String, Thread>();
    private PersistenceManagerFactory pmf = null;
    private long startedAt = System.currentTimeMillis();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.pmf = Utils.getPersistenceManagerFactory();
        }
        catch (Exception e) {
            throw new ServletException("can not get connection to data provider", (Throwable)e);
        }
    }

    public boolean topicMatchesObjectIdentity(String providerName, String segmentName, Topic topic, String objectXri) {
        String topicPatternXri = topic.getTopicPathPattern();
        if (topicPatternXri != null) {
            Path topicPattern = new Path(topicPatternXri);
            Path objectPath = new Path(objectXri);
            if (topicPattern.size() < 7) {
                return false;
            }
            return objectPath.isLike(topicPattern) && providerName.equals(objectPath.getSegment(2).toString()) && segmentName.equals(objectPath.getSegment(4).toString());
        }
        return false;
    }

    private List<Subscription> findSubscriptions(String providerName, String segmentName, Segment workflowSegment, org.opencrx.kernel.home1.jmi1.Segment userHomeSegment, AuditEntry auditEntry) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)workflowSegment);
        ArrayList<Topic> matchingTopics = new ArrayList<Topic>();
        SegmentContainsTopic.Topic topics = workflowSegment.getTopic();
        Iterator iterator = topics.iterator();
        while (iterator.hasNext()) {
            Topic topic = (Topic)iterator.next();
            if (!this.topicMatchesObjectIdentity(providerName, segmentName, topic, auditEntry.getAuditee())) continue;
            matchingTopics.add(topic);
        }
        ArrayList<Subscription> matchingSubscriptions = null;
        if (!matchingTopics.isEmpty()) {
            matchingSubscriptions = new ArrayList<Subscription>();
            SubscriptionQuery query = (SubscriptionQuery)PersistenceHelper.newQuery((Extent)pm.getExtent(Subscription.class), (Object)new Path("xri://@openmdx*org.opencrx.kernel.home1/provider").getDescendant(new String[]{providerName, "segment", segmentName, "userHome", ":*", "subscription", ":*"}));
            query.thereExistsTopic().elementOf(matchingTopics);
            query.isActive().isTrue();
            List subscriptions = userHomeSegment.getExtent((ExtentCapableQuery)query);
            for (Subscription subscription : subscriptions) {
                SubscriptionMatchesParams params = (SubscriptionMatchesParams)Structures.create(SubscriptionMatchesParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)SubscriptionMatchesParams.Member.message, (Object)auditEntry)});
                SubscriptionMatchesResult result = subscription.matches(params);
                if (!Boolean.TRUE.equals(result.isMatches())) continue;
                matchingSubscriptions.add(subscription);
            }
        }
        return matchingSubscriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeWorkflows(String wfProcessInstanceName, UserHome userHome, Path targetObjectIdentity, Path triggeredByIdentity, Workflows.EventType triggeredByEventType, Collection<WfProcess> wfProcesses) throws ServiceException {
        block18: {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)userHome);
            try (PersistenceManager pmUser = null;){
                pmUser = pm.getPersistenceManagerFactory().getPersistenceManager(userHome.refGetPath().getLastSegment().toString(), null);
                ContextCapable targetObject = null;
                try {
                    targetObject = (ContextCapable)pmUser.getObjectById((Object)targetObjectIdentity);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ContextCapable triggeredBy = null;
                try {
                    triggeredBy = (ContextCapable)pmUser.getObjectById((Object)triggeredByIdentity);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!(targetObject instanceof BasicObject) || !(triggeredBy instanceof BasicObject)) break block18;
                int count = 0;
                for (WfProcess wfProcess : wfProcesses) {
                    try {
                        MessageDigest md = MessageDigest.getInstance("MD5");
                        md.update(targetObjectIdentity.toXRI().getBytes("UTF-8"));
                        md.update(wfProcess.refMofId().getBytes("UTF-8"));
                        ExecuteWorkflowParams params = (ExecuteWorkflowParams)Structures.create(ExecuteWorkflowParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ExecuteWorkflowParams.Member.name, (Object)((wfProcessInstanceName == null || wfProcessInstanceName.isEmpty() ? wfProcess.getName() : wfProcessInstanceName) + (wfProcesses.size() == 1 ? "" : " [" + count + "]"))), Datatypes.member((Enum)ExecuteWorkflowParams.Member.targetObject, (Object)targetObject), Datatypes.member((Enum)ExecuteWorkflowParams.Member.triggeredBy, (Object)pmUser.getObjectById((Object)triggeredBy.refGetPath())), Datatypes.member((Enum)ExecuteWorkflowParams.Member.triggeredByEventId, (Object)Base64.encode((byte[])md.digest()).replace('/', '-')), Datatypes.member((Enum)ExecuteWorkflowParams.Member.triggeredByEventType, (Object)new Integer(triggeredByEventType.getValue())), Datatypes.member((Enum)ExecuteWorkflowParams.Member.workflow, (Object)pmUser.getObjectById((Object)wfProcess.refGetPath()))});
                        try {
                            pmUser.currentTransaction().begin();
                            ((UserHome)pmUser.getObjectById((Object)userHome.refGetPath())).executeWorkflow(params);
                            pmUser.refresh((Object)userHome);
                            pmUser.currentTransaction().commit();
                        }
                        catch (Exception e) {
                            ServiceException e0 = new ServiceException(e);
                            SysLog.warning((String)"Execution of workflow FAILED", (Object)("action=" + (wfProcess == null ? null : wfProcess.getName()) + "; home=" + (userHome == null ? null : userHome.refMofId()) + "; cause=" + (e0.getCause() == null ? null : e0.getCause().getMessage())));
                            if (e0.getExceptionCode() == -34) {
                                e0.log();
                            } else {
                                SysLog.detail((String)e.getMessage(), (Throwable)e.getCause());
                            }
                            try {
                                pmUser.currentTransaction().rollback();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (NoSuchAlgorithmException e) {
                        new ServiceException((Exception)e).log();
                    }
                    catch (UnsupportedEncodingException e) {
                        new ServiceException((Exception)e).log();
                    }
                    ++count;
                }
            }
        }
    }

    private void handleSubscriptions(String providerName, String segmentName, PersistenceManager pm, Segment workflowSegment, org.opencrx.kernel.home1.jmi1.Segment userHomeSegment, List<AuditEntry> auditEntries) throws ServiceException {
        ArrayList<String> auditEntryXris = new ArrayList<String>();
        for (AuditEntry auditEntry : auditEntries) {
            auditEntryXris.add(auditEntry.refMofId());
            if (auditEntryXris.size() <= 50) continue;
            break;
        }
        for (String auditEntryXri : auditEntryXris) {
            List<Subscription> subscriptions;
            AuditEntry auditEntry = null;
            try {
                auditEntry = (AuditEntry)pm.getObjectById((Object)new Path(auditEntryXri));
            }
            catch (Exception e) {
                SysLog.warning((String)"Can not access audit entry", Arrays.asList(auditEntryXri, e.getMessage()));
                SysLog.detail((String)e.getMessage(), (Throwable)e.getCause());
            }
            if (auditEntry == null) continue;
            TestAndSetVisitedByResult markAsVisistedReply = null;
            try {
                TestAndSetVisitedByParams params = (TestAndSetVisitedByParams)Structures.create(TestAndSetVisitedByParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)TestAndSetVisitedByParams.Member.visitorId, (Object)"SubscriptionHandler")});
                markAsVisistedReply = auditEntry.testAndSetVisitedBy(params);
            }
            catch (Exception e) {
                SysLog.error((String)"Can not invoke markAsVisited", (Object)e.getMessage());
                ServiceException e0 = new ServiceException(e);
                SysLog.error((String)e0.getMessage(), (Throwable)e0.getCause());
            }
            if (markAsVisistedReply == null || markAsVisistedReply.getVisitStatus() != 0 || (subscriptions = this.findSubscriptions(providerName, segmentName, workflowSegment, userHomeSegment, auditEntry)) == null) continue;
            for (Subscription subscription : subscriptions) {
                Path userHomeIdentity = subscription.refGetPath().getParent().getParent();
                UserHome userHome = (UserHome)pm.getObjectById((Object)userHomeIdentity);
                User user = userHome.getOwningUser();
                boolean userIsDisabled = false;
                try {
                    userIsDisabled = user.isDisabled();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (userIsDisabled) continue;
                List<WfProcess> actions = subscription.getTopic().getPerformAction();
                this.executeWorkflows(subscription.getName(), userHome, new Path(auditEntry.getAuditee()), subscription.refGetPath(), Workflows.getEventType((ContextCapable)auditEntry), actions);
            }
        }
    }

    public void handleSubscriptions(String id, String providerName, String segmentName, HttpServletRequest req, HttpServletResponse res) throws IOException {
        System.out.println(new Date().toString() + "  " + "SubscriptionHandler" + "[Subscriptions] " + providerName + "/" + segmentName);
        try {
            PersistenceManager pm = this.pmf.getPersistenceManager("admin" + SecurityKeys.ID_SEPARATOR + segmentName, null);
            Workflows.getInstance().initWorkflows(pm, providerName, segmentName);
            ArrayList<Indexed> auditSegments = new ArrayList<Indexed>();
            auditSegments.add(Accounts.getInstance().getAccountSegment(pm, providerName, segmentName));
            auditSegments.add(Activities.getInstance().getActivitySegment(pm, providerName, segmentName));
            auditSegments.add(Buildings.getInstance().getBuildingSegment(pm, providerName, segmentName));
            auditSegments.add(Contracts.getInstance().getContractSegment(pm, providerName, segmentName));
            auditSegments.add(Depots.getInstance().getDepotSegment(pm, providerName, segmentName));
            auditSegments.add(Documents.getInstance().getDocumentSegment(pm, providerName, segmentName));
            auditSegments.add(Forecasts.getInstance().getForecastSegment(pm, providerName, segmentName));
            auditSegments.add(Models.getInstance().getModelSegment(pm, providerName, segmentName));
            auditSegments.add(Products.getInstance().getProductSegment(pm, providerName, segmentName));
            auditSegments.add(UserHomes.getInstance().getUserHomeSegment(pm, providerName, segmentName));
            Segment workflowSegment = Workflows.getInstance().getWorkflowSegment(pm, providerName, segmentName);
            org.opencrx.kernel.home1.jmi1.Segment userHomeSegment = UserHomes.getInstance().getUserHomeSegment(pm, providerName, segmentName);
            for (Auditee auditee : auditSegments) {
                AuditEntryQuery query = (AuditEntryQuery)pm.newQuery(AuditEntry.class);
                query.thereExistsVisitedBy().equalTo((Object)"SubscriptionHandler:-");
                query.orderByCreatedAt().ascending();
                try {
                    List<AuditEntry> auditEntries = auditee.getAudit(query);
                    this.handleSubscriptions(providerName, segmentName, pm, workflowSegment, userHomeSegment, auditEntries);
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                    System.out.println(new Date() + "  " + "SubscriptionHandler" + " " + providerName + "/" + segmentName + ": exception occured " + e.getMessage() + ". Continuing");
                }
            }
            try {
                pm.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            new ServiceException(e).log();
            System.out.println(new Date() + "  " + "SubscriptionHandler" + " " + providerName + "/" + segmentName + ": exception occured " + e.getMessage() + ". Continuing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTimers(String id, String providerName, String segmentName, HttpServletRequest req, HttpServletResponse res) throws IOException {
        block33: {
            System.out.println(new Date().toString() + "  " + "SubscriptionHandler" + "[Timers] " + providerName + "/" + segmentName);
            PersistenceManager pmAdmin = null;
            try {
                pmAdmin = this.pmf.getPersistenceManager("admin" + SecurityKeys.ID_SEPARATOR + segmentName, null);
                String[] TIMER_CLAUSES = new String[]{"(current_timestamp BETWEEN {fn timestampadd(SQL_TSI_MINUTE, trigger_interval_minutes, last_trigger_at)} AND LEAST(timer_end_at, {fn timestampadd(SQL_TSI_MINUTE, trigger_repeat * trigger_interval_minutes, timer_start_at)}))", "(current_timestamp BETWEEN {fn timestampadd(SQL_TSI_MINUTE, trigger_interval_minutes, last_trigger_at)} AND CASE WHEN timer_end_at < {fn timestampadd(SQL_TSI_MINUTE, trigger_repeat * trigger_interval_minutes, timer_start_at)} THEN timer_end_at ELSE {fn timestampadd(SQL_TSI_MINUTE, trigger_repeat * trigger_interval_minutes, timer_start_at)} END)", "(current_timestamp BETWEEN last_trigger_at + trigger_interval_minutes MINUTES AND LEAST(timer_end_at, timer_start_at + (trigger_repeat * trigger_interval_minutes) MINUTES))", "(current_timestamp BETWEEN last_trigger_at + numtodsinterval(trigger_interval_minutes, 'minute') AND LEAST(timer_end_at, timer_start_at + numtodsinterval(trigger_repeat * trigger_interval_minutes, 'minute')))"};
                ArrayList<Path> matchingTimerIdentities = new ArrayList<Path>();
                Exception queryError = null;
                for (String clause : TIMER_CLAUSES) {
                    TimerQuery timerQuery = (TimerQuery)PersistenceHelper.newQuery((Extent)pmAdmin.getExtent(Timer.class), (Object)new Path("xri://@openmdx*org.opencrx.kernel.home1").getDescendant(new String[]{"provider", providerName, "segment", segmentName, "userHome", ":*", "timer", ":*"}));
                    timerQuery.forAllDisabled().isFalse();
                    timerQuery.timerState().equalTo((Object)UserHomes.TimerState.OPEN.getValue());
                    QueryExtensionRecord timerQueryExtension = PersistenceHelper.newQueryExtension((AnyTypePredicate)timerQuery);
                    timerQueryExtension.setClause(clause);
                    org.opencrx.kernel.home1.jmi1.Segment userHomeSegment = UserHomes.getInstance().getUserHomeSegment(pmAdmin, providerName, segmentName);
                    List timers = userHomeSegment.getExtent((ExtentCapableQuery)timerQuery);
                    try {
                        int count = 0;
                        for (Timer timer : timers) {
                            matchingTimerIdentities.add(timer.refGetPath());
                            if (++count <= 50) continue;
                            break;
                        }
                        queryError = null;
                        break;
                    }
                    catch (Exception e) {
                        ServiceException e0 = new ServiceException(e);
                        SysLog.detail((String)e0.getMessage(), (Throwable)e0.getCause());
                        queryError = e;
                    }
                }
                if (queryError != null) {
                    SysLog.log((Level)Level.WARNING, (String)("Unable to retrieve pending timers. For more info see log at level " + Level.FINE), (Object[])new Object[0]);
                    break block33;
                }
                for (Path timerIdentity : matchingTimerIdentities) {
                    PersistenceManager pm = null;
                    try {
                        pm = this.pmf.getPersistenceManager(timerIdentity.getSegment(6).toString(), null);
                        Timer timer = (Timer)pm.getObjectById((Object)timerIdentity);
                        pm.currentTransaction().begin();
                        timer.setLastTriggerAt(new Date());
                        if (timer.getTriggerRepeat() != null && timer.getTriggerRepeat() == 1) {
                            timer.setTimerState((short)UserHomes.TimerState.CLOSED.getValue());
                        }
                        pm.currentTransaction().commit();
                        Path userHomeIdentity = timer.refGetPath().getParent().getParent();
                        UserHome userHome = (UserHome)pm.getObjectById((Object)userHomeIdentity);
                        this.executeWorkflows(timer.getName(), userHome, timer.getTarget() == null ? null : timer.getTarget().refGetPath(), timerIdentity, Workflows.EventType.TIMER, timer.getAction());
                    }
                    catch (Exception e) {
                        new ServiceException(e).log();
                        try {
                            pm.currentTransaction().rollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    finally {
                        try {
                            pm.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception e) {
                new ServiceException(e).log();
                System.out.println(new Date() + "  " + "SubscriptionHandler" + " " + providerName + "/" + segmentName + ": exception occured " + e.getMessage() + ". Continuing");
                try {
                    pmAdmin.currentTransaction().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                try {
                    pmAdmin.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (System.currentTimeMillis() > this.startedAt + 180000L) {
            String segmentName = req.getParameter("segment");
            String providerName = req.getParameter("provider");
            String id = providerName + "/" + segmentName;
            if (COMMAND_EXECUTE.equals(req.getPathInfo())) {
                if (!runningSegments.containsKey(id)) {
                    try {
                        runningSegments.put(id, Thread.currentThread());
                        this.handleTimers(id, providerName, segmentName, req, res);
                        this.handleSubscriptions(id, providerName, segmentName, req, res);
                    }
                    catch (Exception e) {
                        new ServiceException(e).log();
                    }
                    finally {
                        runningSegments.remove(id);
                    }
                } else if (!runningSegments.get(id).isAlive() || runningSegments.get(id).isInterrupted()) {
                    Thread t = runningSegments.get(id);
                    System.out.println(new Date() + "  " + "SubscriptionHandler" + " " + providerName + "/" + segmentName + ": workflow " + t.getId() + " is alive=" + t.isAlive() + "; interrupted=" + t.isInterrupted() + ". Skipping execution.");
                }
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(200);
        res.flushBuffer();
        this.handleRequest(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(200);
        res.flushBuffer();
        this.handleRequest(req, res);
    }
}

