/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.workflow.servlet;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jdo.Extent;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.kernel.backend.UserHomes;
import org.opencrx.kernel.backend.Workflows;
import org.opencrx.kernel.base.cci2.ExecuteWorkflowParams;
import org.opencrx.kernel.base.jmi1.ExecuteWorkflowParams;
import org.opencrx.kernel.generic.SecurityKeys;
import org.opencrx.kernel.home1.cci2.WfProcessInstanceQuery;
import org.opencrx.kernel.home1.jmi1.Segment;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.opencrx.kernel.home1.jmi1.WfProcessInstance;
import org.opencrx.kernel.utils.ScriptUtils;
import org.opencrx.kernel.utils.Utils;
import org.opencrx.kernel.workflow1.jmi1.WfProcess;
import org.openmdx.base.cci2.ExtentCapableQuery;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.ContextCapable;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.PersistenceHelper;
import org.openmdx.kernel.loading.Classes;
import org.openmdx.kernel.log.SysLog;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class WorkflowHandlerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1260441904508971604L;
    private static final String WORKFLOW_NAME = "WorkflowHandler";
    private static final String COMMAND_EXECUTE = "/execute";
    private static final long MAX_RETRY_DELAY_MILLIS = 604800000L;
    private static final Map<String, Thread> runningSegments = new ConcurrentHashMap<String, Thread>();
    private static final int BATCH_SIZE = 500;
    private static final int MAX_THREADS = 5;
    private PersistenceManagerFactory pmf = null;
    private long startedAt = System.currentTimeMillis();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.pmf = Utils.getPersistenceManagerFactory();
        }
        catch (Exception e) {
            throw new ServletException("Can not get connection to data provider", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processPendingWorklows(String id, String providerName, String segmentName, boolean isAtomic, HttpServletRequest req, HttpServletResponse res) throws IOException {
        System.out.println(new Date().toString() + "  " + WORKFLOW_NAME + " " + id);
        SysLog.detail((String)("WorkflowHandler " + id));
        try {
            ArrayList<Path> wfProcessInstanceIdentities;
            PersistenceManager pm;
            block16: {
                pm = this.pmf.getPersistenceManager("admin" + SecurityKeys.ID_SEPARATOR + segmentName, null);
                Workflows.getInstance().initWorkflows(pm, providerName, segmentName);
                wfProcessInstanceIdentities = new ArrayList<Path>();
                if (req.getParameter("xri") != null) {
                    String xri = req.getParameter("xri");
                    try {
                        WfProcessInstance wfProcessInstance = (WfProcessInstance)pm.getObjectById((Object)new Path(xri));
                        if (wfProcessInstance.getStartedOn() == null) {
                            wfProcessInstanceIdentities.add(wfProcessInstance.refGetPath());
                            break block16;
                        }
                        System.out.println(new Date() + "  " + WORKFLOW_NAME + " " + id + ": Ignoring " + xri + ". Workflow already completed.");
                    }
                    catch (Exception e) {
                        System.out.println(new Date() + "  " + WORKFLOW_NAME + " " + id + ": unable to retrieve workflow " + xri);
                    }
                } else {
                    Segment userHomeSegment = UserHomes.getInstance().getUserHomeSegment(pm, providerName, segmentName);
                    WfProcessInstanceQuery query = (WfProcessInstanceQuery)PersistenceHelper.newQuery((Extent)pm.getExtent(WfProcessInstance.class), (Object)userHomeSegment.refGetPath().getDescendant(new String[]{"userHome", ":*", "wfProcessInstance", ":*"}));
                    query.startedOn().isNull();
                    query.orderByStepCounter().ascending();
                    query.orderByCreatedAt().ascending();
                    List list = userHomeSegment.getExtent((ExtentCapableQuery)query);
                    for (WfProcessInstance wfInstance : list) {
                        wfProcessInstanceIdentities.add(wfInstance.refGetPath());
                        if (wfProcessInstanceIdentities.size() <= 500) continue;
                        break;
                    }
                }
            }
            SysLog.info((String)"Executing workflows");
            ArrayList<WorkflowExecutorThread> threads = new ArrayList<WorkflowExecutorThread>();
            if (isAtomic) {
                void var11_19;
                int batchSize = wfProcessInstanceIdentities.size() / 5 + 1;
                boolean bl = false;
                while (var11_19 < 5) {
                    WorkflowExecutorThread t = new WorkflowExecutorThread(segmentName, wfProcessInstanceIdentities, isAtomic, (int)(var11_19 * batchSize), (int)((var11_19 + true) * batchSize), this.pmf);
                    threads.add(t);
                    t.start();
                    ++var11_19;
                }
            } else {
                WorkflowExecutorThread t = new WorkflowExecutorThread(segmentName, wfProcessInstanceIdentities, isAtomic, 0, wfProcessInstanceIdentities.size(), this.pmf);
                threads.add(t);
                t.start();
            }
            for (Thread thread : threads) {
                try {
                    thread.join();
                }
                catch (Exception exception) {}
            }
            try {
                pm.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            ServiceException e0 = new ServiceException(e);
            System.out.println(new Date() + "  " + WORKFLOW_NAME + " " + id + ": Exception occured " + e0.getMessage() + ". Continuing");
            SysLog.warning((String)("Exception occured " + e0.getMessage() + ". Continuing"));
            SysLog.detail((String)e0.getMessage(), (Throwable)e0.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (System.currentTimeMillis() > this.startedAt + 180000L) {
            String segmentName = request.getParameter("segment");
            String providerName = request.getParameter("provider");
            String baseId = providerName + "/" + segmentName;
            if (COMMAND_EXECUTE.equals(request.getPathInfo())) {
                for (boolean isAtomic : Arrays.asList(false, true)) {
                    String id = baseId + "[isAtomic=" + isAtomic + "]";
                    if (!runningSegments.containsKey(id)) {
                        try {
                            runningSegments.put(id, Thread.currentThread());
                            this.processPendingWorklows(id, providerName, segmentName, isAtomic, request, response);
                            continue;
                        }
                        catch (Exception e) {
                            SysLog.warning((String)e.getMessage(), (Throwable)e.getCause());
                            continue;
                        }
                        finally {
                            runningSegments.remove(id);
                            continue;
                        }
                    }
                    if (runningSegments.get(id).isAlive() && !runningSegments.get(id).isInterrupted()) continue;
                    Thread t = runningSegments.get(id);
                    System.out.println(new Date() + "  " + WORKFLOW_NAME + " " + id + ": workflow " + t.getId() + " is alive=" + t.isAlive() + "; interrupted=" + t.isInterrupted() + ". Skipping execution.");
                }
            } else {
                SysLog.warning((String)("WorkflowHandler " + baseId + ". Ignoring command. Running segments are"), runningSegments);
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(200);
        res.flushBuffer();
        this.handleRequest(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(200);
        res.flushBuffer();
        this.handleRequest(req, res);
    }

    public class WorkflowExecutorThread
    extends Thread {
        private final List<Path> wfProcessInstanceIdentities;
        private final boolean isAtomic;
        private final int beginIndex;
        private final int endIndex;
        private final PersistenceManager pm;

        public WorkflowExecutorThread(String segmentName, List<Path> wfProcessInstanceIdentities, boolean isAtomic, int beginIndex, int endIndex, PersistenceManagerFactory pmf) {
            this.wfProcessInstanceIdentities = wfProcessInstanceIdentities;
            this.isAtomic = isAtomic;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
            this.pm = pmf.getPersistenceManager("admin" + SecurityKeys.ID_SEPARATOR + segmentName, null);
        }

        private ExecutionStatus executeWorkflow(WfProcessInstance wfInstance, boolean isAtomic) {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)wfInstance);
            SysLog.info((String)"Execute", (Object)wfInstance.getProcess().getName());
            try {
                WfProcess wfProcess = wfInstance.getProcess();
                String workflowName = wfProcess.getName();
                Boolean isSynchronous = wfProcess.isSynchronous();
                if (Boolean.TRUE.equals(isSynchronous)) {
                    if (isAtomic) {
                        UserHome userHome = (UserHome)pm.getObjectById((Object)wfInstance.refGetPath().getParent().getParent());
                        ContextCapable targetObject = null;
                        try {
                            targetObject = (ContextCapable)pm.getObjectById((Object)wfInstance.getTargetObject());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (targetObject != null) {
                            ExecuteWorkflowParams params = (ExecuteWorkflowParams)Structures.create(ExecuteWorkflowParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ExecuteWorkflowParams.Member.targetObject, (Object)targetObject), Datatypes.member((Enum)ExecuteWorkflowParams.Member.triggeredByEventId, (Object)wfInstance.refGetPath().getLastSegment().toString()), Datatypes.member((Enum)ExecuteWorkflowParams.Member.workflow, (Object)wfInstance.getProcess())});
                            try {
                                pm.currentTransaction().begin();
                                userHome.executeWorkflow(params);
                                pm.currentTransaction().commit();
                                pm.refresh((Object)wfInstance);
                                return wfInstance.getStartedOn() == null ? ExecutionStatus.FAILED : ExecutionStatus.SUCCESS;
                            }
                            catch (Exception e) {
                                SysLog.warning((String)"Can not execute workflow. Exception occurred", (Object)("Workflow instance=" + wfInstance + "; home=" + userHome.refGetPath()));
                                SysLog.warning((String)e.getMessage(), (Throwable)e.getCause());
                                try {
                                    pm.currentTransaction().rollback();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return ExecutionStatus.FAILED;
                            }
                        }
                        SysLog.warning((String)"Can not execute workflow. Target object not accessible", (Object)("Workflow instance=" + wfInstance + "; home=" + userHome.refGetPath()));
                        return ExecutionStatus.FAILED;
                    }
                    return ExecutionStatus.SKIPPED;
                }
                if (wfProcess.getExecuteScript() == null || wfProcess.getExecuteScript().isEmpty()) {
                    Workflows.AsynchronousWorkflow workflow = null;
                    Class workflowClass = null;
                    try {
                        workflowClass = Classes.getApplicationClass((String)workflowName);
                    }
                    catch (ClassNotFoundException e) {
                        SysLog.error((String)("Implementation for workflow " + workflowName + " not found"));
                        return ExecutionStatus.FAILED;
                    }
                    Constructor workflowConstructor = null;
                    try {
                        workflowConstructor = workflowClass.getConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        SysLog.error((String)("No constructor found for workflow " + workflowName));
                    }
                    try {
                        workflow = (Workflows.AsynchronousWorkflow)workflowConstructor.newInstance(new Object[0]);
                    }
                    catch (InstantiationException e) {
                        SysLog.error((String)"Can not create workflow (can not instantiate)", (Object)workflowName);
                        return ExecutionStatus.FAILED;
                    }
                    catch (IllegalAccessException e) {
                        SysLog.error((String)"Can not create workflow (illegal access)", (Object)workflowName);
                        return ExecutionStatus.FAILED;
                    }
                    catch (IllegalArgumentException e) {
                        SysLog.error((String)"Can not create workflow (illegal argument)", (Object)workflowName);
                        return ExecutionStatus.FAILED;
                    }
                    catch (InvocationTargetException e) {
                        SysLog.error((String)"Can not create workflow (can not invoke target)", (Object)(workflowName + "(" + e.getTargetException().getMessage() + ")"));
                        return ExecutionStatus.FAILED;
                    }
                    if (isAtomic == workflow.isAtomic()) {
                        workflow.execute(wfInstance);
                        SysLog.info((String)"SUCCESS");
                        return ExecutionStatus.SUCCESS;
                    }
                    return ExecutionStatus.SKIPPED;
                }
                Class<?> workflowClass = ScriptUtils.getClass(wfProcess.getExecuteScript());
                Method executeMethod = null;
                try {
                    executeMethod = workflowClass.getMethod("execute", WfProcessInstance.class);
                }
                catch (NoSuchMethodException e) {
                    SysLog.error((String)("No method 'public static void execute(WfProcessInstance) {}' defined in script for workflow " + workflowName));
                }
                Method isAtomicMethod = null;
                try {
                    isAtomicMethod = workflowClass.getMethod("isAtomic", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    SysLog.error((String)("No method 'public static boolean isAtomic() {}' defined in script for workflow " + workflowName));
                }
                if (isAtomic == (Boolean)isAtomicMethod.invoke(null, new Object[0])) {
                    executeMethod.invoke(null, wfInstance);
                    SysLog.info((String)"SUCCESS");
                    return ExecutionStatus.SUCCESS;
                }
                return ExecutionStatus.SKIPPED;
            }
            catch (Exception e) {
                SysLog.warning((String)"FAILED", (Object)e.getMessage());
                new ServiceException(e).log();
                return ExecutionStatus.FAILED;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (int i = this.beginIndex; i < Math.min(this.endIndex, this.wfProcessInstanceIdentities.size()); ++i) {
                    boolean maxRetryDelayReached;
                    Path wfProcessInstanceIdentity = this.wfProcessInstanceIdentities.get(i);
                    WfProcessInstance wfProcessInstance = (WfProcessInstance)this.pm.getObjectById((Object)wfProcessInstanceIdentity);
                    int stepCounter = wfProcessInstance.getStepCounter() == null ? 0 : wfProcessInstance.getStepCounter();
                    boolean maxRetriesReached = wfProcessInstance.getProcess().getMaxRetries() != null && stepCounter >= wfProcessInstance.getProcess().getMaxRetries();
                    int retryDelayMillis = (1 << stepCounter) * 1000;
                    boolean bl = maxRetryDelayReached = (long)retryDelayMillis > 604800000L;
                    if (!maxRetriesReached && !maxRetryDelayReached && (wfProcessInstance.getLastActivityOn() == null ? 0L : wfProcessInstance.getLastActivityOn().getTime()) + (long)retryDelayMillis < new Date().getTime()) {
                        Date startedOn = new Date();
                        ExecutionStatus status = this.executeWorkflow(wfProcessInstance, this.isAtomic);
                        if (status == ExecutionStatus.SUCCESS) {
                            try {
                                this.pm.refresh((Object)wfProcessInstance);
                                this.pm.currentTransaction().begin();
                                wfProcessInstance.setStartedOn(startedOn);
                                wfProcessInstance.setFailed(Boolean.FALSE);
                                wfProcessInstance.setLastActivityOn(new Date());
                                wfProcessInstance.setStepCounter(new Integer(wfProcessInstance.getStepCounter() + 1));
                                this.pm.currentTransaction().commit();
                            }
                            catch (Exception e) {
                                SysLog.info((String)e.getMessage(), (Throwable)e.getCause());
                                try {
                                    this.pm.currentTransaction().rollback();
                                }
                                catch (Exception exception) {}
                            }
                            continue;
                        }
                        if (status != ExecutionStatus.FAILED) continue;
                        try {
                            this.pm.currentTransaction().begin();
                            wfProcessInstance.setLastActivityOn(new Date());
                            wfProcessInstance.setStepCounter(new Integer(wfProcessInstance.getStepCounter() + 1));
                            this.pm.currentTransaction().commit();
                        }
                        catch (Exception e) {
                            SysLog.info((String)e.getMessage(), (Throwable)e.getCause());
                            try {
                                this.pm.currentTransaction().rollback();
                            }
                            catch (Exception exception) {}
                        }
                        continue;
                    }
                    if (!maxRetryDelayReached && !maxRetriesReached) continue;
                    try {
                        this.pm.currentTransaction().begin();
                        wfProcessInstance.setStartedOn(new Date());
                        wfProcessInstance.setFailed(Boolean.TRUE);
                        this.pm.currentTransaction().commit();
                        continue;
                    }
                    catch (Exception e) {
                        SysLog.info((String)e.getMessage(), (Throwable)e.getCause());
                        try {
                            this.pm.currentTransaction().rollback();
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            finally {
                try {
                    this.pm.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    static enum ExecutionStatus {
        SUCCESS,
        FAILED,
        SKIPPED;

    }
}

