/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.client;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.transform.stream.StreamResult;
import org.opencrx.application.airsync.backend.cci.ClientProfile;
import org.opencrx.application.airsync.backend.cci.GetChangedDataItemsResult;
import org.opencrx.application.airsync.backend.cci.SyncBackend;
import org.opencrx.application.airsync.client.AbstractClientHandler;
import org.opencrx.application.airsync.client.ClientHandler;
import org.opencrx.application.airsync.datatypes.AttendeeT;
import org.opencrx.application.airsync.datatypes.ContactT;
import org.opencrx.application.airsync.datatypes.DataFormatFactory;
import org.opencrx.application.airsync.datatypes.DataType;
import org.opencrx.application.airsync.datatypes.EmailT;
import org.opencrx.application.airsync.datatypes.EventT;
import org.opencrx.application.airsync.datatypes.FolderType;
import org.opencrx.application.airsync.datatypes.IData;
import org.opencrx.application.airsync.datatypes.IDataFormat;
import org.opencrx.application.airsync.datatypes.SyncCollection;
import org.opencrx.application.airsync.datatypes.SyncDataItem;
import org.opencrx.application.airsync.utils.DOMUtils;
import org.opencrx.application.airsync.utils.WbXMLTransformer;
import org.openmdx.base.exception.ServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SyncHandler
extends AbstractClientHandler {
    private static final int DEFAULT_BATCH_SIZE = 50;
    private final int batchSize;

    public SyncHandler(SyncBackend backend) {
        this(backend, 50);
    }

    public SyncHandler(SyncBackend backend, int batchSize) {
        super(backend);
        this.batchSize = batchSize;
    }

    @Override
    public void handle(ClientHandler.SyncTarget target, String userId, String profileName, Object context) throws ServiceException {
        try {
            SyncBackend backend = this.getBackend();
            SyncBackend.RequestContext requestContext = backend.newRequestContext(userId, context);
            ClientProfile clientProfile = backend.getClientProfile(requestContext, profileName);
            block10: for (ClientProfile.Folder folder : clientProfile.getFolders()) {
                String collectionId = folder.getServerId();
                String folderId = folder.getClientId();
                FolderType folderType = folder.getType();
                ClientProfile.Folder.ItemIdMappings itemIdMappings = folder.getItemIdMappings();
                if (collectionId == null || collectionId.length() <= 0) continue;
                DataType collectionType = null;
                switch (folderType) {
                    case DEFAULT_TASKS_FOLDER: 
                    case USER_CREATED_TASKS_FOLDER: {
                        collectionType = DataType.Tasks;
                        break;
                    }
                    case DEFAULT_CALENDAR_FOLDER: 
                    case USER_CREATED_CALENDAR_FOLDER: {
                        collectionType = DataType.Calendar;
                        break;
                    }
                    case DEFAULT_CONTACTS_FOLDER: 
                    case USER_CREATED_CONTACTS_FOLDER: {
                        collectionType = DataType.Contacts;
                        break;
                    }
                    case USER_CREATED_EMAIL_FOLDER: {
                        collectionType = DataType.Email;
                    }
                }
                if (collectionType == null) continue;
                String syncKeyClient = folder.getSyncKeyClient();
                ArrayList changedDataItems = null;
                List<String> deletedItemIds = null;
                if (folder.getSyncKeyServer() != null && !folder.getSyncKeyServer().isEmpty() && !"0".equals(folder.getSyncKeyServer())) {
                    changedDataItems = new ArrayList();
                    if (syncKeyClient == null || "0".equals(syncKeyClient)) {
                        syncKeyClient = "0";
                        folder.setSyncKeyClient("0");
                        folder.setGeneration(folder.getGeneration() + 1);
                    }
                    SyncCollection clientCollection = new SyncCollection();
                    clientCollection.setCollectionId(folderId);
                    clientCollection.setSyncKey(syncKeyClient);
                    clientCollection.setDataType(collectionType);
                    HashSet<String> excludes = new HashSet<String>();
                    logger.log(Level.FINE, "Get new items for client collection {0} and syncKey {1}", new String[]{clientCollection.getCollectionId(), syncKeyClient});
                    GetChangedDataItemsResult getNewDataItemsResult = backend.getChangedDataItems(requestContext, profileName, clientCollection, false, this.batchSize, SyncDataItem.State.NEW, excludes);
                    for (List<SyncDataItem> list : getNewDataItemsResult.getDataItems().values()) {
                        for (SyncDataItem dataItem : list) {
                            excludes.add(dataItem.getServerId());
                        }
                    }
                    logger.log(Level.FINE, "Get changed items for client collection {0} and syncKey {1}", new String[]{clientCollection.getCollectionId(), syncKeyClient});
                    GetChangedDataItemsResult getChangedDataItemsResult = backend.getChangedDataItems(requestContext, profileName, clientCollection, false, this.batchSize, SyncDataItem.State.MODIFIED, excludes);
                    syncKeyClient = getNewDataItemsResult.getDataItems().isEmpty() ? getChangedDataItemsResult.getSyncKey() : (getChangedDataItemsResult.getDataItems().isEmpty() ? getNewDataItemsResult.getSyncKey() : (getNewDataItemsResult.getSyncKey().compareTo(getChangedDataItemsResult.getSyncKey()) < 0 ? getNewDataItemsResult.getSyncKey() : getChangedDataItemsResult.getSyncKey()));
                    for (Map.Entry<String, List<SyncDataItem>> entries : getNewDataItemsResult.getDataItems().entrySet()) {
                        if (entries.getKey().compareTo(syncKeyClient) > 0) continue;
                        changedDataItems.addAll(entries.getValue());
                    }
                    for (Map.Entry<String, List<SyncDataItem>> entries : getChangedDataItemsResult.getDataItems().entrySet()) {
                        if (entries.getKey().compareTo(syncKeyClient) > 0) continue;
                        changedDataItems.addAll(entries.getValue());
                    }
                    logger.log(Level.FINE, "Next SyncKey.Client is {0}", syncKeyClient);
                    deletedItemIds = backend.getDeletedDataItems(requestContext, profileName, clientCollection, syncKeyClient);
                    if (changedDataItems.isEmpty()) {
                        for (ClientProfile.Folder.ItemIdMapping mapping : itemIdMappings.getOldMappings()) {
                            deletedItemIds.add(mapping.getClientId());
                        }
                    }
                }
                logger.log(Level.FINE, "Number of changed data items is {0}", changedDataItems == null ? 0 : changedDataItems.size());
                int slicePos = 0;
                List<Object> changedDataItemsSlice = changedDataItems == null ? Collections.emptyList() : changedDataItems.subList(slicePos, Math.min(slicePos + this.batchSize, changedDataItems.size()));
                List<String> deletedItemIdsSlice = deletedItemIds == null ? Collections.emptyList() : deletedItemIds;
                deletedItemIds = null;
                while (true) {
                    String syncKeyServer = folder.getSyncKeyServer();
                    Document document = DOMUtils.createDoc("AirSync:", "Sync", {"xmlns:Email", "POOMMAIL:"}, {"xmlns:Email2", "POOMMAIL2:"}, {"xmlns:Contacts", "POOMCONTACTS:"}, {"xmlns:Contacts2", "POOMCONTACTS2:"}, {"xmlns:Tasks", "POOMTASKS:"}, {"xmlns:Calendar", "POOMCAL:"}, {"xmlns:AirSyncBase", "AirSyncBase:"});
                    Element eRoot = document.getDocumentElement();
                    Element eCollections = DOMUtils.createElement(eRoot, null, "Collections");
                    Element eCollection = DOMUtils.createElement(eCollections, null, "Collection");
                    DOMUtils.createElementAndText(eCollection, null, "Class", collectionType.toString());
                    DOMUtils.createElementAndText(eCollection, null, "SyncKey", syncKeyServer == null || syncKeyServer.isEmpty() ? "0" : syncKeyServer);
                    DOMUtils.createElementAndText(eCollection, null, "CollectionId", collectionId);
                    if (syncKeyServer != null && !folder.getSyncKeyServer().isEmpty() && !"0".equals(syncKeyServer)) {
                        DOMUtils.createElement(eCollection, null, "GetChanges");
                        DOMUtils.createElementAndText(eCollection, null, "WindowSize", Integer.toString(this.batchSize));
                        if (!changedDataItemsSlice.isEmpty() || !deletedItemIdsSlice.isEmpty()) {
                            IDataFormat dataFormat = DataFormatFactory.getXmlFormat(collectionType);
                            Element eCommands = DOMUtils.createElement(eCollection, null, "Commands");
                            for (SyncDataItem changedItem : changedDataItemsSlice) {
                                String clientId = changedItem.getServerId();
                                String serverId = itemIdMappings.getServerId(clientId);
                                Element eCommand = null;
                                if (serverId == null) {
                                    if (collectionType != DataType.Email) {
                                        eCommand = DOMUtils.createElement(eCommands, null, "Add");
                                        DOMUtils.createElementAndText(eCommand, null, "ClientId", clientId);
                                    }
                                } else {
                                    itemIdMappings.updateMappings(clientId, serverId);
                                    if (collectionType != DataType.Email) {
                                        eCommand = DOMUtils.createElement(eCommands, null, "Change");
                                        DOMUtils.createElementAndText(eCommand, null, "ServerId", serverId);
                                    }
                                    if (changedItem.getData() instanceof EventT) {
                                        EventT eventT = (EventT)changedItem.getData();
                                        eventT.setOrganizerName(null);
                                        eventT.setOrganizerEmail(null);
                                    }
                                }
                                if (eCommand == null) continue;
                                Element eApplicationData = DOMUtils.createElement(eCommand, null, "ApplicationData");
                                if (changedItem.getData() instanceof EventT) {
                                    EventT eventT = (EventT)changedItem.getData();
                                    eventT.setTimezone("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAoAAAAFAAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAFAAIAAAAAAAAAAAAAAA==");
                                    for (AttendeeT attendeeT : eventT.getAttendees()) {
                                        attendeeT.setAttendeeStatus(null);
                                        attendeeT.setAttendeeType(null);
                                    }
                                } else if (changedItem.getData() instanceof ContactT) {
                                    ContactT contactT = (ContactT)changedItem.getData();
                                    contactT.setAlias(null);
                                }
                                dataFormat.format(eApplicationData, changedItem.getData(), 2.5);
                            }
                            for (String itemId : deletedItemIdsSlice) {
                                String serverId = itemIdMappings.getServerId(itemId);
                                if (serverId == null) continue;
                                itemIdMappings.removeAllMappingsByClientId(itemId);
                                Element eCommand = DOMUtils.createElement(eCommands, null, "Delete");
                                DOMUtils.createElementAndText(eCommand, null, "ServerId", serverId);
                            }
                        }
                    }
                    logger.log(Level.FINE, "Syncing with server for collection {0}", collectionId);
                    Document docResponse = (Document)target.perform("Sync", clientProfile.getPolicyKey() == null ? "0" : clientProfile.getPolicyKey(), clientProfile.getUserAgent(), document);
                    eRoot = docResponse.getDocumentElement();
                    NodeList lCollection = eRoot.getElementsByTagNameNS("AirSync:", "Collection");
                    for (int i = 0; i < lCollection.getLength(); ++i) {
                        try {
                            eCollection = (Element)lCollection.item(i);
                            SyncCollection responseCollection = SyncCollection.decode("AirSync:", eCollection);
                            if (!collectionId.equals(responseCollection.getCollectionId())) continue;
                            logger.log(Level.FINE, "Processing response for collection {0}. SyncKey={1}", new String[]{collectionId, responseCollection.getSyncKey()});
                            Element eCommands = DOMUtils.getUniqueElement(eCollection, "AirSync:", "Commands");
                            logger.log(Level.FINE, "Processing commands for collection {0}", collectionId);
                            if (eCommands != null) {
                                NodeList lCommand = eCommands.getChildNodes();
                                for (int j = 0; j < lCommand.getLength(); ++j) {
                                    ClientProfile.Folder.ItemIdMapping mapping;
                                    Node node = lCommand.item(j);
                                    if (!(node instanceof Element)) continue;
                                    Element eCommand = (Element)node;
                                    String command = eCommand.getNodeName();
                                    String serverId = DOMUtils.getElementText(eCommand, "AirSync:", "ServerId");
                                    String clientId = DOMUtils.getElementText(eCommand, "AirSync:", "ClientId");
                                    if (clientId == null && serverId != null && (mapping = itemIdMappings.getMappingByClientId(serverId)) != null) {
                                        clientId = mapping.getClientId();
                                    }
                                    logger.log(Level.FINE, "Decode element {0}", serverId);
                                    Element eApplicationData = DOMUtils.getUniqueElement(eCommand, "AirSync:", "ApplicationData");
                                    IDataFormat dataDecoder = DataFormatFactory.getXmlFormat(responseCollection.getDataType());
                                    IData data = null;
                                    if (eApplicationData != null) {
                                        data = dataDecoder.parse(eApplicationData);
                                    }
                                    logger.log(Level.FINE, "Processing element {0}", serverId);
                                    if (folderId == null) continue;
                                    SyncCollection collection = new SyncCollection();
                                    collection.setCollectionId(folderId);
                                    collection.setDataType(collectionType);
                                    if (command.endsWith("Modify")) {
                                        clientId = backend.createOrUpdateDataItem(requestContext, profileName, collection, clientId, data);
                                    } else if (command.endsWith("Add")) {
                                        if (collectionType == DataType.Email) {
                                            EmailT emailT;
                                            Element eApplicationDataFetch;
                                            NodeList lApplicationDataFetch;
                                            Document fetchRequestDoc = DOMUtils.createDoc("AirSync:", "Sync", {"xmlns:Email", "POOMMAIL:"}, {"xmlns:Email2", "POOMMAIL2:"}, {"xmlns:AirSyncBase", "AirSyncBase:"});
                                            Element eRootFetch = fetchRequestDoc.getDocumentElement();
                                            Element eCollectionsFetch = DOMUtils.createElement(eRootFetch, null, "Collections");
                                            Element eCollectionFetch = DOMUtils.createElement(eCollectionsFetch, null, "Collection");
                                            DOMUtils.createElementAndText(eCollectionFetch, null, "Class", collectionType.toString());
                                            DOMUtils.createElementAndText(eCollectionFetch, null, "SyncKey", responseCollection.getSyncKey());
                                            DOMUtils.createElementAndText(eCollectionFetch, null, "CollectionId", responseCollection.getCollectionId());
                                            Element eOptionsFetch = DOMUtils.createElement(eCollectionFetch, null, "Options");
                                            DOMUtils.createElementAndText(eOptionsFetch, null, "MIMESupport", "2");
                                            Element eCommandsFetch = DOMUtils.createElement(eCollectionFetch, null, "Commands");
                                            Element eCommandFetch = DOMUtils.createElement(eCommandsFetch, null, "Fetch");
                                            DOMUtils.createElementAndText(eCommandFetch, null, "ServerId", serverId);
                                            Document fetchResponseDoc = (Document)target.perform("Sync", null, clientProfile.getUserAgent(), fetchRequestDoc);
                                            if (logger.isLoggable(Level.FINE)) {
                                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                                WbXMLTransformer.transform(fetchResponseDoc, new StreamResult(out), true);
                                                out.close();
                                                logger.log(Level.FINE, "+-+-+-+-+- Response +-+-+-+-+-");
                                                logger.log(Level.FINE, out.toString());
                                            }
                                            if ((lApplicationDataFetch = (eRootFetch = fetchResponseDoc.getDocumentElement()).getElementsByTagNameNS("AirSync:", "ApplicationData")).getLength() > 0 && (eApplicationDataFetch = (Element)lApplicationDataFetch.item(0)) != null && (emailT = (EmailT)dataDecoder.parse(eApplicationDataFetch)).getMimeData() != null) {
                                                data = emailT;
                                            }
                                        }
                                        clientId = backend.createOrUpdateDataItem(requestContext, profileName, collection, clientId, data);
                                    } else if (command.endsWith("Change")) {
                                        clientId = backend.createOrUpdateDataItem(requestContext, profileName, collection, clientId, data);
                                    } else if (command.endsWith("Delete") && clientId != null) {
                                        backend.deleteDataItem(requestContext, profileName, collection, clientId);
                                        itemIdMappings.removeAllMappingsByClientId(clientId);
                                        clientId = null;
                                    }
                                    if (clientId == null || serverId == null || clientId.length() <= 0 || serverId.length() <= 0) continue;
                                    itemIdMappings.updateMappings(clientId, serverId);
                                }
                            }
                            logger.log(Level.FINE, "Processing responses for collection {0}", collectionId);
                            Element eResponses = DOMUtils.getUniqueElement(eCollection, "AirSync:", "Responses");
                            if (eResponses != null) {
                                NodeList lResponse = eResponses.getChildNodes();
                                for (int j = 0; j < lResponse.getLength(); ++j) {
                                    Node node = lResponse.item(j);
                                    if (!(node instanceof Element)) continue;
                                    Element eCommand = (Element)node;
                                    String command = eCommand.getNodeName();
                                    String serverId = DOMUtils.getElementText(eCommand, "AirSync:", "ServerId");
                                    String clientId = DOMUtils.getElementText(eCommand, "AirSync:", "ClientId");
                                    if (folderId == null) continue;
                                    if (command.endsWith("Add")) {
                                        if (clientId == null || serverId == null || clientId.length() <= 0 || serverId.length() <= 0) continue;
                                        itemIdMappings.updateMappings(clientId, serverId);
                                        continue;
                                    }
                                    if (!command.endsWith("Delete") || serverId.length() <= 0) continue;
                                    itemIdMappings.removeAllMappingsByServerId(serverId);
                                }
                            }
                            logger.log(Level.FINE, "Test for locally touched items for collection {0}", collectionId);
                            if (syncKeyServer != null && !folder.getSyncKeyServer().isEmpty() && !"0".equals(syncKeyServer)) {
                                SyncCollection clientCollection = new SyncCollection();
                                clientCollection.setCollectionId(folderId);
                                clientCollection.setSyncKey(syncKeyClient);
                                clientCollection.setDataType(collectionType);
                                GetChangedDataItemsResult getChangedDataItemsResult = backend.getChangedDataItems(requestContext, profileName, clientCollection, true, 1, SyncDataItem.State.MODIFIED, Collections.emptySet());
                                if (getChangedDataItemsResult.getSyncKey().equals(requestContext.getSyncKey())) {
                                    syncKeyClient = requestContext.getSyncKey();
                                }
                            }
                            folder.setSyncKeyServer(responseCollection.getSyncKey());
                            logger.log(Level.FINE, "Set SyncKey.Server to {0} for collection {1}", new String[]{responseCollection.getSyncKey(), folder.getName()});
                            folder.setSyncKeyClient("0".equals(syncKeyClient) ? backend.getNextSyncKey(requestContext, syncKeyClient) : syncKeyClient);
                            continue;
                        }
                        catch (Exception e) {
                            new ServiceException(e).log();
                        }
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        WbXMLTransformer.transform(docResponse, new StreamResult(out), true);
                        out.close();
                        logger.log(Level.FINE, "+-+-+-+-+- Response +-+-+-+-+-");
                        logger.log(Level.FINE, out.toString());
                    }
                    if (changedDataItems == null || (slicePos += this.batchSize) >= changedDataItems.size()) continue block10;
                    changedDataItemsSlice = changedDataItems.subList(slicePos, Math.min(slicePos + this.batchSize, changedDataItems.size()));
                }
            }
            backend.updateClientProfile(requestContext, clientProfile, null, false, false);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }
}

