/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.datatypes;

import org.opencrx.application.airsync.datatypes.AbstractXmlFormat;
import org.opencrx.application.airsync.datatypes.ContactT;
import org.opencrx.application.airsync.datatypes.IData;
import org.opencrx.application.airsync.utils.DOMUtils;
import org.opencrx.kernel.utils.Utils;
import org.w3c.dom.Element;
import org.w3c.format.DateTimeFormat;

public class ContactTXmlFormat
extends AbstractXmlFormat {
    @Override
    public void format(Element eParent, IData data, double protocolVersion) {
        String body;
        ContactT contactT = (ContactT)data;
        DateTimeFormat eutcf = DateTimeFormat.EXTENDED_UTC_FORMAT;
        this.createElement(eParent, "Contacts:", "Alias", contactT.getAlias());
        if (contactT.getAnniversary() != null) {
            this.createElement(eParent, "Contacts:", "Anniversary", eutcf.format(contactT.getAnniversary()));
        }
        this.createElement(eParent, "Contacts:", "AssistantName", contactT.getAssistantName());
        this.createElement(eParent, "Contacts:", "AssistantTelephoneNumber", contactT.getAssistantPhoneNumber());
        this.createElement(eParent, "Contacts:", "AssistnamePhoneNumber", contactT.getAssistnamePhoneNumber());
        if (contactT.getBirthday() != null) {
            this.createElement(eParent, "Contacts:", "Birthday", eutcf.format(contactT.getBirthday()));
        }
        this.createElement(eParent, "Contacts:", "Business2PhoneNumber", contactT.getBusiness2PhoneNumber());
        this.createElement(eParent, "Contacts:", "BusinessAddressCity", contactT.getBusinessAddressCity());
        this.createElement(eParent, "Contacts:", "BusinessPhoneNumber", contactT.getBusinessPhoneNumber());
        this.createElement(eParent, "Contacts:", "WebPage", contactT.getWebPage());
        this.createElement(eParent, "Contacts:", "BusinessAddressCountry", contactT.getBusinessAddressCountry());
        this.createElement(eParent, "Contacts:", "Department", contactT.getDepartment());
        this.createElement(eParent, "Contacts:", "Email1Address", contactT.getEmail1Address());
        this.createElement(eParent, "Contacts:", "Email2Address", contactT.getEmail2Address());
        this.createElement(eParent, "Contacts:", "Email3Address", contactT.getEmail3Address());
        this.createElement(eParent, "Contacts:", "BusinessFaxNumber", contactT.getBusinessFaxNumber());
        this.createElement(eParent, "Contacts:", "FileAs", contactT.getFileAs());
        this.createElement(eParent, "Contacts:", "FirstName", contactT.getFirstName());
        this.createElement(eParent, "Contacts:", "MiddleName", contactT.getMiddleName());
        this.createElement(eParent, "Contacts:", "HomeAddressCity", contactT.getHomeAddressCity());
        this.createElement(eParent, "Contacts:", "HomeAddressCountry", contactT.getHomeAddressCountry());
        this.createElement(eParent, "Contacts:", "HomeFaxNumber", contactT.getHomeFaxNumber());
        this.createElement(eParent, "Contacts:", "HomePhoneNumber", contactT.getHomePhoneNumber());
        this.createElement(eParent, "Contacts:", "Home2PhoneNumber", contactT.getHome2PhoneNumber());
        this.createElement(eParent, "Contacts:", "HomeAddressPostalCode", contactT.getHomeAddressPostalCode());
        this.createElement(eParent, "Contacts:", "HomeAddressState", contactT.getHomeAddressState());
        this.createElement(eParent, "Contacts:", "HomeAddressStreet", contactT.getHomeAddressStreet());
        this.createElement(eParent, "Contacts:", "MobilePhoneNumber", contactT.getMobilePhoneNumber());
        this.createElement(eParent, "Contacts:", "Suffix", contactT.getSuffix());
        this.createElement(eParent, "Contacts:", "CompanyName", contactT.getCompanyName());
        this.createElement(eParent, "Contacts:", "OtherAddressCity", contactT.getOtherAddressCity());
        this.createElement(eParent, "Contacts:", "OtherAddressCountry", contactT.getOtherAddressCountry());
        this.createElement(eParent, "Contacts:", "OtherAddressPostalCode", contactT.getOtherAddressPostalCode());
        this.createElement(eParent, "Contacts:", "OtherAddressState", contactT.getOtherAddressState());
        this.createElement(eParent, "Contacts:", "OtherAddressStreet", contactT.getOtherAddressStreet());
        this.createElement(eParent, "Contacts:", "PagerNumber", contactT.getPagerNumber());
        this.createElement(eParent, "Contacts:", "Title", contactT.getTitle());
        this.createElement(eParent, "Contacts:", "BusinessAddressPostalCode", contactT.getBusinessPostalCode());
        this.createElement(eParent, "Contacts:", "LastName", contactT.getLastName());
        this.createElement(eParent, "Contacts:", "Spouse", contactT.getSpouse());
        this.createElement(eParent, "Contacts:", "BusinessAddressState", contactT.getBusinessState());
        this.createElement(eParent, "Contacts:", "BusinessAddressStreet", contactT.getBusinessStreet());
        this.createElement(eParent, "Contacts:", "JobTitle", contactT.getJobTitle());
        this.createElement(eParent, "Contacts:", "YomiFirstName", contactT.getYomiFirstName());
        this.createElement(eParent, "Contacts:", "YomiLastName", contactT.getYomiLastName());
        this.createElement(eParent, "Contacts:", "YomiCompanyName", contactT.getYomiCompanyName());
        this.createElement(eParent, "Contacts:", "OfficeLocation", contactT.getOfficeLocation());
        this.createElement(eParent, "Contacts:", "Picture", contactT.getPicture());
        if (contactT.getCategories() != null && !contactT.getCategories().isEmpty()) {
            Element eCategories = DOMUtils.createElement(eParent, "Contacts:", "Categories");
            for (String category : contactT.getCategories()) {
                this.createElement(eCategories, "Contacts:", "Category", category);
            }
        }
        if (contactT.getChildren() != null && !contactT.getChildren().isEmpty()) {
            Element eChildren = DOMUtils.createElement(eParent, "Contacts:", "Children");
            for (String child : contactT.getChildren()) {
                this.createElement(eChildren, "Contacts:", "Child", child);
            }
        }
        if ((body = contactT.getBody()) != null) {
            this.createElement(eParent, "Contacts:", "Body", Utils.normalizeNewLines(body).replace("\n", "\r\n"));
        }
        this.createElement(eParent, "Contacts2:", "CustomerId", contactT.getCustomerId());
        this.createElement(eParent, "Contacts2:", "IMAddress", contactT.getIMAddress());
        this.createElement(eParent, "Contacts2:", "IMAddress2", contactT.getIMAddress2());
        this.createElement(eParent, "Contacts2:", "IMAddress3", contactT.getIMAddress3());
        this.createElement(eParent, "Contacts2:", "ManagerName", contactT.getManagerName());
        this.createElement(eParent, "Contacts2:", "NickName", contactT.getNickName());
    }

    @Override
    public IData parse(Element syncData) {
        ContactT contactT = new ContactT();
        contactT.setAlias(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "Alias")));
        contactT.setAnniversary(this.parseDOMDate(DOMUtils.getUniqueElement(syncData, "Contacts:", "Anniversary")));
        contactT.setAssistantName(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "AssistantName")));
        contactT.setAssistantPhoneNumber(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "AssistantTelephoneNumber")));
        contactT.setBirthday(this.parseDOMDate(DOMUtils.getUniqueElement(syncData, "Contacts:", "Birthday")));
        contactT.setBusiness2PhoneNumber(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "Business2PhoneNumber")));
        contactT.setBusinessAddressCity(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "BusinessAddressCity")));
        contactT.setBusinessPhoneNumber(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "BusinessPhoneNumber")));
        contactT.setWebPage(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "WebPage")));
        contactT.setBusinessAddressCountry(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "BusinessAddressCountry")));
        contactT.setDepartment(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "Department")));
        contactT.setEmail1Address(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "Email1Address")));
        contactT.setEmail2Address(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "Email2Address")));
        contactT.setEmail3Address(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "Email3Address")));
        contactT.setBusinessFaxNumber(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "BusinessFaxNumber")));
        contactT.setFileAs(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "FileAs")));
        contactT.setFirstName(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "FirstName")));
        contactT.setMiddleName(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "MiddleName")));
        contactT.setHomeAddressCity(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "HomeAddressCity")));
        contactT.setHomeAddressCountry(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "HomeAddressCountry")));
        contactT.setHomeFaxNumber(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "HomeFaxNumber")));
        contactT.setHomePhoneNumber(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "HomePhoneNumber")));
        contactT.setHome2PhoneNumber(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "Home2PhoneNumber")));
        contactT.setHomeAddressPostalCode(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "HomeAddressPostalCode")));
        contactT.setHomeAddressState(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "HomeAddressState")));
        contactT.setHomeAddressStreet(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "HomeAddressStreet")));
        contactT.setMobilePhoneNumber(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "MobilePhoneNumber")));
        contactT.setSuffix(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "Suffix")));
        contactT.setCompanyName(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "CompanyName")));
        contactT.setOtherAddressCity(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "OtherAddressCity")));
        contactT.setOtherAddressCountry(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "OtherAddressCountry")));
        contactT.setCarPhoneNumber(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "CarTelephoneNumber")));
        contactT.setOtherAddressPostalCode(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "OtherAddressPostalCode")));
        contactT.setOtherAddressState(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "OtherAddressState")));
        contactT.setOtherAddressStreet(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "OtherAddressStreet")));
        contactT.setPagerNumber(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "PagerNumber")));
        contactT.setTitle(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "Title")));
        contactT.setBusinessPostalCode(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "BusinessAddressPostalCode")));
        contactT.setLastName(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "LastName")));
        contactT.setSpouse(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "Spouse")));
        contactT.setBusinessState(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "BusinessAddressState")));
        contactT.setBusinessStreet(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "BusinessAddressStreet")));
        contactT.setJobTitle(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "JobTitle")));
        contactT.setYomiFirstName(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "YomiFirstName")));
        contactT.setYomiLastName(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "YomiLastName")));
        contactT.setYomiCompanyName(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "YomiCompanyName")));
        contactT.setOfficeLocation(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "OfficeLocation")));
        contactT.setRadioPhoneNumber(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "RadioTelephoneNumber")));
        contactT.setPicture(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "Picture")));
        contactT.setCategories(this.parseDOMStringCollection(DOMUtils.getUniqueElement(syncData, "Contacts:", "Categories"), "Contacts:", "Category"));
        contactT.setChildren(this.parseDOMStringCollection(DOMUtils.getUniqueElement(syncData, "Contacts:", "Children"), "Contacts:", "Child"));
        contactT.setBody(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts:", "Body")));
        contactT.setCustomerId(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts2:", "CustomerId")));
        contactT.setGovernmentId(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts2:", "GovernmentId")));
        contactT.setIMAddress(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts2:", "IMAddress")));
        contactT.setIMAddress2(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts2:", "IMAddress2")));
        contactT.setIMAddress3(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts2:", "IMAddress3")));
        contactT.setManagerName(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts2:", "ManagerName")));
        contactT.setCompanyMainPhone(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts2:", "CompanyMainPhone")));
        contactT.setAccountName(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts2:", "AccountName")));
        contactT.setNickName(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts2:", "NickName")));
        contactT.setMMS(this.parseDOMString(DOMUtils.getUniqueElement(syncData, "Contacts2:", "MMS")));
        return contactT;
    }
}

