/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.datatypes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opencrx.application.airsync.datatypes.AbstractXmlFormat;
import org.opencrx.application.airsync.datatypes.AddressT;
import org.opencrx.application.airsync.datatypes.AttachmentT;
import org.opencrx.application.airsync.datatypes.EmailBodyT;
import org.opencrx.application.airsync.datatypes.EmailT;
import org.opencrx.application.airsync.datatypes.EventT;
import org.opencrx.application.airsync.datatypes.IData;
import org.opencrx.application.airsync.datatypes.Importance;
import org.opencrx.application.airsync.datatypes.MethodAttachment;
import org.opencrx.application.airsync.datatypes.RecurrenceDayOfWeek;
import org.opencrx.application.airsync.datatypes.RecurrenceT;
import org.opencrx.application.airsync.utils.DOMUtils;
import org.openmdx.base.text.conversion.Base64;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.format.DateTimeFormat;

public class EmailTXmlFormat
extends AbstractXmlFormat {
    @Override
    public void format(Element parent, IData data, double protocolVersion) {
        EmailT mail = (EmailT)data;
        DateTimeFormat eutcf = DateTimeFormat.EXTENDED_UTC_FORMAT;
        if (!mail.getTo().isEmpty()) {
            DOMUtils.createElementAndText(parent, "Email:", "To", this.addressesToString(mail.getTo()));
        }
        if (!mail.getCc().isEmpty()) {
            DOMUtils.createElementAndText(parent, "Email:", "CC", this.addressesToString(mail.getCc()));
        }
        DOMUtils.createElementAndText(parent, "Email:", "From", this.addressesToString(mail.getFrom() == null ? null : Collections.singletonList(mail.getFrom())));
        DOMUtils.createElementAndText(parent, "Email:", "Subject", mail.getSubject());
        DOMUtils.createElementAndText(parent, "Email:", "ReplyTo", this.addressesToString(mail.getReplyTo() == null ? null : Collections.singletonList(mail.getReplyTo())));
        DOMUtils.createElementAndText(parent, "Email:", "DateReceived", eutcf.format(mail.getDateReceived()));
        if (!mail.getTo().isEmpty() && mail.getTo().get(0) != null && mail.getTo().get(0).getDisplayName() != null && !"".equals(mail.getTo().get(0).getDisplayName())) {
            DOMUtils.createElementAndText(parent, "Email:", "DisplayTo", mail.getTo().get(0).getDisplayName());
        }
        DOMUtils.createElementAndText(parent, "Email:", "ThreadTopic", mail.getSubject());
        if (mail.getImportance() != null) {
            DOMUtils.createElementAndText(parent, "Email:", "Importance", Integer.toString(mail.getImportance().getValue()));
        }
        DOMUtils.createElementAndText(parent, "Email:", "Read", mail.isRead() ? "1" : "0");
        this.formatBody(parent, mail);
        this.formatAttachments(parent, mail);
        if (mail.getMessageClass() != null) {
            DOMUtils.createElementAndText(parent, "Email:", "MessageClass", mail.getMessageClass().toString());
        }
        this.formatMeetingRequest(parent, mail);
        DOMUtils.createElementAndText(parent, "Email:", "InternetCPID", "65001");
    }

    protected void formatBody(Element e, EmailT mail) {
        String data = mail.getBody().getData();
        DOMUtils.createElementAndText(e, "Email:", "Body", data);
        if (data != null) {
            DOMUtils.createElementAndText(e, "Email:", "BodySize", "" + data.getBytes().length);
        }
        if (mail.getInvitation() != null) {
            DOMUtils.createElementAndText(e, "Email:", "ContentClass", "urn:content-classes:calendarmessage");
        } else {
            DOMUtils.createElementAndText(e, "Email:", "ContentClass", "urn:content-classes:message");
        }
    }

    private void formatMeetingRequest(Element e, EmailT emailT) {
        DateTimeFormat eutcf = DateTimeFormat.EXTENDED_UTC_FORMAT;
        if (emailT.getInvitation() != null) {
            Element eMeetingRequest = DOMUtils.createElement(e, "Email:", "MeetingRequest");
            EventT eventT = emailT.getInvitation();
            DOMUtils.createElementAndText(eMeetingRequest, "Email:", "AllDayEvent", eventT.getAllDayEvent() != false ? "1" : "0");
            DOMUtils.createElementAndText(eMeetingRequest, "Email:", "StartTime", eutcf.format(eventT.getStartTime()));
            DOMUtils.createElementAndText(eMeetingRequest, "Email:", "DtStamp", eutcf.format(eventT.getDtStamp()));
            DOMUtils.createElementAndText(eMeetingRequest, "Email:", "EndTime", eutcf.format(eventT.getEndTime()));
            DOMUtils.createElementAndText(eMeetingRequest, "Email:", "InstanceType", "0");
            if (eventT.getLocation() != null && !"".equals(eventT.getLocation())) {
                DOMUtils.createElementAndText(eMeetingRequest, "Email:", "Location", eventT.getLocation());
            }
            if (eventT.getOrganizerEmail() != null && !"".equals(eventT.getOrganizerEmail())) {
                DOMUtils.createElementAndText(eMeetingRequest, "Email:", "Organizer", eventT.getOrganizerEmail());
            } else if (eventT.getOrganizerName() != null && !"".equals(eventT.getOrganizerName())) {
                DOMUtils.createElementAndText(eMeetingRequest, "Email:", "Organizer", eventT.getOrganizerName());
            }
            if (eventT.getReminder() != null) {
                DOMUtils.createElementAndText(eMeetingRequest, "Email:", "Reminder", eventT.getReminder().toString());
            }
            DOMUtils.createElementAndText(eMeetingRequest, "Email:", "ResponseRequested", "1");
            if (eventT.getSensitivity() != null) {
                DOMUtils.createElementAndText(eMeetingRequest, "Email:", "Sensitivity", Integer.toString(eventT.getSensitivity().getValue()));
            }
            if (eventT.getBusyStatus() != null) {
                DOMUtils.createElementAndText(eMeetingRequest, "Email:", "IntDBusyStatus", Integer.toString(eventT.getBusyStatus().getValue()));
            }
            DOMUtils.createElementAndText(eMeetingRequest, "Email:", "GlobalObjId", new String(Base64.encode((byte[])eventT.getUID().getBytes())));
            this.formatRecurrence(eMeetingRequest, eventT);
        }
    }

    private void formatRecurrence(Element e, EventT eventT) {
        DateTimeFormat eutcf = DateTimeFormat.EXTENDED_UTC_FORMAT;
        RecurrenceT recurrenceT = eventT.getRecurrence();
        if (recurrenceT == null || recurrenceT.getType() == null) {
            return;
        }
        Element eRecurrence = DOMUtils.createElement(e, "Email:", "Recurrence");
        DOMUtils.createElementAndText(eRecurrence, "Email:", "Recurrence_Type", Integer.toString(recurrenceT.getType().getValue()));
        if (recurrenceT.getOccurrences() != null) {
            DOMUtils.createElementAndText(eRecurrence, "Email:", "Recurrence_Occurrences", Integer.toString(recurrenceT.getOccurrences()));
        }
        if (recurrenceT.getInterval() != null) {
            DOMUtils.createElementAndText(eRecurrence, "Email:", "Recurrence_Interval", recurrenceT.getInterval().toString());
        }
        if (recurrenceT.getWeekOfMonth() != null) {
            DOMUtils.createElementAndText(eRecurrence, "Email:", "Recurrence_WeekOfMonth", Integer.toString(recurrenceT.getWeekOfMonth()));
        }
        if (recurrenceT.getDayOfWeek() != null) {
            DOMUtils.createElementAndText(eRecurrence, "Email:", "Recurrence_DayOfWeek", Integer.toString(RecurrenceDayOfWeek.asInt(recurrenceT.getDayOfWeek())));
        }
        if (recurrenceT.getMonthOfYear() != null) {
            DOMUtils.createElementAndText(eRecurrence, "Email:", "Recurrence_MonthOfYear", Integer.toString(recurrenceT.getMonthOfYear()));
        }
        if (recurrenceT.getUntil() != null) {
            DOMUtils.createElementAndText(eRecurrence, "Email:", "Recurrence_Until", eutcf.format(recurrenceT.getUntil()));
        }
    }

    private void formatAttachments(Element e, EmailT emailT) {
        if (emailT.getAttachements() != null && !emailT.getAttachements().isEmpty()) {
            Element eAttachments = DOMUtils.createElement(e, "AirSyncBase:", "Attachments");
            List<AttachmentT> attachments = emailT.getAttachements();
            for (AttachmentT attachmentT : attachments) {
                Element eAttachment = DOMUtils.createElement(eAttachments, "AirSyncBase:", "Attachment");
                DOMUtils.createElementAndText(eAttachment, "AirSyncBase:", "DisplayName", attachmentT.getDisplayName());
                DOMUtils.createElementAndText(eAttachment, "AirSyncBase:", "FileReference", attachmentT.getAttachmentName());
                DOMUtils.createElementAndText(eAttachment, "AirSyncBase:", "Method", Integer.toString(attachmentT.getMethod().getValue()));
                if (attachmentT.getEstimatedDataSize() == null) continue;
                DOMUtils.createElementAndText(eAttachment, "AirSyncBase:", "EstimatedDataSize", Integer.toString(attachmentT.getEstimatedDataSize()));
            }
        }
    }

    private String addressesToString(List<AddressT> addressesT) {
        StringBuilder sb = new StringBuilder();
        if (addressesT != null) {
            String sep = "";
            for (AddressT addressT : addressesT) {
                sb.append(sep);
                sb.append(addressT.getMail());
                sep = ", ";
            }
        }
        return sb.toString();
    }

    private EmailBodyT parseBody(Element eData) {
        EmailBodyT emailBodyT = new EmailBodyT();
        emailBodyT.setData(this.parseDOMString(DOMUtils.getUniqueElement(eData, "Email:", "Body")));
        return emailBodyT;
    }

    private List<AddressT> parseAddresses(String addresses) {
        ArrayList<AddressT> addressesT = new ArrayList<AddressT>();
        if (addresses != null) {
            String[] splits = addresses.split(",");
            for (int i = 0; i < splits.length; ++i) {
                String address = splits[i];
                int pos1 = address.indexOf("<");
                int pos2 = address.indexOf(">");
                if (pos1 < 0 || pos2 <= pos1) continue;
                addressesT.add(new AddressT(address.substring(pos1 + 1, pos2).trim()));
            }
        }
        return addressesT;
    }

    private List<AttachmentT> parseAttachments(Element eData) {
        ArrayList<AttachmentT> attachmentsT = new ArrayList<AttachmentT>();
        Element eAttachments = DOMUtils.getUniqueElement(eData, "Email:", "Attachments");
        if (eAttachments != null) {
            int n = eAttachments.getChildNodes().getLength();
            for (int i = 0; i < n; ++i) {
                Node node = eAttachments.getChildNodes().item(i);
                if (!(node instanceof Element)) continue;
                Element eAttachment = (Element)node;
                AttachmentT attachmentT = new AttachmentT();
                attachmentT.setMethod(MethodAttachment.toMethodAttachment(Integer.valueOf(this.parseDOMString(DOMUtils.getUniqueElement(eAttachment, "Email:", "AttMethod")))));
                attachmentT.setEstimatedDataSize(this.parseDOMInt(DOMUtils.getUniqueElement(eAttachment, "Email:", "AttSize")));
                attachmentT.setDisplayName(this.parseDOMString(DOMUtils.getUniqueElement(eAttachment, "Email:", "DisplayName")));
                attachmentT.setAttachmentName(this.parseDOMString(DOMUtils.getUniqueElement(eAttachment, "Email:", "AttName")));
                attachmentsT.add(attachmentT);
            }
        }
        return attachmentsT;
    }

    @Override
    public IData parse(Element eData) {
        EmailT emailT = new EmailT();
        emailT.setMimeData(this.parseDOMString(DOMUtils.getUniqueElement(eData, "Email:", "MIMEData")));
        List<AddressT> addressesTo = this.parseAddresses(this.parseDOMString(DOMUtils.getUniqueElement(eData, "Email:", "To")));
        emailT.setTo(addressesTo);
        List<AddressT> addressesCc = this.parseAddresses(this.parseDOMString(DOMUtils.getUniqueElement(eData, "Email:", "CC")));
        emailT.setCc(addressesCc);
        emailT.setBcc(Collections.emptyList());
        List<AddressT> addressesFrom = this.parseAddresses(this.parseDOMString(DOMUtils.getUniqueElement(eData, "Email:", "From")));
        if (!addressesFrom.isEmpty()) {
            emailT.setFrom(addressesFrom.get(0));
        }
        emailT.setSubject(this.parseDOMString(DOMUtils.getUniqueElement(eData, "Email:", "Subject")));
        emailT.setDateReceived(this.parseDOMDate(DOMUtils.getUniqueElement(eData, "Email:", "DateReceived")));
        String importance = this.parseDOMString(DOMUtils.getUniqueElement(eData, "Email:", "Importance"));
        if (importance != null) {
            emailT.setImportance(Importance.toImportance(Integer.parseInt(importance)));
        }
        emailT.setRead(this.parseDOMInt2Boolean(DOMUtils.getUniqueElement(eData, "Email:", "Read")));
        emailT.setAttachements(this.parseAttachments(eData));
        emailT.setBody(this.parseBody(eData));
        emailT.setCategories(this.parseDOMStringCollection(DOMUtils.getUniqueElement(eData, "Email:", "Categories"), "Email:", "Category"));
        return emailT;
    }
}

