/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.bpi.adapter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.jdo.PersistenceManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.bpi.adapter.BpiAction;
import org.opencrx.application.bpi.adapter.BpiPlugIn;
import org.opencrx.application.bpi.datatype.BpiAddressGroup;
import org.opencrx.kernel.activity1.cci2.AddressGroupQuery;
import org.opencrx.kernel.activity1.jmi1.AddressGroup;
import org.opencrx.kernel.activity1.jmi1.Segment;
import org.opencrx.kernel.backend.Activities;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.openmdx.base.rest.spi.Facades;
import org.openmdx.base.rest.spi.Query_2Facade;

public class GetAddressGroupsAction
extends BpiAction {
    @Override
    public void perform(Path path, PersistenceManager pm, BpiPlugIn plugIn, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServiceException {
        try {
            Segment activitySegment = Activities.getInstance().getActivitySegment(pm, path.get(2), path.get(4));
            Query_2Facade queryFacade = Facades.newQuery((Path)activitySegment.refGetPath().getChild("addressGroup"));
            queryFacade.setQueryType("org:opencrx:kernel:activity1:AddressGroup");
            String query = req.getParameter("query");
            queryFacade.setQuery(query);
            String position = req.getParameter("position");
            queryFacade.setPosition((Number)(position == null ? Integer.valueOf(0) : Integer.valueOf(position)));
            String size = req.getParameter("size");
            queryFacade.setSize((Number)(size == null ? 25 : Integer.parseInt(size)));
            AddressGroupQuery addressGroupQuery = (AddressGroupQuery)pm.newQuery("org.openmdx.query.OPENMDXQL", (Object)queryFacade.getDelegate());
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("application/json");
            ArrayList<BpiAddressGroup> bpiAddressGroups = new ArrayList<BpiAddressGroup>();
            int count = 0;
            ListIterator i = activitySegment.getAddressGroup(addressGroupQuery).listIterator(queryFacade.getPosition().intValue());
            while (i.hasNext()) {
                AddressGroup addressGroup = (AddressGroup)i.next();
                bpiAddressGroups.add(plugIn.toBpiAddressGroup(addressGroup, plugIn.newBpiAddressGroup(), this.getFetchGroup(req)));
                if ((long)(++count) <= queryFacade.getSize()) continue;
                break;
            }
            PrintWriter pw = resp.getWriter();
            plugIn.printObject(pw, bpiAddressGroups);
            resp.setStatus(200);
        }
        catch (Exception e) {
            resp.setStatus(500);
            new ServiceException(e).log();
            try {
                pm.currentTransaction().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

