/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.bpi.adapter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.bpi.adapter.BpiAction;
import org.opencrx.application.bpi.adapter.BpiPlugIn;
import org.opencrx.application.bpi.datatype.BpiCodeTable;
import org.opencrx.kernel.code1.jmi1.CodeValueContainer;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;

public class GetCodeTableAction
extends BpiAction {
    @Override
    public void perform(Path path, PersistenceManager pm, BpiPlugIn plugIn, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServiceException {
        List<CodeValueContainer> codeValueContainers = plugIn.findCodeValueContainers(path, pm);
        if (codeValueContainers == null || codeValueContainers.isEmpty()) {
            resp.setStatus(404);
        } else {
            try {
                CodeValueContainer codeValueContainer = codeValueContainers.iterator().next();
                ArrayList<Short> locales = new ArrayList<Short>();
                if (req.getParameter("locales") != null) {
                    for (String locale : req.getParameter("locales").split(",")) {
                        try {
                            locales.add(Short.parseShort(locale));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                resp.setCharacterEncoding("UTF-8");
                resp.setContentType("application/json");
                PrintWriter pw = resp.getWriter();
                BpiCodeTable bpiCodeTable = plugIn.newBpiCodeTable();
                bpiCodeTable.setId(path.getLastSegment().toString());
                plugIn.printObject(pw, plugIn.toBpiCodeTable(codeValueContainer, bpiCodeTable, locales, "all"));
                resp.setStatus(200);
            }
            catch (Exception e) {
                resp.setStatus(500);
                new ServiceException(e).log();
                try {
                    pm.currentTransaction().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

