/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.caldav;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.opencrx.application.caldav.ActivityCollectionResource;
import org.opencrx.application.caldav.CalDavResource;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.backend.ICalendar;
import org.opencrx.kernel.home1.jmi1.Timer;
import org.openmdx.base.jmi1.ContextCapable;
import org.w3c.cci2.BinaryLargeObject;
import org.w3c.cci2.BinaryLargeObjects;

class ActivityResource
extends CalDavResource {
    private final ActivityCollectionResource parent;

    public ActivityResource(RequestContext requestContext, Activity activity, ActivityCollectionResource parent) {
        super(requestContext, (ContextCapable)activity);
        this.parent = parent;
    }

    public Activity getObject() {
        return (Activity)super.getObject();
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public String getMimeType() {
        return "text/calendar; component=" + (this.parent.getType() == ActivityCollectionResource.Type.VTODO ? "vtodo" : "vevent");
    }

    @Override
    public String getName() {
        return super.getName() + ".ics";
    }

    @Override
    public String getDisplayName() {
        return this.getObject().getName();
    }

    @Override
    public Date getLastModified() {
        Date lastModifiedAt = super.getLastModified();
        Activity activity = this.getObject();
        if (activity.getIcal().indexOf("X-OPENCRX-RENDER-ALARMS:TRUE") > 0) {
            Iterator iterator = this.getObject().getAssignedTimer().iterator();
            while (iterator.hasNext()) {
                Timer timer = (Timer)iterator.next();
                if (timer.getModifiedAt().compareTo(lastModifiedAt) <= 0) continue;
                lastModifiedAt = timer.getModifiedAt();
            }
        }
        return lastModifiedAt;
    }

    public ActivityCollectionResource getSyncFeedResource() {
        return this.parent;
    }

    @Override
    public WebDavStore.ResourceContent getContent() {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        }
        catch (Exception e) {
            pw = new PrintWriter(out);
        }
        HttpServletRequest req = this.getRequestContext().getHttpServletRequest();
        try {
            ICalendar.getInstance().printCalendar(pw, this.getObject(), this.parent.getQueryHelper(), this.parent.getRunAs(), false, req, "-caldav-");
        }
        catch (Exception exception) {
            // empty catch block
        }
        pw.close();
        return new WebDavStore.ResourceContent(){

            @Override
            public Long getLength() {
                return out.size();
            }

            @Override
            public BinaryLargeObject getContent() {
                return BinaryLargeObjects.valueOf((byte[])out.toByteArray());
            }
        };
    }
}

