/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.caldav;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.caldav.ActivityCollectionResource;
import org.opencrx.application.caldav.ActivityResource;
import org.opencrx.application.caldav.CalDavRequestContext;
import org.opencrx.application.caldav.CalDavResource;
import org.opencrx.application.caldav.CalendarProfileResource;
import org.opencrx.application.caldav.QueryBasedActivityCollectionResource;
import org.opencrx.application.caldav.SyncFeedBasedActivityCollectionResource;
import org.opencrx.application.uses.net.sf.webdav.Lock;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.uses.net.sf.webdav.exceptions.LockFailedException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.WebdavException;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.backend.ICalendar;
import org.opencrx.kernel.home1.cci2.CalendarProfileQuery;
import org.opencrx.kernel.home1.jmi1.CalendarProfile;
import org.opencrx.kernel.home1.jmi1.SyncFeed;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.opencrx.kernel.utils.ActivityQueryHelper;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.openmdx.kernel.log.SysLog;
import org.w3c.cci2.BinaryLargeObject;
import org.w3c.cci2.BinaryLargeObjects;

public class CalDavStore
implements WebDavStore {
    protected static final Set<String> CALENDAR_TYPES = new HashSet<String>(Arrays.asList("tracker", "milestone", "category", "home", "resource", "filter", "globalfilter"));
    public static final String[] DEFAULT_PROFILE_NAMES = new String[]{"CalDAV", "Calendars", "Calendar"};
    protected PersistenceManagerFactory pmf = null;
    protected final Map<String, String> pathMapping = new ConcurrentHashMap<String, String>();

    public CalDavStore(PersistenceManagerFactory pmf) {
        this.pmf = pmf;
    }

    public static PersistenceManager getPersistenceManager(HttpServletRequest req, PersistenceManagerFactory pmf) {
        return req.getUserPrincipal() == null ? null : pmf.getPersistenceManager(req.getUserPrincipal().getName(), null);
    }

    public static ActivityQueryHelper getActivityQueryHelper(PersistenceManager pm, String filterId, String isDisabledFilter) {
        ActivityQueryHelper activitiesHelper = new ActivityQueryHelper(pm);
        if (filterId != null) {
            try {
                activitiesHelper.parseQueryId((filterId.startsWith("/") ? "" : "/") + filterId);
                activitiesHelper.parseDisabledFilter(isDisabledFilter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return activitiesHelper;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Resource getResourceByPath(RequestContext requestContext, String path, boolean allowRunAs) {
        ActivityCollectionResource parent;
        PersistenceManager pm = ((CalDavRequestContext)requestContext).getPersistenceManager();
        HttpServletRequest req = requestContext.getHttpServletRequest();
        if (this.pathMapping.containsKey(path)) {
            String mappedPath = this.pathMapping.get(path);
            this.pathMapping.remove(path);
            path = mappedPath;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        path = path.replace("/user/", "/");
        String[] components = (path = path.replace("/profile/", "/")).split("/");
        if (components.length < 3) {
            components = new String[]{components[0], components[1], req.getUserPrincipal().getName()};
        }
        if (components.length < 4) {
            components = new String[]{components[0], components[1], components[2], DEFAULT_PROFILE_NAMES[0]};
        }
        if (CALENDAR_TYPES.contains(components[2]) || CALENDAR_TYPES.contains(components[3])) {
            ActivityQueryHelper queryHelper;
            int pos;
            String runAs = null;
            if (CALENDAR_TYPES.contains(components[3])) {
                String userId = components[2];
                if (allowRunAs && !userId.equals(req.getUserPrincipal().getName())) {
                    runAs = userId;
                }
                path = components[0] + "/" + components[1];
                for (int i = 3; i < components.length; ++i) {
                    path = path + "/" + components[i];
                }
            }
            String resourceId = null;
            if (path.endsWith(".ics") && (pos = path.lastIndexOf("/")) > 0) {
                resourceId = path.substring(pos + 1);
                path = path.substring(0, pos);
            }
            ActivityCollectionResource.Type type = ActivityCollectionResource.Type.VEVENT;
            if (path.indexOf("/VTODO") > 0) {
                path = path.substring(0, path.indexOf("/VTODO"));
                type = ActivityCollectionResource.Type.VTODO;
            }
            if ((queryHelper = CalDavStore.getActivityQueryHelper(pm, path, "false")).getSource() == null) {
                SysLog.log((Level)Level.FINE, (String)"Unable to get query helper for user >{0}< and path >{1}<", (Object[])new Object[]{req.getUserPrincipal().getName(), Arrays.asList(components)});
                return null;
            }
            QueryBasedActivityCollectionResource activityCollectionResource = new QueryBasedActivityCollectionResource(requestContext, queryHelper, type, runAs);
            if (resourceId == null) return activityCollectionResource;
            try {
                Activity activity = (Activity)activityCollectionResource.getQueryHelper().getPersistenceManager().getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.activity1").getDescendant(new String[]{"provider", components[0], "segment", components[1], "activity", resourceId.endsWith(".ics") ? resourceId.substring(0, resourceId.length() - 4) : resourceId}));
                return new ActivityResource(requestContext, activity, activityCollectionResource);
            }
            catch (Exception e) {
                ServiceException e0 = new ServiceException(e);
                SysLog.detail((String)e0.getMessage(), (Throwable)e0.getCause());
                return null;
            }
        }
        String userId = components[2];
        UserHome userHome = (UserHome)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.home1").getDescendant(new String[]{"provider", components[0], "segment", components[1], "userHome", userId}));
        CalendarProfile syncProfile = null;
        try {
            syncProfile = (CalendarProfile)pm.getObjectById((Object)userHome.refGetPath().getDescendant(new String[]{"syncProfile", components[3]}));
        }
        catch (Exception queryHelper) {
            // empty catch block
        }
        if (syncProfile == null) {
            ArrayList<String> profileNames = new ArrayList<String>();
            profileNames.add(components[3]);
            profileNames.addAll(Arrays.asList(DEFAULT_PROFILE_NAMES));
            for (String profileName : profileNames) {
                CalendarProfileQuery calendarProfileQuery = (CalendarProfileQuery)pm.newQuery(CalendarProfile.class);
                calendarProfileQuery.name().equalTo((Object)profileName);
                List calendarProfiles = userHome.getSyncProfile(calendarProfileQuery);
                if (calendarProfiles.isEmpty()) continue;
                syncProfile = (CalendarProfile)calendarProfiles.iterator().next();
                break;
            }
        }
        if (syncProfile == null) return null;
        String runAs = null;
        if (!userId.equals(req.getUserPrincipal().getName())) {
            runAs = userId;
        }
        if (components.length == 4) {
            return new CalendarProfileResource(requestContext, syncProfile, runAs);
        }
        if (components.length == 5) {
            SyncFeed syncFeed;
            String id = components[4];
            ActivityCollectionResource.Type type = ActivityCollectionResource.Type.VEVENT;
            if (id.endsWith(":VTODO")) {
                id = id.substring(0, id.indexOf(":VTODO"));
                type = ActivityCollectionResource.Type.VTODO;
            }
            if ((syncFeed = syncProfile.getFeed(id)) != null) return new SyncFeedBasedActivityCollectionResource(requestContext, syncFeed, type, runAs);
            return null;
        }
        if (components.length != 6 || (parent = (ActivityCollectionResource)this.getResourceByPath(requestContext, components[0] + "/" + components[1] + "/" + components[2] + "/" + components[3] + "/" + components[4])) == null) return null;
        String id = components[5];
        if (id.endsWith(".ics")) {
            id = id.substring(0, id.indexOf(".ics"));
        }
        try {
            Activity activity = (Activity)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.activity1").getDescendant(new String[]{"provider", components[0], "segment", components[1], "activity", id}));
            return new ActivityResource(requestContext, activity, parent);
        }
        catch (Exception e) {
            ServiceException e0 = new ServiceException(e);
            SysLog.detail((String)e0.getMessage(), (Throwable)e0.getCause());
        }
        return null;
    }

    @Override
    public RequestContext begin(HttpServletRequest req, HttpServletResponse resp) {
        CalDavRequestContext requestContext = new CalDavRequestContext(req, resp, this.pmf);
        return requestContext;
    }

    @Override
    public void commit(RequestContext requestContext) {
        PersistenceManager pm = ((CalDavRequestContext)requestContext).getPersistenceManager();
        try {
            if (!pm.isClosed()) {
                pm.currentTransaction().commit();
                pm.close();
            }
        }
        catch (Exception e) {
            try {
                pm.currentTransaction().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void createCollection(RequestContext requestContext, String path) {
        throw new WebdavException("Not supported by CalDAV");
    }

    @Override
    public Collection<Resource> getChildren(RequestContext requestContext, Resource res, Date timeRangeStart, Date timeRangeEnd) {
        if (res instanceof CalDavResource) {
            return ((CalDavResource)res).getChildren(timeRangeStart, timeRangeEnd);
        }
        return Collections.emptyList();
    }

    @Override
    public WebDavStore.ResourceContent getResourceContent(RequestContext requestContext, Resource res) {
        if (res instanceof CalDavResource) {
            return ((CalDavResource)res).getContent();
        }
        return new WebDavStore.ResourceContent(){

            @Override
            public BinaryLargeObject getContent() {
                return BinaryLargeObjects.valueOf((byte[])new byte[0]);
            }

            @Override
            public Long getLength() {
                return 0L;
            }
        };
    }

    @Override
    public Resource getResourceByPath(RequestContext requestContext, String path) {
        return this.getResourceByPath(requestContext, path, true);
    }

    @Override
    public WebDavStore.Status removeResource(RequestContext requestContext, String path, Resource res) {
        String parentPath = this.getParentPath(path);
        Resource parent = this.getResourceByPath(requestContext, parentPath, false);
        if (parent instanceof ActivityCollectionResource && res instanceof ActivityResource) {
            ActivityCollectionResource activityCollectionRes = (ActivityCollectionResource)parent;
            if (activityCollectionRes.allowAddDelete()) {
                PersistenceManager pm = ((CalDavRequestContext)requestContext).getPersistenceManager();
                try {
                    pm.currentTransaction().begin();
                    ((ActivityResource)res).getObject().setDisabled(true);
                    pm.currentTransaction().commit();
                    return WebDavStore.Status.OK;
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                    try {
                        pm.currentTransaction().rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return WebDavStore.Status.FORBIDDEN;
                }
            }
            return WebDavStore.Status.FORBIDDEN;
        }
        return WebDavStore.Status.FORBIDDEN;
    }

    @Override
    public WebDavStore.Status moveResource(RequestContext requestContext, Resource res, String sourcePath, String destinationPath) {
        try {
            WebDavStore.Status status = this.putResource(requestContext, destinationPath, this.getResourceContent(requestContext, res).getContent().getContent(), this.getMimeType(res));
            if (status != WebDavStore.Status.FORBIDDEN) {
                String mappedPath = this.pathMapping.get(destinationPath);
                this.removeResource(requestContext, sourcePath, res);
                if (mappedPath != null) {
                    this.pathMapping.put(destinationPath, mappedPath);
                }
            }
            return status;
        }
        catch (Exception e) {
            new ServiceException(e).log();
            return WebDavStore.Status.FORBIDDEN;
        }
    }

    @Override
    public void rollback(RequestContext requestContext) {
        PersistenceManager pm = ((CalDavRequestContext)requestContext).getPersistenceManager();
        try {
            if (!pm.isClosed()) {
                pm.currentTransaction().rollback();
                pm.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getMimeType(Resource res) {
        if (res instanceof CalDavResource) {
            return ((CalDavResource)res).getMimeType();
        }
        return "application/xml";
    }

    protected String getParentPath(String path) {
        int slash = path.lastIndexOf(47);
        if (slash != -1) {
            return path.substring(0, slash);
        }
        return null;
    }

    protected String getBasePath(String path) {
        int slash = path.lastIndexOf(47);
        if (slash != -1) {
            return path.substring(slash + 1);
        }
        return null;
    }

    @Override
    public WebDavStore.Status putResource(RequestContext requestContext, String path, InputStream content, String contentType) {
        String parentPath;
        Resource parent;
        if (this.pathMapping.containsKey(path)) {
            String mappedPath = this.pathMapping.get(path);
            this.pathMapping.remove(path);
            path = mappedPath;
        }
        if ((parent = this.getResourceByPath(requestContext, parentPath = this.getParentPath(path), false)) instanceof ActivityCollectionResource) {
            ActivityCollectionResource activityCollectionRes = (ActivityCollectionResource)parent;
            if (activityCollectionRes.allowChange()) {
                try {
                    ICalendar.PutICalResult result;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(content, "UTF-8"));
                    String resId = this.getBasePath(path);
                    if (resId != null && resId.endsWith(".ics")) {
                        resId = resId.substring(0, resId.length() - 4);
                    }
                    if ((result = ICalendar.getInstance().putICal(reader, activityCollectionRes.getQueryHelper(), true, resId)).getActivity() != null && resId != null) {
                        this.pathMapping.put(path, path.replace(resId, result.getActivity().refGetPath().getLastSegment().toString()));
                    }
                    switch (result.getStatus()) {
                        case CREATED: {
                            return WebDavStore.Status.OK_CREATED;
                        }
                        case UPDATED: {
                            return WebDavStore.Status.OK;
                        }
                        case ERROR: {
                            return WebDavStore.Status.FORBIDDEN;
                        }
                    }
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                    return WebDavStore.Status.FORBIDDEN;
                }
            } else {
                return WebDavStore.Status.FORBIDDEN;
            }
        }
        return null;
    }

    @Override
    public List<Lock> getLocksByPath(RequestContext requestContext, String path) {
        return Collections.emptyList();
    }

    @Override
    public Lock lock(RequestContext requestContext, String path, String id, String owner, String scope, String type, int depth, int timeout) throws LockFailedException {
        return null;
    }

    @Override
    public boolean unlock(RequestContext requestContext, String path, String id) {
        return false;
    }
}

