/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.carddav;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.carddav.AccountCollectionResource;
import org.opencrx.application.carddav.AccountResource;
import org.opencrx.application.carddav.CardDavRequestContext;
import org.opencrx.application.carddav.CardDavResource;
import org.opencrx.application.carddav.CardProfileResource;
import org.opencrx.application.carddav.UserHomeResource;
import org.opencrx.application.uses.net.sf.webdav.Lock;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.uses.net.sf.webdav.exceptions.LockFailedException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.WebdavException;
import org.opencrx.kernel.account1.cci2.MemberQuery;
import org.opencrx.kernel.account1.jmi1.AbstractGroup;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.account1.jmi1.Member;
import org.opencrx.kernel.account1.jmi1.Segment;
import org.opencrx.kernel.backend.Base;
import org.opencrx.kernel.backend.VCard;
import org.opencrx.kernel.home1.cci2.CardProfileQuery;
import org.opencrx.kernel.home1.jmi1.CardProfile;
import org.opencrx.kernel.home1.jmi1.ContactsFeed;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.openmdx.kernel.log.SysLog;
import org.w3c.cci2.BinaryLargeObject;
import org.w3c.cci2.BinaryLargeObjects;

public class CardDavStore
implements WebDavStore {
    protected PersistenceManagerFactory pmf = null;
    protected final Map<String, String> uidMapping = new ConcurrentHashMap<String, String>();

    public CardDavStore(PersistenceManagerFactory pmf) {
        this.pmf = pmf;
    }

    public static PersistenceManager getPersistenceManager(HttpServletRequest req, PersistenceManagerFactory pmf) {
        return req.getUserPrincipal() == null ? null : pmf.getPersistenceManager(req.getUserPrincipal().getName(), null);
    }

    @Override
    public RequestContext begin(HttpServletRequest req, HttpServletResponse resp) {
        CardDavRequestContext requestContext = new CardDavRequestContext(req, resp, this.pmf);
        return requestContext;
    }

    @Override
    public void commit(RequestContext requestContext) {
        PersistenceManager pm = ((CardDavRequestContext)requestContext).getPersistenceManager();
        try {
            if (!pm.isClosed()) {
                pm.currentTransaction().commit();
                pm.close();
            }
        }
        catch (Exception e) {
            try {
                pm.currentTransaction().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void createCollection(RequestContext requestContext, String path) {
        throw new WebdavException("Not supported by CalDAV");
    }

    @Override
    public Collection<Resource> getChildren(RequestContext requestContext, Resource res, Date timeRangeStart, Date timeRangeEnd) {
        if (res instanceof CardDavResource) {
            return ((CardDavResource)res).getChildren(timeRangeStart, timeRangeEnd);
        }
        return Collections.emptyList();
    }

    @Override
    public WebDavStore.ResourceContent getResourceContent(RequestContext requestContext, Resource res) {
        if (res instanceof CardDavResource) {
            return ((CardDavResource)res).getContent();
        }
        return new WebDavStore.ResourceContent(){

            @Override
            public BinaryLargeObject getContent() {
                return BinaryLargeObjects.valueOf((byte[])new byte[0]);
            }

            @Override
            public Long getLength() {
                return 0L;
            }
        };
    }

    @Override
    public Resource getResourceByPath(RequestContext requestContext, String path) {
        PersistenceManager pm = ((CardDavRequestContext)requestContext).getPersistenceManager();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        path = path.replace("/user/", "/");
        path = path.replace("/profile/", "/");
        String[] components = path.split("/");
        int posStripped = -1;
        int pos = 0;
        for (String component : components) {
            if (component.startsWith(":") || ".well-known".equals(component)) {
                posStripped = pos;
                break;
            }
            ++pos;
        }
        if (posStripped >= 0) {
            ArrayList<String> strippedComponents = new ArrayList<String>(Arrays.asList(components));
            components = strippedComponents.subList(0, posStripped).toArray(new String[posStripped]);
        }
        if (components.length >= 3) {
            UserHome userHome = (UserHome)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.home1").getDescendant(new String[]{"provider", components[0], "segment", components[1], "userHome", components[2]}));
            if (components.length == 3) {
                if (userHome == null) {
                    return null;
                }
                return new UserHomeResource(requestContext, userHome);
            }
            CardProfile cardProfile = null;
            String profileId = components[3];
            try {
                cardProfile = (CardProfile)userHome.getSyncProfile(profileId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cardProfile == null) {
                CardProfileQuery cardProfileQuery = (CardProfileQuery)pm.newQuery(CardProfile.class);
                cardProfileQuery.name().equalTo((Object)profileId);
                List cardProfiles = userHome.getSyncProfile(cardProfileQuery);
                CardProfile cardProfile2 = cardProfile = cardProfiles.isEmpty() ? null : (CardProfile)cardProfiles.iterator().next();
            }
            if (components.length == 4) {
                if (cardProfile == null) {
                    return null;
                }
                return new CardProfileResource(requestContext, cardProfile);
            }
            if (components.length == 5) {
                String feedId = components[4];
                ContactsFeed contactsFeed = (ContactsFeed)cardProfile.getFeed(feedId);
                return new AccountCollectionResource(requestContext, contactsFeed);
            }
            if (components.length == 6) {
                AccountCollectionResource parent = (AccountCollectionResource)this.getResourceByPath(requestContext, components[0] + "/" + components[1] + "/" + components[2] + "/" + components[3] + "/" + components[4]);
                String id = components[5];
                if (id.endsWith(".vcf")) {
                    id = id.substring(0, id.indexOf(".vcf"));
                }
                if (this.uidMapping.containsKey(id)) {
                    String newId = this.uidMapping.get(id);
                    this.uidMapping.remove(id);
                    id = newId;
                }
                try {
                    Account account = (Account)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.account1").getDescendant(new String[]{"provider", components[0], "segment", components[1], "account", id}));
                    return new AccountResource(requestContext, account, parent);
                }
                catch (Exception e) {
                    ServiceException e0 = new ServiceException(e);
                    SysLog.detail((String)e0.getMessage(), (Throwable)e0.getCause());
                }
            }
        }
        return null;
    }

    @Override
    public WebDavStore.Status removeResource(RequestContext requestContext, String path, Resource res) {
        String parentPath = this.getParentPath(path);
        Resource parent = this.getResourceByPath(requestContext, parentPath);
        if (parent instanceof AccountCollectionResource && res instanceof AccountResource) {
            AccountCollectionResource accountCollection = (AccountCollectionResource)parent;
            if (Boolean.TRUE.equals(accountCollection.getObject().isAllowAddDelete())) {
                PersistenceManager pm = ((CardDavRequestContext)requestContext).getPersistenceManager();
                try {
                    Account account = ((AccountResource)res).getObject();
                    MemberQuery query = (MemberQuery)pm.newQuery(Member.class);
                    query.thereExistsAccount().equalTo(account);
                    List members = ((AccountResource)res).getAccountCollectionResource().getObject().getAccountGroup().getMember(query);
                    pm.currentTransaction().begin();
                    for (Member member : members) {
                        member.setDisabled(true);
                    }
                    pm.currentTransaction().commit();
                    return WebDavStore.Status.OK;
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                    try {
                        pm.currentTransaction().rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return WebDavStore.Status.FORBIDDEN;
                }
            }
            return WebDavStore.Status.FORBIDDEN;
        }
        return WebDavStore.Status.FORBIDDEN;
    }

    @Override
    public WebDavStore.Status moveResource(RequestContext requestContext, Resource res, String sourcePath, String destinationPath) {
        throw new WebdavException("Not supported by CardDAV");
    }

    @Override
    public void rollback(RequestContext requestContext) {
        PersistenceManager pm = ((CardDavRequestContext)requestContext).getPersistenceManager();
        try {
            if (!pm.isClosed()) {
                pm.currentTransaction().rollback();
                pm.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getMimeType(Resource res) {
        if (res instanceof CardDavResource) {
            return ((CardDavResource)res).getMimeType();
        }
        return "application/xml";
    }

    protected String getParentPath(String path) {
        int slash = path.lastIndexOf(47);
        if (slash != -1) {
            return path.substring(0, slash);
        }
        return null;
    }

    @Override
    public WebDavStore.Status putResource(RequestContext requestContext, String path, InputStream content, String contentType) {
        block15: {
            String parentPath = this.getParentPath(path);
            Resource parent = this.getResourceByPath(requestContext, parentPath);
            if (parent instanceof AccountCollectionResource) {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(content, "UTF-8"));
                    ContactsFeed feed = ((AccountCollectionResource)parent).getObject();
                    if (feed.isAllowChange().booleanValue()) {
                        AbstractGroup group = feed.getAccountGroup();
                        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)group);
                        Segment accountSegment = (Segment)pm.getObjectById((Object)group.refGetPath().getParent().getParent());
                        VCard.PutVCardResult result = VCard.getInstance().putVCard(reader, accountSegment);
                        if (result.getStatus() != VCard.PutVCardResult.Status.ERROR) {
                            if (result.getAccount() != null) {
                                MemberQuery query = (MemberQuery)pm.newQuery(Member.class);
                                query.thereExistsAccount().equalTo(result.getAccount());
                                List members = group.getMember(query);
                                if (members.isEmpty()) {
                                    boolean isTxLocal;
                                    boolean bl = isTxLocal = !pm.currentTransaction().isActive();
                                    if (isTxLocal) {
                                        pm.currentTransaction().begin();
                                    }
                                    Member member = (Member)pm.newInstance(Member.class);
                                    member.setName(result.getAccount().getFullName());
                                    member.setAccount(result.getAccount());
                                    member.setQuality((short)5);
                                    group.addMember(Base.getInstance().getUidAsString(), member);
                                    if (isTxLocal) {
                                        pm.currentTransaction().commit();
                                    }
                                }
                            }
                            if (result.getOldUID() != null && result.getAccount() != null) {
                                this.uidMapping.put(result.getOldUID(), result.getAccount().refGetPath().getLastSegment().toString());
                            }
                        }
                        switch (result.getStatus()) {
                            case CREATED: {
                                return WebDavStore.Status.OK_CREATED;
                            }
                            case UPDATED: {
                                return WebDavStore.Status.OK;
                            }
                            case ERROR: {
                                return WebDavStore.Status.FORBIDDEN;
                            }
                        }
                        break block15;
                    }
                    return WebDavStore.Status.FORBIDDEN;
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                    return WebDavStore.Status.FORBIDDEN;
                }
            }
        }
        return WebDavStore.Status.FORBIDDEN;
    }

    @Override
    public List<Lock> getLocksByPath(RequestContext requestContext, String path) {
        return Collections.emptyList();
    }

    @Override
    public Lock lock(RequestContext requestContext, String path, String id, String owner, String scope, String type, int depth, int timeout) throws LockFailedException {
        return null;
    }

    @Override
    public boolean unlock(RequestContext requestContext, String path, String id) {
        return false;
    }
}

