/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.imap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.UIDFolder;
import javax.mail.internet.MimeMessage;
import javax.mail.search.SearchTerm;
import org.opencrx.application.adapter.AbstractSession;
import org.opencrx.kernel.activity1.cci2.ActivityGroupIsCreatedBy;
import org.opencrx.kernel.activity1.cci2.EMailQuery;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.activity1.jmi1.ActivityCreator;
import org.opencrx.kernel.activity1.jmi1.EMail;
import org.opencrx.kernel.backend.Activities;
import org.opencrx.kernel.utils.ActivityQueryHelper;
import org.opencrx.kernel.utils.MimeUtils;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.kernel.log.SysLog;
import org.w3c.format.DateTimeFormat;

public class IMAPFolderImpl
extends Folder
implements UIDFolder {
    protected static final String METAINF_FILE_NAME = ".METAINF";
    protected static final long SYNCHRONIZE_REFRESH_RATE = 60000L;
    public static final String MAILDIR_PROPERTY_NAME = "org.opencrx.maildir";
    public static final int META_INF_CREATED_AT = 0;
    public static final int META_INF_LAST_SYNCHRONIZED_AT = 1;
    public static final int META_INF_NEXT_UID = 2;
    protected final String name;
    protected File folderDir;
    protected final String username;
    protected final String folderId;
    protected final PersistenceManagerFactory pmf;

    public IMAPFolderImpl(String name, String folderId, String username, PersistenceManagerFactory pmf) {
        super(null);
        this.name = name;
        this.folderDir = new File(IMAPFolderImpl.getMailDir(username), name.toUpperCase().replace(":", "~"));
        this.folderDir.mkdirs();
        this.username = username;
        this.pmf = pmf;
        this.folderId = folderId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] loadMetaInf() {
        File metainfFile = new File(this.folderDir, METAINF_FILE_NAME);
        Object[] metainf = null;
        if (metainfFile.exists()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(metainfFile)));
                Date createdAt = DateTimeFormat.BASIC_UTC_FORMAT.parse(reader.readLine());
                Date lastSynchronizedAt = DateTimeFormat.BASIC_UTC_FORMAT.parse(reader.readLine());
                Long nextUID = Long.valueOf(reader.readLine());
                metainf = new Object[]{createdAt, lastSynchronizedAt, nextUID};
            }
            catch (Exception exception) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return metainf;
    }

    public void storeMetaInf(Object[] metainf) {
        File metainfFile = new File(this.folderDir, METAINF_FILE_NAME);
        try {
            PrintStream out = new PrintStream(metainfFile);
            for (int i = 0; i < metainf.length; ++i) {
                Object value = metainf[i];
                if (value instanceof Date) {
                    out.println(DateTimeFormat.BASIC_UTC_FORMAT.format((Date)value));
                    continue;
                }
                out.println(value.toString());
            }
            out.close();
        }
        catch (Exception e) {
            SysLog.error((String)("Can not read index file " + metainfFile), (Object)e.getMessage());
            new ServiceException(e).log();
        }
    }

    public static File getMailDir(String username) {
        return new File((System.getProperty(MAILDIR_PROPERTY_NAME) == null ? "/temp" : System.getProperty(MAILDIR_PROPERTY_NAME)) + "/" + username.replace(":", "~"));
    }

    private long getUID(File mimeFile) {
        int pos = mimeFile.getName().indexOf("-");
        if (pos > 0) {
            return Long.valueOf(mimeFile.getName().substring(0, pos));
        }
        return -1L;
    }

    private Map<Long, File> getMimeFiles() {
        TreeMap<Long, File> sortedFiles = new TreeMap<Long, File>();
        File[] files = this.folderDir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().endsWith(".eml")) continue;
                sortedFiles.put(this.getUID(files[i]), files[i]);
            }
        }
        return sortedFiles;
    }

    private MimeFileDescr getMimeFileDescr(Activity activity) {
        String activityNumber = activity.getActivityNumber().trim();
        Map<Long, File> mimeFiles = this.getMimeFiles();
        int messageNumber = 1;
        for (Map.Entry<Long, File> entry : mimeFiles.entrySet()) {
            if (entry.getValue().getName().indexOf("-" + activityNumber) <= 0) continue;
            return new MimeFileDescr(messageNumber, this.getUID(entry.getValue()), entry.getValue());
        }
        return null;
    }

    private MimeFileDescr getMimeFileDescr(long uid) {
        Map<Long, File> mimeFiles = this.getMimeFiles();
        int messageNumber = 1;
        for (Map.Entry<Long, File> entry : mimeFiles.entrySet()) {
            if (this.getUID(entry.getValue()) == uid) {
                return new MimeFileDescr(messageNumber, uid, entry.getValue());
            }
            ++messageNumber;
        }
        return null;
    }

    private MimeFileDescr getMimeFileDescr(int messageNumber) {
        Map<Long, File> mimeFiles = this.getMimeFiles();
        int index = 1;
        for (Map.Entry<Long, File> entry : mimeFiles.entrySet()) {
            if (index == messageNumber) {
                return new MimeFileDescr(messageNumber, this.getUID(entry.getValue()), entry.getValue());
            }
            ++index;
        }
        return null;
    }

    protected ActivityQueryHelper getActivitiesHelper() {
        ActivityQueryHelper activitiesHelper = new ActivityQueryHelper(AbstractSession.newPersistenceManager(this.pmf, this.username));
        try {
            activitiesHelper.parseQueryId(this.folderId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return activitiesHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendMessages(Message[] newMessages) throws MessagingException {
        block9: {
            try (ActivityQueryHelper activitiesHelper = this.getActivitiesHelper();){
                if (activitiesHelper.getActivityGroup() == null) break block9;
                ActivityCreator emailCreator = null;
                ActivityGroupIsCreatedBy.ActivityCreator activityCreators = activitiesHelper.getActivityGroup().getActivityCreator();
                Iterator iterator = activityCreators.iterator();
                while (iterator.hasNext()) {
                    ActivityCreator creator = (ActivityCreator)iterator.next();
                    if (creator.getActivityType() == null || creator.getActivityType().getActivityClass() != Activities.ActivityClass.EMAIL.getValue()) continue;
                    emailCreator = creator;
                    break;
                }
                if (emailCreator == null) break block9;
                PersistenceManager pm = activitiesHelper.getPersistenceManager();
                String providerName = emailCreator.refGetPath().get(2);
                String segmentName = emailCreator.refGetPath().get(4);
                for (Message message : newMessages) {
                    MimeMessage mimeMessage = (MimeMessage)message;
                    try {
                        Activities.getInstance().importMimeMessage(pm, providerName, segmentName, mimeMessage, emailCreator);
                    }
                    catch (Exception e) {
                        try {
                            pm.currentTransaction().rollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        SysLog.warning((String)"Can not create email activity", (Object)e.getMessage());
                        new ServiceException(e).log();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void synchronizeMailDir() {
        try (ActivityQueryHelper activitiesHelper = this.getActivitiesHelper();){
            if (activitiesHelper.getActivityGroup() != null) {
                FileOutputStream out;
                Object mappedMessage;
                MimeUtils.MimeMessageImpl mimeMessage;
                Comparable<File> mimeMessageFile;
                long uid;
                MimeFileDescr mimeFileDescr;
                PersistenceManager pm = activitiesHelper.getPersistenceManager();
                Date lastSynchronizedAt = null;
                Date createdAt = null;
                Long nextUID = null;
                Object[] metainf = this.loadMetaInf();
                if (metainf == null) {
                    File[] files = this.folderDir.listFiles();
                    if (files != null) {
                        for (int i = 0; i < files.length; ++i) {
                            if (!files[i].isFile()) continue;
                            try {
                                files[i].delete();
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    createdAt = new Date();
                    nextUID = 1L;
                } else {
                    createdAt = (Date)metainf[0];
                    lastSynchronizedAt = (Date)metainf[1];
                    nextUID = (Long)metainf[2];
                }
                EMailQuery query = (EMailQuery)pm.newQuery(EMail.class);
                if (lastSynchronizedAt != null) {
                    query.modifiedAt().greaterThanOrEqualTo((Comparable)lastSynchronizedAt);
                }
                query.activityNumber().isNonNull();
                query.forAllDisabled().isFalse();
                query.orderByActivityNumber().ascending();
                Collection<Activity> activities = activitiesHelper.getFilteredActivities(query);
                for (Activity activity : activities) {
                    mimeFileDescr = this.getMimeFileDescr(activity);
                    if (mimeFileDescr != null) continue;
                    String activityNumber = activity.getActivityNumber().trim();
                    Long l = nextUID;
                    Long l2 = nextUID = Long.valueOf(nextUID + 1L);
                    uid = l;
                    mimeMessageFile = new File(this.folderDir, uid + "-" + activityNumber + ".eml");
                    try {
                        mimeMessage = new MimeUtils.MimeMessageImpl();
                        mappedMessage = Activities.getInstance().mapToMessage((EMail)activity, (Message)mimeMessage);
                        if (mappedMessage instanceof InputStream) {
                            mimeMessage = new MimeUtils.MimeMessageImpl((InputStream)mappedMessage);
                            mimeMessage.setSubject(((EMail)activity).getMessageSubject(), "UTF-8");
                        }
                        out = new FileOutputStream((File)mimeMessageFile);
                        mimeMessage.setUid(uid);
                        mimeMessage.writeTo(out);
                        ((OutputStream)out).close();
                    }
                    catch (Exception e) {
                        SysLog.warning((String)"Unable to map activity to mime message", (Object)activityNumber);
                        new ServiceException(e).log();
                    }
                }
                if (lastSynchronizedAt != null) {
                    query = (EMailQuery)pm.newQuery(EMail.class);
                    query.activityNumber().isNonNull();
                    query.thereExistsDisabled().isTrue();
                    query.orderByActivityNumber().ascending();
                    query.modifiedAt().greaterThan((Comparable)lastSynchronizedAt);
                    activities = activitiesHelper.getFilteredActivities(query);
                    for (Activity activity : activities) {
                        mimeFileDescr = this.getMimeFileDescr(activity);
                        if (mimeFileDescr == null) continue;
                        try {
                            mimeFileDescr.getFile().delete();
                        }
                        catch (Exception activityNumber) {}
                    }
                    query = (EMailQuery)pm.newQuery(EMail.class);
                    query.activityNumber().isNonNull();
                    query.forAllDisabled().isFalse();
                    query.orderByActivityNumber().ascending();
                    query.modifiedAt().greaterThan((Comparable)lastSynchronizedAt);
                    activities = activitiesHelper.getFilteredActivities(query);
                    for (Activity activity : activities) {
                        String activityNumber = activity.getActivityNumber().trim();
                        MimeFileDescr mimeFileDescr2 = this.getMimeFileDescr(activity);
                        if (mimeFileDescr2 != null) continue;
                        mimeMessageFile = nextUID;
                        Long e = nextUID = Long.valueOf(nextUID + 1L);
                        uid = (Long)mimeMessageFile;
                        mimeMessageFile = new File(this.folderDir, uid + "-" + activityNumber + ".eml");
                        try {
                            mimeMessage = new MimeUtils.MimeMessageImpl();
                            mappedMessage = Activities.getInstance().mapToMessage((EMail)activity, (Message)mimeMessage);
                            if (mappedMessage instanceof InputStream) {
                                mimeMessage = new MimeUtils.MimeMessageImpl((InputStream)mappedMessage);
                                mimeMessage.setSubject(((EMail)activity).getMessageSubject(), "UTF-8");
                            }
                            out = new FileOutputStream((File)mimeMessageFile);
                            mimeMessage.setUid(uid);
                            mimeMessage.writeTo(out);
                            ((OutputStream)out).close();
                        }
                        catch (Exception e2) {
                            SysLog.warning((String)"Unable to map activity to mime message", (Object)activityNumber);
                            new ServiceException(e2).log();
                        }
                    }
                }
                lastSynchronizedAt = new Date();
                this.storeMetaInf(new Object[]{createdAt, lastSynchronizedAt, nextUID});
            }
        }
    }

    public void close(boolean arg0) throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public boolean create(int arg0) throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public boolean delete(boolean arg0) throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public boolean exists() throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public Message[] expunge() throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public Folder getFolder(String arg0) throws MessagingException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getMessage(int messageNumber) throws MessagingException {
        block6: {
            try (ActivityQueryHelper activitiesHelper = this.getActivitiesHelper();){
                MimeFileDescr mimeFileDescr = this.getMimeFileDescr(messageNumber);
                if (mimeFileDescr == null) break block6;
                try {
                    FileInputStream in = new FileInputStream(mimeFileDescr.getFile());
                    MimeUtils.MimeMessageImpl mimeMessage = new MimeUtils.MimeMessageImpl(in);
                    in.close();
                    mimeMessage.setUid(mimeFileDescr.getUID());
                    mimeMessage.setMessageNumber(messageNumber);
                    MimeUtils.MimeMessageImpl mimeMessageImpl = mimeMessage;
                    return mimeMessageImpl;
                }
                catch (Exception e) {
                    SysLog.error((String)("Can not read message " + mimeFileDescr.getFile()), (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    public int getMessageCount() throws MessagingException {
        this.synchronizeMailDir();
        Map<Long, File> mimeFiles = this.getMimeFiles();
        return mimeFiles.size();
    }

    public String getFullName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Folder getParent() throws MessagingException {
        return null;
    }

    public Flags getPermanentFlags() {
        throw new UnsupportedOperationException();
    }

    public char getSeparator() throws MessagingException {
        throw new MessagingException("Unsupported Operation");
    }

    public int getType() throws MessagingException {
        throw new MessagingException("Unsupported Operation");
    }

    public boolean hasNewMessages() throws MessagingException {
        return false;
    }

    public boolean isOpen() {
        return true;
    }

    public Folder[] list(String arg0) throws MessagingException {
        throw new MessagingException("Unsupported Operation");
    }

    public void open(int arg0) throws MessagingException {
        throw new MessagingException("Unsupported Operation");
    }

    public boolean renameTo(Folder arg0) throws MessagingException {
        throw new MessagingException("Unsupported Operation");
    }

    public Message getMessageByUID(long uid) throws MessagingException {
        MimeFileDescr mimeFileDescr = this.getMimeFileDescr(uid);
        if (mimeFileDescr != null) {
            try {
                FileInputStream in = new FileInputStream(mimeFileDescr.getFile());
                MimeUtils.MimeMessageImpl mimeMessage = new MimeUtils.MimeMessageImpl(in);
                in.close();
                mimeMessage.setUid(uid);
                mimeMessage.setMessageNumber(mimeFileDescr.getMessageNumber());
                return mimeMessage;
            }
            catch (Exception e) {
                SysLog.error((String)("Can not read message " + mimeFileDescr.getFile()), (Object)e.getMessage());
            }
        }
        return null;
    }

    public Message[] getMessagesByUID(long[] uids) throws MessagingException {
        throw new MessagingException("Unsupported Operation");
    }

    public Message[] getMessagesByUID(long start, long end) throws MessagingException {
        ArrayList<Message> result = new ArrayList<Message>();
        Map<Long, File> mimeFiles = this.getMimeFiles();
        for (Map.Entry<Long, File> entry : mimeFiles.entrySet()) {
            long uid = this.getUID(entry.getValue());
            if (uid < start || uid > end) continue;
            result.add(this.getMessageByUID(uid));
        }
        return result.toArray(new Message[result.size()]);
    }

    public long getUID(Message message) throws MessagingException {
        return ((MimeUtils.MimeMessageImpl)message).getUid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUIDValidity() throws MessagingException {
        try (ActivityQueryHelper activitiesHelper = this.getActivitiesHelper();){
            Object[] metainf = this.loadMetaInf();
            if (metainf == null) {
                this.synchronizeMailDir();
            }
            long l = (metainf = this.loadMetaInf()) == null ? System.currentTimeMillis() / 1000L : ((Date)metainf[0]).getTime() / 1000L;
            return l;
        }
    }

    public long getUIDNext() throws MessagingException {
        return 0L;
    }

    public Message[] search(SearchTerm searchTerm) throws MessagingException {
        ArrayList<MimeUtils.MimeMessageImpl> messages = new ArrayList<MimeUtils.MimeMessageImpl>();
        Map<Long, File> mimeFiles = this.getMimeFiles();
        int messageNumber = 1;
        for (Map.Entry<Long, File> mimeFile : mimeFiles.entrySet()) {
            try {
                FileInputStream in = new FileInputStream(mimeFile.getValue());
                MimeUtils.MimeMessageImpl mimeMessage = new MimeUtils.MimeMessageImpl(in);
                in.close();
                mimeMessage.setUid(this.getUID(mimeFile.getValue()));
                mimeMessage.setMessageNumber(messageNumber);
                mimeMessage.setFlag(Flags.Flag.SEEN, true);
                mimeMessage.setFlag(Flags.Flag.DELETED, false);
                mimeMessage.setFlag(Flags.Flag.ANSWERED, false);
                mimeMessage.setFlag(Flags.Flag.RECENT, false);
                mimeMessage.setFlag(Flags.Flag.DRAFT, false);
                if (searchTerm == null || searchTerm.match((Message)mimeMessage)) {
                    messages.add(mimeMessage);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++messageNumber;
        }
        return messages.toArray(new Message[messages.size()]);
    }

    static class MimeFileDescr {
        private final int messageNumber;
        private final long uid;
        private final File file;

        public MimeFileDescr(int messageNumber, long uid, File file) {
            this.messageNumber = messageNumber;
            this.uid = uid;
            this.file = file;
        }

        public int getMessageNumber() {
            return this.messageNumber;
        }

        public long getUID() {
            return this.uid;
        }

        public File getFile() {
            return this.file;
        }
    }
}

