/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.mail.importer;

import java.util.Iterator;
import java.util.UUID;
import javax.jdo.PersistenceManager;
import org.opencrx.kernel.admin1.jmi1.ComponentConfiguration;
import org.opencrx.kernel.admin1.jmi1.Segment;
import org.opencrx.kernel.base.cci2.PropertySetContainsProperty;
import org.opencrx.kernel.base.jmi1.BooleanProperty;
import org.opencrx.kernel.base.jmi1.Property;
import org.opencrx.kernel.base.jmi1.StringProperty;
import org.openmdx.base.accessor.jmi.cci.JmiServiceException;
import org.openmdx.base.naming.Path;
import org.openmdx.base.text.conversion.UUIDConversion;
import org.openmdx.kernel.id.UUIDs;
import org.openmdx.kernel.log.SysLog;

public class MailImporterConfig {
    private static final String COMPONENT_CONFIGURATION_ID = "MailImporterServlet";
    private static final String OPTION_MAIL_BOX = "mailbox";
    private static final String OPTION_MAIL_SERVICE_NAME = "mailServiceName";
    private static final String OPTION_MAIL_DELETE_IMPORTED_MESSAGES = "deleteImportedMessages";
    protected final String mailServiceName;
    protected final String mailbox;
    protected final boolean deleteImportedMessages;

    public MailImporterConfig(PersistenceManager pm, String providerName, String segmentName) {
        String mailServiceName = null;
        String mailbox = null;
        Boolean deleteImportedMessages = null;
        try {
            Segment adminSegment = (Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.admin1").getDescendant(new String[]{"provider", providerName, "segment", "Root"}));
            ComponentConfiguration componentConfiguration = null;
            try {
                componentConfiguration = adminSegment.getConfiguration(COMPONENT_CONFIGURATION_ID);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String optionPrefix = providerName + "." + segmentName + ".";
            if (componentConfiguration == null) {
                componentConfiguration = (ComponentConfiguration)pm.newInstance(ComponentConfiguration.class);
                componentConfiguration.setName(COMPONENT_CONFIGURATION_ID);
                pm.currentTransaction().begin();
                adminSegment.addConfiguration(COMPONENT_CONFIGURATION_ID, componentConfiguration);
                StringProperty sp = (StringProperty)pm.newInstance(StringProperty.class);
                sp.setName(optionPrefix + OPTION_MAIL_SERVICE_NAME + ".Default");
                sp.setDescription("Mail service name");
                sp.setStringValue("/mail/provider/" + providerName);
                componentConfiguration.addProperty(UUIDConversion.toUID((UUID)UUIDs.newUUID()), sp);
                sp = (StringProperty)pm.newInstance(StringProperty.class);
                sp.setName(optionPrefix + OPTION_MAIL_BOX + ".Default");
                sp.setDescription("Mailbox name");
                sp.setStringValue("INBOX");
                componentConfiguration.addProperty(UUIDConversion.toUID((UUID)UUIDs.newUUID()), sp);
                BooleanProperty bp = (BooleanProperty)pm.newInstance(BooleanProperty.class);
                bp.setName(optionPrefix + OPTION_MAIL_DELETE_IMPORTED_MESSAGES + ".Default");
                bp.setDescription("Delete imported messages");
                bp.setBooleanValue(false);
                componentConfiguration.addProperty(UUIDConversion.toUID((UUID)UUIDs.newUUID()), bp);
                pm.currentTransaction().commit();
                componentConfiguration = adminSegment.getConfiguration(COMPONENT_CONFIGURATION_ID);
            }
            for (int i = 0; i < 2; ++i) {
                String suffix = (new String[]{".Default", ""})[i];
                PropertySetContainsProperty.Property properties = componentConfiguration.getProperty();
                Iterator iterator = properties.iterator();
                while (iterator.hasNext()) {
                    Property property = (Property)iterator.next();
                    if ((optionPrefix + OPTION_MAIL_SERVICE_NAME + suffix).equals(property.getName())) {
                        mailServiceName = ((StringProperty)property).getStringValue();
                        continue;
                    }
                    if ((optionPrefix + OPTION_MAIL_BOX + suffix).equals(property.getName())) {
                        mailbox = ((StringProperty)property).getStringValue();
                        continue;
                    }
                    if (!(optionPrefix + OPTION_MAIL_DELETE_IMPORTED_MESSAGES + suffix).equals(property.getName())) continue;
                    deleteImportedMessages = new Boolean(((BooleanProperty)property).isBooleanValue());
                }
            }
            if (mailServiceName == null) {
                SysLog.warning((String)"Could not get option mailServiceName from configuration. Either it does not exist or access level browse is not set to global. Fallback to system default. Used option prefix", (Object)optionPrefix);
                SysLog.warning((String)"Checked configuration properties", componentConfiguration.getProperty());
            }
            if (mailbox == null) {
                SysLog.warning((String)"Could not get option mailbox from configuration. Either it does not exist or access level browse is not set to global. Fallback to system default. Used option prefix", (Object)optionPrefix);
                SysLog.warning((String)"Checked configuration properties", componentConfiguration.getProperty());
            }
        }
        catch (JmiServiceException e0) {
            SysLog.info((String)"Can not create default configuration", (Object)e0.getMessage());
            throw e0;
        }
        this.mailServiceName = mailServiceName == null ? "/mail/provider/" + providerName : mailServiceName;
        this.mailbox = mailbox == null ? "INBOX" : mailbox;
        this.deleteImportedMessages = deleteImportedMessages == null ? false : deleteImportedMessages;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("EMailServerConfiguration{");
        tmp.append("mailServiceName='").append(this.mailServiceName).append("', ");
        tmp.append("mailbox='").append(this.mailbox).append("', ");
        tmp.append("deleteImportedMessages='").append(this.deleteImportedMessages).append("', ");
        return tmp.toString();
    }

    public String getMailServiceName() {
        return this.mailServiceName;
    }

    public String getMailbox() {
        return this.mailbox;
    }

    public boolean deleteImportedMessages() {
        return this.deleteImportedMessages;
    }
}

