/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.mail.importer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.mail.importer.MailImporterConfig;
import org.opencrx.application.mail.importer.MailStore;
import org.opencrx.kernel.activity1.jmi1.ActivityProcess;
import org.opencrx.kernel.activity1.jmi1.ActivityTracker;
import org.opencrx.kernel.activity1.jmi1.ActivityType;
import org.opencrx.kernel.backend.Activities;
import org.opencrx.kernel.backend.Workflows;
import org.opencrx.kernel.base.cci2.SendAlertParams;
import org.opencrx.kernel.base.jmi1.SendAlertParams;
import org.opencrx.kernel.generic.SecurityKeys;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.opencrx.kernel.utils.Utils;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.mof.spi.Model_1Factory;
import org.openmdx.base.naming.Path;
import org.openmdx.kernel.log.SysLog;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class MailImporterServlet
extends HttpServlet {
    private static final long serialVersionUID = -7260829387268368633L;
    private static final String WORKFLOW_NAME = "MailImporter";
    private static final String COMMAND_EXECUTE = "/execute";
    private PersistenceManagerFactory pmf = null;
    private final Map<String, Thread> runningSegments = new ConcurrentHashMap<String, Thread>();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            Model_1Factory.getModel();
        }
        catch (Exception e) {
            SysLog.warning((String)"Can not initialize model repository", (Throwable)e);
        }
        try {
            this.pmf = Utils.getPersistenceManagerFactory();
        }
        catch (Exception e) {
            throw new ServletException("can not get connection to data provider", (Throwable)e);
        }
    }

    protected void notifyAdmin(PersistenceManager pm, String providerName, String segmentName, short importance, String subject, String message, String[] params) {
        try {
            Path adminHomeIdentity = new Path("xri://@openmdx*org.opencrx.kernel.home1").getDescendant(new String[]{"provider", providerName, "segment", segmentName, "userHome", "admin" + SecurityKeys.ID_SEPARATOR + segmentName});
            UserHome userHome = (UserHome)pm.getObjectById((Object)adminHomeIdentity);
            try {
                pm.currentTransaction().begin();
                message = (message == null || message.length() == 0 ? "" : message + ": ") + Arrays.asList(params);
                SendAlertParams sendAlertParams = (SendAlertParams)Structures.create(SendAlertParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)SendAlertParams.Member.description, (Object)message), Datatypes.member((Enum)SendAlertParams.Member.importance, (Object)importance), Datatypes.member((Enum)SendAlertParams.Member.name, (Object)("Email Importer [" + providerName + "/" + segmentName + "] " + subject)), Datatypes.member((Enum)SendAlertParams.Member.resendDelayInSeconds, null), Datatypes.member((Enum)SendAlertParams.Member.toUsers, (Object)("admin" + SecurityKeys.ID_SEPARATOR + segmentName)), Datatypes.member((Enum)SendAlertParams.Member.reference, null)});
                userHome.sendAlert(sendAlertParams);
                pm.currentTransaction().commit();
            }
            catch (Exception e) {
                try {
                    pm.currentTransaction().rollback();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
        }
    }

    protected void importMessages(PersistenceManager pm, String providerName, String segmentName, MimeMessage message, MailImporterConfig config) {
        SysLog.info((String)("Importing Message (" + providerName + "/" + segmentName + "): "), (Object)message);
        String messageId = "NA";
        try {
            messageId = message.getMessageID();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean success = true;
        try {
            Activities.getInstance().importMimeMessage(pm, providerName, segmentName, message, null);
        }
        catch (Exception e) {
            SysLog.info((String)e.getMessage(), (Throwable)e.getCause());
            this.notifyAdmin(pm, providerName, segmentName, Activities.Priority.NORMAL.getValue(), "Exception occurred when importing message (" + e.getMessage() + ")", new ServiceException(e).toString(), new String[]{messageId});
            success = false;
        }
        if (success && config.deleteImportedMessages()) {
            try {
                message.setFlag(Flags.Flag.DELETED, true);
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importMessages(String providerName, String segmentName) throws IOException {
        try (PersistenceManager pm = null;){
            pm = this.pmf.getPersistenceManager("admin" + SecurityKeys.ID_SEPARATOR + segmentName, null);
            System.out.println(new Date().toString() + ": " + WORKFLOW_NAME + " " + providerName + "/" + segmentName);
            Workflows.getInstance().initWorkflows(pm, providerName, segmentName);
            ActivityProcess emailActivityProcess = Activities.getInstance().initEmailProcess(pm, providerName, segmentName, null, (short)0);
            ActivityType emailActivityType = Activities.getInstance().initActivityType(emailActivityProcess, "E-Mails", Activities.ActivityClass.EMAIL.getValue(), null, (short)0);
            ActivityTracker emailActivityTracker = Activities.getInstance().initActivityTracker("E-Mails", null, pm, providerName, segmentName);
            Activities.getInstance().initActivityCreator("E-Mails", emailActivityType, Arrays.asList(emailActivityTracker), null);
            MailImporterConfig mailImporterConfig = new MailImporterConfig(pm, providerName, segmentName);
            MailStore mailStore = new MailStore(mailImporterConfig);
            mailStore.openStore();
            mailStore.openFolder(mailImporterConfig.getMailbox());
            Message[] messages = mailStore.getMessages();
            for (int i = 0; i < messages.length; ++i) {
                Message message = messages[i];
                if (!(message instanceof MimeMessage)) continue;
                MimeMessage mimeMessage = (MimeMessage)message;
                String messageId = "NA";
                try {
                    messageId = mimeMessage.getMessageID();
                    this.importMessages(pm, providerName, segmentName, mimeMessage, mailImporterConfig);
                    continue;
                }
                catch (Exception e) {
                    SysLog.info((String)e.getMessage(), (Throwable)e.getCause());
                    this.notifyAdmin(pm, providerName, segmentName, Activities.Priority.HIGH.getValue(), "Import of message " + messageId + " failed (" + e.getMessage() + ")", new ServiceException(e).toString(), new String[]{messageId});
                }
            }
            mailStore.closeFolder();
            mailStore.closeStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String segmentName = req.getParameter("segment");
        String providerName = req.getParameter("provider");
        String id = providerName + "/" + segmentName;
        if (COMMAND_EXECUTE.equals(req.getPathInfo())) {
            if (!this.runningSegments.containsKey(id)) {
                try {
                    this.runningSegments.put(id, Thread.currentThread());
                    this.importMessages(providerName, segmentName);
                }
                catch (Exception e) {
                    ServiceException e0 = new ServiceException(e);
                    SysLog.warning((String)"Import messages failed", (Object)e0.getMessage());
                    SysLog.warning((String)e0.getMessage(), (Throwable)e0.getCause());
                }
                finally {
                    this.runningSegments.remove(id);
                }
            } else if (!this.runningSegments.get(id).isAlive() || this.runningSegments.get(id).isInterrupted()) {
                Thread t = this.runningSegments.get(id);
                System.out.println(new Date() + ": " + WORKFLOW_NAME + " " + providerName + "/" + segmentName + ": workflow " + t.getId() + " is alive=" + t.isAlive() + "; interrupted=" + t.isInterrupted() + ". Skipping execution.");
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(200);
        res.flushBuffer();
        this.handleRequest(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(200);
        res.flushBuffer();
        this.handleRequest(req, res);
    }
}

