/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.msproject;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import org.opencrx.application.msproject.StandardCalendar;
import org.opencrx.kernel.activity1.cci2.ActivityContainsLinkTo;
import org.opencrx.kernel.activity1.cci2.ActivityGroupContainsActivity;
import org.opencrx.kernel.activity1.cci2.ActivityHasResourceAssignment;
import org.opencrx.kernel.activity1.cci2.ActivityWorkRecordQuery;
import org.opencrx.kernel.activity1.cci2.ResourceAssignmentQuery;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.activity1.jmi1.Activity1Package;
import org.opencrx.kernel.activity1.jmi1.ActivityGroup;
import org.opencrx.kernel.activity1.jmi1.ActivityLinkTo;
import org.opencrx.kernel.activity1.jmi1.ActivityWorkRecord;
import org.opencrx.kernel.activity1.jmi1.Resource;
import org.opencrx.kernel.activity1.jmi1.ResourceAssignment;
import org.opencrx.kernel.backend.Activities;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.text.conversion.XMLEncoder;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.log.SysLog;
import org.openmdx.portal.servlet.Action;

public class ProjectExporter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int MAX_ACTIVITY_LINKS = 10;
    public static final short TASK_TYPE_FIXED_UNITS = 0;
    public static final short TASK_TYPE_FIXED_DURATION = 1;
    public static final short TASK_TYPE_FIXED_WORK = 2;
    public static final String ID_EXTENDED_TASK_ATTR_IDENTITY = "188743731";
    public static final String ID_EXTENDED_TASK_ATTR_2 = "188743734";
    public static final String ID_EXTENDED_TASK_ATTR_3 = "188743737";
    public static final String ID_EXTENDED_RESOURCE_ATTR_IDENTITY = "205520904";
    public static final String ID_EXTENDED_RESOURCE_ATTR_2 = "205520905";
    public static final String ID_EXTENDED_RESOURCE_ATTR_3 = "205520926";
    private DateFormat startDateFormater = new SimpleDateFormat("yyyy-MM-dd'T00:00:00'");
    private DateFormat endDateFormater = new SimpleDateFormat("yyyy-MM-dd'T23:59:59'");
    private PrintWriter pw;
    private ActivityGroup activityGroup;
    private PersistenceManager pm;
    private String mspHyperlinkRootAddress = null;
    private boolean exportActivities = true;
    private boolean exportResources = true;
    private boolean exportAssignments = true;
    private String leadingSpaces = "";
    private int nextUid = 1;
    private short isParentOf = 1;
    private short isChildOf = (short)99;
    private short isPartOf = (short)95;
    private short isContainerOf = (short)101;
    private short mspTaskType = 0;
    private DateFormat projectDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
    private StandardCalendar mspCalendar = new StandardCalendar();
    private Map<String, ActivityMapper> activityMappers = new HashMap<String, ActivityMapper>();
    private Map<String, ResourceMapper> resourceMappers = new HashMap<String, ResourceMapper>();

    public ProjectExporter(OutputStream os, ActivityGroup activityGroup, PersistenceManager pm) {
        this.setOutputStream(os);
        this.setActivityGroup(activityGroup);
        this.pm = pm;
    }

    private String toFormatedStartDate(Date startDate) {
        GregorianCalendar start = new GregorianCalendar();
        start.setTime(startDate);
        return this.startDateFormater.format(start.getTime());
    }

    String toFormatedEndDate(Date endDate) {
        GregorianCalendar end = new GregorianCalendar();
        end.setTime(endDate);
        return this.endDateFormater.format(end.getTime());
    }

    public void setMspHyperlinkRootAddress(String mspHyperlinkRootAddress) {
        this.mspHyperlinkRootAddress = mspHyperlinkRootAddress;
    }

    public void setMspTaskType(short mspTaskType) {
        this.mspTaskType = mspTaskType;
    }

    public void setActivityGroup(ActivityGroup activityGroup) {
        this.activityGroup = activityGroup;
    }

    public void setExportActivities(Boolean enable) {
        this.exportActivities = enable == null ? true : enable;
    }

    public void setExportResources(Boolean enable) {
        this.exportResources = enable == null ? true : enable;
    }

    public void setExportAssignments(Boolean enable) {
        this.exportAssignments = enable == null ? true : enable;
    }

    public void setActivityLinkTypeCodeIsParentOf(short isParentOf) {
        this.isParentOf = isParentOf;
    }

    public void setActivityLinkTypeCodeIsChildOf(short isChildOf) {
        this.isChildOf = isChildOf;
    }

    public void setActivityLinkTypeCodeIsPartOf(short isPartOf) {
        this.isPartOf = isPartOf;
    }

    public void setActivityLinkTypeCodeIsContainerOf(short isContainerOf) {
        this.isContainerOf = isContainerOf;
    }

    public void setOutputStream(OutputStream export) {
        try {
            this.pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(export, "UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            SysLog.error((String)"Failed to open writer using UTF-8 charset, use default charset of JVM", (Throwable)e);
            this.pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(export)));
        }
    }

    public void export() throws ServiceException {
        SysLog.info((String)"export begin", (Object)this.activityGroup.refMofId());
        this.preExport();
        this.w("<?xml version=\"1.0\"  encoding=\"UTF-8\"?>");
        this.weba("Project", "xmlns=\"http://schemas.microsoft.com/project\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://schemas.microsoft.com/project mspdi.xsd\"");
        if (this.activityGroup.getName() != null) {
            this.we("Title", this.activityGroup.getName());
        }
        this.we("Subject", this.activityGroup.getName());
        this.we("CalendarUID", Integer.toString(this.mspCalendar.getUID()));
        this.we("DefaultTaskType", Short.toString(this.mspTaskType));
        this.we("NewTasksEffortDriven", "1");
        this.we("TaskUpdatesResource", "0");
        this.exportExtendedAttributes();
        this.exportCalendars();
        if (this.exportActivities) {
            this.exportTasks();
        }
        if (this.exportResources) {
            this.exportResources();
        }
        if (this.exportAssignments) {
            this.exportAssignments();
        }
        this.wee("Project");
        this.postExport();
        SysLog.info((String)"export end", (Object)this.activityGroup.getName());
    }

    private void preExport() throws ServiceException {
        this.clear();
        ActivityGroupContainsActivity.FilteredActivity activities = this.activityGroup.getFilteredActivity();
        Iterator iterator = activities.iterator();
        while (iterator.hasNext()) {
            Activity a = (Activity)iterator.next();
            a = (Activity)this.pm.getObjectById((Object)a.refGetPath());
            ActivityMapper am = new ActivityMapper(a);
            this.activityMappers.put(am.getActivity().getIdentity(), am);
        }
        Iterator<ActivityMapper> i = this.activityMappers.values().iterator();
        while (i.hasNext()) {
            this.setActivityLinks(i.next());
        }
        for (ActivityMapper am : this.activityMappers.values()) {
            if (!am.isRootActivity()) continue;
            this.setActivityMapperUid(am, 0);
        }
        int resourceUid = 0;
        Iterator<ActivityMapper> i2 = this.activityMappers.values().iterator();
        while (i2.hasNext()) {
            Activity a = i2.next().getActivity();
            ActivityHasResourceAssignment.AssignedResource assignments = a.getAssignedResource();
            Iterator iterator2 = assignments.iterator();
            while (iterator2.hasNext()) {
                ResourceAssignment assignment = (ResourceAssignment)iterator2.next();
                Resource r = assignment.getResource();
                if (r == null || this.resourceMappers.containsKey(r.getIdentity())) continue;
                this.resourceMappers.put(r.getIdentity(), new ResourceMapper(r, ++resourceUid));
            }
        }
    }

    private void setActivityMapperUid(ActivityMapper am, int deep) throws ServiceException {
        if (deep >= 10) {
            throw new ServiceException("DefaultDomain", -23, "Activities seems to be linked recursively!", new BasicException.Parameter[0]);
        }
        am.setUid(this.nextUid);
        ++this.nextUid;
        int newDeep = deep + 1;
        for (ActivityMapper next : am.getPartActivityMappers()) {
            this.setActivityMapperUid(next, newDeep);
        }
    }

    private void setActivityLinks(ActivityMapper am) {
        ActivityContainsLinkTo.ActivityLinkTo links = am.getActivity().getActivityLinkTo();
        Iterator iterator = links.iterator();
        while (iterator.hasNext()) {
            ActivityLinkTo link = (ActivityLinkTo)iterator.next();
            if (link.getActivityLinkType() != this.isPartOf && link.getActivityLinkType() != this.isContainerOf && link.getActivityLinkType() != this.isChildOf && link.getActivityLinkType() != this.isParentOf) continue;
            Activity linkedActivity = link.getLinkTo();
            if (linkedActivity == null) {
                SysLog.warning((String)("Activity " + am.getActivity().getIdentity() + " has an ActivityLinkTo that doesn't reference a linked activity"));
                continue;
            }
            ActivityMapper linkedMapper = this.activityMappers.get(linkedActivity.getIdentity());
            if (linkedMapper == null) {
                SysLog.warning((String)("Activity " + am.getActivity().getIdentity() + " has a link to an Activity outside the exported set"), (Object)linkedActivity.getIdentity());
                continue;
            }
            if (link.getActivityLinkType() == this.isPartOf) {
                linkedMapper.addPartActivityMapper(am);
                continue;
            }
            if (link.getActivityLinkType() == this.isContainerOf) {
                am.addPartActivityMapper(linkedMapper);
                continue;
            }
            if (link.getActivityLinkType() == this.isChildOf) {
                am.addPredecessorActivityMapper(linkedMapper);
                continue;
            }
            if (link.getActivityLinkType() != this.isParentOf) continue;
            linkedMapper.addPredecessorActivityMapper(am);
        }
    }

    private void postExport() {
        this.clear();
        this.pw.flush();
    }

    private void clear() {
        this.initIndent();
        this.nextUid = 1;
        this.activityMappers.clear();
        this.resourceMappers.clear();
        if (this.exportAssignments) {
            this.exportActivities = true;
            this.exportResources = true;
        }
    }

    private void exportExtendedAttributes() {
        this.web("ExtendedAttributes");
        this.web("ExtendedAttribute");
        this.we("FieldID", ID_EXTENDED_TASK_ATTR_IDENTITY);
        this.we("FieldName", "Text1");
        this.we("Alias", "opencrx.identity");
        this.wee("ExtendedAttribute");
        this.web("ExtendedAttribute");
        this.we("FieldID", ID_EXTENDED_RESOURCE_ATTR_IDENTITY);
        this.we("FieldName", "Text1");
        this.we("Alias", "opencrx.identity");
        this.wee("ExtendedAttribute");
        this.wee("ExtendedAttributes");
    }

    private void exportCalendars() {
        this.web("Calendars");
        this.w(this.mspCalendar.toXml());
        this.wee("Calendars");
    }

    private void exportTasks() {
        this.web("Tasks");
        this.exportTask0();
        ArrayList<Integer> outlineNumber = new ArrayList<Integer>();
        outlineNumber.add(new Integer(0));
        for (ActivityMapper am : this.activityMappers.values()) {
            if (!am.isRootActivity()) continue;
            outlineNumber.set(0, new Integer((Integer)outlineNumber.get(0) + 1));
            this.exportTask(am, outlineNumber);
        }
        this.wee("Tasks");
    }

    private void exportTask0() {
        this.web("Task");
        this.we("UID", "0");
        this.we("ID", "0");
        if (this.activityGroup.getName() != null) {
            this.we("Name", this.activityGroup.getName());
        }
        this.we("FixedCostAccrual", "3");
        if (this.activityGroup.getDescription() != null) {
            this.we("Notes", this.activityGroup.getDescription());
        }
        this.wee("Task");
    }

    private void exportTask(ActivityMapper am, List<Integer> outlineNumber) {
        Activity a = am.getActivity();
        Date start = a.getScheduledStart();
        Date finish = a.getScheduledEnd();
        String durationFormat = "39";
        int percentComplete = a.getPercentComplete() == null ? 0 : a.getPercentComplete().intValue();
        int workingMinutesDuringScheduledPeriod = this.mspCalendar.getWorkingMinutes(a.getScheduledStart() == null ? new Date() : a.getScheduledStart(), a.getScheduledEnd() == null ? new Date() : a.getScheduledEnd());
        int mainEstimateMinutes = (a.getMainEstimateEffortHours() == null ? 0 : a.getMainEstimateEffortHours() * 60) + (a.getMainEstimateEffortMinutes() == null ? 0 : a.getMainEstimateEffortMinutes());
        if (mainEstimateMinutes == 0) {
            mainEstimateMinutes = workingMinutesDuringScheduledPeriod;
        }
        int actualDurationMinutes = percentComplete * mainEstimateMinutes / 100;
        Date earlyStart = a.getScheduledStart();
        Date earlyFinish = a.getScheduledEnd();
        Date lateStart = a.getActualStart();
        Date lateFinish = a.getActualEnd();
        Date actualStart = a.getActualStart();
        Date actualFinish = a.getActualEnd();
        int effortDriven = 1;
        int uid = am.getUid();
        int id = am.getUid();
        String name = "#" + a.getActivityNumber() + ": " + (a.getName() == null ? "" : a.getName());
        String outlineNo = ProjectExporter.outlineNumberToString(outlineNumber);
        int outlineLevel = outlineNumber.size();
        short priority = a.getPriority();
        Date createDate = a.getCreatedAt();
        String notes = this.toMsProjectNotes(a.getDescription(), a.getDetailedDescription());
        if (actualStart != null) {
            start = actualStart;
        }
        if (actualFinish != null) {
            finish = actualFinish;
        }
        if (actualFinish != null) {
            durationFormat = "7";
        }
        am.setTaskAttributes(start, finish, actualFinish);
        this.web("Task");
        this.we("UID", Integer.toString(uid));
        this.we("ID", Integer.toString(id));
        if (name != null) {
            this.we("Name", name);
        }
        this.we("Type", Short.toString(this.mspTaskType));
        if (createDate != null) {
            this.we("CreateDate", this.toMsProjectDate(createDate));
        }
        if (outlineNo != null) {
            this.we("OutlineNumber", outlineNo);
        }
        this.we("OutlineLevel", Integer.toString(outlineLevel));
        this.we("Priority", Short.toString(priority));
        if (start != null) {
            this.we("Start", this.toFormatedStartDate(start));
        }
        if (finish != null) {
            this.we("Finish", this.toFormatedEndDate(finish));
        }
        this.we("DurationFormat", durationFormat);
        this.we("EffortDriven", Integer.toString(effortDriven));
        if (earlyStart != null) {
            this.we("EarlyStart", this.toFormatedStartDate(earlyStart));
        }
        if (earlyFinish != null) {
            this.we("EarlyFinish", this.toFormatedEndDate(earlyFinish));
        }
        if (lateStart != null) {
            this.we("LateStart", this.toFormatedStartDate(lateStart));
        }
        if (lateFinish != null) {
            this.we("LateFinish", this.toFormatedEndDate(lateFinish));
        }
        this.we("FixedCostAccrual", "3");
        if (actualStart != null) {
            this.we("ActualStart", this.toFormatedStartDate(actualStart));
        }
        if (actualFinish != null) {
            this.we("ActualFinish", this.toFormatedEndDate(actualFinish));
        }
        this.we("PercentComplete", Integer.toString(percentComplete));
        int normalizedActualDurationMinutes = actualDurationMinutes * workingMinutesDuringScheduledPeriod / (mainEstimateMinutes == 0 ? 1 : mainEstimateMinutes);
        normalizedActualDurationMinutes = Math.abs(normalizedActualDurationMinutes);
        this.we("ActualDuration", ProjectExporter.toMSProjectDuration(normalizedActualDurationMinutes / 60, normalizedActualDurationMinutes % 60));
        this.we("CalendarUID", Integer.toString(this.mspCalendar.getUID()));
        this.exportHyperlink(a.getIdentity());
        this.we("IgnoreResourceCalendar", "true");
        this.we("Notes", notes);
        Iterator<ActivityMapper> i = am.getPredecessorActivityMappers().iterator();
        while (i.hasNext()) {
            this.exportPredecessorLink(i.next());
        }
        this.exportExtendedAttribute(ID_EXTENDED_TASK_ATTR_IDENTITY, a.getIdentity());
        this.wee("Task");
        int lastOutlineNumberIx = outlineNumber.size();
        int lastOutlineNumber = 0;
        outlineNumber.add(lastOutlineNumberIx, new Integer(lastOutlineNumber));
        Iterator<ActivityMapper> i2 = am.getPartActivityMappers().iterator();
        while (i2.hasNext()) {
            outlineNumber.set(lastOutlineNumberIx, new Integer(++lastOutlineNumber));
            this.exportTask(i2.next(), outlineNumber);
        }
        outlineNumber.remove(lastOutlineNumberIx);
    }

    private void exportPredecessorLink(ActivityMapper predecessor) {
        this.web("PredecessorLink");
        this.we("PredecessorUID", Integer.toString(predecessor.getUid()));
        this.wee("PredecessorLink");
    }

    private void exportResources() {
        this.web("Resources");
        this.exportResource0();
        ResourceMapper[] resourceMappersArr = new ResourceMapper[this.resourceMappers.size()];
        Iterator<ResourceMapper> i = this.resourceMappers.values().iterator();
        while (i.hasNext()) {
            ResourceMapper rm;
            resourceMappersArr[rm.getUid() - 1] = rm = i.next();
        }
        for (int i2 = 0; i2 < resourceMappersArr.length; ++i2) {
            this.exportResource(resourceMappersArr[i2]);
        }
        this.wee("Resources");
    }

    private void exportResource0() {
        this.web("Resource");
        this.we("UID", "0");
        this.we("ID", "0");
        this.wee("Resource");
    }

    private void exportResource(ResourceMapper rm) {
        Resource r = rm.getResource();
        int uid = rm.getUid();
        int id = rm.getUid();
        String name = r.getName() == null ? null : r.getName();
        String type = "1";
        String notes = r.getDescription() == null ? null : r.getDescription();
        this.web("Resource");
        this.we("UID", Integer.toString(uid));
        this.we("ID", Integer.toString(id));
        if (name != null) {
            this.we("Name", name);
        }
        if (type != null) {
            this.we("Type", type);
        }
        this.exportHyperlink(r.getIdentity());
        if (notes != null) {
            this.we("Notes", notes);
        }
        this.exportExtendedAttribute(ID_EXTENDED_RESOURCE_ATTR_IDENTITY, r.getIdentity());
        this.wee("Resource");
    }

    private void exportAssignments() {
        ResourceAssignmentQuery filter = null;
        this.web("Assignments");
        int assignmentUid = 0;
        for (ActivityMapper am : this.activityMappers.values()) {
            Activity a = am.getActivity();
            if (filter == null) {
                Activity1Package pkg = (Activity1Package)a.refImmediatePackage();
                filter = pkg.createResourceAssignmentQuery();
                filter.orderByResourceOrder().ascending();
            }
            ArrayList<AssignmentMapper> assignmentMappers = new ArrayList<AssignmentMapper>();
            int totalWorkPercentage = 0;
            List assignments = a.getAssignedResource(filter);
            for (ResourceAssignment ra : assignments) {
                totalWorkPercentage = ra.getWorkDurationPercentage() == null || ra.getWorkDurationPercentage() < 0 ? (totalWorkPercentage += 100) : (totalWorkPercentage += ra.getWorkDurationPercentage().shortValue());
                assignmentMappers.add(new AssignmentMapper(++assignmentUid, ra, am, this.resourceMappers.get(ra.getResource().getIdentity())));
            }
            if (totalWorkPercentage == 0) {
                totalWorkPercentage = 100 * assignmentMappers.size();
            }
            for (int j = 0; j < assignmentMappers.size(); ++j) {
                AssignmentMapper assignmentMapper = (AssignmentMapper)assignmentMappers.get(j);
                this.exportAssignment(assignmentMappers.size(), assignmentMapper);
            }
        }
        this.wee("Assignments");
    }

    private void exportAssignment(int noOfAssignments, AssignmentMapper assignment) {
        this.web("Assignment");
        this.we("UID", Integer.toString(assignment.getUid()));
        this.we("TaskUID", Integer.toString(assignment.getTaskUid()));
        this.we("ResourceUID", Integer.toString(assignment.getResourceUid()));
        this.we("ActualWork", ProjectExporter.toMSProjectDuration(assignment.getActualWorkHours(), 0));
        if (assignment.getFinish() != null) {
            this.we("Finish", this.toMsProjectDate(assignment.getFinish()));
        }
        this.exportHyperlink(assignment.getResourceAssignment().getIdentity());
        this.we("Units", Double.toString(1.0 * (double)assignment.getWorkDurationPercentage() / 100.0));
        this.web("TimephasedData");
        this.we("Type", "2");
        this.we("UID", "2");
        if (assignment.getStart() != null) {
            this.we("Start", this.toMsProjectDate(assignment.getStart()));
        }
        if (assignment.getFinish() != null) {
            this.we("Finish", this.toMsProjectDate(assignment.getFinish()));
        }
        this.we("Unit", "2");
        this.we("Value", ProjectExporter.toMSProjectDuration(assignment.getActualWorkHours(), 0));
        this.wee("TimephasedData");
        this.wee("Assignment");
    }

    private void exportHyperlink(String identity) {
        this.we("Hyperlink", "hyperlink to corresponding openCRX object");
        if (this.mspHyperlinkRootAddress == null) {
            this.we("HyperlinkAddress", identity);
        } else {
            Action action = new Action(6, new Action.Parameter[]{new Action.Parameter("xri", identity)}, "", true);
            this.we("HyperlinkAddress", this.mspHyperlinkRootAddress + "/" + action.getParameter());
        }
    }

    private static String outlineNumberToString(List<Integer> outlineNumber) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < outlineNumber.size(); ++i) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(outlineNumber.get(i));
        }
        return buf.toString();
    }

    private String toMsProjectDate(Date d) {
        return this.projectDateFormatter.format(d);
    }

    private String toMsProjectNotes(String description, String detail) {
        StringBuffer b = new StringBuffer();
        if (description != null) {
            b.append(description);
            b.append(LINE_SEPARATOR);
            b.append(LINE_SEPARATOR);
        }
        if (detail != null) {
            b.append(detail);
        }
        return b.toString();
    }

    private void exportExtendedAttribute(String fieldID, String value) {
        this.web("ExtendedAttribute");
        this.we("FieldID", fieldID);
        this.we("Value", value);
        this.wee("ExtendedAttribute");
    }

    private void w(String stringToExport) {
        this.pw.print(this.leadingSpaces);
        this.pw.println(stringToExport);
    }

    private void we(String element, String value) {
        this.pw.print(this.leadingSpaces);
        this.pw.print("<");
        this.pw.print(element);
        this.pw.print(">");
        this.pw.print(XMLEncoder.encode((String)value));
        this.pw.print("</");
        this.pw.print(element);
        this.pw.println(">");
    }

    private void web(String element) {
        this.pw.print(this.leadingSpaces);
        this.pw.print("<");
        this.pw.print(element);
        this.pw.println(">");
        this.incrementIndent();
    }

    private void weba(String element, String attributes) {
        this.pw.print(this.leadingSpaces);
        this.pw.print("<");
        this.pw.print(element);
        this.pw.print(" ");
        this.pw.print(attributes);
        this.pw.println(">");
        this.incrementIndent();
    }

    private void wee(String element) {
        this.decrementIndent();
        this.pw.print(this.leadingSpaces);
        this.pw.print("</");
        this.pw.print(element);
        this.pw.println(">");
    }

    private void incrementIndent() {
        this.leadingSpaces = this.leadingSpaces + "  ";
    }

    private void decrementIndent() {
        this.leadingSpaces = this.leadingSpaces.substring(0, this.leadingSpaces.length() - 2);
    }

    private void initIndent() {
        this.leadingSpaces = "";
    }

    public void close() throws Throwable {
        if (this.pw != null) {
            this.pw.close();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private static String toMSProjectDuration(int hours, int minutes) {
        return "PT" + hours + "H" + minutes + "M0S";
    }

    private static class AssignmentMapper {
        private ResourceAssignment resourceAssignment;
        private ActivityMapper activityMapper;
        private ResourceMapper resourceMapper;
        private int uid;
        private short workDurationPercentage;
        private int actualWorkHours;

        public AssignmentMapper(int uid, ResourceAssignment ra, ActivityMapper am, ResourceMapper rm) {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)ra);
            this.resourceAssignment = ra;
            this.activityMapper = am;
            this.resourceMapper = rm;
            this.uid = uid;
            ActivityWorkRecordQuery workRecordQuery = (ActivityWorkRecordQuery)pm.newQuery(ActivityWorkRecord.class);
            workRecordQuery.recordType().elementOf(new Object[]{Activities.WorkRecordType.OVERTIME.getValue(), Activities.WorkRecordType.STANDARD.getValue()});
            List workRecords = ra.getWorkRecord(workRecordQuery);
            BigDecimal totalAmount = new BigDecimal(0.0);
            for (ActivityWorkRecord workRecord : workRecords) {
                totalAmount = totalAmount.add(workRecord.getQuantity());
            }
            this.actualWorkHours = totalAmount.intValue();
            this.workDurationPercentage = (short)(ra.getWorkDurationPercentage() == null ? 100 : (int)ra.getWorkDurationPercentage().shortValue());
        }

        public int getUid() {
            return this.uid;
        }

        public int getTaskUid() {
            return this.activityMapper.getUid();
        }

        public int getResourceUid() {
            return this.resourceMapper.getUid();
        }

        public Date getFinish() {
            return this.activityMapper.getTaskFinish();
        }

        public Date getStart() {
            return this.activityMapper.getTaskStart();
        }

        public ResourceAssignment getResourceAssignment() {
            return this.resourceAssignment;
        }

        public short getWorkDurationPercentage() {
            return this.workDurationPercentage;
        }

        public int getActualWorkHours() {
            return this.actualWorkHours;
        }
    }

    private static class ResourceMapper {
        private Resource resource;
        private int uid;

        public ResourceMapper(Resource r, int uid) {
            this.resource = r;
            this.uid = uid;
        }

        Resource getResource() {
            return this.resource;
        }

        int getUid() {
            return this.uid;
        }
    }

    private static class ActivityMapper {
        private Activity activity;
        private int uid;
        private boolean isRoot = true;
        private Map<String, ActivityMapper> partActivityMappers = new HashMap<String, ActivityMapper>();
        private Map<String, ActivityMapper> predecessorActivityMappers = new HashMap<String, ActivityMapper>();
        private Date taskStart = null;
        private Date taskFinish = null;

        public ActivityMapper(Activity a) {
            this.activity = a;
        }

        Activity getActivity() {
            return this.activity;
        }

        int getUid() {
            return this.uid;
        }

        void setUid(int uid) {
            this.uid = uid;
        }

        boolean isRootActivity() {
            return this.isRoot;
        }

        Collection<ActivityMapper> getPartActivityMappers() {
            return this.partActivityMappers.values();
        }

        Collection<ActivityMapper> getPredecessorActivityMappers() {
            return this.predecessorActivityMappers.values();
        }

        void addPartActivityMapper(ActivityMapper an) {
            this.partActivityMappers.put(an.activity.getIdentity(), an);
            an.isRoot = false;
        }

        void addPredecessorActivityMapper(ActivityMapper an) {
            this.predecessorActivityMappers.put(an.activity.getIdentity(), an);
        }

        void setTaskAttributes(Date start, Date finish, Date actualFinish) {
            this.taskStart = start;
            this.taskFinish = finish;
        }

        Date getTaskStart() {
            return this.taskStart;
        }

        Date getTaskFinish() {
            return this.taskFinish;
        }
    }
}

