/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opencrx.application.uses.ezvcard.VCard;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.io.scribe.ScribeIndex;
import org.opencrx.application.uses.ezvcard.io.scribe.VCardPropertyScribe;
import org.opencrx.application.uses.ezvcard.parameter.AddressType;
import org.opencrx.application.uses.ezvcard.property.Address;
import org.opencrx.application.uses.ezvcard.property.Label;
import org.opencrx.application.uses.ezvcard.property.ProductId;
import org.opencrx.application.uses.ezvcard.property.RawProperty;
import org.opencrx.application.uses.ezvcard.property.VCardProperty;

public abstract class StreamWriter
implements Closeable {
    protected ScribeIndex index = new ScribeIndex();
    protected boolean addProdId = true;
    protected boolean versionStrict = true;

    public void write(VCard vcard) throws IOException {
        List<VCardProperty> properties = this.prepare(vcard);
        this._write(vcard, properties);
    }

    protected abstract void _write(VCard var1, List<VCardProperty> var2) throws IOException;

    protected abstract VCardVersion getTargetVersion();

    public boolean isAddProdId() {
        return this.addProdId;
    }

    public void setAddProdId(boolean addProdId) {
        this.addProdId = addProdId;
    }

    public boolean isVersionStrict() {
        return this.versionStrict;
    }

    public void setVersionStrict(boolean versionStrict) {
        this.versionStrict = versionStrict;
    }

    public void registerScribe(VCardPropertyScribe<? extends VCardProperty> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
    }

    private List<VCardProperty> prepare(VCard vcard) {
        VCardVersion targetVersion = this.getTargetVersion();
        ArrayList<VCardProperty> propertiesToAdd = new ArrayList<VCardProperty>();
        HashSet unregistered = new HashSet();
        for (VCardProperty property : vcard) {
            Address adr;
            String labelStr;
            if (this.addProdId && property instanceof ProductId || this.versionStrict && !property.getSupportedVersions().contains((Object)targetVersion)) continue;
            if (!this.index.hasPropertyScribe(property)) {
                unregistered.add(property.getClass());
                continue;
            }
            propertiesToAdd.add(property);
            if (!(property instanceof Address) || targetVersion != VCardVersion.V2_1 && targetVersion != VCardVersion.V3_0 || (labelStr = (adr = (Address)property).getLabel()) == null) continue;
            Label label = new Label(labelStr);
            for (AddressType adrType : adr.getTypes()) {
                label.addType(adrType);
            }
            propertiesToAdd.add(label);
        }
        if (!unregistered.isEmpty()) {
            throw new IllegalArgumentException("No scribes were found the following property classes: " + unregistered);
        }
        if (this.addProdId) {
            RawProperty property = new RawProperty("X-PRODID", "//OPENCRX//V3//EN");
            propertiesToAdd.add(property);
        }
        return propertiesToAdd;
    }
}

