/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io.scribe;

import java.util.List;
import org.opencrx.application.uses.ezvcard.VCard;
import org.opencrx.application.uses.ezvcard.VCardDataType;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.io.scribe.VCardPropertyScribe;
import org.opencrx.application.uses.ezvcard.io.xml.XCardElement;
import org.opencrx.application.uses.ezvcard.parameter.Encoding;
import org.opencrx.application.uses.ezvcard.parameter.MediaTypeParameter;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameter;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameters;
import org.opencrx.application.uses.ezvcard.property.BinaryProperty;
import org.opencrx.application.uses.ezvcard.util.DataUri;
import org.opencrx.application.uses.org.apache.commons.codec.binary.Base64;

public abstract class BinaryPropertyScribe<T extends BinaryProperty<U>, U extends MediaTypeParameter>
extends VCardPropertyScribe<T> {
    public BinaryPropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName);
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        switch (version) {
            case V2_1: 
            case V3_0: {
                return null;
            }
            case V4_0: {
                return VCardDataType.URI;
            }
        }
        return null;
    }

    @Override
    protected VCardDataType _dataType(T property, VCardVersion version) {
        if (((BinaryProperty)property).getUrl() != null) {
            switch (version) {
                case V2_1: {
                    return VCardDataType.URL;
                }
                case V3_0: 
                case V4_0: {
                    return VCardDataType.URI;
                }
            }
        }
        if (((BinaryProperty)property).getData() != null) {
            switch (version) {
                case V2_1: 
                case V3_0: {
                    return null;
                }
                case V4_0: {
                    return VCardDataType.URI;
                }
            }
        }
        return this._defaultDataType(version);
    }

    @Override
    protected void _prepareParameters(T property, VCardParameters copy, VCardVersion version, VCard vcard) {
        Object contentType = ((BinaryProperty)property).getContentType();
        if (contentType == null) {
            contentType = new MediaTypeParameter(null, null, null);
        }
        if (((BinaryProperty)property).getUrl() != null) {
            copy.setEncoding(null);
            switch (version) {
                case V2_1: {
                    copy.setType(((VCardParameter)contentType).getValue());
                    copy.setMediaType(null);
                    return;
                }
                case V3_0: {
                    copy.setType(((VCardParameter)contentType).getValue());
                    copy.setMediaType(null);
                    return;
                }
                case V4_0: {
                    copy.setMediaType(((MediaTypeParameter)contentType).getMediaType());
                    return;
                }
            }
        }
        if (((BinaryProperty)property).getData() != null) {
            copy.setMediaType(null);
            switch (version) {
                case V2_1: {
                    copy.setEncoding(Encoding.BASE64);
                    copy.setType(((VCardParameter)contentType).getValue());
                    return;
                }
                case V3_0: {
                    copy.setEncoding(Encoding.B);
                    copy.setType(((VCardParameter)contentType).getValue());
                    return;
                }
                case V4_0: {
                    copy.setEncoding(null);
                    return;
                }
            }
        }
    }

    @Override
    protected String _writeText(T property, VCardVersion version) {
        return this.write(property, version);
    }

    @Override
    protected T _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        value = BinaryPropertyScribe.unescape(value);
        return this.parse(value, dataType, parameters, version, warnings);
    }

    @Override
    protected void _writeXml(T property, XCardElement parent) {
        parent.append(VCardDataType.URI, this.write(property, parent.version()));
    }

    @Override
    protected T _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        String value = element.first(VCardDataType.URI);
        if (value != null) {
            return this.parse(value, VCardDataType.URI, parameters, element.version(), warnings);
        }
        throw BinaryPropertyScribe.missingXmlElements(VCardDataType.URI);
    }

    protected T cannotUnmarshalValue(String value, VCardVersion version, List<String> warnings, U contentType) {
        switch (version) {
            case V2_1: 
            case V3_0: {
                if (value.startsWith("http")) {
                    return this._newInstance(value, contentType);
                }
                return this._newInstance(Base64.decodeBase64(value), contentType);
            }
            case V4_0: {
                return this._newInstance(value, contentType);
            }
        }
        return null;
    }

    protected abstract U _buildMediaTypeObj(String var1);

    protected abstract U _buildTypeObj(String var1);

    protected abstract T _newInstance(String var1, U var2);

    protected abstract T _newInstance(byte[] var1, U var2);

    protected U parseContentType(VCardParameters parameters, VCardVersion version) {
        switch (version) {
            case V2_1: 
            case V3_0: {
                String type = parameters.getType();
                if (type == null) break;
                return this._buildTypeObj(type);
            }
            case V4_0: {
                String mediaType = parameters.getMediaType();
                if (mediaType == null) break;
                return this._buildMediaTypeObj(mediaType);
            }
        }
        return null;
    }

    private T parse(String value, VCardDataType dataType, VCardParameters parameters, VCardVersion version, List<String> warnings) {
        U contentType = this.parseContentType(parameters, version);
        switch (version) {
            case V2_1: 
            case V3_0: {
                if (dataType == VCardDataType.URL || dataType == VCardDataType.URI) {
                    return this._newInstance(value, contentType);
                }
                Encoding encodingSubType = parameters.getEncoding();
                if (encodingSubType != Encoding.BASE64 && encodingSubType != Encoding.B) break;
                return this._newInstance(Base64.decodeBase64(value), contentType);
            }
            case V4_0: {
                try {
                    DataUri uri = new DataUri(value);
                    contentType = this._buildMediaTypeObj(uri.getContentType());
                    return this._newInstance(uri.getData(), contentType);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return this.cannotUnmarshalValue(value, version, warnings, contentType);
    }

    private String write(T property, VCardVersion version) {
        String url = ((BinaryProperty)property).getUrl();
        if (url != null) {
            return url;
        }
        byte[] data = ((BinaryProperty)property).getData();
        if (data != null) {
            switch (version) {
                case V2_1: 
                case V3_0: {
                    return new String(Base64.encodeBase64(data));
                }
                case V4_0: {
                    Object contentType = ((BinaryProperty)property).getContentType();
                    String mediaType = contentType == null || ((MediaTypeParameter)contentType).getMediaType() == null ? "application/octet-stream" : ((MediaTypeParameter)contentType).getMediaType();
                    return new DataUri(mediaType, data).toString();
                }
            }
        }
        return "";
    }
}

