/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io.scribe;

import java.util.List;
import org.opencrx.application.uses.ezvcard.VCardDataType;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.io.CannotParseException;
import org.opencrx.application.uses.ezvcard.io.scribe.VCardPropertyScribe;
import org.opencrx.application.uses.ezvcard.io.xml.XCardElement;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameters;
import org.opencrx.application.uses.ezvcard.property.ClientPidMap;

public class ClientPidMapScribe
extends VCardPropertyScribe<ClientPidMap> {
    public ClientPidMapScribe() {
        super(ClientPidMap.class, "CLIENTPIDMAP");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected String _writeText(ClientPidMap property, VCardVersion version) {
        return ClientPidMapScribe.structured(property.getPid(), property.getUri());
    }

    @Override
    protected ClientPidMap _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        VCardPropertyScribe.SemiStructuredIterator it = ClientPidMapScribe.semistructured(value, 2);
        String pid = it.next();
        String uri = it.next();
        if (pid == null || uri == null) {
            throw new CannotParseException(3, new Object[0]);
        }
        return this.parse(pid, uri);
    }

    @Override
    protected void _writeXml(ClientPidMap property, XCardElement parent) {
        Integer pid = property.getPid();
        parent.append("sourceid", pid == null ? "" : pid.toString());
        parent.append(VCardDataType.URI, property.getUri());
    }

    @Override
    protected ClientPidMap _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        String sourceid = element.first("sourceid");
        String uri = element.first(VCardDataType.URI);
        if (uri == null && sourceid == null) {
            throw ClientPidMapScribe.missingXmlElements(VCardDataType.URI.getName().toLowerCase(), "sourceid");
        }
        if (uri == null) {
            throw ClientPidMapScribe.missingXmlElements(VCardDataType.URI);
        }
        if (sourceid == null) {
            throw ClientPidMapScribe.missingXmlElements("sourceid");
        }
        return this.parse(sourceid, uri);
    }

    private ClientPidMap parse(String pid, String uri) {
        try {
            return new ClientPidMap(Integer.parseInt(pid), uri);
        }
        catch (NumberFormatException e) {
            throw new CannotParseException(4, new Object[0]);
        }
    }
}

