/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io.scribe;

import java.util.Date;
import java.util.List;
import org.opencrx.application.uses.ezvcard.Messages;
import org.opencrx.application.uses.ezvcard.VCardDataType;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.io.CannotParseException;
import org.opencrx.application.uses.ezvcard.io.scribe.VCardPropertyScribe;
import org.opencrx.application.uses.ezvcard.io.xml.XCardElement;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameters;
import org.opencrx.application.uses.ezvcard.property.DateOrTimeProperty;
import org.opencrx.application.uses.ezvcard.util.PartialDate;

public abstract class DateOrTimePropertyScribe<T extends DateOrTimeProperty>
extends VCardPropertyScribe<T> {
    public DateOrTimePropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName);
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        switch (version) {
            case V2_1: 
            case V3_0: {
                return null;
            }
            case V4_0: {
                return VCardDataType.DATE_AND_OR_TIME;
            }
        }
        return null;
    }

    @Override
    protected VCardDataType _dataType(T property, VCardVersion version) {
        switch (version) {
            case V2_1: 
            case V3_0: {
                return null;
            }
            case V4_0: {
                if (((DateOrTimeProperty)property).getText() != null) {
                    return VCardDataType.TEXT;
                }
                if (((DateOrTimeProperty)property).getDate() != null || ((DateOrTimeProperty)property).getPartialDate() != null) {
                    return ((DateOrTimeProperty)property).hasTime() ? VCardDataType.DATE_TIME : VCardDataType.DATE;
                }
                return VCardDataType.DATE_AND_OR_TIME;
            }
        }
        return null;
    }

    @Override
    protected String _writeText(T property, VCardVersion version) {
        Date date = ((DateOrTimeProperty)property).getDate();
        if (date != null) {
            boolean extended = version == VCardVersion.V3_0;
            return DateOrTimePropertyScribe.date(date).time(((DateOrTimeProperty)property).hasTime()).extended(extended).utc(false).write();
        }
        if (version == VCardVersion.V4_0) {
            String text = ((DateOrTimeProperty)property).getText();
            if (text != null) {
                return DateOrTimePropertyScribe.escape(text);
            }
            PartialDate partialDate = ((DateOrTimeProperty)property).getPartialDate();
            if (partialDate != null) {
                return partialDate.toDateAndOrTime(false);
            }
        }
        return "";
    }

    @Override
    protected T _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        value = DateOrTimePropertyScribe.unescape(value);
        if (version == VCardVersion.V4_0 && dataType == VCardDataType.TEXT) {
            return this.newInstance(value);
        }
        return this.parse(value, version, warnings);
    }

    @Override
    protected void _writeXml(T property, XCardElement parent) {
        Date date = ((DateOrTimeProperty)property).getDate();
        if (date != null) {
            boolean hasTime = ((DateOrTimeProperty)property).hasTime();
            String value = DateOrTimePropertyScribe.date(date).time(hasTime).extended(false).utc(false).write();
            VCardDataType dataType = hasTime ? VCardDataType.DATE_TIME : VCardDataType.DATE;
            parent.append(dataType, value);
            return;
        }
        PartialDate partialDate = ((DateOrTimeProperty)property).getPartialDate();
        if (partialDate != null) {
            VCardDataType dataType = partialDate.hasTimeComponent() && partialDate.hasDateComponent() ? VCardDataType.DATE_TIME : (partialDate.hasTimeComponent() ? VCardDataType.TIME : (partialDate.hasDateComponent() ? VCardDataType.DATE : VCardDataType.DATE_AND_OR_TIME));
            parent.append(dataType, partialDate.toDateAndOrTime(false));
            return;
        }
        String text = ((DateOrTimeProperty)property).getText();
        if (text != null) {
            parent.append(VCardDataType.TEXT, text);
            return;
        }
        parent.append(VCardDataType.DATE_AND_OR_TIME, "");
    }

    @Override
    protected T _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        String value = element.first(VCardDataType.DATE, VCardDataType.DATE_TIME, VCardDataType.DATE_AND_OR_TIME);
        if (value != null) {
            return this.parse(value, element.version(), warnings);
        }
        value = element.first(VCardDataType.TEXT);
        if (value != null) {
            return this.newInstance(value);
        }
        throw DateOrTimePropertyScribe.missingXmlElements(VCardDataType.DATE, VCardDataType.DATE_TIME, VCardDataType.DATE_AND_OR_TIME, VCardDataType.TEXT);
    }

    private T parse(String value, VCardVersion version, List<String> warnings) {
        try {
            boolean hasTime = value.contains("T");
            return this.newInstance(DateOrTimePropertyScribe.date(value), hasTime);
        }
        catch (IllegalArgumentException e) {
            if (version == VCardVersion.V2_1 || version == VCardVersion.V3_0) {
                throw new CannotParseException(5, new Object[0]);
            }
            try {
                return this.newInstance(new PartialDate(value));
            }
            catch (IllegalArgumentException e2) {
                warnings.add(Messages.INSTANCE.getParseMessage(6, new Object[0]));
                return this.newInstance(value);
            }
        }
    }

    protected abstract T newInstance(String var1);

    protected abstract T newInstance(Date var1, boolean var2);

    protected abstract T newInstance(PartialDate var1);
}

