/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io.scribe;

import java.util.List;
import org.opencrx.application.uses.ezvcard.VCardDataType;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.io.scribe.VCardPropertyScribe;
import org.opencrx.application.uses.ezvcard.io.xml.XCardElement;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameters;
import org.opencrx.application.uses.ezvcard.property.Gender;

public class GenderScribe
extends VCardPropertyScribe<Gender> {
    public GenderScribe() {
        super(Gender.class, "GENDER");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected String _writeText(Gender property, VCardVersion version) {
        String gender = property.getGender();
        String text = property.getText();
        if (text != null) {
            return GenderScribe.structured(gender, text);
        }
        if (gender != null) {
            return GenderScribe.structured(new Object[]{gender});
        }
        return "";
    }

    @Override
    protected Gender _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        VCardPropertyScribe.SemiStructuredIterator it = GenderScribe.semistructured(value, 2);
        String sex = it.next();
        if (sex != null) {
            sex = sex.length() == 0 ? null : sex.toUpperCase();
        }
        String text = it.next();
        Gender property = new Gender(sex);
        property.setText(text);
        return property;
    }

    @Override
    protected void _writeXml(Gender property, XCardElement parent) {
        parent.append("sex", property.getGender());
        String text = property.getText();
        if (text != null) {
            parent.append("identity", text);
        }
    }

    @Override
    protected Gender _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        String sex = element.first("sex");
        if (sex != null) {
            Gender property = new Gender(sex);
            property.setText(element.first("identity"));
            return property;
        }
        throw GenderScribe.missingXmlElements("sex");
    }
}

