/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io.scribe;

import java.util.List;
import org.opencrx.application.uses.ezvcard.VCardDataType;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.io.scribe.VCardPropertyScribe;
import org.opencrx.application.uses.ezvcard.io.xml.XCardElement;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameters;
import org.opencrx.application.uses.ezvcard.property.ListProperty;
import org.opencrx.application.uses.ezvcard.property.TextListProperty;

public abstract class ListPropertyScribe<T extends TextListProperty>
extends VCardPropertyScribe<T> {
    public ListPropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName);
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected String _writeText(T property, VCardVersion version) {
        return ListPropertyScribe.list(((ListProperty)property).getValues());
    }

    @Override
    protected T _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        List<String> values = ListPropertyScribe.list(value);
        return this.parse(values);
    }

    @Override
    protected void _writeXml(T property, XCardElement parent) {
        parent.append(VCardDataType.TEXT.getName().toLowerCase(), ((ListProperty)property).getValues());
    }

    @Override
    protected T _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        List<String> values = element.all(VCardDataType.TEXT);
        if (!values.isEmpty()) {
            return this.parse(values);
        }
        throw ListPropertyScribe.missingXmlElements(VCardDataType.TEXT);
    }

    private T parse(List<String> values) {
        T property = this._newInstance();
        ((ListProperty)property).getValues().addAll(values);
        return property;
    }

    protected abstract T _newInstance();
}

