/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io.scribe;

import java.util.List;
import org.opencrx.application.uses.ezvcard.VCardDataType;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.io.scribe.VCardPropertyScribe;
import org.opencrx.application.uses.ezvcard.io.xml.XCardElement;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameters;
import org.opencrx.application.uses.ezvcard.property.StructuredName;

public class StructuredNameScribe
extends VCardPropertyScribe<StructuredName> {
    public StructuredNameScribe() {
        super(StructuredName.class, "N");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected String _writeText(StructuredName property, VCardVersion version) {
        return StructuredNameScribe.structured(property.getFamily(), property.getGiven(), property.getAdditional(), property.getPrefixes(), property.getSuffixes());
    }

    @Override
    protected StructuredName _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        StructuredName property = new StructuredName();
        VCardPropertyScribe.StructuredIterator it = StructuredNameScribe.structured(value);
        property.setFamily(it.nextString());
        property.setGiven(it.nextString());
        property.getAdditional().addAll(it.nextComponent());
        property.getPrefixes().addAll(it.nextComponent());
        property.getSuffixes().addAll(it.nextComponent());
        return property;
    }

    @Override
    protected void _writeXml(StructuredName property, XCardElement parent) {
        parent.append("surname", property.getFamily());
        parent.append("given", property.getGiven());
        parent.append("additional", property.getAdditional());
        parent.append("prefix", property.getPrefixes());
        parent.append("suffix", property.getSuffixes());
    }

    @Override
    protected StructuredName _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        StructuredName property = new StructuredName();
        property.setFamily(this.s(element.first("surname")));
        property.setGiven(this.s(element.first("given")));
        property.getAdditional().addAll(element.all("additional"));
        property.getPrefixes().addAll(element.all("prefix"));
        property.getSuffixes().addAll(element.all("suffix"));
        return property;
    }

    private String s(String value) {
        return value == null || value.length() == 0 ? null : value;
    }
}

