/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io.scribe;

import java.util.List;
import java.util.TimeZone;
import org.opencrx.application.uses.ezvcard.Messages;
import org.opencrx.application.uses.ezvcard.VCardDataType;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.io.CannotParseException;
import org.opencrx.application.uses.ezvcard.io.scribe.VCardPropertyScribe;
import org.opencrx.application.uses.ezvcard.io.xml.XCardElement;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameters;
import org.opencrx.application.uses.ezvcard.property.Timezone;
import org.opencrx.application.uses.ezvcard.util.UtcOffset;

public class TimezoneScribe
extends VCardPropertyScribe<Timezone> {
    public TimezoneScribe() {
        super(Timezone.class, "TZ");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        switch (version) {
            case V2_1: 
            case V3_0: {
                return VCardDataType.UTC_OFFSET;
            }
            case V4_0: {
                return VCardDataType.TEXT;
            }
        }
        return null;
    }

    @Override
    protected VCardDataType _dataType(Timezone property, VCardVersion version) {
        String text = property.getText();
        UtcOffset offset = property.getOffset();
        switch (version) {
            case V2_1: {
                return VCardDataType.UTC_OFFSET;
            }
            case V3_0: {
                if (offset != null) {
                    return VCardDataType.UTC_OFFSET;
                }
                if (text == null) break;
                return VCardDataType.TEXT;
            }
            case V4_0: {
                if (text != null) {
                    return VCardDataType.TEXT;
                }
                if (offset == null) break;
                return VCardDataType.UTC_OFFSET;
            }
        }
        return this._defaultDataType(version);
    }

    @Override
    protected String _writeText(Timezone property, VCardVersion version) {
        String text = property.getText();
        UtcOffset offset = property.getOffset();
        switch (version) {
            case V2_1: {
                TimeZone timezone;
                if (offset != null) {
                    return offset.toString(false);
                }
                if (text == null || (timezone = this.timezoneFromId(text)) == null) break;
                UtcOffset tzOffset = this.offsetFromTimezone(timezone);
                return tzOffset.toString(false);
            }
            case V3_0: {
                if (offset != null) {
                    return offset.toString(true);
                }
                if (text == null) break;
                return TimezoneScribe.escape(text);
            }
            case V4_0: {
                if (text != null) {
                    return TimezoneScribe.escape(text);
                }
                if (offset == null) break;
                return offset.toString(false);
            }
        }
        return "";
    }

    @Override
    protected Timezone _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        value = TimezoneScribe.unescape(value);
        return this.parse(value, dataType, version, warnings);
    }

    @Override
    protected void _writeXml(Timezone property, XCardElement parent) {
        String text = property.getText();
        if (text != null) {
            parent.append(VCardDataType.TEXT, text);
            return;
        }
        UtcOffset offset = property.getOffset();
        if (offset != null) {
            parent.append(VCardDataType.UTC_OFFSET, offset.toString(false));
            return;
        }
        parent.append(VCardDataType.TEXT, "");
    }

    @Override
    protected Timezone _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        String text = element.first(VCardDataType.TEXT);
        if (text != null) {
            return new Timezone(text);
        }
        String utcOffset = element.first(VCardDataType.UTC_OFFSET);
        if (utcOffset != null) {
            try {
                return new Timezone(UtcOffset.parse(utcOffset));
            }
            catch (IllegalArgumentException e) {
                throw new CannotParseException(19, new Object[0]);
            }
        }
        throw TimezoneScribe.missingXmlElements(VCardDataType.TEXT, VCardDataType.UTC_OFFSET);
    }

    private Timezone parse(String value, VCardDataType dataType, VCardVersion version, List<String> warnings) {
        if (value == null || value.length() == 0) {
            return new Timezone((String)null);
        }
        switch (version) {
            case V2_1: {
                try {
                    return new Timezone(UtcOffset.parse(value));
                }
                catch (IllegalArgumentException e) {
                    throw new CannotParseException(19, new Object[0]);
                }
            }
            case V3_0: 
            case V4_0: {
                try {
                    return new Timezone(UtcOffset.parse(value));
                }
                catch (IllegalArgumentException e) {
                    if (dataType == VCardDataType.UTC_OFFSET) {
                        warnings.add(Messages.INSTANCE.getParseMessage(20, new Object[0]));
                    }
                    return new Timezone(value);
                }
            }
        }
        return new Timezone((String)null);
    }

    private UtcOffset offsetFromTimezone(TimeZone timezone) {
        long offsetMs = timezone.getOffset(System.currentTimeMillis());
        int hours = (int)(offsetMs / 1000L / 60L / 60L);
        int minutes = (int)(offsetMs / 1000L / 60L % 60L);
        if (minutes < 0) {
            minutes *= -1;
        }
        return new UtcOffset(hours, minutes);
    }

    private TimeZone timezoneFromId(String id) {
        TimeZone timezone = TimeZone.getTimeZone(id);
        return "GMT".equals(timezone.getID()) ? null : timezone;
    }
}

