/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io.xml;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.opencrx.application.uses.ezvcard.VCard;
import org.opencrx.application.uses.ezvcard.VCardDataType;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.io.EmbeddedVCardException;
import org.opencrx.application.uses.ezvcard.io.SkipMeException;
import org.opencrx.application.uses.ezvcard.io.StreamWriter;
import org.opencrx.application.uses.ezvcard.io.scribe.VCardPropertyScribe;
import org.opencrx.application.uses.ezvcard.io.xml.XCardQNames;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameters;
import org.opencrx.application.uses.ezvcard.property.VCardProperty;
import org.opencrx.application.uses.ezvcard.property.Xml;
import org.opencrx.application.uses.ezvcard.util.IOUtils;
import org.opencrx.application.uses.ezvcard.util.ListMultimap;
import org.opencrx.application.uses.ezvcard.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XCardWriter
extends StreamWriter {
    private final VCardVersion targetVersion = VCardVersion.V4_0;
    private final Document DOC = XmlUtils.createDocument();
    private final Map<String, VCardDataType> parameterDataTypes = new HashMap<String, VCardDataType>();
    private final Writer writer;
    private final TransformerHandler handler;
    private final String indent;
    private final boolean vcardsElementExists;
    private int level;
    private boolean textNodeJustPrinted;
    private boolean started;

    public XCardWriter(OutputStream out) {
        this(IOUtils.utf8Writer(out));
    }

    public XCardWriter(OutputStream out, String indent) {
        this(IOUtils.utf8Writer(out), indent);
    }

    public XCardWriter(File file) throws IOException {
        this(IOUtils.utf8Writer(file));
    }

    public XCardWriter(File file, String indent) throws IOException {
        this(IOUtils.utf8Writer(file), indent);
    }

    public XCardWriter(Writer writer) {
        this(writer, null);
    }

    public XCardWriter(Writer writer, String indent) {
        this(writer, indent, null);
    }

    public XCardWriter(Node parent) {
        this(null, null, parent);
    }

    private XCardWriter(Writer writer, String indent, Node parent) {
        Node root;
        this.registerParameterDataType("ALTID", VCardDataType.TEXT);
        this.registerParameterDataType("CALSCALE", VCardDataType.TEXT);
        this.registerParameterDataType("GEO", VCardDataType.URI);
        this.registerParameterDataType("LABEL", VCardDataType.TEXT);
        this.registerParameterDataType("LANGUAGE", VCardDataType.LANGUAGE_TAG);
        this.registerParameterDataType("MEDIATYPE", VCardDataType.TEXT);
        this.registerParameterDataType("PID", VCardDataType.TEXT);
        this.registerParameterDataType("PREF", VCardDataType.INTEGER);
        this.registerParameterDataType("SORT-AS", VCardDataType.TEXT);
        this.registerParameterDataType("TYPE", VCardDataType.TEXT);
        this.registerParameterDataType("TZ", VCardDataType.URI);
        this.level = 0;
        this.textNodeJustPrinted = false;
        this.started = false;
        this.writer = writer;
        this.indent = indent;
        if (parent instanceof Document && (root = parent.getFirstChild()) != null) {
            parent = root;
        }
        this.vcardsElementExists = this.isVCardsElement(parent);
        try {
            SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            this.handler = factory.newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        Result result = writer == null ? new DOMResult(parent) : new StreamResult(writer);
        this.handler.setResult(result);
    }

    private boolean isVCardsElement(Node node) {
        if (node == null) {
            return false;
        }
        if (!(node instanceof Element)) {
            return false;
        }
        QName vcards = XCardQNames.VCARDS;
        return vcards.getNamespaceURI().equals(node.getNamespaceURI()) && vcards.getLocalPart().equals(node.getLocalName());
    }

    @Override
    protected void _write(VCard vcard, List<VCardProperty> properties) throws IOException {
        try {
            if (!this.started) {
                this.handler.startDocument();
                if (!this.vcardsElementExists) {
                    this.start(XCardQNames.VCARDS);
                    ++this.level;
                }
                this.started = true;
            }
            ListMultimap<String, VCardProperty> propertiesByGroup = new ListMultimap<String, VCardProperty>();
            for (VCardProperty vCardProperty : properties) {
                propertiesByGroup.put(vCardProperty.getGroup(), vCardProperty);
            }
            this.start(XCardQNames.VCARD);
            ++this.level;
            for (Map.Entry entry : propertiesByGroup) {
                String groupName = (String)entry.getKey();
                if (groupName != null) {
                    AttributesImpl attr = new AttributesImpl();
                    attr.addAttribute(XCardQNames.NAMESPACE, "", "name", "", groupName);
                    this.start(XCardQNames.GROUP, (Attributes)attr);
                    ++this.level;
                }
                for (VCardProperty property : (List)entry.getValue()) {
                    this.write(property, vcard);
                }
                if (groupName == null) continue;
                --this.level;
                this.end(XCardQNames.GROUP);
            }
            --this.level;
            this.end(XCardQNames.VCARD);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected VCardVersion getTargetVersion() {
        return this.targetVersion;
    }

    public void registerParameterDataType(String parameterName, VCardDataType dataType) {
        parameterName = parameterName.toLowerCase();
        if (dataType == null) {
            this.parameterDataTypes.remove(parameterName);
        } else {
            this.parameterDataTypes.put(parameterName, dataType);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.started) {
                this.handler.startDocument();
                if (!this.vcardsElementExists) {
                    this.start(XCardQNames.VCARDS);
                    ++this.level;
                }
            }
            if (!this.vcardsElementExists) {
                --this.level;
                this.end(XCardQNames.VCARDS);
            }
            this.handler.endDocument();
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        if (this.writer != null) {
            this.writer.close();
        }
    }

    private void write(VCardProperty property, VCard vcard) throws SAXException {
        Element propertyElement;
        VCardPropertyScribe<? extends VCardProperty> scribe = this.index.getPropertyScribe(property);
        VCardParameters parameters = scribe.prepareParameters(property, this.targetVersion, vcard);
        if (property instanceof Xml) {
            Xml xml = (Xml)property;
            Document value = (Document)xml.getValue();
            if (value == null) {
                return;
            }
            propertyElement = XmlUtils.getRootElement(value);
        } else {
            QName qname = scribe.getQName();
            propertyElement = this.DOC.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
            try {
                scribe.writeXml(property, propertyElement);
            }
            catch (SkipMeException e) {
                return;
            }
            catch (EmbeddedVCardException e) {
                return;
            }
        }
        this.start(propertyElement);
        ++this.level;
        this.write(parameters);
        this.write(propertyElement);
        --this.level;
        this.end(propertyElement);
    }

    private void write(Element propertyElement) throws SAXException {
        NodeList children = propertyElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child instanceof Element) {
                Element element = (Element)child;
                if (element.hasChildNodes()) {
                    this.start(element);
                    ++this.level;
                    this.write(element);
                    --this.level;
                    this.end(element);
                    continue;
                }
                this.childless(element);
                continue;
            }
            if (!(child instanceof Text)) continue;
            Text text = (Text)child;
            this.text(text.getTextContent());
        }
    }

    private void write(VCardParameters parameters) throws SAXException {
        if (parameters.isEmpty()) {
            return;
        }
        this.start(XCardQNames.PARAMETERS);
        ++this.level;
        for (Map.Entry parameter : parameters) {
            String parameterName = ((String)parameter.getKey()).toLowerCase();
            this.start(parameterName);
            ++this.level;
            for (String parameterValue : parameter.getValue()) {
                VCardDataType dataType = this.parameterDataTypes.get(parameterName);
                String dataTypeElementName = dataType == null ? "unknown" : dataType.getName().toLowerCase();
                this.start(dataTypeElementName);
                this.text(parameterValue);
                this.end(dataTypeElementName);
            }
            --this.level;
            this.end(parameterName);
        }
        --this.level;
        this.end(XCardQNames.PARAMETERS);
    }

    private void indent() throws SAXException {
        if (this.indent == null) {
            return;
        }
        StringBuilder sb = new StringBuilder("\n");
        for (int i = 0; i < this.level; ++i) {
            sb.append(this.indent);
        }
        String str = sb.toString();
        this.handler.ignorableWhitespace(str.toCharArray(), 0, str.length());
    }

    private void childless(Element element) throws SAXException {
        Attributes attributes = this.getElementAttributes(element);
        this.indent();
        this.handler.startElement(element.getNamespaceURI(), "", element.getLocalName(), attributes);
        this.handler.endElement(element.getNamespaceURI(), "", element.getLocalName());
    }

    private void start(Element element) throws SAXException {
        Attributes attributes = this.getElementAttributes(element);
        this.start(element.getNamespaceURI(), element.getLocalName(), attributes);
    }

    private void start(String element) throws SAXException {
        this.start(element, null);
    }

    private void start(QName qname) throws SAXException {
        this.start(qname, null);
    }

    private void start(QName qname, Attributes attributes) throws SAXException {
        this.start(qname.getNamespaceURI(), qname.getLocalPart(), attributes);
    }

    private void start(String element, Attributes attributes) throws SAXException {
        this.start(this.targetVersion.getXmlNamespace(), element, attributes);
    }

    private void start(String namespace, String element, Attributes attributes) throws SAXException {
        this.indent();
        this.handler.startElement(namespace, "", element, attributes);
    }

    private void end(Element element) throws SAXException {
        this.end(element.getNamespaceURI(), element.getLocalName());
    }

    private void end(String element) throws SAXException {
        this.end(this.targetVersion.getXmlNamespace(), element);
    }

    private void end(QName qname) throws SAXException {
        this.end(qname.getNamespaceURI(), qname.getLocalPart());
    }

    private void end(String namespace, String element) throws SAXException {
        if (!this.textNodeJustPrinted) {
            this.indent();
        }
        this.handler.endElement(namespace, "", element);
        this.textNodeJustPrinted = false;
    }

    private void text(String text) throws SAXException {
        this.handler.characters(text.toCharArray(), 0, text.length());
        this.textNodeJustPrinted = true;
    }

    private Attributes getElementAttributes(Element element) {
        AttributesImpl attributes = new AttributesImpl();
        NamedNodeMap attributeNodes = element.getAttributes();
        for (int i = 0; i < attributeNodes.getLength(); ++i) {
            Node node = attributeNodes.item(i);
            attributes.addAttribute(node.getNamespaceURI(), "", node.getLocalName(), "", node.getNodeValue());
        }
        return attributes;
    }
}

