/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.parameter;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameter;

public class VersionedVCardParameter
extends VCardParameter {
    protected final Set<VCardVersion> supportedVersions;

    public VersionedVCardParameter(String value, VCardVersion ... supportedVersions) {
        super(value);
        if (supportedVersions.length == 0) {
            supportedVersions = VCardVersion.values();
        }
        EnumSet<VCardVersion> set = EnumSet.copyOf(Arrays.asList(supportedVersions));
        this.supportedVersions = Collections.unmodifiableSet(set);
    }

    public boolean isSupported(VCardVersion version) {
        return this.supportedVersions.contains((Object)version);
    }
}

