/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.property;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.opencrx.application.uses.ezvcard.VCard;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.Warning;
import org.opencrx.application.uses.ezvcard.parameter.MediaTypeParameter;
import org.opencrx.application.uses.ezvcard.property.HasAltId;
import org.opencrx.application.uses.ezvcard.property.VCardProperty;
import org.opencrx.application.uses.ezvcard.util.IOUtils;

public abstract class BinaryProperty<T extends MediaTypeParameter>
extends VCardProperty
implements HasAltId {
    protected byte[] data;
    protected String url;
    protected T contentType;

    public BinaryProperty() {
    }

    public BinaryProperty(String url, T type) {
        this.setUrl(url, type);
    }

    public BinaryProperty(byte[] data, T type) {
        this.setData(data, type);
    }

    public BinaryProperty(InputStream in, T type) throws IOException {
        this(IOUtils.toByteArray(in, true), type);
    }

    public BinaryProperty(File file, T type) throws IOException {
        this(new FileInputStream(file), type);
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data, T type) {
        this.url = null;
        this.data = data;
        this.setContentType(type);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url, T type) {
        this.url = url;
        this.data = null;
        this.setContentType(type);
    }

    public T getContentType() {
        return this.contentType;
    }

    public void setContentType(T contentType) {
        this.contentType = contentType;
    }

    public String getType() {
        return this.parameters.getType();
    }

    public void setType(String type) {
        this.parameters.setType(type);
    }

    @Override
    public List<Integer[]> getPids() {
        return super.getPids();
    }

    @Override
    public void addPid(int localId, int clientPidMapRef) {
        super.addPid(localId, clientPidMapRef);
    }

    @Override
    public void removePids() {
        super.removePids();
    }

    @Override
    public Integer getPref() {
        return super.getPref();
    }

    @Override
    public void setPref(Integer pref) {
        super.setPref(pref);
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    @Override
    protected void _validate(List<Warning> warnings, VCardVersion version, VCard vcard) {
        if (this.url == null && this.data == null) {
            warnings.add(new Warning(8, new Object[0]));
        }
    }
}

