/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.property;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.opencrx.application.uses.ezvcard.VCard;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.Warning;
import org.opencrx.application.uses.ezvcard.property.HasAltId;
import org.opencrx.application.uses.ezvcard.property.VCardProperty;
import org.opencrx.application.uses.ezvcard.util.GeoUri;

public class PlaceProperty
extends VCardProperty
implements HasAltId {
    protected GeoUri geoUri;
    protected String uri;
    protected String text;

    public PlaceProperty() {
    }

    public PlaceProperty(double latitude, double longitude) {
        this.setCoordinates(latitude, longitude);
    }

    public PlaceProperty(String text) {
        this.setText(text);
    }

    @Override
    public Set<VCardVersion> _supportedVersions() {
        return EnumSet.of(VCardVersion.V4_0);
    }

    public Double getLatitude() {
        return this.geoUri == null ? null : this.geoUri.getCoordA();
    }

    public Double getLongitude() {
        return this.geoUri == null ? null : this.geoUri.getCoordB();
    }

    public GeoUri getGeoUri() {
        return this.geoUri;
    }

    public void setCoordinates(double latitude, double longitude) {
        this.setGeoUri(new GeoUri.Builder(latitude, longitude).build());
    }

    public void setGeoUri(GeoUri geoUri) {
        this.geoUri = geoUri;
        this.uri = null;
        this.text = null;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
        this.geoUri = null;
        this.text = null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.geoUri = null;
        this.uri = null;
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    @Override
    public String getLanguage() {
        return super.getLanguage();
    }

    @Override
    public void setLanguage(String language) {
        super.setLanguage(language);
    }

    @Override
    protected void _validate(List<Warning> warnings, VCardVersion version, VCard vcard) {
        if (this.uri == null && this.text == null && this.geoUri == null) {
            warnings.add(new Warning(8, new Object[0]));
        }
    }
}

