/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.property;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opencrx.application.uses.ezvcard.VCard;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.Warning;
import org.opencrx.application.uses.ezvcard.parameter.TelephoneType;
import org.opencrx.application.uses.ezvcard.property.HasAltId;
import org.opencrx.application.uses.ezvcard.property.VCardProperty;
import org.opencrx.application.uses.ezvcard.util.TelUri;

public class Telephone
extends VCardProperty
implements HasAltId {
    private String text;
    private TelUri uri;

    public Telephone(String text) {
        this.setText(text);
    }

    public Telephone(TelUri uri) {
        this.setUri(uri);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.uri = null;
    }

    public TelUri getUri() {
        return this.uri;
    }

    public void setUri(TelUri uri) {
        this.text = null;
        this.uri = uri;
    }

    public Set<TelephoneType> getTypes() {
        Set<String> values = this.parameters.getTypes();
        HashSet<TelephoneType> types = new HashSet<TelephoneType>(values.size());
        for (String value : values) {
            types.add(TelephoneType.get(value));
        }
        return types;
    }

    public void addType(TelephoneType type) {
        this.parameters.addType(type.getValue());
    }

    public void removeType(TelephoneType type) {
        this.parameters.removeType(type.getValue());
    }

    @Override
    public List<Integer[]> getPids() {
        return super.getPids();
    }

    @Override
    public void addPid(int localId, int clientPidMapRef) {
        super.addPid(localId, clientPidMapRef);
    }

    @Override
    public void removePids() {
        super.removePids();
    }

    @Override
    public Integer getPref() {
        return super.getPref();
    }

    @Override
    public void setPref(Integer pref) {
        super.setPref(pref);
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    @Override
    protected void _validate(List<Warning> warnings, VCardVersion version, VCard vcard) {
        if (this.uri == null && this.text == null) {
            warnings.add(new Warning(8, new Object[0]));
        }
        if (this.uri != null && (version == VCardVersion.V2_1 || version == VCardVersion.V3_0)) {
            warnings.add(new Warning(19, new Object[0]));
        }
        for (TelephoneType type : this.getTypes()) {
            if (type == TelephoneType.PREF || type.isSupported(version)) continue;
            warnings.add(new Warning(9, type.getValue()));
        }
    }
}

