/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.net.sf.webdav;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.uses.net.sf.webdav.methods.DoCopy;
import org.opencrx.application.uses.net.sf.webdav.methods.DoDelete;
import org.opencrx.application.uses.net.sf.webdav.methods.DoGet;
import org.opencrx.application.uses.net.sf.webdav.methods.DoHead;
import org.opencrx.application.uses.net.sf.webdav.methods.DoLock;
import org.opencrx.application.uses.net.sf.webdav.methods.DoMkcol;
import org.opencrx.application.uses.net.sf.webdav.methods.DoMove;
import org.opencrx.application.uses.net.sf.webdav.methods.DoNotImplemented;
import org.opencrx.application.uses.net.sf.webdav.methods.DoOptions;
import org.opencrx.application.uses.net.sf.webdav.methods.DoPropfind;
import org.opencrx.application.uses.net.sf.webdav.methods.DoProppatch;
import org.opencrx.application.uses.net.sf.webdav.methods.DoPut;
import org.opencrx.application.uses.net.sf.webdav.methods.DoReport;
import org.opencrx.application.uses.net.sf.webdav.methods.DoUnlock;
import org.opencrx.application.uses.net.sf.webdav.methods.WebDavMethod;
import org.openmdx.base.exception.ServiceException;

public abstract class AbstractWebDavServlet
extends HttpServlet {
    private static final long serialVersionUID = -4817456237932116287L;
    private static Logger LOG = Logger.getLogger(AbstractWebDavServlet.class.getPackage().getName());
    private WebDavStore _store;
    private HashMap<String, WebDavMethod> _methodMap = new HashMap();

    public void init(ServletConfig conf) throws ServletException {
        super.init(conf);
        WebDavStore webdavStore = this.constructStore();
        boolean lazyFolderCreationOnPut = Boolean.valueOf(this.getInitParameter("lazyFolderCreationOnPut"));
        this.init(webdavStore, lazyFolderCreationOnPut);
    }

    protected abstract WebDavStore constructStore();

    protected WebDavMethod newDoGet(WebDavStore store) {
        return new DoGet(store);
    }

    protected WebDavMethod newDoReport(WebDavStore store) {
        return new DoReport(store);
    }

    protected WebDavMethod newDoHead(WebDavStore store) {
        return new DoHead(store);
    }

    protected WebDavMethod newDoDelete(WebDavStore store) {
        return new DoDelete(store);
    }

    protected WebDavMethod newDoCopy(WebDavStore store, DoDelete doDelete) {
        return new DoCopy(store, doDelete);
    }

    protected WebDavMethod newDoLock(WebDavStore store) {
        return new DoLock(store);
    }

    protected WebDavMethod newDoUnlock(WebDavStore store) {
        return new DoUnlock(store);
    }

    protected WebDavMethod newDoMove(WebDavStore store) {
        return new DoMove(store);
    }

    protected WebDavMethod newDoMkcol(WebDavStore store) {
        return new DoMkcol(store);
    }

    protected WebDavMethod newDoOptions(WebDavStore store) {
        return new DoOptions(store);
    }

    protected WebDavMethod newDoPut(WebDavStore store, boolean lazyFolderCreationOnPut) {
        return new DoPut(store, lazyFolderCreationOnPut);
    }

    protected WebDavMethod newDoPropfind(WebDavStore store) {
        return new DoPropfind(store);
    }

    protected WebDavMethod newDoProppatch(WebDavStore store) {
        return new DoProppatch(store);
    }

    public void init(WebDavStore store, boolean lazyFolderCreationOnPut) throws ServletException {
        this._store = store;
        this.register("GET", this.newDoGet(store));
        this.register("REPORT", this.newDoReport(store));
        this.register("HEAD", this.newDoHead(store));
        DoDelete doDelete = (DoDelete)this.register("DELETE", this.newDoDelete(store));
        this.register("COPY", this.newDoCopy(store, doDelete));
        this.register("LOCK", this.newDoLock(store));
        this.register("UNLOCK", this.newDoUnlock(store));
        this.register("MOVE", this.newDoMove(store));
        this.register("MKCOL", this.newDoMkcol(store));
        this.register("OPTIONS", this.newDoOptions(store));
        this.register("PUT", this.newDoPut(store, lazyFolderCreationOnPut));
        this.register("PROPFIND", this.newDoPropfind(store));
        this.register("PROPPATCH", this.newDoProppatch(store));
        this.register("*NO*IMPL*", new DoNotImplemented());
    }

    private WebDavMethod register(String methodName, WebDavMethod method) {
        this._methodMap.put(methodName, method);
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String methodName = req.getMethod();
        RequestContext transaction = null;
        if (LOG.isLoggable(Level.FINEST)) {
            this.debugRequest(methodName, req);
        }
        try {
            transaction = this._store.begin(req, resp);
            WebDavMethod methodExecutor = this._methodMap.get(methodName);
            if (methodExecutor == null) {
                methodExecutor = this._methodMap.get("*NO*IMPL*");
            }
            methodExecutor.execute(transaction);
            this._store.commit(transaction);
        }
        catch (Exception e) {
            resp.sendError(500);
            this._store.rollback(transaction);
            new ServiceException(e).log();
        }
    }

    private void debugRequest(String methodName, HttpServletRequest req) {
        String s;
        LOG.finest("-----------");
        LOG.finest("WebdavServlet\n request: methodName = " + methodName);
        LOG.finest("time: " + System.currentTimeMillis());
        LOG.finest("path: " + req.getRequestURI());
        LOG.finest("-----------");
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            LOG.finest("header: " + s + " " + req.getHeader(s));
        }
        e = req.getAttributeNames();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            LOG.finest("attribute: " + s + " " + req.getAttribute(s));
        }
        e = req.getParameterNames();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            LOG.finest("parameter: " + s + " " + req.getParameter(s));
        }
    }
}

