/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.org.apache.commons.csv;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import org.opencrx.application.uses.org.apache.commons.csv.CSVParser;
import org.opencrx.application.uses.org.apache.commons.csv.CSVPrinter;
import org.opencrx.application.uses.org.apache.commons.csv.CSVRecord;
import org.opencrx.application.uses.org.apache.commons.csv.Quote;

public class CSVFormat
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final char DISABLED = '\ufffe';
    private final char delimiter;
    private final Character quoteChar;
    private final Quote quotePolicy;
    private final Character commentStart;
    private final Character escape;
    private final boolean ignoreSurroundingSpaces;
    private final boolean ignoreEmptyLines;
    private final String recordSeparator;
    private final String[] header;
    private static final CSVFormat PRISTINE = new CSVFormat('\ufffe', null, null, null, null, false, false, null, null);
    public static final CSVFormat RFC4180 = PRISTINE.withDelimiter(',').withQuoteChar('\"').withRecordSeparator("\r\n");
    public static final CSVFormat DEFAULT = RFC4180.withIgnoreEmptyLines(true);
    public static final CSVFormat EXCEL = PRISTINE.withDelimiter(',').withQuoteChar('\"').withRecordSeparator("\r\n");
    public static final CSVFormat TDF = PRISTINE.withDelimiter('\t').withQuoteChar('\"').withIgnoreSurroundingSpaces(true).withIgnoreEmptyLines(true).withRecordSeparator("\r\n");
    public static final CSVFormat MYSQL = PRISTINE.withDelimiter('\t').withEscape('\\').withRecordSeparator('\n');

    public CSVFormat(char delimiter) {
        this(delimiter, null, null, null, null, false, false, null, null);
    }

    CSVFormat(char delimiter, Character quoteChar, Quote quotePolicy, Character commentStart, Character escape, boolean ignoreSurroundingSpaces, boolean ignoreEmptyLines, String lineSeparator, String[] header) {
        if (CSVFormat.isLineBreak(delimiter)) {
            throw new IllegalArgumentException("The delimiter cannot be a line break");
        }
        this.delimiter = delimiter;
        this.quoteChar = quoteChar;
        this.quotePolicy = quotePolicy;
        this.commentStart = commentStart;
        this.escape = escape;
        this.ignoreSurroundingSpaces = ignoreSurroundingSpaces;
        this.ignoreEmptyLines = ignoreEmptyLines;
        this.recordSeparator = lineSeparator;
        this.header = header;
    }

    private static boolean isLineBreak(Character c) {
        return c != null && CSVFormat.isLineBreak(c.charValue());
    }

    private static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    void validate() throws IllegalStateException {
        if (this.quoteChar != null && this.delimiter == this.quoteChar.charValue()) {
            throw new IllegalStateException("The quoteChar character and the delimiter cannot be the same ('" + this.quoteChar + "')");
        }
        if (this.escape != null && this.delimiter == this.escape.charValue()) {
            throw new IllegalStateException("The escape character and the delimiter cannot be the same ('" + this.escape + "')");
        }
        if (this.commentStart != null && this.delimiter == this.commentStart.charValue()) {
            throw new IllegalStateException("The comment start character and the delimiter cannot be the same ('" + this.commentStart + "')");
        }
        if (this.quoteChar != null && this.quoteChar.equals(this.commentStart)) {
            throw new IllegalStateException("The comment start character and the quoteChar cannot be the same ('" + this.commentStart + "')");
        }
        if (this.escape != null && this.escape.equals(this.commentStart)) {
            throw new IllegalStateException("The comment start and the escape character cannot be the same ('" + this.commentStart + "')");
        }
        if (this.escape == null && this.quotePolicy == Quote.NONE) {
            throw new IllegalStateException("No quotes mode set but no escape character is set");
        }
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public CSVFormat withDelimiter(char delimiter) {
        return new CSVFormat(delimiter, this.quoteChar, this.quotePolicy, this.commentStart, this.escape, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.header);
    }

    public Character getQuoteChar() {
        return this.quoteChar;
    }

    public CSVFormat withQuoteChar(char quoteChar) {
        return this.withQuoteChar(Character.valueOf(quoteChar));
    }

    public CSVFormat withQuoteChar(Character quoteChar) {
        if (CSVFormat.isLineBreak(quoteChar)) {
            throw new IllegalArgumentException("The quoteChar cannot be a line break");
        }
        return new CSVFormat(this.delimiter, quoteChar, this.quotePolicy, this.commentStart, this.escape, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.header);
    }

    public boolean isQuoting() {
        return this.quoteChar != null;
    }

    public Character getCommentStart() {
        return this.commentStart;
    }

    public CSVFormat withCommentStart(char commentStart) {
        return this.withCommentStart(Character.valueOf(commentStart));
    }

    public CSVFormat withCommentStart(Character commentStart) {
        if (CSVFormat.isLineBreak(commentStart)) {
            throw new IllegalArgumentException("The comment start character cannot be a line break");
        }
        return new CSVFormat(this.delimiter, this.quoteChar, this.quotePolicy, commentStart, this.escape, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.header);
    }

    public boolean isCommentingEnabled() {
        return this.commentStart != null;
    }

    public Character getEscape() {
        return this.escape;
    }

    public CSVFormat withEscape(char escape) {
        return this.withEscape(Character.valueOf(escape));
    }

    public CSVFormat withEscape(Character escape) {
        if (CSVFormat.isLineBreak(escape)) {
            throw new IllegalArgumentException("The escape character cannot be a line break");
        }
        return new CSVFormat(this.delimiter, this.quoteChar, this.quotePolicy, this.commentStart, escape, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.header);
    }

    public boolean isEscaping() {
        return this.escape != null;
    }

    public boolean getIgnoreSurroundingSpaces() {
        return this.ignoreSurroundingSpaces;
    }

    public CSVFormat withIgnoreSurroundingSpaces(boolean ignoreSurroundingSpaces) {
        return new CSVFormat(this.delimiter, this.quoteChar, this.quotePolicy, this.commentStart, this.escape, ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.header);
    }

    public boolean getIgnoreEmptyLines() {
        return this.ignoreEmptyLines;
    }

    public CSVFormat withIgnoreEmptyLines(boolean ignoreEmptyLines) {
        return new CSVFormat(this.delimiter, this.quoteChar, this.quotePolicy, this.commentStart, this.escape, this.ignoreSurroundingSpaces, ignoreEmptyLines, this.recordSeparator, this.header);
    }

    public String getRecordSeparator() {
        return this.recordSeparator;
    }

    public CSVFormat withRecordSeparator(char recordSeparator) {
        return new CSVFormat(this.delimiter, this.quoteChar, this.quotePolicy, this.commentStart, this.escape, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, String.valueOf(recordSeparator), this.header);
    }

    public CSVFormat withRecordSeparator(String recordSeparator) {
        return new CSVFormat(this.delimiter, this.quoteChar, this.quotePolicy, this.commentStart, this.escape, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, recordSeparator, this.header);
    }

    public CSVFormat withQuotePolicy(Quote quotePolicy) {
        return new CSVFormat(this.delimiter, this.quoteChar, quotePolicy, this.commentStart, this.escape, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.header);
    }

    String[] getHeader() {
        return this.header;
    }

    public CSVFormat withHeader(String ... header) {
        return new CSVFormat(this.delimiter, this.quoteChar, this.quotePolicy, this.commentStart, this.escape, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, header);
    }

    public Iterable<CSVRecord> parse(Reader in) throws IOException {
        return new CSVParser(in, this);
    }

    public String format(Object ... values) {
        StringWriter out = new StringWriter();
        try {
            new CSVPrinter(out, this).printRecord(values);
            return out.toString().trim();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Delimiter=<").append(this.delimiter).append('>');
        if (this.isEscaping()) {
            sb.append(' ');
            sb.append("Escape=<").append(this.escape).append('>');
        }
        if (this.isQuoting()) {
            sb.append(' ');
            sb.append("QuoteChar=<").append(this.quoteChar).append('>');
        }
        if (this.isCommentingEnabled()) {
            sb.append(' ');
            sb.append("CommentStart=<").append(this.commentStart).append('>');
        }
        if (this.getIgnoreEmptyLines()) {
            sb.append(" EmptyLines:ignored");
        }
        if (this.getIgnoreSurroundingSpaces()) {
            sb.append(" SurroundingSpaces:ignored");
        }
        return sb.toString();
    }

    public Quote getQuotePolicy() {
        return this.quotePolicy;
    }
}

