/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.layer.persistence;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.resource.ResourceException;
import javax.resource.cci.Interaction;
import javax.resource.cci.MappedRecord;
import org.opencrx.kernel.generic.SecurityKeys;
import org.opencrx.kernel.layer.persistence.Indexed_2;
import org.opencrx.kernel.utils.DataproviderOperation;
import org.openmdx.application.dataprovider.cci.FilterProperty;
import org.openmdx.base.collection.TreeSparseArray;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.openmdx.base.query.ConditionType;
import org.openmdx.base.query.Quantifier;
import org.openmdx.base.resource.spi.ResourceExceptions;
import org.openmdx.base.resource.spi.RestInteractionSpec;
import org.openmdx.base.rest.cci.MessageRecord;
import org.openmdx.base.rest.cci.ObjectRecord;
import org.openmdx.base.rest.cci.QueryRecord;
import org.openmdx.base.rest.cci.RestConnection;
import org.openmdx.base.rest.cci.ResultRecord;
import org.openmdx.base.rest.spi.Facades;
import org.openmdx.base.rest.spi.Object_2Facade;
import org.openmdx.base.text.conversion.UUIDConversion;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.id.UUIDs;
import org.w3c.cci2.SparseArray;
import org.w3c.format.DateTimeFormat;

public class Audit_2
extends Indexed_2 {
    protected static final String NOT_VISITED_SUFFIX = "-";
    protected final Path ACTIVITY_CREATOR_IDENTITY_PATTERN = new Path("xri://@openmdx*org.opencrx.kernel.activity1/provider/:*/segment/:*/activityCreator/:*");
    protected final Map<Path, Boolean> auditSegments = new HashMap<Path, Boolean>();
    protected SparseArray<String> visitorId = new TreeSparseArray();

    @Override
    public Interaction getInteraction(RestConnection connection) throws ResourceException {
        return new RestInteraction(this, connection);
    }

    protected boolean isAuditee(ObjectRecord object) throws ServiceException {
        String objectClass = Object_2Facade.getObjectClass((MappedRecord)object);
        return this.getModel().isSubtypeOf((Object)objectClass, (Object)"org:opencrx:kernel:base:Auditee");
    }

    protected boolean isInstanceOfBasicObject(MappedRecord object) {
        return Object_2Facade.getPath((MappedRecord)object).size() > 5;
    }

    protected String getQualifiedPrincipalName(Path accessPath, String principalName) {
        return accessPath.getSegment(4).toString() + ":" + principalName;
    }

    private boolean areEqual(Object v1, Object v2) {
        if (v1 == null) {
            return v2 == null;
        }
        if (v2 == null) {
            return v1 == null;
        }
        if (v1 instanceof Number && v2 instanceof Number) {
            if (v1 instanceof Short || v2 instanceof Short) {
                return ((Number)v1).shortValue() == ((Number)v2).shortValue();
            }
            if (v1 instanceof Integer || v2 instanceof Integer) {
                return ((Number)v1).intValue() == ((Number)v2).intValue();
            }
            if (v1 instanceof Long || v2 instanceof Long) {
                return ((Number)v1).longValue() == ((Number)v2).longValue();
            }
            return ((Comparable)v1).compareTo(v2) == 0;
        }
        if (v1 instanceof Comparable && v2 instanceof Comparable && v1.getClass().equals(v2.getClass())) {
            return ((Comparable)v1).compareTo(v2) == 0;
        }
        return v1.equals(v2);
    }

    protected void setSecurityAttributes(MappedRecord auditEntry) throws ServiceException {
        Object_2Facade auditEntryFacade;
        try {
            auditEntryFacade = Object_2Facade.newInstance((MappedRecord)auditEntry);
        }
        catch (ResourceException e) {
            throw new ServiceException((Exception)((Object)e));
        }
        String segmentName = auditEntryFacade.getPath().get(4);
        auditEntryFacade.attributeValuesAsList("owner").clear();
        auditEntryFacade.attributeValuesAsList("owner").add(this.getQualifiedPrincipalName(auditEntryFacade.getPath(), "admin" + SecurityKeys.ID_SEPARATOR + segmentName + "." + "User"));
        auditEntryFacade.attributeValuesAsList("owner").add(this.getQualifiedPrincipalName(auditEntryFacade.getPath(), "Administrators"));
        auditEntryFacade.attributeValuesAsList("accessLevelBrowse").clear();
        auditEntryFacade.attributeValuesAsList("accessLevelBrowse").add(new Short(2));
        auditEntryFacade.attributeValuesAsList("accessLevelUpdate").clear();
        auditEntryFacade.attributeValuesAsList("accessLevelUpdate").add(new Short(1));
        auditEntryFacade.attributeValuesAsList("accessLevelDelete").clear();
        auditEntryFacade.attributeValuesAsList("accessLevelDelete").add(new Short(0));
    }

    protected void setSystemAttributes(List<String> principalChain, ObjectRecord object, DataproviderOperation operation) throws ServiceException {
        Object_2Facade facade;
        try {
            facade = Object_2Facade.newInstance((MappedRecord)object);
        }
        catch (ResourceException e) {
            throw new ServiceException((Exception)((Object)e));
        }
        Date at = new Date();
        List<String> by = principalChain;
        switch (operation) {
            case OBJECT_CREATION: {
                if (this.isInstanceOfBasicObject((MappedRecord)object)) {
                    facade.attributeValuesAsList("createdBy").clear();
                    facade.attributeValuesAsList("createdBy").addAll(by);
                    facade.attributeValuesAsList("createdAt").clear();
                    facade.attributeValuesAsList("createdAt").add(at);
                }
            }
            case OBJECT_REPLACEMENT: {
                if (!this.isInstanceOfBasicObject((MappedRecord)object)) break;
                facade.attributeValuesAsList("modifiedBy").clear();
                facade.attributeValuesAsList("modifiedBy").addAll(by);
                facade.attributeValuesAsList("modifiedAt").clear();
                facade.attributeValuesAsList("modifiedAt").add(at);
                break;
            }
        }
    }

    protected Set<String> getChangedAttributes(MappedRecord o1, MappedRecord o2) throws ServiceException {
        if (o2 == null) {
            return new HashSet<String>();
        }
        Object_2Facade o1Facade = Facades.asObject((MappedRecord)o1);
        Object_2Facade o2Facade = Facades.asObject((MappedRecord)o2);
        Iterator i = o1Facade.getValue().keySet().iterator();
        while (i.hasNext()) {
            o2Facade.attributeValuesAsList((String)i.next());
        }
        HashSet<String> changedAttributes = new HashSet<String>();
        for (String attributeName : o2Facade.getValue().keySet()) {
            boolean isEqual;
            List v1 = o1Facade.attributeValuesAsList(attributeName);
            List v2 = o2Facade.attributeValuesAsList(attributeName);
            if ("object_instanceof".equals(attributeName) || "identity".equals(attributeName) || attributeName.startsWith("context:")) continue;
            boolean bl = isEqual = v1.size() == v2.size();
            if (isEqual) {
                for (int j = 0; j < v1.size() && (isEqual = this.areEqual(v1.get(j), v2.get(j))); ++j) {
                }
            }
            if (isEqual) continue;
            changedAttributes.add(attributeName);
        }
        return changedAttributes;
    }

    public String getBeforeImageAsString(MappedRecord beforeImage) throws ServiceException {
        String beforeImageAsString = "";
        Object_2Facade beforeImageFacade = Facades.asObject((MappedRecord)beforeImage);
        for (String attributeName : beforeImageFacade.getValue().keySet()) {
            beforeImageAsString = beforeImageAsString + attributeName + ":\n";
            int jj = 0;
            Iterator j = beforeImageFacade.attributeValuesAsList(attributeName).iterator();
            while (j.hasNext()) {
                beforeImageAsString = beforeImageAsString + "" + jj + ": " + j.next() + "\n";
                ++jj;
            }
        }
        return beforeImageAsString;
    }

    public SparseArray<String> getVisitorId() {
        return this.visitorId;
    }

    public void setVisitorId(SparseArray<String> visitorId) {
        this.visitorId = visitorId;
    }

    public class RestInteraction
    extends Indexed_2.RestInteraction {
        public RestInteraction(Audit_2 audit, RestConnection connection) throws ResourceException {
            super(Audit_2.this, audit, connection);
        }

        private String getVisitedBy(String visitorId) throws ResourceException {
            return visitorId + ":" + (this.isBulkLoad() ? DateTimeFormat.BASIC_UTC_FORMAT.format(new Date()) : Audit_2.NOT_VISITED_SUFFIX);
        }

        private boolean isAuditSegment(Path path) throws ResourceException, ServiceException {
            Path segmentPath = path.getPrefix(5);
            Boolean isAuditSegment = Audit_2.this.auditSegments.get(path);
            if (isAuditSegment == null) {
                ObjectRecord segment = this.retrieveObject(segmentPath, "all");
                if (segment != null) {
                    isAuditSegment = new Boolean(Audit_2.this.isAuditee(segment));
                    Audit_2.this.auditSegments.put(segmentPath, isAuditSegment);
                } else {
                    return false;
                }
            }
            return isAuditSegment;
        }

        protected boolean excludeFromTouch(Path path) {
            return path.isLike(Audit_2.this.ACTIVITY_CREATOR_IDENTITY_PATTERN);
        }

        protected boolean isObjectTouch(Set<String> modifiedFeatures) {
            return modifiedFeatures.size() == 1 && modifiedFeatures.contains("modifiedAt") || modifiedFeatures.size() == 2 && modifiedFeatures.contains("modifiedAt") && modifiedFeatures.contains("modifiedBy");
        }

        @Override
        public boolean get(RestInteractionSpec ispec, QueryRecord request, ResultRecord response) throws ResourceException {
            Path path = request.getResourceIdentifier();
            try {
                Path reference = path.getParent();
                if ("audit".equals(reference.getLastSegment().toString())) {
                    ObjectRecord auditEntry = this.retrieveObject(path.getPrefix(5).getDescendant(new String[]{"audit", path.getLastSegment().toString()}), "all");
                    if (auditEntry != null) {
                        ObjectRecord mappedAuditEntry = Object_2Facade.cloneObject((MappedRecord)auditEntry);
                        Object_2Facade.newInstance((MappedRecord)mappedAuditEntry).setPath(path);
                        response.add((Object)mappedAuditEntry);
                        return true;
                    }
                    return false;
                }
                return super.get(ispec, request, response);
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
        }

        @Override
        public boolean find(RestInteractionSpec ispec, QueryRecord request, ResultRecord response) throws ResourceException {
            Path path = request.getResourceIdentifier();
            try {
                if (path.size() > 6 && "audit".equals(path.getLastSegment().toString())) {
                    QueryRecord findRequest = request.clone();
                    findRequest.setResourceIdentifier(path.getPrefix(5).getChild("audit"));
                    findRequest.getQueryFilter().getCondition().addAll(FilterProperty.toCondition((FilterProperty[])new FilterProperty[]{new FilterProperty(Quantifier.THERE_EXISTS.code(), "auditee", ConditionType.IS_IN.code(), new Object[]{path.getParent().toXri()})}));
                    findRequest.setSize(Long.valueOf(500L));
                    ResultRecord auditEntries = this.newResult();
                    super.find(Audit_2.this.SUPER.GET, findRequest, auditEntries);
                    ArrayList<ObjectRecord> mappedAuditEntries = new ArrayList<ObjectRecord>();
                    for (Object object : auditEntries) {
                        ObjectRecord auditEntry = (ObjectRecord)object;
                        ObjectRecord mappedAuditEntry = Object_2Facade.cloneObject((MappedRecord)auditEntry);
                        mappedAuditEntry.setResourceIdentifier(path.getChild(auditEntry.getResourceIdentifier().getLastSegment().toString()));
                        mappedAuditEntries.add(mappedAuditEntry);
                    }
                    response.addAll(mappedAuditEntries);
                    response.setHasMore(Boolean.FALSE.booleanValue());
                    response.setTotal((long)new Integer(mappedAuditEntries.size()).intValue());
                    return true;
                }
                return super.find(ispec, request, response);
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
        }

        @Override
        public boolean update(RestInteractionSpec ispec, ObjectRecord request, ResultRecord response) throws ResourceException {
            Path path = request.getResourceIdentifier();
            try {
                String principalName;
                List<String> principalChain = Audit_2.this.getPrincipalChain(this.getConnection());
                String string = principalName = principalChain.isEmpty() ? null : principalChain.get(0);
                if (path.size() > 5 || path.size() == 5 && principalName.startsWith("admin" + SecurityKeys.ID_SEPARATOR)) {
                    ObjectRecord existing;
                    boolean propagatePut = true;
                    if (this.isAuditSegment(path) && Audit_2.this.isAuditee(existing = this.retrieveObject(path, "all"))) {
                        ObjectRecord auditEntry = Object_2Facade.newInstance((Path)path.getPrefix(5).getDescendant(new String[]{"audit", UUIDConversion.toUID((UUID)UUIDs.newUUID())}), (String)"org:opencrx:kernel:base:ObjectModificationAuditEntry").getDelegate();
                        Object_2Facade auditEntryFacade = Object_2Facade.newInstance((MappedRecord)auditEntry);
                        auditEntryFacade.attributeValuesAsList("auditee").add(path.toXri());
                        for (String visitorId : Audit_2.this.visitorId) {
                            auditEntryFacade.attributeValuesAsList("visitedBy").add(this.getVisitedBy(visitorId));
                        }
                        ObjectRecord beforeImage = Object_2Facade.cloneObject((MappedRecord)existing);
                        Object_2Facade.getValue((MappedRecord)beforeImage).keySet().retainAll(Object_2Facade.getValue((MappedRecord)request).keySet());
                        Set<String> modifiedFeatures = Audit_2.this.getChangedAttributes((MappedRecord)beforeImage, (MappedRecord)request);
                        boolean isObjectTouch = this.isObjectTouch(modifiedFeatures);
                        if (modifiedFeatures.isEmpty()) {
                            propagatePut = false;
                        } else if (!isObjectTouch) {
                            Object_2Facade.getValue((MappedRecord)beforeImage).keySet().retainAll(modifiedFeatures);
                            auditEntryFacade.attributeValuesAsList("beforeImage").add(Audit_2.this.getBeforeImageAsString((MappedRecord)beforeImage));
                            String modifiedFeaturesAsString = modifiedFeatures.toString();
                            auditEntryFacade.attributeValuesAsList("modifiedFeatures").add(modifiedFeaturesAsString.length() > 300 ? modifiedFeaturesAsString.substring(0, 280) + "..." : modifiedFeaturesAsString);
                            Audit_2.this.setSystemAttributes(Audit_2.this.getPrincipalChain(this.getConnection()), auditEntry, DataproviderOperation.OBJECT_CREATION);
                            Audit_2.this.setSecurityAttributes((MappedRecord)auditEntry);
                            super.create(Audit_2.this.SUPER.CREATE, auditEntry, this.newResult());
                        } else {
                            boolean bl = propagatePut = !this.excludeFromTouch(path);
                        }
                    }
                    if (propagatePut) {
                        super.update(ispec, request, response);
                    }
                    return true;
                }
                if (response != null) {
                    response.add((Object)request);
                }
                return true;
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
        }

        @Override
        public boolean create(RestInteractionSpec ispec, ObjectRecord request, ResultRecord response) throws ResourceException {
            Path path = request.getResourceIdentifier();
            try {
                super.create(ispec, request, response);
                if (path.size() > 5 && this.isAuditSegment(path) && Audit_2.this.isAuditee(request)) {
                    ObjectRecord auditEntry = Object_2Facade.newInstance((Path)path.getPrefix(5).getDescendant(new String[]{"audit", UUIDConversion.toUID((UUID)UUIDs.newUUID())}), (String)"org:opencrx:kernel:base:ObjectCreationAuditEntry").getDelegate();
                    Object_2Facade auditEntryFacade = Object_2Facade.newInstance((MappedRecord)auditEntry);
                    auditEntryFacade.attributeValuesAsList("auditee").add(path.toXri());
                    for (String visitorId : Audit_2.this.visitorId) {
                        auditEntryFacade.attributeValuesAsList("visitedBy").add(this.getVisitedBy(visitorId));
                    }
                    Audit_2.this.setSystemAttributes(Audit_2.this.getPrincipalChain(this.getConnection()), auditEntry, DataproviderOperation.OBJECT_CREATION);
                    Audit_2.this.setSecurityAttributes((MappedRecord)auditEntry);
                    super.create(Audit_2.this.SUPER.CREATE, auditEntry, this.newResult());
                }
                return true;
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
        }

        @Override
        public boolean delete(RestInteractionSpec ispec, ObjectRecord request) throws ResourceException {
            Path path = request.getResourceIdentifier();
            try {
                ObjectRecord existing;
                if (path.size() > 5 && this.isAuditSegment(path) && Audit_2.this.isAuditee(existing = this.retrieveObject(path, "all"))) {
                    ObjectRecord auditEntry = Object_2Facade.newInstance((Path)path.getPrefix(5).getDescendant(new String[]{"audit", UUIDConversion.toUID((UUID)UUIDs.newUUID())}), (String)"org:opencrx:kernel:base:ObjectRemovalAuditEntry").getDelegate();
                    Object_2Facade auditEntryFacade = Object_2Facade.newInstance((MappedRecord)auditEntry);
                    auditEntryFacade.attributeValuesAsList("auditee").add(path.toXri());
                    for (String visitorId : Audit_2.this.visitorId) {
                        auditEntryFacade.attributeValuesAsList("visitedBy").add(this.getVisitedBy(visitorId));
                    }
                    auditEntryFacade.attributeValuesAsList("beforeImage").add(Audit_2.this.getBeforeImageAsString((MappedRecord)existing));
                    Audit_2.this.setSystemAttributes(Audit_2.this.getPrincipalChain(this.getConnection()), auditEntry, DataproviderOperation.OBJECT_CREATION);
                    Audit_2.this.setSecurityAttributes((MappedRecord)auditEntry);
                    super.create(Audit_2.this.SUPER.CREATE, auditEntry, this.newResult());
                }
                return super.delete(ispec, request);
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
        }

        @Override
        public boolean invoke(RestInteractionSpec ispec, MessageRecord request, MessageRecord response) throws ResourceException {
            String operationName = request.getTarget().getLastSegment().toString();
            Path path = request.getResourceIdentifier();
            try {
                if ("testAndSetVisitedBy".equals(operationName)) {
                    Path auditEntryIdentity = path.getPrefix(path.size() - 2);
                    ObjectRecord auditEntry = this.retrieveObject(auditEntryIdentity, "all");
                    Object_2Facade auditEntryFacade = Object_2Facade.newInstance((MappedRecord)auditEntry);
                    String visitorId = (String)request.getBody().get((Object)"visitorId");
                    response.setBody(this.newOperationResult("org:opencrx:kernel:base:TestAndSetVisitedByResult"));
                    int pos = 0;
                    if (visitorId == null || !Audit_2.this.visitorId.values().contains(visitorId)) {
                        response.getBody().put((Object)"visitStatus", (Object)new Short(2));
                    } else {
                        pos = auditEntryFacade.attributeValuesAsList("visitedBy").indexOf(visitorId + ":" + Audit_2.NOT_VISITED_SUFFIX);
                        if (pos >= 0) {
                            auditEntryFacade.attributeValuesAsList("visitedBy").set(pos, visitorId + ":" + DateTimeFormat.BASIC_UTC_FORMAT.format(new Date()));
                            super.update(Audit_2.this.SUPER.UPDATE, auditEntry, this.newResult());
                            response.getBody().put((Object)"visitStatus", (Object)new Short(0));
                        } else {
                            response.getBody().put((Object)"visitStatus", (Object)new Short(1));
                        }
                    }
                    return true;
                }
                return super.invoke(ispec, request, response);
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
        }
    }
}

